/*
 * Decompiled with CFR 0.152.
 */
package permutation2;

public class ChiTest {
    public static double threshold = 6.634896712;
    public static double sigma = 3.5;
    public int size;
    public boolean[][] signiDiff;

    public static void main(String[] args) {
        int samplesize = 200;
        ChiTest chi = new ChiTest(samplesize);
        int i = 1;
        while (i < 100) {
            int j = 1;
            while (j < 100) {
                System.out.printf("\t%d", chi.isSigniDiff(i, j));
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public ChiTest(int sampleSize) {
        this.size = sampleSize;
        this.signiDiff = new boolean[this.size + 1][this.size + 1];
        int i = 0;
        while (i < this.size + 1) {
            int j = 0;
            while (j < this.size + 1) {
                this.signiDiff[i][j] = ChiTest.ChiSquare1(i, sampleSize - i, j, sampleSize - j) > threshold;
                ++j;
            }
            ++i;
        }
    }

    public boolean isSigniDiff(int[][] data) {
        int i = 0;
        while (i < data[0].length) {
            if (ChiTest.chiTest(this.size, data[0][i], data[1][i]) == 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isSigniDiff(int i, int j) {
        return !this.signiDiff[i][j];
    }

    public static double ChiSquare1(int A, int B, int C, int D) {
        double a = A;
        double b = B;
        double c = C;
        double d = D;
        double N = a + b + c + d;
        double chi2 = (a * d - b * c) * (a * d - b * c) * N / ((a + c) * (b + d) * (a + b) * (c + d));
        return chi2;
    }

    public static int upperLimit(int sampleSize, double frequency, int haba) {
        double x = Math.sqrt(threshold * (double)sampleSize * frequency);
        int n = (int)((double)sampleSize * frequency + x) + haba;
        if (n < sampleSize) {
            return n;
        }
        return sampleSize;
    }

    public static int lowerLimit(int sampleSize, double frequency, int haba) {
        double x = Math.sqrt(threshold * (double)sampleSize * frequency);
        int n = (int)((double)sampleSize * frequency - x) - haba;
        if (n >= 0) {
            return n;
        }
        return 0;
    }

    public static int significant2(int sampleSize, int[][] data, double[] frequency) {
        int result = 0;
        int i = 0;
        while (i < data[0].length) {
            if (ChiTest.chiTest(sampleSize, data[0][i], data[1][i]) == 1) {
                return 1;
            }
            ++i;
        }
        return result;
    }

    public static int chiTest(int sampleSize, int patient, int control) {
        double chi2 = ChiTest.ChiSquare1(patient, sampleSize - patient, control, sampleSize - control);
        if (chi2 == Double.NaN) {
            return 0;
        }
        if (chi2 > threshold) {
            return 1;
        }
        return 0;
    }

    public static int chiTest(int A, int B, int C, int D) {
        double chi2 = ChiTest.ChiSquare1(A, B, C, D);
        if (chi2 > threshold) {
            return 1;
        }
        return 0;
    }

    public static int significant(int sampleSize, int[] obs, double[] frequency) {
        int result = 0;
        int i = 0;
        while (i < obs.length) {
            if (ChiTest.significant(sampleSize, obs[i], frequency[i]) == 1) {
                result = 1;
            }
            ++i;
        }
        return result;
    }

    public static int significant(int sampleSize, int obs, double frequency) {
        double exp = (double)sampleSize * frequency;
        double chi2 = ((double)obs - exp) * ((double)obs - exp) / exp;
        if (chi2 > threshold) {
            return 1;
        }
        return 0;
    }
}

