/*
 * Decompiled with CFR 0.152.
 */
package permutation;

import io.fileload;
import java.io.FileNotFoundException;
import java.io.IOException;
import permutation.Factorial;
import permutation.Gsampler;
import permutation.Permutation;
import permutation.Q;
import permutation.Table;
import primitive.SnpData;
import primitive.Snp_DataReader;
import primitive.pearson;

public class RAT {
    public static void main(String[] args) throws FileNotFoundException, IOException {
        double gen = 100.0;
        String[] data1 = fileload.loadLine0(args[0]);
        SnpData[] snpData1 = new SnpData[data1.length];
        int j = 0;
        while (j < data1.length) {
            snpData1[j] = Snp_DataReader.DataReaderSetData(data1[j], 2);
            ++j;
        }
        String[] data2 = fileload.loadLine0(args[1]);
        SnpData[] snpData2 = new SnpData[data2.length];
        int j2 = 0;
        while (j2 < data2.length) {
            snpData2[j2] = Snp_DataReader.DataReaderSetData(data2[j2], 2);
            ++j2;
        }
        SnpData[][] data = Snp_DataReader.DataReaderMakeParallelData(snpData1, snpData2);
        int a = data[0][0].SNPdata.length;
        int b = data[1][0].SNPdata.length;
        double Sobs = 0.0;
        int top = 0;
        int j3 = 0;
        while (j3 < data[0].length) {
            int[] populationType = Snp_DataReader.populationType(data[0][j3], data[1][j3]);
            int[][] Tobs = Snp_DataReader.DataReaderMakeTable(data[0][j3], data[1][j3], populationType);
            double S = pearson.S(Tobs);
            if (S != Double.NaN && S > Sobs) {
                Sobs = S;
                top = j3;
            }
            ++j3;
        }
        System.out.print("Observed:");
        System.out.print(data[0][top].rsNumber);
        System.out.print("\t");
        System.out.print(Sobs);
        System.out.println();
        String[] caseSequence = Snp_DataReader.sequences(data[0]);
        String[] controlSequence = Snp_DataReader.sequences(data[1]);
        int n = a + b;
        String[] sequence = new String[n];
        int[] type = new int[n];
        int[] observedOrder = new int[n];
        int h = 0;
        while (h < n) {
            if (h >= 0 && h < a) {
                sequence[h] = caseSequence[h];
                type[h] = 1;
            }
            if (a <= h && h < n) {
                sequence[h] = controlSequence[h - a];
                type[h] = 0;
            }
            observedOrder[h] = h;
            ++h;
        }
        int[][] genotype = Permutation.genotype(sequence);
        int m = genotype.length;
        int[][][] Tj = new int[m][][];
        int j4 = 0;
        while (j4 < m) {
            Tj[j4] = Permutation.T(type, genotype[j4]);
            ++j4;
        }
        double[] Sj = Q.Sj(Tj);
        double sumOfQj = Gsampler.sumOfQj(Tj, Sj);
        double sumOfinvQj = 0.0;
        int i = 0;
        while ((double)i < gen) {
            int j5 = Gsampler.algorithmA(Tj, Sobs);
            double S = Sj[j5];
            Table T = new Table(Tj[j5]);
            Gsampler.algorithmB(T, S);
            double Srat = Sj[j5];
            int[] di = Permutation.conditionedDi(genotype[j5], T.table());
            double Qvalue = Q.Qvalue(genotype, di, Srat);
            if (Qvalue != 0.0) {
                sumOfinvQj += 1.0 / Qvalue;
            }
            ++i;
        }
        Factorial f = new Factorial(n);
        double F = f.combination(n, a);
        System.out.println(sumOfQj * sumOfinvQj / gen / F);
    }
}

