/*
 * Decompiled with CFR 0.152.
 */
package permutation;

import permutation.Permutation;
import permutation.Table;

public class Q {
    public static void main(String[] args) {
        String[] caseSequence = new String[]{"ATAATTTAC", "ACGGCCGGT", "GTAATTTAT"};
        String[] controlSequence = new String[]{"ATAATTTAT", "GTAATTTAC", "ATAATTTAT"};
        int a = caseSequence.length;
        int b = controlSequence.length;
        int n = a + b;
        String[] sequence = new String[n];
        int[] type = new int[n];
        int[] observedOrder = new int[n];
        int h = 0;
        while (h < n) {
            if (h >= 0 && h < a) {
                sequence[h] = caseSequence[h];
                type[h] = 1;
            }
            if (a <= h && h < n) {
                sequence[h] = controlSequence[h - a];
                type[h] = 0;
            }
            observedOrder[h] = h;
            ++h;
        }
        int[][] genotype = Permutation.genotype(sequence);
        int m = genotype.length;
        int[][][] Tj = new int[m][][];
        int j = 0;
        while (j < m) {
            Tj[j] = Permutation.T(type, genotype[j]);
            ++j;
        }
        double Smax = Q.Smax(Tj);
        int gen = 100;
        int i = 0;
        while (i < gen) {
            int[] omega = Permutation.omega(n);
            int[] di = Permutation.di(n, a, omega);
            System.out.println(Q.Qvalue(genotype, di, Smax));
            ++i;
        }
    }

    public static double Smax(int[][][] Tj) {
        double[] Sj = Q.Sj(Tj);
        int sequenceLength = Sj.length;
        double Smax = 0.0;
        int j = 0;
        while (j < sequenceLength) {
            if (Sj[j] > Smax) {
                Smax = Sj[j];
            }
            ++j;
        }
        return Smax;
    }

    public static double[] Sj(int[][][] Tj) {
        int sequenceLength = Tj.length;
        double[] result = new double[sequenceLength];
        int j = 0;
        while (j < sequenceLength) {
            result[j] = Table.PearsonScore(Tj[j]);
            ++j;
        }
        return result;
    }

    public static int Qvalue(String[] sequence, int[] di, double Sobs) {
        int result = 0;
        int sequenceLength = sequence[0].length();
        int n = sequence.length;
        int c1 = 0;
        while (c1 < sequenceLength) {
            char org = sequence[0].charAt(c1);
            int[] genotype = new int[n];
            int i = 0;
            while (i < n) {
                genotype[i] = sequence[i].charAt(c1) == org ? 0 : 1;
                ++i;
            }
            int[][] T = Permutation.T(di, genotype);
            double S = Table.PearsonScore(T);
            if (S >= Sobs) {
                ++result;
            }
            ++c1;
        }
        return result;
    }

    public static int Qvalue(int[][] genotype, int[] di, double Sobs) {
        int result = 0;
        int m = genotype.length;
        int j = 0;
        while (j < m) {
            int[][] T = Permutation.T(di, genotype[j]);
            double S = Table.PearsonScore(T);
            if (S >= Sobs) {
                ++result;
            }
            ++j;
        }
        return result;
    }
}

