/*
 * Decompiled with CFR 0.152.
 */
package permutation;

import permutation.Table;

public class Permutation {
    public static void main(String[] args) {
        int a1 = 66;
        int a2 = 34;
        int b1 = 90;
        int b2 = 10;
        int a = a1 + a2;
        int b = b1 + b2;
        int n = a + b;
        int[] genotype = new int[n];
        int[] type = new int[n];
        int[] observedOrder = new int[n];
        int h = 0;
        while (h < n) {
            if (h >= 0 && h < a1) {
                genotype[h] = 1;
            }
            if (a <= h && h < a + b1) {
                genotype[h] = 1;
            }
            if (h >= 0 && h < a) {
                type[h] = 1;
            }
            observedOrder[h] = h;
            ++h;
        }
        int[][] Tobs = Permutation.T(type, genotype);
        double Sobs = Permutation.S(Tobs);
        int repeat2 = 100;
        boolean count = false;
        int i = 0;
        while (i < repeat2) {
            int[] omega = Permutation.omega(n);
            int[] tmp = new int[]{65, 67, 68};
            int[] di = Permutation.di(tmp, omega);
            int[] tmp2 = new int[tmp.length];
            int h2 = 0;
            while (h2 < di.length) {
                int n2 = di[h2];
                tmp2[n2] = tmp2[n2] + 1;
                ++h2;
            }
            Permutation.showVector(tmp2);
            ++i;
        }
    }

    public static int[] omega2(int len) {
        int[] result = new int[len];
        int[] flag = new int[len];
        int h = 0;
        while (h < len) {
            int x = 1;
            do {
                result[h] = x = (int)(Math.random() * (double)len);
            } while (flag[x] > 0);
            int n = x;
            flag[n] = flag[n] + 1;
            ++h;
        }
        return result;
    }

    public static int[] omega(int len) {
        int[] result = new int[len];
        int n = result.length;
        while (n > 1) {
            int k = (int)(Math.random() * (double)n);
            int temp = result[--n];
            result[n] = result[k];
            result[k] = temp;
        }
        return result;
    }

    public static int[] di(int n, int a, int[] omega) {
        int[] result = new int[n];
        int h = 0;
        while (h < a) {
            int n2 = omega[h];
            result[n2] = result[n2] + 1;
            ++h;
        }
        return result;
    }

    public static int[] di(int[] n, int[] omega) {
        int len = omega.length;
        int[] result = new int[len];
        int l = n.length;
        int h = 0;
        while (h < len) {
            int target = omega[h];
            int h2 = 0;
            while (h2 < l) {
                if (target < n[h2]) {
                    result[h] = h2;
                    h2 = l;
                } else {
                    target -= n[h2];
                }
                ++h2;
            }
            ++h;
        }
        return result;
    }

    public static int[] conditionedDi(int[] genotype, int[][] T) {
        int a1 = T[0][0];
        int a2 = T[0][1];
        int a = a1 + a2;
        int b1 = T[1][0];
        int b2 = T[1][1];
        int b = b1 + b2;
        int n1 = a1 + b1;
        int n2 = a2 + b2;
        int n = n1 + n2;
        int[][] num = new int[][]{new int[n1], new int[n2]};
        int[] count = new int[2];
        int h = 0;
        while (h < n) {
            int gen = genotype[h];
            num[gen][count[gen]] = h++;
            int n3 = gen;
            count[n3] = count[n3] + 1;
        }
        int[][] shuffle = new int[2][];
        int[] tmp = new int[]{n1, n2};
        int gen = 0;
        while (gen < 2) {
            shuffle[gen] = Permutation.omega(tmp[gen]);
            ++gen;
        }
        int[] type = new int[n];
        int gen2 = 0;
        while (gen2 < 2) {
            int h2 = 0;
            while (h2 < tmp[gen2]) {
                int tag = shuffle[gen2][h2];
                type[tag] = h2 < T[0][gen2] ? 0 : 1;
                ++h2;
            }
            ++gen2;
        }
        return type;
    }

    public static int[][] T(int[] d, int[] genotype) {
        int[][] result = new int[2][2];
        int len = d.length;
        int h = 0;
        while (h < len) {
            int[] nArray = result[d[h]];
            int n = genotype[h];
            nArray[n] = nArray[n] + 1;
            ++h;
        }
        return result;
    }

    public static double S(int[][] T) {
        return Table.Fst(T);
    }

    public static void showVector(int[] data) {
        int h = 0;
        while (h < data.length) {
            System.out.print(data[h]);
            System.out.print("\t");
            ++h;
        }
        System.out.println();
    }

    public static int[][] genotype(String[] sequence) {
        int sequenceLength = sequence[0].length();
        int n = sequence.length;
        int[][] result = new int[sequenceLength][];
        int j = 0;
        while (j < sequenceLength) {
            char org = sequence[0].charAt(j);
            int[] genotype = new int[n];
            int i = 0;
            while (i < n) {
                genotype[i] = sequence[i].charAt(j) == org ? 0 : 1;
                ++i;
            }
            result[j] = genotype;
            ++j;
        }
        return result;
    }
}

