/*
 * Decompiled with CFR 0.152.
 */
package permutation;

import permutation.G;
import permutation.MCMC;
import permutation.Table;

public class Gsampler {
    public static double sumOfQj(int[][][] Tj, double[] Sj) {
        return Gsampler.sumOfNumberOfHj(Tj, Sj);
    }

    public static double sumOfNumberOfHj(int[][][] Tj, double[] Sj) {
        int m = Tj.length;
        double[] numberOfDiInHj = new double[m];
        double sum = 0.0;
        int j = 0;
        while (j < m) {
            Table T = new Table(Tj[j]);
            numberOfDiInHj[j] = G.numberOfDiInHj(T, Sj[j]);
            sum += numberOfDiInHj[j];
            ++j;
        }
        return sum;
    }

    public static int algorithmA(int[][][] Tj, double Sobs) {
        int m = Tj.length;
        long sumOfNumberOfHj = 0L;
        double[] numberOfDiInHj = new double[m];
        int j = 0;
        while (j < m) {
            Table T = new Table(Tj[j]);
            numberOfDiInHj[j] = G.numberOfDiInHj(T, Sobs);
            sumOfNumberOfHj = (long)((double)sumOfNumberOfHj + numberOfDiInHj[j]);
            ++j;
        }
        double p = (double)sumOfNumberOfHj * Math.random();
        int j2 = 0;
        while (j2 < m) {
            if (p < numberOfDiInHj[j2]) {
                return j2;
            }
            p -= numberOfDiInHj[j2];
            ++j2;
        }
        return 0;
    }

    public static Table algorithmB(Table T, double Score) {
        int gen2 = 100000;
        int burnin = 100000;
        if (T.twoParts(Score)) {
            int m = 0;
            while (m < burnin) {
                MCMC.markov2(T, Score);
                ++m;
            }
            m = 0;
            while (m < gen2) {
                MCMC.markov2(T, Score);
                Gsampler.algorithmC(T);
                ++m;
            }
        } else {
            int m = 0;
            while (m < burnin) {
                MCMC.markov1(T, Score);
                ++m;
            }
            m = 0;
            while (m < gen2) {
                MCMC.markov1(T, Score);
                Gsampler.algorithmC(T);
                ++m;
            }
        }
        return T;
    }

    public static void algorithmC(Table T) {
    }
}

