/*
 * Decompiled with CFR 0.152.
 */
package permutation;

import io.fastaFormat;
import io.fileload;
import java.util.Vector;
import permutation.Permutation;

public class FstPermutation {
    public static void main(String[] args) {
        String[] tmp;
        String[] org = null;
        try {
            org = fileload.loadLine0(args[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String[] region = new String[]{args[1], args[2]};
        String[][] data = fastaFormat.translate(org);
        int bootstrap = new Integer(args[3]);
        boolean fifth = false;
        if (args.length > 4) {
            if (args[4].equals("0") || args[3].equals("complete")) {
                tmp = fastaFormat.gapdel(data[1]);
                data[1] = tmp;
                fifth = false;
            }
            if (args[4].equals("1") || args[3].equals("fifth")) {
                fifth = true;
            }
            if (args[4].equals("2") || args[3].equals("pairwise")) {
                fifth = false;
            }
        } else {
            tmp = fastaFormat.gapdel(data[1]);
            data[1] = tmp;
        }
        String[][] subPopSeq = FstPermutation.subPop(data, region);
        int b = 0;
        while (b < bootstrap) {
            String[][] data2 = fastaFormat.bootStrap(data);
            subPopSeq = FstPermutation.subPop(data2, region);
            FstPermutation.FstOutput(subPopSeq, fifth);
            ++b;
        }
    }

    public static void mainTest(String[] args) {
        String[] org = null;
        if (org == null) {
            org = new String[]{">Shallow_east", "AAAAA", ">Shallow_west", "AAAAT", ">Deep_east", "AAATA", ">Deep_west", "AAAAA", ">outgroup", "AAAAA", ">outgroup", "AAAAA"};
        }
        String[][] data = fastaFormat.translate(org);
        fastaFormat.output(data);
        String[] title = data[0];
        String[] sequence = data[1];
        int sampleSize = title.length;
        int[] populationNumber = new int[sampleSize];
        int[] observedOrder = new int[sampleSize];
        int magicNumber = 5;
        int[] subSampleSize = new int[magicNumber];
        int h = 0;
        while (h < sampleSize) {
            int popNumber = 0;
            if (title[h].indexOf("Shallow") >= 0 && title[h].indexOf("east") >= 0) {
                popNumber = 1;
            }
            if (title[h].indexOf("Deep") >= 0 && title[h].indexOf("east") >= 0) {
                popNumber = 2;
            }
            if (title[h].indexOf("Shallow") >= 0 && title[h].indexOf("west") >= 0) {
                popNumber = 3;
            }
            if (title[h].indexOf("Deep") >= 0 && title[h].indexOf("west") >= 0) {
                popNumber = 4;
            }
            populationNumber[h] = popNumber;
            int n = popNumber;
            subSampleSize[n] = subSampleSize[n] + 1;
            observedOrder[h] = h;
            ++h;
        }
        subSampleSize[0] = sampleSize - subSampleSize[1] - subSampleSize[2];
        int x = 0;
        while (x < magicNumber - 1) {
            int y = x + 1;
            while (y < magicNumber) {
                double Obs = FstPermutation.Fst92(x, y, populationNumber, sequence);
                double p = FstPermutation.permP(1000, x, y, subSampleSize, populationNumber, sequence);
                System.out.print("pop");
                System.out.print(x);
                System.out.print(" pop");
                System.out.print(y);
                System.out.print("\tObs\t");
                System.out.print(Obs);
                System.out.print("\tp\t");
                System.out.print(p);
                System.out.println();
                ++y;
            }
            ++x;
        }
    }

    public static void FstOutput(String[][] subPopSeq, boolean fifth) {
        int x = 0;
        int y = 1;
        double Fst = FstPermutation.Fst92(subPopSeq[x], subPopSeq[y], fifth);
        System.out.print(Fst);
        System.out.println();
    }

    public static String[][] subPopTitle(String[][] data, String[] popName) {
        int i;
        String[] title = data[0];
        String[] sequence = data[1];
        Vector[] v = new Vector[popName.length];
        int i2 = 0;
        while (i2 < v.length) {
            v[i2] = new Vector();
            ++i2;
        }
        int sampleSize = title.length;
        int h = 0;
        while (h < sampleSize) {
            i = 0;
            while (i < popName.length) {
                if (title[h].indexOf(popName[i]) >= 0) {
                    v[i].add(title[h]);
                }
                ++i;
            }
            ++h;
        }
        String[][] subPop = new String[popName.length][];
        i = 0;
        while (i < subPop.length) {
            subPop[i] = new String[v[i].size()];
            v[i].copyInto(subPop[i]);
            ++i;
        }
        return subPop;
    }

    public static String[][] subPop(String[][] data, String[] popName) {
        int i;
        String[] title = data[0];
        String[] sequence = data[1];
        Vector[] v = new Vector[popName.length];
        int i2 = 0;
        while (i2 < v.length) {
            v[i2] = new Vector();
            ++i2;
        }
        int sampleSize = title.length;
        int h = 0;
        while (h < sampleSize) {
            i = 0;
            while (i < popName.length) {
                if (title[h].indexOf(popName[i]) >= 0) {
                    v[i].add(sequence[h]);
                }
                ++i;
            }
            ++h;
        }
        String[][] subPop = new String[popName.length][];
        i = 0;
        while (i < subPop.length) {
            subPop[i] = new String[v[i].size()];
            v[i].copyInto(subPop[i]);
            ++i;
        }
        return subPop;
    }

    public static double permP(int repeat2, int popNo1, int popNo2, int[] subSampleSize, int[] type, String[] seq) {
        double Obs = FstPermutation.Fst92(popNo1, popNo2, type, seq);
        int count = 0;
        int sampleSize = type.length;
        int i = 0;
        while (i < repeat2) {
            int[] omega = Permutation.omega(sampleSize);
            int[] di = Permutation.di(subSampleSize, omega);
            double Perm = FstPermutation.Fst92(popNo1, popNo2, di, seq);
            if (Perm > Obs) {
                ++count;
            }
            ++i;
        }
        return (double)count / (double)repeat2;
    }

    public static double Fst92(String[] pop0, String[] pop1) {
        double Hw = FstPermutation.Hw(pop0, pop1);
        double Hb = FstPermutation.Hb(pop0, pop1);
        return 1.0 - Hw / Hb;
    }

    public static double Fst92(String[] pop0, String[] pop1, boolean fifth) {
        double Hw = FstPermutation.Hw(pop0, pop1, fifth);
        double Hb = FstPermutation.Hb(pop0, pop1, fifth);
        return 1.0 - Hw / Hb;
    }

    public static double Fst92(int[] type, String[] seq) {
        int len = type.length;
        if (len > seq.length) {
            len = seq.length;
        }
        int count0 = 0;
        int count1 = 0;
        int i = 0;
        while (i < len) {
            if (type[i] == 0) {
                ++count0;
            }
            if (type[i] == 1) {
                ++count1;
            }
            ++i;
        }
        String[] pop0 = new String[count0];
        String[] pop1 = new String[count1];
        int c0 = 0;
        int c1 = 0;
        int i2 = 0;
        while (i2 < len) {
            if (type[i2] == 0) {
                pop0[c0] = seq[i2];
                ++c0;
            }
            if (type[i2] == 1) {
                pop1[c1] = seq[i2];
                ++c1;
            }
            ++i2;
        }
        double Hw = FstPermutation.Hw(pop0, pop1);
        double Hb = FstPermutation.Hb(pop0, pop1);
        return 1.0 - Hw / Hb;
    }

    public static double Fst92(int popNo1, int popNo2, int[] type, String[] seq) {
        int len = type.length;
        if (len > seq.length) {
            len = seq.length;
        }
        int count0 = 0;
        int count1 = 0;
        int i = 0;
        while (i < len) {
            if (type[i] == popNo1) {
                ++count0;
            }
            if (type[i] == popNo2) {
                ++count1;
            }
            ++i;
        }
        String[] pop1 = new String[count0];
        String[] pop2 = new String[count1];
        int c0 = 0;
        int c1 = 0;
        int i2 = 0;
        while (i2 < len) {
            if (type[i2] == popNo1) {
                pop1[c0] = seq[i2];
                ++c0;
            }
            if (type[i2] == popNo2) {
                pop2[c1] = seq[i2];
                ++c1;
            }
            ++i2;
        }
        double Hw = FstPermutation.Hw(pop1, pop2);
        double Hb = FstPermutation.Hb(pop1, pop2);
        return 1.0 - Hw / Hb;
    }

    static double Hw(String[] pop) {
        double result = 0.0;
        double count = 0.0;
        int i = 0;
        while (i < pop.length - 1) {
            int j = i + 1;
            while (j < pop.length) {
                count += 1.0;
                result += FstPermutation.diff(pop[i], pop[j]);
                ++j;
            }
            ++i;
        }
        if (count == 0.0) {
            return 0.0;
        }
        return result / count;
    }

    static double Hw(String[] pop, boolean fifth) {
        double result = 0.0;
        double count = 0.0;
        int i = 0;
        while (i < pop.length - 1) {
            int j = i + 1;
            while (j < pop.length) {
                count += 1.0;
                result += FstPermutation.diff(pop[i], pop[j], fifth);
                ++j;
            }
            ++i;
        }
        if (count == 0.0) {
            return 0.0;
        }
        return result / count;
    }

    static double Hw(String[] pop1, String[] pop2) {
        double count1 = pop1.length;
        double count2 = pop2.length;
        return (FstPermutation.Hw(pop1) * count1 + FstPermutation.Hw(pop2) * count2) / (count1 + count2);
    }

    static double Hw(String[] pop1, String[] pop2, boolean fifth) {
        double count1 = pop1.length;
        double count2 = pop2.length;
        return (FstPermutation.Hw(pop1, fifth) * count1 + FstPermutation.Hw(pop2, fifth) * count2) / (count1 + count2);
    }

    static double Hb(String[] pop1, String[] pop2) {
        double result = 0.0;
        double count = 0.0;
        int i = 0;
        while (i < pop1.length) {
            int j = 0;
            while (j < pop2.length) {
                count += 1.0;
                result += FstPermutation.diff(pop1[i], pop2[j]);
                ++j;
            }
            ++i;
        }
        if (count == 0.0) {
            return 0.0;
        }
        return result / count;
    }

    static double Hb(String[] pop1, String[] pop2, boolean fifth) {
        double result = 0.0;
        double count = 0.0;
        int i = 0;
        while (i < pop1.length) {
            int j = 0;
            while (j < pop2.length) {
                count += 1.0;
                result += FstPermutation.diff(pop1[i], pop2[j], fifth);
                ++j;
            }
            ++i;
        }
        if (count == 0.0) {
            return 0.0;
        }
        return result / count;
    }

    static double diff(String seq1, String seq2) {
        double result = 0.0;
        int len = seq1.length();
        if (len > seq2.length()) {
            len = seq2.length();
        }
        int i = 0;
        while (i < len) {
            if (seq1.charAt(i) != seq2.charAt(i)) {
                result += 1.0;
            }
            ++i;
        }
        return result;
    }

    static double diff(String seq1, String seq2, boolean fifth) {
        double result = 0.0;
        int len = seq1.length();
        if (len > seq2.length()) {
            len = seq2.length();
        }
        int i = 0;
        while (i < len) {
            if (fifth) {
                if (seq1.charAt(i) != seq2.charAt(i)) {
                    result += 1.0;
                }
            } else if (seq1.charAt(i) != '-' && seq2.charAt(i) != '-' && seq1.charAt(i) != seq2.charAt(i)) {
                result += 1.0;
            }
            ++i;
        }
        return result;
    }
}

