/*
 * Decompiled with CFR 0.152.
 */
package permutation;

import io.fastaFormat;
import io.fileload;
import java.util.Vector;
import permutation.Permutation;

public class FstBoot2 {
    public static void main(String[] args) {
        String[] tmp;
        String[] org = null;
        try {
            org = fileload.loadLine0(args[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String[] region = new String[2];
        String[] habitat = new String[2];
        region[0] = args[1];
        region[1] = args[2];
        habitat[0] = args[3];
        habitat[1] = args[4];
        String[][] data = fastaFormat.translate(org);
        int bootstrap = new Integer(args[5]);
        boolean fifth = false;
        if (args.length >= 6) {
            if (args[6].equals("0") || args[6].equals("complete")) {
                tmp = fastaFormat.gapdel(data[1]);
                data[1] = tmp;
                fifth = false;
            }
            if (args[6].equals("1") || args[6].equals("fifth")) {
                fifth = true;
            }
            if (args[6].equals("2") || args[6].equals("pairwise")) {
                fifth = false;
            }
        } else {
            tmp = fastaFormat.gapdel(data[1]);
            data[1] = tmp;
        }
        String[][] subPopSeq1 = FstBoot2.subPop(data, region);
        String[][] subPopSeq2 = FstBoot2.subPop(data, habitat);
        int b = 0;
        while (b < bootstrap) {
            String[][] data2 = fastaFormat.bootStrap(data);
            subPopSeq1 = FstBoot2.subPop(data2, region);
            double Fst1 = FstBoot2.Fst92(subPopSeq1, fifth);
            subPopSeq2 = FstBoot2.subPop(data2, habitat);
            double Fst2 = FstBoot2.Fst92(subPopSeq2, fifth);
            System.out.print(Fst1);
            System.out.print("\t");
            System.out.print(Fst2);
            System.out.print("\t");
            System.out.print(Fst2 - Fst1);
            System.out.println();
            ++b;
        }
    }

    public static String[][] subPopTitle(String[][] data, String[] popName) {
        int i;
        String[] title = data[0];
        String[] sequence = data[1];
        Vector[] v = new Vector[popName.length];
        int i2 = 0;
        while (i2 < v.length) {
            v[i2] = new Vector();
            ++i2;
        }
        int sampleSize = title.length;
        int h = 0;
        while (h < sampleSize) {
            i = 0;
            while (i < popName.length) {
                if (title[h].indexOf(popName[i]) >= 0) {
                    v[i].add(title[h]);
                }
                ++i;
            }
            ++h;
        }
        String[][] subPop = new String[popName.length][];
        i = 0;
        while (i < subPop.length) {
            subPop[i] = new String[v[i].size()];
            v[i].copyInto(subPop[i]);
            ++i;
        }
        return subPop;
    }

    public static String[][] subPop(String[][] data, String[] popName) {
        int i;
        String[] title = data[0];
        String[] sequence = data[1];
        Vector[] v = new Vector[popName.length];
        int i2 = 0;
        while (i2 < v.length) {
            v[i2] = new Vector();
            ++i2;
        }
        int sampleSize = title.length;
        int h = 0;
        while (h < sampleSize) {
            i = 0;
            while (i < popName.length) {
                if (title[h].indexOf(popName[i]) >= 0) {
                    v[i].add(sequence[h]);
                }
                ++i;
            }
            ++h;
        }
        String[][] subPop = new String[popName.length][];
        i = 0;
        while (i < subPop.length) {
            subPop[i] = new String[v[i].size()];
            v[i].copyInto(subPop[i]);
            ++i;
        }
        return subPop;
    }

    public static double permP(int repeat2, int popNo1, int popNo2, int[] subSampleSize, int[] type, String[] seq) {
        double Obs = FstBoot2.Fst92(popNo1, popNo2, type, seq);
        int count = 0;
        int sampleSize = type.length;
        int i = 0;
        while (i < repeat2) {
            int[] omega = Permutation.omega(sampleSize);
            int[] di = Permutation.di(subSampleSize, omega);
            double Perm = FstBoot2.Fst92(popNo1, popNo2, di, seq);
            if (Perm > Obs) {
                ++count;
            }
            ++i;
        }
        return (double)count / (double)repeat2;
    }

    public static double Fst92(String[][] pop, boolean fifth) {
        double Hw = FstBoot2.Hw(pop[0], pop[1]);
        double Hb = FstBoot2.Hb(pop[0], pop[1]);
        return 1.0 - Hw / Hb;
    }

    public static double Fst92(String[] pop0, String[] pop1) {
        double Hw = FstBoot2.Hw(pop0, pop1);
        double Hb = FstBoot2.Hb(pop0, pop1);
        return 1.0 - Hw / Hb;
    }

    public static double Fst92(String[] pop0, String[] pop1, boolean fifth) {
        double Hw = FstBoot2.Hw(pop0, pop1, fifth);
        double Hb = FstBoot2.Hb(pop0, pop1, fifth);
        return 1.0 - Hw / Hb;
    }

    public static double Fst92(int[] type, String[] seq) {
        int len = type.length;
        if (len > seq.length) {
            len = seq.length;
        }
        int count0 = 0;
        int count1 = 0;
        int i = 0;
        while (i < len) {
            if (type[i] == 0) {
                ++count0;
            }
            if (type[i] == 1) {
                ++count1;
            }
            ++i;
        }
        String[] pop0 = new String[count0];
        String[] pop1 = new String[count1];
        int c0 = 0;
        int c1 = 0;
        int i2 = 0;
        while (i2 < len) {
            if (type[i2] == 0) {
                pop0[c0] = seq[i2];
                ++c0;
            }
            if (type[i2] == 1) {
                pop1[c1] = seq[i2];
                ++c1;
            }
            ++i2;
        }
        double Hw = FstBoot2.Hw(pop0, pop1);
        double Hb = FstBoot2.Hb(pop0, pop1);
        return 1.0 - Hw / Hb;
    }

    public static double Fst92(int popNo1, int popNo2, int[] type, String[] seq) {
        int len = type.length;
        if (len > seq.length) {
            len = seq.length;
        }
        int count0 = 0;
        int count1 = 0;
        int i = 0;
        while (i < len) {
            if (type[i] == popNo1) {
                ++count0;
            }
            if (type[i] == popNo2) {
                ++count1;
            }
            ++i;
        }
        String[] pop1 = new String[count0];
        String[] pop2 = new String[count1];
        int c0 = 0;
        int c1 = 0;
        int i2 = 0;
        while (i2 < len) {
            if (type[i2] == popNo1) {
                pop1[c0] = seq[i2];
                ++c0;
            }
            if (type[i2] == popNo2) {
                pop2[c1] = seq[i2];
                ++c1;
            }
            ++i2;
        }
        double Hw = FstBoot2.Hw(pop1, pop2);
        double Hb = FstBoot2.Hb(pop1, pop2);
        return 1.0 - Hw / Hb;
    }

    static double Hw(String[] pop) {
        double result = 0.0;
        double count = 0.0;
        int i = 0;
        while (i < pop.length - 1) {
            int j = i + 1;
            while (j < pop.length) {
                count += 1.0;
                result += FstBoot2.diff(pop[i], pop[j]);
                ++j;
            }
            ++i;
        }
        if (count == 0.0) {
            return 0.0;
        }
        return result / count;
    }

    static double Hw(String[] pop, boolean fifth) {
        double result = 0.0;
        double count = 0.0;
        int i = 0;
        while (i < pop.length - 1) {
            int j = i + 1;
            while (j < pop.length) {
                count += 1.0;
                result += FstBoot2.diff(pop[i], pop[j], fifth);
                ++j;
            }
            ++i;
        }
        if (count == 0.0) {
            return 0.0;
        }
        return result / count;
    }

    static double Hw(String[] pop1, String[] pop2) {
        double count1 = pop1.length;
        double count2 = pop2.length;
        return (FstBoot2.Hw(pop1) * count1 + FstBoot2.Hw(pop2) * count2) / (count1 + count2);
    }

    static double Hw(String[] pop1, String[] pop2, boolean fifth) {
        double count1 = pop1.length;
        double count2 = pop2.length;
        return (FstBoot2.Hw(pop1, fifth) * count1 + FstBoot2.Hw(pop2, fifth) * count2) / (count1 + count2);
    }

    static double Hb(String[] pop1, String[] pop2) {
        double result = 0.0;
        double count = 0.0;
        int i = 0;
        while (i < pop1.length) {
            int j = 0;
            while (j < pop2.length) {
                count += 1.0;
                result += FstBoot2.diff(pop1[i], pop2[j]);
                ++j;
            }
            ++i;
        }
        if (count == 0.0) {
            return 0.0;
        }
        return result / count;
    }

    static double Hb(String[] pop1, String[] pop2, boolean fifth) {
        double result = 0.0;
        double count = 0.0;
        int i = 0;
        while (i < pop1.length) {
            int j = 0;
            while (j < pop2.length) {
                count += 1.0;
                result += FstBoot2.diff(pop1[i], pop2[j], fifth);
                ++j;
            }
            ++i;
        }
        if (count == 0.0) {
            return 0.0;
        }
        return result / count;
    }

    static double diff(String seq1, String seq2) {
        double result = 0.0;
        int len = seq1.length();
        if (len > seq2.length()) {
            len = seq2.length();
        }
        int i = 0;
        while (i < len) {
            if (seq1.charAt(i) != seq2.charAt(i)) {
                result += 1.0;
            }
            ++i;
        }
        return result;
    }

    static double diff(String seq1, String seq2, boolean fifth) {
        double result = 0.0;
        int len = seq1.length();
        if (len > seq2.length()) {
            len = seq2.length();
        }
        int i = 0;
        while (i < len) {
            if (fifth) {
                if (seq1.charAt(i) != seq2.charAt(i)) {
                    result += 1.0;
                }
            } else if (seq1.charAt(i) != '-' && seq2.charAt(i) != '-' && seq1.charAt(i) != seq2.charAt(i)) {
                result += 1.0;
            }
            ++i;
        }
        return result;
    }
}

