/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.ui.navigator;

/**
 * プロジェクト情報をもつクラスです。
 * 
 * @author		<A href="mailto:s_imai@valtech.jp">S.Imai</A>
 * @version	Ver.0.8
 */
public class ProjectConfig {
	
	/** プロジェクト名 */
	private String projectName = null;
	
	/** ユーザ名 */
	private String userName = null;
	
	/** SSID */
	private String ssid = null;
	
	/** メール通知チェック */
	private boolean mailCheck = false;
	
	/** SMTPサーバ */
	private String smtp = null;
	
	/** 差出人アドレス */
	private String sender = null;
	
	/** 送信先アドレス */
	private String recipient = null;
	
	/** タイトルプレフィックス */
	private String prefix = null;
	
	/** カテゴリ */
	private String category = null;
	
	/** 優先度 */
	private String priority = null;
	
	/** 担当者 */
	private String assigned = null;
	
	/** 投票数チェック */
	private boolean voteCheck = false;
	
	/** 投票数 */
	private String vote = null;
	
	/** 完了期限チェック */
	private boolean untilDeadLineCheck = false;
	
	/** 完了期限 */
	private String untilDeadLine = null;
	
	/** 固定同期処理チェック */
	private boolean fixedSyncCheck = false;
	
	/** アドレス1番目 */
	private String address1 = null;
	
	/** アドレス2番目 */
	private String address2 = null;
	
	/** アドレス3番目 */
	private String address3 = null;
	
	/** アドレス4番目 */
	private String address4 = null;
	
	/** ポート番号 */
	private String port = null;
	
	/** 自動同期処理チェック */
	private boolean autoSyncCheck = false;
	
	/** 通常の同期ラジオ */
	private boolean normalSyncRadio = false;
	
	/** 端末指定同期ラジオ */
	private boolean appointSyncRadio = false;
	
	
	public ProjectConfig() {
	}
	
	/**
	 * @return		プロジェクト名を戻します。
	 */
	public String getProjectName() {
		return projectName;
	}
	
	/**
	 * プロジェクト名を設定します。
	 */
	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}
	
	/**
	 * @return		SSIDを戻します。
	 */
	public String getSsid() {
		return ssid;
	}
	
	/**
	 * SSIDを設定します。
	 */
	public void setSsid(String ssid) {
		this.ssid = ssid;
	}
	
	/**
	 * @return		ユーザ名を戻します。
	 */
	public String getUserName() {
		return userName;
	}
	
	/**
	 * ユーザ名を設定します。
	 */
	public void setUserName(String userName) {
		this.userName = userName;
	}
	
	/**
	 * @return appointSyncRadio を戻します。
	 */
	public boolean isAppointSyncRadio() {
		return appointSyncRadio;
	}

	/**
	 * @param appointSyncRadio 設定する appointSyncRadio。
	 */
	public void setAppointSyncRadio(boolean appointSyncRadio) {
		this.appointSyncRadio = appointSyncRadio;
	}

	/**
	 * @return autoSyncCheck を戻します。
	 */
	public boolean isAutoSyncCheck() {
		return autoSyncCheck;
	}

	/**
	 * @param autoSyncCheck 設定する autoSyncCheck。
	 */
	public void setAutoSyncCheck(boolean autoSyncCheck) {
		this.autoSyncCheck = autoSyncCheck;
	}

	/**
	 * @return normalSyncRadio を戻します。
	 */
	public boolean isNormalSyncRadio() {
		return normalSyncRadio;
	}

	/**
	 * @param normalSyncRadio 設定する normalSyncRadio。
	 */
	public void setNormalSyncRadio(boolean normalSyncRadio) {
		this.normalSyncRadio = normalSyncRadio;
	}

	/**
	 * @return mailCheck を戻します。
	 */
	public boolean isMailCheck() {
		return mailCheck;
	}

	/**
	 * @param mailCheck 設定する mailCheck。
	 */
	public void setMailCheck(boolean mailCheck) {
		this.mailCheck = mailCheck;
	}

	/**
	 * @return recipient を戻します。
	 */
	public String getRecipient() {
		return recipient;
	}

	/**
	 * @param recipient 設定する recipient。
	 */
	public void setRecipient(String recipient) {
		this.recipient = recipient;
	}

	/**
	 * @return sender を戻します。
	 */
	public String getSender() {
		return sender;
	}

	/**
	 * @param sender 設定する sender。
	 */
	public void setSender(String sender) {
		this.sender = sender;
	}

	/**
	 * @return smtp を戻します。
	 */
	public String getSmtp() {
		return smtp;
	}

	/**
	 * @param smtp 設定する smtp。
	 */
	public void setSmtp(String smtp) {
		this.smtp = smtp;
	}

	/**
	 * @return prefix を戻します。
	 */
	public String getPrefix() {
		return prefix;
	}

	/**
	 * @param prefix 設定する prefix。
	 */
	public void setPrefix(String prefix) {
		this.prefix = prefix;
	}

	/**
	 * @return		カテゴリを戻します。
	 */
	public String getCategory() {
		return category;
	}

	
	/**
	 * カテゴリを設定します。
	 */
	public void setCategory(String category) {
		this.category = category;
	}

	/**
	 * @return		優先度を戻します。
	 */
	public String getPriority() {
		return priority;
	}
	
	/**
	 * @return		優先度を配列に変換して返します。
	 */
	public String[] getPriorities() {
		if(priority==null) {
			return null;
		}
		// 縦棒で分けて配列にする
		String[] priorities = priority.split("|");
		
		// 文字列の前後をtrimする
		for (int idx = 0; idx < priorities.length; idx++) {
			priorities[idx] = priorities[idx].trim();
		}
		
		return priorities;
	}

	
	/**
	 * 優先度を設定します。
	 */
	public void setPriority(String priority) {
		this.priority = priority;
	}
	
	/**
	 * @return 担当者を戻します。
	 */
	public String getAssigned() {
		return assigned;
	}

	/**
	 * 担当者を設定します。
	 * 
	 * @param 担当者
	 */
	public void setAssigned(String assigned) {
		this.assigned = assigned;
	}

	/**
	 * @return		完了期限を戻します。
	 */
	public String getUntilDeadLine() {
		return untilDeadLine;
	}

	/**
	 * 完了期限を設定します。
	 */
	public void setUntilDeadLine(String untilDeadLine) {
		this.untilDeadLine = untilDeadLine;
	}

	/**
	 * @return		完了期限チェックを戻します。
	 */
	public boolean isUntilDeadLineCheck() {
		return untilDeadLineCheck;
	}

	/**
	 * 完了期限チェックを設定します。
	 */
	public void setUntilDeadLineCheck(boolean untilDeadLineCheck) {
		this.untilDeadLineCheck = untilDeadLineCheck;
	}

	/**
	 * @return		投票数を戻します。
	 */
	public String getVote() {
		return vote;
	}

	/**
	 * 投票数を設定します。
	 */
	public void setVote(String vote) {
		this.vote = vote;
	}

	/**
	 * @return		投票数チェックを戻します。
	 */
	public boolean isVoteCheck() {
		return voteCheck;
	}
	
	/**
	 * 投票数チェックを設定します。
	 */
	public void setVoteCheck(boolean voteCheck) {
		this.voteCheck = voteCheck;
	}

	/**
	 * @return address1 を戻します。
	 */
	public String getAddress1() {
		return address1;
	}

	/**
	 * @param address1 を設定します。
	 */
	public void setAddress1(String address1) {
		this.address1 = address1;
	}

	/**
	 * @return address2 を戻します。
	 */
	public String getAddress2() {
		return address2;
	}

	/**
	 * @param address2 を設定します。
	 */
	public void setAddress2(String address2) {
		this.address2 = address2;
	}

	/**
	 * @return address3 を戻します。
	 */
	public String getAddress3() {
		return address3;
	}

	/**
	 * @param address3 を設定します。
	 */
	public void setAddress3(String address3) {
		this.address3 = address3;
	}

	/**
	 * @return address4 を戻します。
	 */
	public String getAddress4() {
		return address4;
	}

	/**
	 * @param address4 を設定します。
	 */
	public void setAddress4(String address4) {
		this.address4 = address4;
	}

	public String getSyncAddress() {
		StringBuffer buf = new StringBuffer();
		buf.append(address1);
		buf.append(".");
		buf.append(address2);
		buf.append(".");
		buf.append(address3);
		buf.append(".");
		buf.append(address4);
		
		return buf.toString();
	}
	/**
	 * @return fixedSyncCheck を戻します。
	 */
	public boolean isFixedSyncCheck() {
		return fixedSyncCheck;
	}

	/**
	 * @param fixedSyncCheck を設定します。
	 */
	public void setFixedSyncCheck(boolean fixedSyncCheck) {
		this.fixedSyncCheck = fixedSyncCheck;
	}

	/**
	 * @return port を戻します。
	 */
	public String getPort() {
		return port;
	}

	/**
	 * @return port を戻します。
	 */
	public int getSyncPort() {
		if(port ==null) {
			return 0;
		}
		try {
			return Integer.parseInt(port);
		}catch (Exception e) {
			return 0;
		}
	}

	/**
	 * @param port を設定します。
	 */
	public void setPort(String port) {
		this.port = port;
	}
	
}
