/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.ui.msglist;

/**
 * メッセージフィルタ情報をもつクラスです。
 * 
 * @author		<A href="mailto:s_imai@valtech.jp">S.Imai</A>
 * @version	Ver.0.8
 */
public class MessageFilter {

	/** システムメッセージチェック */
	private boolean msgSystemChk = false;
	
	/** ユーザメッセージチェック */
	private boolean msgUserChk = false;
	
	/** メッセージコンボ */
	private String messageCmb = null;
	
	/** メッセージ */
	private String message = null;
	
	/** From日付 */
	private String frmDate = null;
	
	/** To日付 */
	private String toDate = null;
	
	/** チェックが付いていない送信者 「|」区切り */
	private String senderChk = null;


	/**
	 * @return frmDate を戻します。
	 */
	public String getFrmDate() {
		return frmDate;
	}


	/**
	 * @param frmDate 設定する frmDate。
	 */
	public void setFrmDate(String frmDate) {
		this.frmDate = frmDate;
	}


	/**
	 * @return message を戻します。
	 */
	public String getMessage() {
		return message;
	}


	/**
	 * @param message 設定する message。
	 */
	public void setMessage(String message) {
		this.message = message;
	}


	/**
	 * @return messageCmb を戻します。
	 */
	public String getMessageCmb() {
		return messageCmb;
	}


	/**
	 * @param messageCmb 設定する messageCmb。
	 */
	public void setMessageCmb(String messageCmb) {
		this.messageCmb = messageCmb;
	}


	/**
	 * @return msgSystemChk を戻します。
	 */
	public boolean isMsgSystemChk() {
		return msgSystemChk;
	}


	/**
	 * @param msgSystemChk 設定する msgSystemChk。
	 */
	public void setMsgSystemChk(boolean msgSystemChk) {
		this.msgSystemChk = msgSystemChk;
	}


	/**
	 * @return msgUserChk を戻します。
	 */
	public boolean isMsgUserChk() {
		return msgUserChk;
	}


	/**
	 * @param msgUserChk 設定する msgUserChk。
	 */
	public void setMsgUserChk(boolean msgUserChk) {
		this.msgUserChk = msgUserChk;
	}

	
	/**
	 * @return toDate を戻します。
	 */
	public String getToDate() {
		return toDate;
	}


	/**
	 * @param toDate 設定する toDate。
	 */
	public void setToDate(String toDate) {
		this.toDate = toDate;
	}


	/**
	 * @return senderChk を戻します。
	 */
	public String getSenderChk() {
		return senderChk;
	}


	/**
	 * @param senderChk 設定する senderChk。
	 */
	public void setSenderChk(String senderChk) {
		this.senderChk = senderChk;
	}
		
	
}
