/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.ui.action;

import jp.valtech.bts.network.ClientInfo;
import jp.valtech.bts.network.ClientList;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.msglist.MessageSenderDialog;
import jp.valtech.bts.util.BTSUtility;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.part.ViewPart;

/**
 * {@link MessageSenderDialog メッセージ送信ダイアログ}を開くアクションです。
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class OpenMessageDlgAction extends Action {

	/** 活性時のアイコン */
	private static final ImageDescriptor THIS_IMAGE = BtsPlugin.getInstance().getImageDescriptor("mail.gif"); 
	/** 非活性時のアイコン */
	private static final ImageDescriptor THIS_IMAGE_DISABLE = BtsPlugin.getInstance().getImageDescriptor("mail_disable.gif"); 

	/** このアクションの呼び出しもとのビューオブジェクト */
	private ViewPart view;

    /** 送信メッセージ（受信メッセージの引用符） */
    private String message = null;

	/** 送信先情報 */
	private ClientInfo clientInfo;

	/** 送信先を全員にするかどうか。true--全員、false--全員でない*/
	private boolean sendAll = false;

	/**
	 * 呼び出し元のビューインスタンスと送信タイプを設定します。
	 * 
	 * @param		view			 呼び出し元のビューインスタンス
	 */
	public OpenMessageDlgAction(ViewPart view) {
		super();
		this.view = view;
		setText(Messages.getString("OpenMessageDlgAction.0")); //$NON-NLS-1$

		setImageDescriptor(THIS_IMAGE);
		setDisabledImageDescriptor(THIS_IMAGE_DISABLE);
	}


	/**
	 * {@link MessageSenderDialog}を開きます。
	 */
	public void run() {

		MessageSenderDialog dialog = new MessageSenderDialog(view.getSite().getShell());
		
		// 返信メッセージの場合
		if (this.message != null && !message.equals("")) {
			message = message.replaceAll("^", ">");
			message = message.replaceAll("\n", "\n>");
			message = "\n" + message;
			dialog.setReplyMessage(message);
		}

		// 送信先情報設定
		dialog.setClientInfo(this.clientInfo);
		dialog.setSendAll(this.sendAll);
		
		dialog.open();
	}


	/**
	 * {@link ClientInfo 接続ユーザ情報}を格納します。
	 * 
	 * @param		clientInfo		接続ユーザ情報
	 */
	public void setClientInfo(ClientInfo clientInfo) {
		
		if(BTSUtility.isLocalHost(clientInfo)) {
			this.clientInfo = null;
		} else {
			this.clientInfo = clientInfo;
		}
	}

	
	/**
	 * 送信元ユーザ名を格納します。
	 * 送信元ユーザ名を元に{@link ClientInfo 接続ユーザ情報}を生成して当インスタンスに保持します。
	 * 
	 * @param		fromUser		送信元ユーザ名
	 */
	public void setFromUser(String fromUser) {
		ClientInfo info = ClientList.getClientInfoByClientName(fromUser);

		// 取得したClientInfoにより処理を分ける
		if(info ==null) {
			// ClientInfoを取得できなかった場合
			this.clientInfo = null;
		} else if(BTSUtility.isLocalHost(info)) { 
			// ClientInfoが自分だった場合
			this.clientInfo = null;
		} else {
			// ClientInfo取得
			this.clientInfo = info;
		}
	}


	/**
	 * あて先を全員にするかどうか
	 * 
	 * @param		sendAll		
	 */
	public void setSendAll(boolean sendAll) {
		this.sendAll = sendAll;
	}

	/**
	 * 返信メッセージを設定
	 * 
	 * @param		message		返信メッセージ
	 */
	public void setReplyMessage(String message) {
		this.message = message;
	}
}
