/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.ui.action;

import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;

import jp.valtech.bts.data.Issue;
import jp.valtech.bts.data.IssueType;
import jp.valtech.bts.facade.ReceiveGarbageIssueFacade;
import jp.valtech.bts.facade.ReceiveReleaseIssueFacade;
import jp.valtech.bts.facade.VoteDAOFacade;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.util.Logging;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.part.ViewPart;

/**
 * 課題票をインポートするアクションです。
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class ImportIssueAction extends Action implements Logging {
	
	/** このアクションの呼び出しもとのビューオブジェクト */
	private ViewPart view;


	/**
	 * アクションを生成します。
	 * 
	 * @param		view			 呼び出し元のビューインスタンス
	 */
	public ImportIssueAction(ViewPart view) {
		super();
		this.view = view;
		setText(Messages.getString("ImportIssueAction.0")); //$NON-NLS-1$
		setToolTipText(Messages.getString("ImportIssueAction.1"));  //$NON-NLS-1$
		setImageDescriptor(BtsPlugin.getInstance().getImageDescriptor("import.gif"));
	}
	
	/**
	 * 課題票インポートを実行します。
	 */
	public void run() {
		
		try {
			
			// ファイルオープンダイアログ生成
			FileDialog fileDialog = new FileDialog(view.getSite().getShell(), SWT.OPEN);
			fileDialog.setFilterExtensions(new String[]{"*.bts"});
			
			// ファイルオープンダイアログを開き、ファイルパス取得
			String fileName = fileDialog.open();
			
			if(fileName==null || fileName.equals("")) {
				return;
			}
    		// 存在するファイルかどうかのチェック
    		File file = new File(fileName);
    		if(!file.exists()) {
    			return;
    		}
    		
			// 課題票のインポート
			FileInputStream fileInputStream = new FileInputStream(fileName);
			ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
			Issue importIssue = (Issue) objectInputStream.readObject();

			// インポートした課題票が「配布済み」の時
			if( IssueType.RELEASE_VALUE.equals(importIssue.getType()) ){

				// 課題票を保存
				ReceiveReleaseIssueFacade facade = new ReceiveReleaseIssueFacade();
				facade.importReleaseIssue(importIssue);
				// メッセージを保存
				facade.saveImportMessage();
			}
			
			// インポートした課題票が「ごみ箱」の時
			else if( IssueType.GARBAGE_VALUE.equals(importIssue.getType()) ){

				// 課題票を保存
				ReceiveGarbageIssueFacade facade = new ReceiveGarbageIssueFacade();
				facade.changeGarbageIssue(importIssue);
				// メッセージを保存
				facade.saveReceiveMessage();
			}

			// 投票情報更新
			VoteDAOFacade voteDAOFacade = new VoteDAOFacade();
			voteDAOFacade.cleanInsert(importIssue.getVotes());

			
		} catch (Exception e) {
			String msg = Messages.getString("ImportIssueAction.2"); //$NON-NLS-1$
			logger.fatal(msg, e);
			BtsPlugin.getInstance().error(msg, e);
		}
		
	}
	
}
