/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.ui;

import org.eclipse.jface.viewers.TableViewer;

/**
 * BTSシステムのテーブル表示にて必要な機能のインタフェースです。 
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public interface IBtsViewPart {
	
	
	/**
	 * {@link org.eclipse.ui.part.ViewPart#setContentDescription(java.lang.String) 一覧の説明文字列}の設定を更新します。
	 * 
	 * 「フィルタ表示している件数」を表示します。
	 * 
	 * @param			filterListSize			フィルタ表示している件数
	 */
	public void updateDescription(int filterListSize);


	/**
	 * ビューが保持しているビューアオブジェクトを取得します。
	 * 
	 * @return			ビューが保持しているビューアオブジェクト
	 */
	public TableViewer getViewer();
}
