/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.data;

import java.io.Serializable;
import java.util.Date;

/**
 * <dl><dt><b>課題票ヘッダ情報</b></dt>
 * 	<dd>同期処理の際使用します。</dd>
 * </dl>
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class IssueSyncHeader implements Serializable {

	/** シリアルID　*/
	private static final long serialVersionUID = 6799087284867026426L;

	/** 指紋 : 課題票を一意に識別するためのSHA-1フィンガープリント */
	private String fingerPrint = null;

	/** レコード更新タイムスタンプ : このレコードを更新した日時のタイムスタンプ */
	private Date updateDate = null;

	/** バージョン番号 : 更新したらインクリメントする通し番号 */
	private int version = 0;


	/**
	 * 課題票ヘッダインスタンス生成
	 *
	 */
	public IssueSyncHeader() {
		;
	}
	
	
	/**
	 * <DL>
	 * <DT><B>指紋 を戻します。</B></B>
	 * <DD></DD>
	 * </DL>
	 * @return 指紋 
	 */
	public String getFingerPrint() {
		return this.fingerPrint;
	}

	/**
	 * <DL>
	 * <DT><B>指紋を設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param fingerPrint 指紋
	 */
	public void setFingerPrint( String fingerPrint ) {
		this.fingerPrint = fingerPrint;
	}
	
	/**
	 * <DL>
	 *  <DT><B>レコード更新タイムスタンプ に日時情報を設定します。</B></DL>
	 *  <DD></DD>
	 * </DL>
	 * @param updateDate        レコード更新タイムスタンプ に指定する日時オブジェクト
	 */
	public void setUpdateDate( Date updateDate ){
		if( updateDate != null ){
			this.updateDate = new Date( updateDate.getTime() );
		}
	}

	/**
	 * <DL>
	 *  <DT><B>レコード更新タイムスタンプ に日時情報をlong型のタイムスタンプで設定します。</B></DL>
	 *  <DD></DD>
	 * </DL>
	 * @param timestamp   レコード更新タイムスタンプ に指定するlong型のタイムスタンプ
	 */
	public void setUpdateDate( long timestamp ){
		this.updateDate = new Date( timestamp );
	}

	/**
	 * <DL>
	 *  <DT><B>レコード更新タイムスタンプ を取得。</B></DL>
	 *  <DD></DD>
	 * </DL>
	 * @return レコード更新タイムスタンプ
	 */
	public Date getUpdateDate(){
		return this.updateDate;
	}

	/**
	 * <DL>
	 *  <DT><B>レコード更新タイムスタンプ をlongのタイムスタンプで取得</B></DL>
	 *  <DD>レコード更新タイムスタンプ の日付情報をlongのタイムスタンプで取得します。
	 * レコード更新タイムスタンプ がnullの場合、NullPointerExceptionが発生することに注意してください。</DD>
	 * </DL>
	 * @return レコード更新タイムスタンプ のタイムスタンプ(long)
	 */
	public long getUpdateDateTimestamp(){
		return this.updateDate.getTime();
	}

	/**
	 * <DL><DT><B>バージョン番号 を戻します。</B></B>
	 * <DD></DD>
	 * </DL>
	 * @return version バージョン番号
	 */
	public int getVersion() {
		return this.version;
	}

	/**
	 * <DL><DT><B>バージョン番号を設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param version バージョン番号。
	 */
	public void setVersion( int version ) {
		this.version = version;
	}
	
	
	/**
	 * 
	 * {@link java.util.AbstractCollection#removeAll(java.util.Collection)}で使う
	 */
	public boolean equals(Object obj) {
		// Issueインスタンスかどうかを確認
		if(obj instanceof IssueSyncHeader) {

			IssueSyncHeader that = (IssueSyncHeader)obj;
			if(this.fingerPrint.equals(that.getFingerPrint())) {

				// #removeで自分よりバージョンが新しいものを残す 
				//  localのバージョン == receiveのバージョン　-> 除外
				//  localのバージョン >  receiveのバージョン　-> 同期対象としてリクエスト元に返す
				//  localのバージョン <  receiveのバージョン　-> 除外

				if(this.version == that.getVersion()) {
					return true;
				} else if(this.version > that.getVersion()) {
					return false;
				} else if(this.version < that.getVersion()) {
					return true;
				}
			} else {
				// FingerPrintが違う場合
				return false;
			}
		}
		return false;
	}

}