/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.command.server;

import jp.valtech.bts.data.NetworkConfig;
import jp.valtech.bts.data.Vote;
import jp.valtech.bts.facade.VoteDAOFacade;
import jp.valtech.bts.network.Request;
import jp.valtech.bts.network.command.MulticastServerCommand;

/**
 * <dl><dt><b>投票を受信します。</b></dt>
 * <dd>他のクライアントからのマルチキャスト通信を受信し、このクラスが呼び出されると、課題票への投票を事項します。</dd>
 * 
 * @see			jp.valtech.bts.command.client.VoteAdd
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class VoteAddServer extends MulticastServerCommand {

	/**
	 * サーバコマンドインスタンスを生成します。
	 */
	public VoteAddServer() {
		super();
	}


	/**
	 * 投票を受信しローカル情報を更新します。
	 * 
	 * @param		request			リクエストオブジェクト
	 * @param		myconfig		ローカル端末のネットワーク情報
	 */
	public void execute(Request request, NetworkConfig myconfig){

		try {
			Vote vote = (Vote)request.getParameterObject( "vote" );
			VoteDAOFacade facade = new VoteDAOFacade();
			facade.cntPlus(vote);
		} catch (Exception e) {
			logger.fatal(e.getMessage(), e);
		}
	}
	
}
