/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.command.server;

import java.util.List;

import jp.valtech.bts.data.NetworkConfig;
import jp.valtech.bts.network.ClientInfo;
import jp.valtech.bts.network.ClientList;
import jp.valtech.bts.network.Request;
import jp.valtech.bts.network.command.MulticastServerCommand;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.IBtsListener;

/**
 * <dl><dt><b>ネットワークへの離脱通知を受信します。</b></dt>
 * <dd>
 * <ul>
 * 	<li>他のクライアントからのマルチキャスト通信を受信し、このクラスが呼び出されると、ネットワークからの離脱通知処理を実行します。
 *	<li>ネットワークへの離脱自体は、クライアントの終了や待ち受けるソフトウェアの終了で離脱することができますが、明示的に離脱を通知し、クライアントリストから参加情報を削除ためには離脱通知処理を行ってください。
 *  <li>ネットワークへの離脱通知を行った場合、クライアントリスト({@link jp.valtech.bts.network.ClientList})から、自分自身のクライアントを削除することが可能になります。
 * </ul>
 * </dd>
 * </dl>
 * 
 * @see			jp.valtech.bts.command.client.Leave
 * @see			jp.valtech.bts.network.ClientList
 * @see			jp.valtech.bts.network.command.MulticastServerCommand
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class LeaveServer extends MulticastServerCommand {

	/**
	 * サーバコマンドインスタンスを生成します。
	 */
	public LeaveServer() {
		super();
	}


	/*
	 *  (非 Javadoc)
	 * @see jp.valtech.bts.network.command.MulticastServerCommand#execute(jp.valtech.bts.network.Request, jp.valtech.bts.data.NetworkConfig)
	 */
	public void execute(Request request, NetworkConfig myconfig){
		
		// 削除するユーザ情報を取得する。存在しない場合は以降の処理はやらない		
		ClientInfo clientInfo = ClientList.getClientInfo( getRequestClient() );
		if(clientInfo == null) {
			return;
		}
		
		// クライアントリストから削除
		ClientList.remove( getRequestClient() );
		
		// ビューを最新表示する。
		List listeners = BtsPlugin.getInstance().getListeners();
		for (int idx = 0; idx < listeners.size(); idx++) {
			IBtsListener listnener = (IBtsListener)listeners.get(idx);
			listnener.leaveMember(clientInfo);
		}
	}

}
