/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.command.client;

import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.data.Issue;
import jp.valtech.bts.data.NetworkConfig;
import jp.valtech.bts.network.Request;
import jp.valtech.bts.network.command.TCPClientCommand;
import jp.valtech.bts.util.Logging;

/**
 * 課題票を送信します。
 * このコマンドで課題票を送信します。送信できる課題票の数はひとつのみです。
 * 課題票の送信にはTCP通信が使用されます。
 * 
 * @see			jp.valtech.bts.command.server.SendIssueServer
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class SendIssue extends TCPClientCommand implements Logging {


	/** 送信する課題票 */
	private Issue issue = null;
	
	/**
	 * クライアントコマンド生成
	 * 
	 * @param		config 		設定情報
	 * @param		host		送信先ホスト名
	 * @param		port 		送信先ポート番号
	 */
	public SendIssue( NetworkConfig myconfig, String host, int port ) {
		super( myconfig, host, port );
		setTimeout(myconfig.getSendTimeout());
	}

	
	/**
	 * このインスタンスに課題票を設定します。
	 * @param		issue		課題票
	 */
	public void setIssue(Issue issue) {
		this.issue = issue;
	}
	
	
	/**
	 * 課題票を送信します。
	 * 送信結果は{@link TCPClientCommand#isSuccessful()}にて取得します。
	 */
	public void execute() throws Exception {

		// 課題票が設定されてなかったら何もしません。
		if( this.issue == null ){
			return;
		}

		// 送信オブジェクトを生成
		Request request = new Request();
		
		// コマンド名を設定
		request.setCommand( "sendIssue" );

		// 送信するものを格納
		request.addParameter( "issue" 		, this.issue );

		String userName = CurrentProject.getInsance().getProjectConfig().getUserName();
		request.addParameter( "fromUser"	, userName);
		
		
		// 送信～受信をおこないます。
		send( request );
	}
}
