/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.ui.issuelist;

/**
 * 課題票フィルタ情報をもつクラスです。
 * 
 * @author		<A href="mailto:s_imai@valtech.jp">S.Imai</A>
 * @version	Ver.0.8
 */
public class IssueFilter {

	/** 課題票ID */
	private String issueID = null;
	
	/** From起票日 */
	private String frmDate = null;
	
	/** To起票日 */
	private String toDate = null;
	
	/** タイトルコンボ */
	private String titleCmb = null;
	
	/** タイトル */
	private String title = null;
	
	/** 詳細コンボ */
	private String descCmb = null;
	
	/** 詳細 */
	private String desc = null;
	
	/** チェックが付いていない担当者「|」区切り */
	private String assignedChk = null;
	
	/** チェックが付いていない優先度「|」区切り */
	private String priorityChk = null;
	
	/** ステータス：起票 */
	private boolean stOpenChk = false;
	
	/** ステータス：担当者割り当て済み */
	private boolean stAssignedChk = false;
	
	/** ステータス：対応済み */
	private boolean stResolvedChk = false;
	
	/** ステータス：確認済み */
	private boolean stVerifiedChk = false;
	
	/** ステータス：完了 */
	private boolean stClosedChk = false;

	/** 内緒のバグ */
	private boolean secretChk = false;
	
	/** 保留中 */
	private boolean reserveChk = false;
	
	/** 完了期限切れ */
	private boolean deadLineChk = false;

	
	
	
	/**
	 * @return assignedChk を戻します。
	 */
	public String getAssignedChk() {
		return assignedChk;
	}

	/**
	 * @param assignedChk 設定する assignedChk。
	 */
	public void setAssignedChk(String assignedChk) {
		this.assignedChk = assignedChk;
	}

	/**
	 * @return deadLineChk を戻します。
	 */
	public boolean isDeadLineChk() {
		return deadLineChk;
	}

	/**
	 * @param deadLineChk 設定する deadLineChk。
	 */
	public void setDeadLineChk(boolean deadLineChk) {
		this.deadLineChk = deadLineChk;
	}

	/**
	 * @return desc を戻します。
	 */
	public String getDesc() {
		return desc;
	}

	/**
	 * @param desc 設定する desc。
	 */
	public void setDesc(String desc) {
		this.desc = desc;
	}

	/**
	 * @return descCmb を戻します。
	 */
	public String getDescCmb() {
		return descCmb;
	}

	/**
	 * @param descCmb 設定する descCmb。
	 */
	public void setDescCmb(String descCmb) {
		this.descCmb = descCmb;
	}

	/**
	 * @return frmDate を戻します。
	 */
	public String getFrmDate() {
		return frmDate;
	}

	/**
	 * @param frmDate 設定する frmDate。
	 */
	public void setFrmDate(String frmDate) {
		this.frmDate = frmDate;
	}

	/**
	 * @return issueID を戻します。
	 */
	public String getIssueID() {
		return issueID;
	}

	/**
	 * @param issueID 設定する issueID。
	 */
	public void setIssueID(String issueID) {
		this.issueID = issueID;
	}

	/**
	 * @return priorityChk を戻します。
	 */
	public String getPriorityChk() {
		return priorityChk;
	}

	/**
	 * @param priorityChk 設定する priorityChk。
	 */
	public void setPriorityChk(String priorityChk) {
		this.priorityChk = priorityChk;
	}

	/**
	 * @return reserveChk を戻します。
	 */
	public boolean isReserveChk() {
		return reserveChk;
	}

	/**
	 * @param reserveChk 設定する reserveChk。
	 */
	public void setReserveChk(boolean reserveChk) {
		this.reserveChk = reserveChk;
	}

	/**
	 * @return secretChk を戻します。
	 */
	public boolean isSecretChk() {
		return secretChk;
	}

	/**
	 * @param secretChk 設定する secretChk。
	 */
	public void setSecretChk(boolean secretChk) {
		this.secretChk = secretChk;
	}

	/**
	 * @return stAssignedChk を戻します。
	 */
	public boolean isStAssignedChk() {
		return stAssignedChk;
	}

	/**
	 * @param stAssignedChk 設定する stAssignedChk。
	 */
	public void setStAssignedChk(boolean stAssignedChk) {
		this.stAssignedChk = stAssignedChk;
	}

	/**
	 * @return stClosedChk を戻します。
	 */
	public boolean isStClosedChk() {
		return stClosedChk;
	}

	/**
	 * @param stClosedChk 設定する stClosedChk。
	 */
	public void setStClosedChk(boolean stClosedChk) {
		this.stClosedChk = stClosedChk;
	}

	/**
	 * @return stOpenChk を戻します。
	 */
	public boolean isStOpenChk() {
		return stOpenChk;
	}

	/**
	 * @param stOpenChk 設定する stOpenChk。
	 */
	public void setStOpenChk(boolean stOpenChk) {
		this.stOpenChk = stOpenChk;
	}

	/**
	 * @return stResolvedChk を戻します。
	 */
	public boolean isStResolvedChk() {
		return stResolvedChk;
	}

	/**
	 * @param stResolvedChk 設定する stResolvedChk。
	 */
	public void setStResolvedChk(boolean stResolvedChk) {
		this.stResolvedChk = stResolvedChk;
	}

	/**
	 * @return stVerifiedChk を戻します。
	 */
	public boolean isStVerifiedChk() {
		return stVerifiedChk;
	}

	/**
	 * @param stVerifiedChk 設定する stVerifiedChk。
	 */
	public void setStVerifiedChk(boolean stVerifiedChk) {
		this.stVerifiedChk = stVerifiedChk;
	}

	/**
	 * @return title を戻します。
	 */
	public String getTitle() {
		return title;
	}

	/**
	 * @param title 設定する title。
	 */
	public void setTitle(String title) {
		this.title = title;
	}

	/**
	 * @return titleCmb を戻します。
	 */
	public String getTitleCmb() {
		return titleCmb;
	}

	/**
	 * @param titleCmb 設定する titleCmb。
	 */
	public void setTitleCmb(String titleCmb) {
		this.titleCmb = titleCmb;
	}

	/**
	 * @return toDate を戻します。
	 */
	public String getToDate() {
		return toDate;
	}

	/**
	 * @param toDate 設定する toDate。
	 */
	public void setToDate(String toDate) {
		this.toDate = toDate;
	}

//	/** チェックが付いているその他の表示 */
//	protected String otherChk = null;

	
	
	

	
}
