/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.ui.action;

import java.util.List;

import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.facade.ModifyIssueFacade;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.IBtsListener;
import jp.valtech.bts.util.Logging;

import org.eclipse.jface.action.Action;

/**
 * UI表示を最新にするアクションです。
 * 最新表示はローカルDBを読み込み、その情報を表示します。<br>
 * 他の端末と同期をとり最新表示する場合は{@link jp.valtech.bts.ui.action.SyncRemoteAction}を使います。
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class RefreshAction extends Action implements Logging{

	/**
	 * 呼び出し元のビューインスタンスを設定します。
	 */
	public RefreshAction() {
		super();
		setText(Messages.getString("RefreshAction.0")); //$NON-NLS-1$
		setToolTipText(Messages.getString("RefreshAction.1"));  //$NON-NLS-1$
		setImageDescriptor(BtsPlugin.getInstance().getImageDescriptor("refresh.gif"));
	}

	
	/**
	 * ローカルDBの情報でビューを最新表示にします。
	 */
	public void run() {
		try {
			
			// カレントプロジェクトが設定されてない場合は何もしません。
			CurrentProject project = CurrentProject.getInsance();
			if(!project.isOpen()) {
				return;
			}
			
			// 課題票一覧を取得
			ModifyIssueFacade issueModifyFacade = new ModifyIssueFacade(); 
			List issueList = issueModifyFacade.getIssueList() ;

			// 現在プラグインが保持しているリスナクラスを取得します。
			List listeners = BtsPlugin.getInstance().getListeners();
			
			// 各リスナにビューを最新表示をするよう通知します。
			for (int idx = 0; idx < listeners.size(); idx++) {
				IBtsListener listnener = (IBtsListener)listeners.get(idx);
				listnener.refresh(issueList);
			}
			
		} catch (Exception e) {
			String msg = Messages.getString("RefreshAction.2"); //$NON-NLS-1$
			BtsPlugin.getInstance().error(msg, e);
			logger.fatal(msg, e);
		}
	}

}
