/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.ui.action;

import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.navigator.ProjectConfigDialog;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.ViewPart;

/**
 * {@link jp.valtech.bts.ui.navigator.ProjectConfigDialog プロジェクト情報のダイアログ}を開くアクションです。
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class OpenProjectConfigDlgAction extends Action {

	/** オープンモード：新規に開く */
	public static final int NEW = 0;
	/** オープンモード：更新 */
	public static final int EDIT = 1;
	/** オープンモード：更新、オープン時に「課題票タブ」をアクティブ */
	public static final int EDIT_ISSUE = 2;
	
	/** オープンモード */
	private int mode = EDIT;

	/** このアクションの呼び出しもとのビューオブジェクト */
	private Shell parent;

	/** プロジェクトのSSID */
	private String ssid;

	
	
	/**
	 * アクションを生成します。
	 * 
	 * @param view
	 *            呼び出し元のビューインスタンス
	 */
	public OpenProjectConfigDlgAction(ViewPart view, int mode) {
		super();
		
		this.mode = mode;
		
		this.parent = view.getSite().getShell();
		
		if (mode == NEW) {
			setText(Messages.getString("OpenProjectConfigDlgAction.0")); //$NON-NLS-1$
			setToolTipText(Messages.getString("OpenProjectConfigDlgAction.1")); //$NON-NLS-1$
			setImageDescriptor(BtsPlugin.getInstance().getImageDescriptor(
					"project_new.gif"));
		} else if (mode == EDIT) {
			setText(Messages.getString("OpenProjectConfigDlgAction.2")); //$NON-NLS-1$
			setToolTipText(Messages.getString("OpenProjectConfigDlgAction.3")); //$NON-NLS-1$

		}
	}

	
	/**
	 * アクションを生成します。
	 * 
	 * @param		editor			呼び出しもとのエディタインスタンス
	 */
	public OpenProjectConfigDlgAction(IEditorPart editor) {
		super();
		this.ssid = CurrentProject.getInsance().getSSID();
		this.parent = editor.getSite().getShell();
		this.mode = EDIT_ISSUE;
	}
	
	
	/**
	 * {@link jp.valtech.bts.ui.navigator.ProjectConfigDialog プロジェクト情報のダイアログ}を開きます。
	 */
	public void run() {
		
		// 右クリックしたときに取得したSSIDの有無を調べる
		if (ssid == null) {
			
			// SSIDがnullの場合はツールボタンから新規作成した場合
			ProjectConfigDialog dialog = new ProjectConfigDialog(parent);
			dialog.open();

		} else if(ssid != null && mode == EDIT) {
		
			// SSIDがある場合は右クリックメニューから編集した場合
			ProjectConfigDialog dialog = new ProjectConfigDialog(parent, ssid);
			dialog.open();

		} else if(ssid != null && mode == EDIT_ISSUE) {
			
			// EDIT_ISSUEなのでオープン時に「課題票タブ」を指定する
			ProjectConfigDialog dialog = new ProjectConfigDialog(parent, ssid, ProjectConfigDialog.TAB_INDEX_ISSUE);
			dialog.open();
		}
	}


	/**
	 * SSIDを設定します。
	 * 
	 * @param ssid
	 *            SSID
	 */
	public void setSSID(String ssid) {
		this.ssid = ssid;
	}

}
