/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.ui.action;

import jp.valtech.bts.data.MessagePacket;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.util.AttachmentUtility;
import jp.valtech.bts.util.Logging;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;

/**
 * メッセージの添付ファイルを保存するアクションです。
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class DownloadMessageAttachmentAction extends Action implements Logging {

	/** メッセージ情報 */
	private MessagePacket messagePacket;

	/**
	 * 呼び出し元のビューインスタンスを設定します。
	 * 
	 * @param		view			 呼び出し元のビューインスタンス
	 */
	public DownloadMessageAttachmentAction() {
		super();
		setText(Messages.getString("DownloadMessageAttachmentAction.0")); //$NON-NLS-1$
		setToolTipText(Messages.getString("DownloadMessageAttachmentAction.1"));  //$NON-NLS-1$
	}


	/**
	 * 添付ファイルをファイルシステムに出力します。
	 */
	public void run() {
		try {
			// ファイル保存ダイアログを開き、出力先を指定する。
			FileDialog dialog = new FileDialog(BtsPlugin.getInstance().getShell(), SWT.SAVE);
			dialog.setFileName(messagePacket.getAttachFileName());
			
			// 選択したファイルのフルパスを取得
			String path = dialog.open();
			if( path==null || "".equals(path)) {
				return;
			}
			
			new AttachmentUtility().writeLocalFromWorkspace(messagePacket, path);
			
		}catch (Exception e) {
			String msg = Messages.getString("DownloadMessageAttachmentAction.2"); //$NON-NLS-1$
			logger.fatal(msg, e);
			BtsPlugin.getInstance().error(msg, e);
		}
	}

	/**
	 * メッセージ情報を格納します。
	 * 
	 * @param		messagePacket		メッセージ情報
	 */
	public void setMessagePacket(MessagePacket messagePacket) {
		this.messagePacket = messagePacket;
	}
}
