/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.ui.action;

import jp.valtech.bts.data.Attachment;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.util.AttachmentUtility;
import jp.valtech.bts.util.Logging;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;

/**
 * 課題票エディタの「添付ファイル一覧」にて右クリックから
 * 「名前を付けて保存」を選択したときに呼ばれるアクションです。
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class DownloadIssueAttachmentAction extends Action implements Logging {


	/** プロジェクトのSSID */
	private Attachment attachment;

	/**
	 * アクションを生成します。
	 */
	public DownloadIssueAttachmentAction() {
		super();
		setText(Messages.getString("DownloadIssueAttachmentAction.0")); //$NON-NLS-1$
	}
	
	/**
	 * ファイル保存ダイアログを開き、そこで指定したPATHにファイルを出力します。
	 * 
	 */
	public void run() {
		try {
			// ファイル保存ダイアログを開き、出力先を指定する。
			FileDialog dialog = new FileDialog(BtsPlugin.getInstance().getShell(), SWT.SAVE);
			dialog.setFileName(attachment.getDisplayName());
			
			// 選択したファイルのフルパスを取得
			String path = dialog.open();
			if( path==null || "".equals(path)) {
				return;
			}
			
			// DBに登録済みとそうでない場合で処理を分ける。
			if(attachment.isRegisted()) {
				// DBに登録ずみの場合。ワークスペースからファイルを取得して指定の場所に出力する
				new AttachmentUtility().writeLocalFromWorkspace(attachment, path);
			} else {
				// まだDBに登録されてない場合。ローカルにファイルを指定の場所に出力する
				new AttachmentUtility().writeLocalFromLocal(attachment, path);
			}
			
		}catch (Exception e) {
			String msg = Messages.getString("DownloadIssueAttachmentAction.1"); //$NON-NLS-1$
			logger.fatal(msg, e);
			BtsPlugin.getInstance().error(msg, e);
		}
	}
	

	/**
	 * 添付ファイル情報を設定します。
	 * 
	 * @param		attachment			添付ファイル情報
	 */
	public void setAttachment(Attachment attachment) {
		this.attachment = attachment;
	}
}
