/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.network;


/**
 * レスポンスオブジェクト。
 * 送信側が作成する送信情報を格納したオブジェクトです。
 * 
 * @author		<A href="mailto:iinuma@valtech.jp">K.Iinuma</A>
 * @version	Ver.0.8
 */
public class Request extends TransData {

	/** シリアルID　*/
	private static final long serialVersionUID = -919250256108272645L;

	/** リクエストコマンド */
	protected String	command			= null;

	/** リクエストコマンド */
	protected String	ssid			= null;

	/**
	 * <DL><DT><B>リクエストコマンド を戻します。</B></B>
	 * <DD></DD>
	 * </DL>
	 * @return command リクエストコマンド
	 */
	public String getCommand() {
		return this.command;
	}

	/**
	 * <DL><DT><B>リクエストコマンドを設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param command リクエストコマンド。
	 */
	public void setCommand( String command ) {
		this.command = command;
	}

	/**
	 * <DL><DT><B>SSIDを戻します。</B></B>
	 * <DD></DD>
	 * </DL>
	 * @return SSID
	 */
	public String getSSID() {
		return this.ssid;
	}

	/**
	 * <DL><DT><B>SSIDを設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param ssid SSID
	 */
	public void setSSID( String ssid ) {
		this.ssid = ssid;
	}

}
