/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.network;

/**
 * <dl><dt><b>クライアント情報クラス</b></dt>
 * <dd>
 * 	クライアント一覧{@link jp.valtech.bts.network.ClientList}で保管されるクライアント情報のためのデータクラスです。
 * </dd>
 * </dl>
 * 
 * @author		<A href="mailto:iinuma@valtech.jp">K.Iinuma</A>
 * @version	Ver.0.8
 */
public class ClientInfo {

	/** クライアント名 */
	protected String clientName	= null;

	/** クライアントIPアドレス  */
	protected String clientAddress	= null;

	/** クライアントホスト名  */
	protected String clientHostName	= null;

	/** TCPポート番号 */
	protected Integer port			= null;

	/**
	 * <DL><DT><B>コンストラクタ</B>
	 *  <DD></DD>
	 * </DL>
	 */
	public ClientInfo() {
		super();
	}

	/**
	 * <DL><DT><B>クライアントIPアドレス を戻します。</B></B>
	 * <DD></DD>
	 * </DL>
	 * @return clientAddress クライアントIPアドレス
	 */
	public String getClientAddress() {
		return this.clientAddress;
	}

	/**
	 * <DL><DT><B>クライアントIPアドレスを設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param clientHostName クライアントIPアドレス。
	 */
	public void setClientAddress( String clientAddress ) {
		this.clientAddress = clientAddress;
	}

	/**
	 * <DL><DT><B>クライアントホスト名 を戻します。</B></B>
	 * <DD></DD>
	 * </DL>
	 * @return クライアントホスト名
	 */
	public String getClientHostName() {
		return this.clientHostName;
	}

	/**
	 * <DL><DT><B>クライアントホスト名を設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param clientAddress クライアントホスト名。
	 */
	public void setClientHostName( String clientHostName ) {
		this.clientHostName = clientHostName;
	}

	/**
	 * <DL><DT><B>クライアント名 を戻します。</B></B>
	 * <DD></DD>
	 * </DL>
	 * @return clientName クライアント名
	 */
	public String getClientName() {
		return this.clientName;
	}

	/**
	 * <DL><DT><B>クライアント名を設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param clientName クライアント名。
	 */
	public void setClientName( String clientName ) {
		this.clientName = clientName;
	}

	/**
	 * <DL><DT><B>TCPポート番号 を戻します。</B></B>
	 * <DD></DD>
	 * </DL>
	 * @return port TCPポート番号
	 */
	public Integer getPort() {
		return this.port;
	}

	/**
	 * <DL><DT><B>TCPポート番号を設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param port TCPポート番号。
	 */
	public void setPort( Integer port ) {
		this.port = port;
	}
	
	/**
	 * <DL><DT><B>TCPポート番号を設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param port TCPポート番号。
	 */
	public void setPort( int port ) {
		this.port = new Integer(port);
	}

	/**
	 * オブジェクトの比較を行います。
	 * 比較対象のオブジェクトと{@link	#getClientAddress IPアドレス}が同一の場合は、同一オブジェクトと判断します。
	 * 
	 * @param		obj			比較対照のオブジェクト
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj) {
		if(obj instanceof ClientInfo) {
			ClientInfo that = (ClientInfo)obj;
			return clientAddress.equals( that.getClientAddress() );
		}
		return false;
	}

	/*
	 *  (非 Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buf = new StringBuffer() ;
		buf.append("{clientName=" + clientName);
		buf.append(", clientAddress=" + clientAddress);
		buf.append(", port=" + port + "}");
		return buf.toString();
	}
	
}
