/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.facade;

import java.util.List;

import jp.valtech.bts.connection.MessageDBConnection;
import jp.valtech.bts.dao.MessagePacketDAO;
import jp.valtech.bts.data.MessagePacket;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.IBtsListener;
import jp.valtech.bts.util.AttachmentUtility;
import jp.valtech.bts.util.Logging;

/**
 * {@link jp.valtech.bts.dao.MessagePacketDAO}用のFacadeクラスです。
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class SendMessageFacade implements Logging {

	/**
	 * 何もしない。
	 */
	public SendMessageFacade() {
		;
	}
	


	/**
	 * 指定のメッセージを。追加します。
	 * 失敗してもエラーはスローしません。ログに残すだけです。
	 * 
	 * @param		messageID		メッセージID
	 */
	public void addMessage(MessagePacket message) {

		// DBコネクション取得
		MessageDBConnection dbcon = new MessageDBConnection();
		try {
			// ローカルDBに登録。
			MessagePacketDAO dao = new MessagePacketDAO( dbcon );
			dao.addMessage(message);

			// メッセージIDはDBには設定されているがJAVAオブジェクトには格納されてないので、ここで入れる
			int messageID = dao.getMaxMessageID();
			message.setMessageID(messageID);

			// 添付ファイルをファイルシステムに保存
			AttachmentUtility utility = new AttachmentUtility();
			utility.writeWorkspaceFromLocal(message);
			
			
			// 現在プラグインが保持しているリスナクラスを取得します。
			List listeners = BtsPlugin.getInstance().getListeners();
			
			// 各リスナにビューを最新表示をするよう通知します。
			for (int idx = 0; idx < listeners.size(); idx++) {
				IBtsListener listnener = (IBtsListener)listeners.get(idx);
				listnener.addMessage(message);
			}
			dbcon.commit();
		
		} catch (Exception e) {
			dbcon.rollback();

			// エラー情報の出力
			String msg = Messages.getString("SendMessagePacketFacade.0"); //$NON-NLS-1$
			logger.fatal(msg, e);
			BtsPlugin.getInstance().error(msg, e);
			
		} finally {
			dbcon.close();
			dbcon = null;
		}
	}

}
