/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.facade;

import jp.valtech.bts.connection.IssueDBConnection;
import jp.valtech.bts.dao.IssueHistoryDAO;
import jp.valtech.bts.data.Issue;
import jp.valtech.bts.data.IssueHistory;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.util.Logging;

/**
 * ローカルDB更新・画面再描画などを行うFacadeクラスです。
 * 当クラスのインスタンスは{@link #getInstance()}にて取得します。
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class IssueHistoryFacade implements Logging {

	
	//	DBコネクション取得
	IssueDBConnection dbcon = new IssueDBConnection();
	
	/**
	 * 当該インスタンスを生成時に、{@link IssueDBConnection コネクション}も生成されます。
	 * したがって、当該インスタンスを生成し使い終わったら必ず明示的に{@link #close()}を呼ぶようにしてください。
	 */
	public IssueHistoryFacade() {
	}

	/**
	 * <DL>
	 *   <DT><B>指定された{@link Issue#getFingerPrint() FingerPrint}を持つ課題票の課題票履歴を全件取得します。</B></DT>
	 *   <DD></DD>
	 * </DL>
	 * @param			fingerprint			課題票の{@link Issue#getFingerPrint() FingerPrint}
	 * @param			type				課題票の{@link jp.valtech.bts.data.IssueType 種別}
	 * @return			指定された課題票システムIDに属する課題票履歴全件。
	 * 					履歴が無い場合、または例外発生時はnull。
	 */
	public IssueHistory[] getByFingerPrint(String fingerprint, String type) {

		try {
			// 課題票を登録
			IssueHistoryDAO dao = new IssueHistoryDAO( dbcon );
			return dao.getByFingerPrint( fingerprint, type );
			
		} catch (Exception e) {

			// エラー情報の出力
			String msg = Messages.getString("IssueHistoryFacade.0"); //$NON-NLS-1$
			logger.fatal(msg, e);
			BtsPlugin.getInstance().error(msg, e);
			return null;
		}
	}
	

	/**
	 * 当該インスタンスを生成し使い終わったときには、必ず当メソッドを明示的に呼ぶようにしてください。
	 *
	 */
	public void close() {
		dbcon.close();
		dbcon = null;
	}
}
