/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.data;

import java.beans.XMLEncoder;

/**
 * {@link XMLEncoder}を利用してステータス別課題票件数をXMLに出力するためのJavaBeansクラスです。
 * {@link XMLEncoder}を利用するにはデフォルトコンストラクタが存在しなければなりません。
 * 
 * @author		<A href="mailto:s_imai@valtech.jp">S.Imai</A>
 * @version	Ver.0.8
 */
public class OutputStatus {

	/** 「起票」ステータス数 */
	private String openedCnt;
	
	/** 完了期限切れ「起票」ステータス数 */
	private String openedOverCnt;
	
	/** 「担当者割り当て」ステータス数 */
	private String assignedCnt;
	
	/** 完了期限切れ「担当者割り当て」ステータス数 */
	private String assignedOverCnt;
	
	/** 「対応済み」ステータス数 */
	private String resolvedCnt;
	
	/** 完了期限切れ「対応済み」ステータス数 */
	private String resolvedOverCnt;
	
	/** 「確認済み」ステータス数 */
	private String verifiedCnt;
	
	/** 完了期限切れ「確認済み」ステータス数 */
	private String verifiedOverCnt;
	
	/** 「完了」ステータス数 */
	private String closedCnt;
	
	/** 未完了ステータス合計 */
	private String notClosedSum;
	
	/** 完了期限切れ未完了ステータス合計 */
	private String notClosedOverSum;
	
	/** ステータス数合計 */
	private String statusSum;
	
	/** ヘッダ文字列 */
	private String header;
	
	/** フッタ文字列 */
	private String footer;
	
	/** レポート出力日時(yyyy/MM/dd HH:mm) */
	private String nowDate;
	
	
	/**
	 * デフォルトコンストラクタです。
	 */
	public OutputStatus() {
	}


	/**
	 * @return assignedCnt を戻します。
	 */
	public String getAssignedCnt() {
		return assignedCnt;
	}


	/**
	 * @param assignedCnt 設定する assignedCnt。
	 */
	public void setAssignedCnt(String assignedCnt) {
		this.assignedCnt = assignedCnt;
	}


	/**
	 * @return assignedOverCnt を戻します。
	 */
	public String getAssignedOverCnt() {
		return assignedOverCnt;
	}


	/**
	 * @param assignedOverCnt 設定する assignedOverCnt。
	 */
	public void setAssignedOverCnt(String assignedOverCnt) {
		this.assignedOverCnt = assignedOverCnt;
	}


	/**
	 * @return closedCnt を戻します。
	 */
	public String getClosedCnt() {
		return closedCnt;
	}


	/**
	 * @param closedCnt 設定する closedCnt。
	 */
	public void setClosedCnt(String closedCnt) {
		this.closedCnt = closedCnt;
	}


	/**
	 * @return footer を戻します。
	 */
	public String getFooter() {
		return footer;
	}


	/**
	 * @param footer 設定する footer。
	 */
	public void setFooter(String footer) {
		this.footer = footer;
	}


	/**
	 * @return header を戻します。
	 */
	public String getHeader() {
		return header;
	}


	/**
	 * @param header 設定する header。
	 */
	public void setHeader(String header) {
		this.header = header;
	}


	/**
	 * @return notClosedOverSum を戻します。
	 */
	public String getNotClosedOverSum() {
		return notClosedOverSum;
	}


	/**
	 * @param notClosedOverSum 設定する notClosedOverSum。
	 */
	public void setNotClosedOverSum(String notClosedOverSum) {
		this.notClosedOverSum = notClosedOverSum;
	}


	/**
	 * @return notClosedSum を戻します。
	 */
	public String getNotClosedSum() {
		return notClosedSum;
	}


	/**
	 * @param notClosedSum 設定する notClosedSum。
	 */
	public void setNotClosedSum(String notClosedSum) {
		this.notClosedSum = notClosedSum;
	}


	/**
	 * @return nowDate を戻します。
	 */
	public String getNowDate() {
		return nowDate;
	}


	/**
	 * @param nowDate 設定する nowDate。
	 */
	public void setNowDate(String nowDate) {
		this.nowDate = nowDate;
	}


	/**
	 * @return openedCnt を戻します。
	 */
	public String getOpenedCnt() {
		return openedCnt;
	}


	/**
	 * @param openedCnt 設定する openedCnt。
	 */
	public void setOpenedCnt(String openedCnt) {
		this.openedCnt = openedCnt;
	}


	/**
	 * @return openedOverCnt を戻します。
	 */
	public String getOpenedOverCnt() {
		return openedOverCnt;
	}


	/**
	 * @param openedOverCnt 設定する openedOverCnt。
	 */
	public void setOpenedOverCnt(String openedOverCnt) {
		this.openedOverCnt = openedOverCnt;
	}


	/**
	 * @return resolvedCnt を戻します。
	 */
	public String getResolvedCnt() {
		return resolvedCnt;
	}


	/**
	 * @param resolvedCnt 設定する resolvedCnt。
	 */
	public void setResolvedCnt(String resolvedCnt) {
		this.resolvedCnt = resolvedCnt;
	}


	/**
	 * @return resolvedOverCnt を戻します。
	 */
	public String getResolvedOverCnt() {
		return resolvedOverCnt;
	}


	/**
	 * @param resolvedOverCnt 設定する resolvedOverCnt。
	 */
	public void setResolvedOverCnt(String resolvedOverCnt) {
		this.resolvedOverCnt = resolvedOverCnt;
	}


	/**
	 * @return statusSum を戻します。
	 */
	public String getStatusSum() {
		return statusSum;
	}


	/**
	 * @param statusSum 設定する statusSum。
	 */
	public void setStatusSum(String statusSum) {
		this.statusSum = statusSum;
	}


	/**
	 * @return verifiedCnt を戻します。
	 */
	public String getVerifiedCnt() {
		return verifiedCnt;
	}


	/**
	 * @param verifiedCnt 設定する verifiedCnt。
	 */
	public void setVerifiedCnt(String verifiedCnt) {
		this.verifiedCnt = verifiedCnt;
	}


	/**
	 * @return verifiedOverCnt を戻します。
	 */
	public String getVerifiedOverCnt() {
		return verifiedOverCnt;
	}


	/**
	 * @param verifiedOverCnt 設定する verifiedOverCnt。
	 */
	public void setVerifiedOverCnt(String verifiedOverCnt) {
		this.verifiedOverCnt = verifiedOverCnt;
	}


}
