/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.data;

import java.io.Serializable;
import java.util.Date;


/**
 * <dl><dt><b>送信メッセージ</b></dt>
 * 	<dd></dd>
 * </dl>
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class MessagePacket implements Serializable {

	/** シリアルID　*/
	private static final long serialVersionUID = -8297082849393870723L;

	/** メッセージID :  */
	private int messageID = -1;

	/** 送信者 :  */
	private String fromUser = null;

	/** メッセージタイプ  :  */
	private String messageType = null;

	/** 送信日時 : */
	private Date sent = null;

	/** メッセージ本文 :  */
	private String message = null;

	/** 添付ファイル名 :  */
	private String attachFileName = null;

	/** FingerPrint :  */
	private String fingerPrint = null;
	
	/** 課題票タイプ  :  */
	private String issueType = null;

	/** オープン済み :  */
	private Boolean opened = new Boolean(false);

	/** 添付ファイル実体 */
	private byte[] attachFile;

	/**
	 * <DL>
	 * <DT><B>メッセージID を戻します。</B></DT>
	 * <DD>メッセージIDをIntegerのプリミティブ型intで取得します。</DD>
	 * </DL>
	 * @return メッセージID 
	 */
	public int getMessageID() {
		return this.messageID;
	}

	/**
	 * <DL>
	 * <DT><B>メッセージIDを設定します。</B></DT>
	 * <DD>メッセージIDをIntegerのプリミティブ型intで設定します。</DD>
	 * </DL>
	 * @param messageID メッセージID
	 */
	public void setMessageID( int messageID ) {
		this.messageID = messageID;
	}
	/**
	 * <DL>
	 * <DT><B>送信者 を戻します。</B></B>
	 * <DD></DD>
	 * </DL>
	 * @return 送信者 
	 */
	public String getFromUser() {
		return this.fromUser;
	}

	/**
	 * <DL>
	 * <DT><B>タイプを戻します。</B></DT>
	 * <DD>タイプを取得します。</DD>
	 * </DL>
	 * @return タイプ
	 */
	public String getMessageType() {
		return messageType;
	}

	/**
	 * <DL>
	 * <DT><B>タイプを設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param messageType タイプ
	 */
	public void setMessageType(String type) {
		this.messageType = type;
	}

	/**
	 * <DL>
	 * <DT><B>タイプを戻します。</B></DT>
	 * <DD>タイプを取得します。</DD>
	 * </DL>
	 * @return タイプ
	 */
	public String getIssueType() {
		return issueType;
	}

	/**
	 * <DL>
	 * <DT><B>タイプを設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param issueType タイプ
	 */
	public void setIssueType(String issueType) {
		this.issueType = issueType;
	}

	/**
	 * <DL>
	 * <DT><B>送信者を設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param fromUser 送信者
	 */
	public void setFromUser( String fromUser ) {
		this.fromUser = fromUser;
	}
	/**
	 * <DL>
	 * <DT><B>メッセージ本文 を戻します。</B></B>
	 * <DD></DD>
	 * </DL>
	 * @return メッセージ本文 
	 */
	public String getMessage() {
		return this.message;
	}

	/**
	 * <DL>
	 * <DT><B>メッセージ本文を設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param message メッセージ本文
	 */
	public void setMessage( String message ) {
		this.message = message;
	}
	/**
	 * <DL>
	 *  <DT><B>送信日時 に日時情報を設定します。</B></DL>
	 *  <DD></DD>
	 * </DL>
	 * @param sent        送信日時 に指定する日時オブジェクト
	 */
	public void setSent( Date sent ){
		if(sent != null) {
			this.sent = new Date(sent.getTime());
		}
	}

	/**
	 * <DL>
	 *  <DT><B>送信日時 に日時情報をlong型のタイムスタンプで設定します。</B></DL>
	 *  <DD></DD>
	 * </DL>
	 * @param timestamp   送信日時 に指定するlong型のタイムスタンプ
	 */
	public void setSent( long timestamp ){
		this.sent = new Date( timestamp );
	}

	/**
	 * <DL>
	 *  <DT><B>送信日時 を取得。</B></DL>
	 *  <DD></DD>
	 * </DL>
	 * @return 送信日時
	 */
	public Date getSent(){
		return this.sent;
	}

	/**
	 * <DL>
	 *  <DT><B>送信日時 をlongのタイムスタンプで取得</B></DL>
	 *  <DD>送信日時 の日付情報をlongのタイムスタンプで取得します。
	 * 送信日時 がnullの場合、NullPointerExceptionが発生することに注意してください。</DD>
	 * </DL>
	 * @return 送信日時 のタイムスタンプ(long)
	 */
	public long getSentTimestamp(){
		return this.sent.getTime();
	}

	/**
	 * 添付ファイル名を返します。
	 * 
	 * @return		添付ファイル名			
	 */
	public String getAttachFileName() {
		return attachFileName;
	}

	/**
	 * 添付ファイル名を設定します。
	 * 
	 * @param 		attachFileName		添付ファイル名
	 */
	public void setAttachFileName(String attachFileName) {
		this.attachFileName = attachFileName;
	}

	/**
	 * FingerPrintを返します。
	 * 
	 * @return			FingerPrint
	 */
	public String getFingerPrint() {
		return fingerPrint;
	}

	/**
	 * FingerPrintを設定します。
	 * @param		fingerPrint			FingerPrint
	 */
	public void setFingerPrint(String fingerPrint) {
		this.fingerPrint = fingerPrint;
	}

	/**
	 * オープン済みを返します。
	 * 
	 * @return		true--オープン済み。false--未オープン					
	 */
	public Boolean getOpened() {
		return opened;
	}

	/**
	 * オープン済みを返します。
	 * 
	 * @return		true--オープン済み。false--未オープン					
	 */
	public Boolean isOpend() {
		return opened;
	}

	/**
	 * オープン済みを設定します。
	 * @param		opend		オープン済み
	 */
	public void setOpened(Boolean opend) {
		this.opened = opend;
	}

	/**
	 * オープン済みを設定します。
	 * @param		opend		オープン済み
	 */
	public void setOpened(boolean opend) {
		this.opened = new Boolean(opend);
	}
	
	/**
	 * 添付ファイル実体を返します。
	 * 
	 * @return		添付ファイル実体					
	 */
	public byte[] getAttachFile() {
		return attachFile;
	}

	/**
	 * 添付ファイル実体を設定します。
	 * @param		attachFile		添付ファイル実体
	 */
	public void setAttachFile(byte[] attachFile) {
		this.attachFile = attachFile;
	}
	
	public String getRealpath() {
		return attachFileName + sent.getTime();
	}

	public boolean equals(Object obj) {
		if(obj==this) {
			return true;
		}

		// Issueインスタンスかどうかを確認
		if(obj instanceof MessagePacket) {
			MessagePacket that = (MessagePacket)obj;
			
			// fingerprint+typeを比較する。同じであればtrueを返し、それ以外はfalseを返す。
			if( this.messageID == that.getMessageID() ){
				return true;
			}
		}
		return false;
	}


}