/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.command.server;

import java.util.List;

import jp.valtech.bts.command.client.Join;
import jp.valtech.bts.data.NetworkConfig;
import jp.valtech.bts.network.ClientInfo;
import jp.valtech.bts.network.ClientList;
import jp.valtech.bts.network.Request;
import jp.valtech.bts.network.command.MulticastServerCommand;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.IBtsListener;

/**
 * <dl><dt><b>ネットワークへの参加通知を受信します。</b></dt>
 * <dd>
 * <ul>
 * 	<li>他のクライアントからのマルチキャスト通信を受信し、このクラスが呼び出されると、ネットワークへの参加通知処理を実行します。
 * 	<li>クライアントから送信される情報は、クライアント名称(ホスト名ではありません)、ポート番号です。
 *	<li>ネットワークへの参加自体は、同一のマルチキャストIPアドレスを使用することで参加可能となりますが、明示的に参加を通知し、クライアントリストに表示させるためには参加通知処理を行ってください。
 *  <li>ネットワークへの参加通知を行った場合、クライアントリスト({@link jp.valtech.bts.network.ClientList})から、参加しているクライアントの一覧を見ることが可能になります。
 * </ul>
 * </dd>
 * 
 * @see			jp.valtech.bts.network.command.MulticastServerCommand
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class JoinServer extends MulticastServerCommand {

	/**
	 * サーバコマンドインスタンスを生成します。
	 */
	public JoinServer() {
		super();
	}


	/**
	 * ネットワークへの参加通知を受信し{@link ClientInfo クライアント情報}を更新します。
	 * 送信元がコールバックを指定してきた場合は、コールバックを参加者に通知します。
	 * 
	 * @param		request			リクエストオブジェクト
	 * @param		myconfig		ローカル端末のネットワーク情報
	 */
	public void execute(Request request, NetworkConfig myconfig){

		// コールバック実行
		boolean callback = request.getParameterBoolean( "callback" ).booleanValue(); 
		if( callback ){
			Join join = new Join( myconfig );
			join.setCallback( false );
			join.execute();
		}

		// 接続ユーザ名取得
		String name = request.getParameterString( "name" ); 
		
		// ポート番号取得
		Number port = request.getParameterNumber( "port" ); 

		// 送信元クライアント情報生成
		ClientInfo clientInfo = new ClientInfo();
		clientInfo.setClientAddress( getRequestClient().getHostAddress() );
		clientInfo.setClientHostName( getRequestClient().getHostName() );
		clientInfo.setClientName( name );
		clientInfo.setPort(port.intValue());
		ClientList.add(clientInfo);
		
		// ビューを最新表示する。
		List listeners = BtsPlugin.getInstance().getListeners();
		for (int idx = 0; idx < listeners.size(); idx++) {
			IBtsListener listnener = (IBtsListener)listeners.get(idx);
			listnener.joinMember(clientInfo);
		}
	}

}
