/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.command.client;

import jp.valtech.bts.data.NetworkConfig;
import jp.valtech.bts.data.Vote;
import jp.valtech.bts.network.Request;
import jp.valtech.bts.network.command.MulticastClientCommand;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.util.Logging;

/**
 * <dl><dt><b>投票を配信するためのコマンドです。</b></dt>
 * <dd>このコマンドを実行することで、現在の参加者に課題票への投票を配信します。
 * </dd>
 * </dl>
 * 
 * @see			jp.valtech.bts.command.server.VoteAddServer
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class VoteAdd extends MulticastClientCommand implements Logging{

	/** 投票情報 */
	private Vote vote;
	
	/**
	 * 通知コマンドインスタンスを生成します。
	 * 
	 * @param		config		ネットワーク情報
	 */
	public VoteAdd( NetworkConfig myconfig ) {
		super( myconfig );
	}


	/**
	 * 投票配信コマンドを実行します。
	 *
	 */
	public void execute() {
		Request request = new Request();
		request.setCommand( "voteAdd" );
		request.setSSID( this.myconfig.getSSID() );
		request.addParameter( "vote" , this.vote );
		
		try {
			send( request );
		} catch (Exception e) {
			BtsPlugin.getInstance().errorlog(e);
		}
	}

	/**
	 * 投票情報を設定します。
	 * @param vote 投票情報。
	 */
	public void setVote( Vote vote ) {
		this.vote = vote;
	}

}
