/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.command.client;

import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.data.NetworkConfig;
import jp.valtech.bts.network.Request;
import jp.valtech.bts.network.command.TCPClientCommand;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.util.Logging;

/**
 * PINGリクエストを送信します。
 * PINGを受け取った端末では、受け取ったSSIDがカレントプロジェクトであれば{@link jp.valtech.bts.network.Response#OK}を返します。
 * 
 * @see			jp.valtech.bts.command.server.PingServer
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class Ping extends TCPClientCommand implements Logging {

	/** このクライアントコマンドのタイムアウト */
	private static final int PING_TIMEOUT = 1000 * 4;
	/** エラーメッセージ */
	private String errorMsg;
	
	/**
	 * クライアントコマンド生成
	 * 
	 * @param		config 		設定情報
	 * @param		host		送信先ホスト名
	 * @param		port 		送信先ポート番号
	 */
	public Ping( NetworkConfig myconfig, String host, int port ) {
		super( myconfig, host, port );
		setTimeout(PING_TIMEOUT);
	}

	
	/**
	 * PINGリクエストを送信します。
	 * 送信結果は{@link TCPClientCommand#isSuccessful()}にて取得します。
	 * 
	 */
	public void execute(){
		try {

			// 送信オブジェクト設定
			Request request = new Request();
			request.setCommand( "ping" );
			
			String ssid = CurrentProject.getInsance().getSSID();
			request.setSSID(ssid);
			
			// PINGコマンド送信
			send( request );
			
			// 失敗
			if(!isSuccessful()) {
				this.errorMsg = Messages.getString("Ping.1")  //$NON-NLS-1$
							  + "\n addr=" + host + ", port=" + port + ", ssid=" + ssid;
			}
			
		}catch (Exception e) {
			this.errorMsg = e.getMessage() + "\n  addr=" + host + ", port=" + port;
			BtsPlugin.getInstance().errorlog(errorMsg, e);
		}
		
	}
	
	/**
	 * エラーメッセージ取得
	 * 
	 * @return		エラーメッセージ
	 */
	public String getErrorMsg() {
		return this.errorMsg;
	}
	
}

