/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.command.client;

import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.data.NetworkConfig;
import jp.valtech.bts.network.Request;
import jp.valtech.bts.network.command.MulticastClientCommand;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.util.Logging;

/**
 * <dl><dt><b>ネットワークに参加したことを通知するためのコマンドです。</b></dt>
 * <dd>このコマンドを実行することで、同一のマルチキャストアドレスのネットワークに対して参加することを通知します。
 * クライアントから送信される情報は、クライアント名(ホスト名ではありません)と、ポート番号です。
 * 参加者名は{@link jp.valtech.bts.data.NetworkConfig#setDisplayName(String)}で指定します。
 * </dd>
 * </dl>
 * 
 * @see			jp.valtech.bts.command.server.JoinServer
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class Join extends MulticastClientCommand implements Logging{

	/** 
	 * コールバック。初期値<code>true</code>に設定。
	 * Joinを受け取った側が通知を返すかフラグ。コールバックする側は<code>false</code>を設定してJoinすること。
	 */
	private boolean callback = true;

	/**
	 * 通知コマンドインスタンスを生成します。
	 * 
	 * @param		config		ネットワーク情報
	 */
	public Join( NetworkConfig myconfig ) {
		super( myconfig );
	}


	/**
	 * 通知コマンドを実行します。
	 *
	 */
	public void execute() {
		Request request = new Request();
		request.setCommand( "join" );
		request.setSSID( this.myconfig.getSSID() );
		request.addParameter( "port" , new Integer( this.myconfig.getTCPPort() ) );
		request.addParameter( "callback" , new Boolean( this.callback ) );

		String userName = CurrentProject.getInsance().getProjectConfig().getUserName();
		request.addParameter( "name" , userName );

		
		try {
			send( request );
		} catch (Exception e) {
			BtsPlugin.getInstance().errorlog(e);
		}
	}

	/**
	 * <DL><DT><B>callback を戻します。</B></B>
	 * <DD></DD>
	 * </DL>
	 * @return callback 
	 */
	public boolean isCallback() {
		return this.callback;
	}

	/**
	 * <DL><DT><B>callbackを設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param callback callback。
	 */
	public void setCallback( boolean callback ) {
		this.callback = callback;
	}

}
