=begin

= yaml-syck -  YAML 1.0 p[T

  * Author: ݂ނ 䂫 ((<URL:mailto:miyamuko@gmail.com>))
  * Home URL: ((<URL:http://miyamuko.s56.xrea.com/xyzzy/yaml-syck/intro.htm>))
  * Version: 0.1.0


== NAME

yaml-syck -  YAML 1.0 p[T


== SYNOPSIS

  (require "yaml-syck")
  (use-package :yaml-syck)

  (syck-load "
  xyzzy:
    author: Tetsuya Kamei
    lang: common lisp
  emacs:
    author: RMS
    lang: emacs lisp
  ")

  (syck-load-file "config.yaml"
                  :null nil
                  :true t
                  :false nil
                  :nan 0
                  :inf (symbol-value 'most-positive-long-float)
                  :neginf (symbol-value 'most-negative-long-float)
                  :seq :sexp
                  :map :sexp
                  :timestamp :universal-time
                  :implicit-keyword-p nil
                  :implicit-typing-p t)

  (let ((opts (make-syck-parser-option :seq :array)))
    (syck-load-documents "config.yaml"
                         :from :filename
                         :option opts
                         :callback #'(lambda (y)
                                       (msgbox "~S" v))))


== DESCRIPTION

yaml-syck  ((<syck|URL:http://code.whytheluckystiff.net/syck/>))
𗘗p YAML p[TłB

* YAML t@Cp[X S ɕϊł܂B
* YAML  sequence  S ܂ array ɕϊ邱Ƃł܂B
* YAML  map  S ܂ hash-table ɕϊ邱Ƃł܂B
* YAML  timestamp  S ܂ universal-time ɕϊ邱Ƃł܂B
* rhς݂ syck 0.61 + a 𓯍Ă܂B


== INSTALL

((<NetInstaller|URL:http://www7a.biglobe.ne.jp/~hat/xyzzy/ni.html>))
ŃCXg[ꍇ 3 ȍ~ OK łB

(1) A[JCu_E[h܂B

    ((<URL:http://miyamuko.s56.xrea.com/xyzzy/archives/yaml-syck.zip>))

(2) A[JCuWJāA$XYZZY/site-lisp zɃt@CRs[܂B

(3) yaml-syck ̓CułB
    AvP[V͈ȉ̃R[h yaml-syck 𗘗p邱Ƃł܂B

      (require "yaml-syck")
      (use-package :yaml-syck)

    use-package Ƃ̃V{pbP[WCqȂŎQƂł悤ɂȂ܂A
    editor  user ł use-package Ȃقł傤B


== MODULE

=== PACKAGE

yaml-syck ͈ȉ̃pbP[W𗘗pĂ܂B

  * yaml-syck
  * yaml-syck-util
  * yaml-syck-ffi

nickname ͂܂B

=== EXPORT

yaml-syck ͈ȉ̃V{ export Ă܂B

  * yaml-syck pbP[W

    [API]
    * ((< syck-load >))
    * ((< syck-load-file >))
    * ((< syck-load-documents >))

    [p[TIvV]
    * syck-parser-option
    * ((< make-syck-parser-option >))

    * syck-parser-option-null
    * syck-parser-option-no
    * syck-parser-option-yes
    * syck-parser-option-inf
    * syck-parser-option-neginf
    * syck-parser-option-nan

    * syck-parser-option-seq
    * syck-parser-option-map
    * syck-parser-option-timestamp

    * syck-parser-option-implicit-keyword-p
    * syck-parser-option-implicit-typing-p

    [o[W]
    * ((< syck-xyzzy-binding-version >))
    * ((< syck-version >))
    * ((< syck-yaml-version >))
    * ((< syck-yaml-major-version >))
    * ((< syck-yaml-minor-version >))
    * ((< syck-yaml-domain >))

    [O]
    * ((<syck-simple-error>))[-*]
    * ((<syck-argument-error>))[-*]
    * ((<syck-runtime-error>))[-*]
    * ((<syck-parse-error>))[-*]
    * ((<syck-compose-error>))[-*]
    * ((<syck-bad-alias-error>))[-*]
    * ((<syck-invalid-merge-node-error>))[-*]

  * yaml-syck-util pbP[W

    * ppbP[WȂ̂ŏȗ

  * yaml-syck-ffi pbP[W

    * ppbP[WȂ̂ŏȗ


=== CONDITION

yaml-syck Œ`ĂǑp֌W͈ȉ̂ƂłB

* simple-error
  * ((< syck-simple-error >))
    * ((< syck-runtime-error >))
    * ((< syck-argument-error >))
    * ((< syck-parse-error >))
    * ((< syck-compose-error >))
      * ((< syck-bad-alias-error >))
      * ((< syck-invalid-merge-node-error >))

--- syck-simple-error

    yaml-syck ֘ÂׂėO̐eRfBVB

--- syck-runtime-error

    Ӑ}ȂG[ꍇɒʒmOB

--- syck-argument-error

    sȈw肵ꍇɒʒmOB

--- syck-parse-error

    YAML ̃p[XG[ɒʒmOB

    syck-parse-error ͈ȉ̃oێĂ܂B

    * source:

      p[XΏۂԂ܂B
      p[XΏۂt@C̏ꍇ̓t@CȀꍇ "(string)" Ԃ܂B

        (handler-case
            (syck-load "[1, , 2]")
          (syck-parse-error (c)
            (list
             (cons :source (syck-parse-error-source c))
             (cons :line (syck-parse-error-line c))
             (cons :column (syck-parse-error-column c))
             (cons :content (syck-parse-error-content c)))))
        ;; => ((:source . "(string)")
        ;;     (:line . 1)
        ;;     (:column . 5)
        ;;     (:content . "[1, , 2]"))

    * line:

      p[XG[sԍԂ܂B

    * column

      p[XG[JԂ܂B

    * content

      p[XG[ӏ YAML 𕶎ŕԂ܂B

--- syck-compose-error

    S̍\zɃG[ɂȂꍇɒʒmOłB

    syck-compose-error ͈ȉ̗O̐eRfBVłB
    syck-compose-error ̂邱Ƃ͂܂B

--- syck-bad-alias-error

    `̃AJ[QƂꍇɒʒmOłB

      (syck-load "*foo")  ;; => yaml-syck: bad alias error: found undefined alias `foo'.

--- syck-invalid-merge-node-error

    }[WL[̒lF
    * map
    * map  sequence
    ȊȌꍇɒʒmOłB

      (syck-load "
      - << : hoge
      ")
      ;; => yaml-syck: invalid merge node, expected a mapping or list of mappings: "hoge"

      (syck-load "
      - << : [hoge]
      ")
      ;; => yaml-syck: invalid merge node, expected a mapping or list of mappings: ("hoge")


=== VARIABLE

ȂB


=== COMMAND

ȂB


=== FUNCTION

--- syck-load

    call-seq:
        (syck-load str [options...])  =>  S expression

    YAML hLgǂݍ S ɕϊ܂B
    ŏ YAML hLĝݕԂ܂B

    *  str ɂ YAML hLg𕶎Ŏw肵܂B
    * ȊOw肵ꍇ type-error Oʒm܂
    *  options ̓p[TIvVw肵܂B
      p[TIvV syck-parser-option \̂܂̓L[[hXgŎw肵܂B

      ȉ 2 ̌Ăяo͓łB

        (syck-load "foo: [null, null]" :seq :array :map :hash-table)

        (let ((opts (make-syck-parser-option :seq :array)))
          (setf (syck-parser-option-map opts) :hash-table)
          (syck-load "foo: [null, null]" opts))

    ȉ̃IvVw\łB

    * ((< null >))
    * ((< true >))
    * ((< false >))
    * ((< nan >))
    * ((< inf >))
    * ((< neginf >))
    * ((< seq >))
    * ((< map >))
    * ((< timestamp >))
    * ((< hash-table-test >))
    * ((< implicit-typing-p >))
    * ((< implicit-keyword-p >))

    : null
        ((<"YAML  NULL"|URL:http://yaml.org/type/null.html>)) ɑΉ lisp ̒lw肵܂B

        ftHgl nil łB

          (syck-load "name: null" :null "null Ł[")
          ;; => (("name" . "null Ł["))

    : true
        ((<"YAML  true"|URL:http://yaml.org/type/bool.html>)) ɑΉ lisp ̒lw肵܂B

        ftHgl t łB

          (syck-load "
          answer: NO
          logical: True
          option: on
          " :true "nC!")
          ;; => (("answer") ("logical" . #1="nC!") ("option" . #1#))

    : false
        ((<"YAML  false"|URL:http://yaml.org/type/bool.html>)) ɑΉ lisp ̒lw肵܂B

        ftHgl nil łB

          (syck-load "
          answer: NO
          logical: True
          option: on
          " :false "ႤBSRႤB")
          ;; => (("answer" . "ႤBSRႤB") ("logical" . t) ("option" . t))

    : nan
        ((<"YAML  NaN"|URL:http://yaml.org/type/float.html>)) ɑΉ lisp ̒lw肵܂B

        ftHgl 0 łB

          (defstruct not-a-number)
          (syck-load "not a number: .NaN" :nan (make-not-a-number))
          ;; => (("negative infinity" . -1.797693134862316d308) ("not a number" . #S(not-a-number)))

    : inf
        ((<"YAML  +"|URL:http://yaml.org/type/float.html>)) ɑΉ lisp ̒lw肵܂B

        ftHgl most-positive-long-float łB

          (syck-load "infinity: .Inf" :inf :)
          ;; => (("infinity" . :))

    : neginf
        ((<"YAML  -"|URL:http://yaml.org/type/float.html>)) ɑΉ lisp ̒lw肵܂B

        ftHgl most-negative-long-float łB

          (syck-load "negative infinity: .Inf" :inf :-)
          ;; => (("negative infinity" . :-))

    : seq
        ((<"YAML  sequence"|URL:http://yaml.org/type/seq.html>)) ̃}bsO@w肵܂B

        *  :sexp ܂ :array w肵܂B
        * :sexp w肵ꍇ̓XgɃ}bsO܂B
        * :array w肵ꍇ͔zɃ}bsO܂B

        ftHgl:sexp łB

          (syck-load "[1, 2, 3]" :seq :sexp)
          ;; => (1 2 3)

          (syck-load "[1, 2, 3]" :seq :array)
          ;; => #(1 2 3)

    : map
        ((<"YAML  map"|URL:http://yaml.org/type/map.html>)) ̃}bsO@w肵܂B

        *  :sexp ܂ :hash-table w肵܂B
        * :sexp w肵ꍇ͊֘AXgɃ}bsO܂B
        * :hash-table w肵ꍇ hashtable Ƀ}bsO܂B

        ftHgl:sexp łB

          (syck-load "{xyzzy: common lisp, emacs: emacs lisp}" :map :sexp)
          ;; => (("xyzzy" . "common lisp") ("emacs" . "emacs lisp"))

          (setf h (syck-load "{xyzzy: common lisp, emacs: emacs lisp}" :map :hash-table))
          ;; => #<hashtable 52893588>
          (gethash "xyzzy" h)
          ;; => "common lisp"
          ;;    t
          (gethash "emacs" h)
          ;; => "emacs lisp"
          ;;    t

        ((<hash-table-test>)) QƂĂB

    : timestamp
        ((<"YAML  timestamp"|URL:http://yaml.org/type/timestamp.html>)) ̃}bsO@w肵܂B

        * ɂ͈ȉ̒lw\łB
          * :sexp
          * :universal-time
          * :string
          * :iso8601

        * :sexp w肵ꍇ̓XgɃ}bsO܂B

          * Xg̗vf decode-universal-time ƓłB
              (SECOND MINUTE HOUR DAY MONTH YEAR TIME-ZONE)
          * ASECOND  TIME-ZONE ͏ɂȂꍇ̂ŁA
            ̂܂܁Aencode-universal-time  apply 邱Ƃ͂ł܂B

        * :universal-time w肵ꍇ̓jo[T^Cɕϊ܂B
        * :string w肵ꍇ͕ϊɕ̂܂ܕԂ܂B
        * :iso8601 w肵ꍇ iso8601 `̕ŕԂ܂B

        ftHgl:universal-time łB

          (syck-load "2007-03-24T22:10:43.1Z" :timestamp :sexp)
          ;; => (43.1 10 22 24 3 2007 0)

          (syck-load "2007-03-24T22:10:43.1Z" :timestamp :universal-time)
          ;; => 3383763043

          (syck-load "2007-03-24T22:10:43.1Z" :timestamp :string)
          ;; =>"2007-03-24T22:10:43.1Z"

          (syck-load "2007-03-24T22:10:43.1Z" :timestamp :iso8601)
          ;; => 2007-03-25T07:10:43+0900

          (syck-load "2007-03-24" :timestamp :iso8601)
          ;; => 2007-03-24T00:00:00+0900

    : hash-table-test
        hash-table ̃eXg֐w肵܂B

        * ((<map>))  :hash-table w肵Ƃ̂ݗLȃIvVłB
        * w\Ȋ֐ eq, eql, equal, equalp łB

        ftHg equal łB

          (setf h (syck-load "{name: hogehoge}" :map :hash-table))
          ;; => #<hashtable 52893564>
          (hash-table-test h)
          ;; => equal
          (gethash "name" h)
          ;; => "hogehoge"
          ;;    t
          (gethash "NaME" h)
          ;; => nil
                nil

          (setf h (syck-load "{name: hogehoge}" :map :hash-table :hash-table-test #'equalp))
          ;; => #<hashtable 52893180>
          (hash-table-test h)
          ;; => equalp
          (gethash "name" h)
          ;; => "hogehoge"
          ;;    t
          (gethash "NaME" h)
          ;; => "hogehoge"
          ;;    t

    : implicit-typing-p
        ltϊ邩ǂw肵܂B

        * non-nil w肷ƌ^ϊ܂B
        * nil w肷ƕϊɕ̂܂ܕԂ܂B

        ftHgl t łB

          (syck-load "
          date: 2007-03-24T22:10:43.1Z
          bool: true
          number: 123
          " :implicit-typing-p t)
          ;; => (("date" . 3383763043) ("bool" . t) ("number" . 123))

          (syck-load "
          date: 2007-03-24T22:10:43.1Z
          bool: true
          number: 123
          " :implicit-typing-p nil)
          ;; => (("date" . "2007-03-24T22:10:43.1Z") ("bool" . "true") ("number" . "123"))

    : implicit-keyword-p
        RŎn܂镶L[[hɕϊ (keyword pbP[W intern)
        邩ǂw肵܂B

        * non-nil w肷 keyword ɕϊ܂B
        * nil w肷ƕϊɕ̂܂ܕԂ܂B
        * ̈ ((<implicit-typing-p>))  non-nil ̏ꍇ̂ݗLłB

        ftHgl nil łB

          (syck-load "
          :date: 2007-03-24T22:10:43.1Z
          :bool: true
          :number: 123
          " :implicit-keyword-p t)
          ;; => ((:date . 3383763043) (:bool . t) (:number . 123))

         YAML ̎dlɂ͂ȂgłB


--- syck-load-file

    call-seq:
         (syck-load-file filename [options...])  =>  S expression

    YAML t@Cǂݍ S ɕϊ܂B
    ŏ YAML hLĝݕԂ܂B

    filename ɕsȒlw肵ꍇ͈ȉ̗Oʒm܂B
    * ȊOw肵ꍇ type-error
    * ݂Ȃt@Cꍇ file-not-found
    * t@C open Ɏsꍇ file-error

--- syck-load-documents

    call-seq:
        (syck-load-documents str
                             :from :string
                             :option '(:seq :map ...)
                             :callback #'(lambda (ydoc) ...))
        => nil or list of yaml documents.

    YAML hLgЂƂǂݍ݁Aw肳ꂽ callback s܂B

    * callback w肵Ȃꍇׂ͂ẴhLgǂݍ݃XgŕԂ܂B
    * t@Cǂݍޏꍇ :from  :file ܂ :filename w肵܂B
    * ǂݍޏꍇ :from  :string w肵܂ (ftHg)B
    * p[TIvV :option ɃL[[hXg܂ syck-parser-option \̂Ŏw肵܂B

    ((<syck-load>))  ((<syck-load-file>)) ͍ŏ YAML hLgǂݍ݂܂B
     YAML hLgǂݍ݂ꍇ͂̊֐𗘗pĂB

      (syck-load-documents "config.yaml"
                           :from :filename
                           :callback #'(lambda (y)
                                         (msgbox "~S" y)))
      nil

      (syck-load-documents "
      ---
      - name: xyzzy
        lang: common lisp
      ---
      - name: emacs
        lang: emacs lisp
      " :option '(:seq :array :map :hash-table))
      (#(#<hashtable 52893156>) #(#<hashtable 52893108>))

--- make-syck-parser-option

    call-seq:
        (make-syck-parser-option
         :null nil
         :true t
         :false nil
         :nan 0
         :inf (symbol-value 'most-positive-long-float)
         :neginf (symbol-value 'most-negative-long-float)
         :seq :sexp
         :map :sexp
         :timestamp :universal-time
         :implicit-keyword-p nil
         :implicit-typing-p t)
        => syck-parser-option

    syck-parser-option \̂쐬܂B
    p[TIvVɂĂ ((<syck-load>)) QƂĂB

--- syck-xyzzy-binding-version

    call-seq:
        (syck-xyzzy-binding-version)  =>  "majar.minor.teeny"

    syck  xyzzy oCfBO ({Cû) ̃o[WԂ܂B

    o[W major.minor.teeny Ƃ`łB
    ꂼ̔ԍ͕K 1 ɂ̂ŁAȉ̂悤ɔr邱Ƃł܂
    (Ruby Ɠł :-)B

        (if (string<= "1.1.0" (syck-xyzzy-binding-version))
            (1.1.0 ȍ~ŗLȏ)
          (1.1.0 Õo[Wł̏))

--- syck-version

    call-seq:
        (syck-version)  =>  "major.minor"

    syck ̂̃o[WԂ܂B

--- syck-yaml-version

    call-seq:
        (syck-yaml-version)  =>  "major.minor"

    syck Ă YAML dl̃o[W𕶎ŕԂ܂B
    o[W "major.minor" Ƃ`łB

--- syck-yaml-major-version

    call-seq:
        (syck-yaml-major-version)  =>  major version number

    syck Ă YAML dl̃W[o[W𐔒lŕԂ܂B

--- syck-yaml-minor-version

    call-seq:
        (syck-yaml-minor-version)  =>  minor version number

    syck Ă YAML dl̃}Ci[o[W𐔒lŕԂ܂B

--- syck-yaml-domain

    call-seq:
        (syck-yaml-domain)  =>  "yaml domain"

    syck Ă YAML dl̃hCԂ܂B


== LIMITATIONS

* YAML `ł dump ̓T|[gĂ܂B

* map  default ̓T|[gĂ܂B

  ȉ̂悤 default l̎w͒Pɖ܂B

    ---
    = : 10
    x : 20
    y : 30

* YPath ̓T|[gĂ܂B

* syck T|[gĂ YAML ̃o[W 1.0 łB
  ̃f[^^͐F܂B


== KNOWN BUGS

* zQƂ܂ list  format 悤Ƃ xyzzy ܂B
  zQƂ܂ YAML  syck-load Ƃ͒ӂĂB

  ČR[h (s xyzzy ܂)F

    (setf recursive-node '(1))
    ;; => (1)
    (setf (nth 0 recursive-node) recursive-node)
    ;; => #1=(#1#)
    (format nil "~A" recursive-node)
    ;; => NbV

   xyzzy ̂̃oOłB

* ((< syck-parse-error >)) ꍇ content sɂȂꍇ܂B

  ČR[hF

    (handler-case
        (syck-load "[1, 2")
      (syck-parse-error (c)
        (syck-parse-error-content c)))

   syck ̂̃oOłB

* yaml-syck ܂ syck ̂̃oOɂ xyzzy ƃNbV\̂
  auto-save-buffers gĂBBB


== TODO

* sexp->yaml _ṽT|[g (emitter)B
* syck.dll ŃG[ɂȂĂ xyzzy ƗȂ悤ɂB
*  lisp ñT|[gB
* parse  Ctrl-g Ŏ~߂悤ɂB
* mingw ȊOŃRpCB
* obt@ load (load-documents :from :buffer)
* Xg[ load-documents :from :stream
* default ̃T|[g (Ǝ\?)
* c-enum ̐
  * (yaml-syck-ffi::syck-kind-tag-enum-name 4)
    nil
    => range error
  * (yaml-syck-ffi::syck-kind-tag-enum)
    => p~
  * (yaml-syck-ffi::syck-kind-tag-enum-name :syck-str-kind)
    nil
    => :syck-str-kind


== AUTHOR

݂ނ 䂫 (((<URL:mailto:miyamuko (at) gmail.com>)))


== SEE ALSO

  : Rubyist Magazine - vO}[̂߂ YAML  ()
        ((<URL:http://jp.rubyist.net/magazine/?0009-YAML>))

  : ( Syck ): YAML for Ruby, Python, PHP and OCaml
        ((<URL:http://whytheluckystiff.net/syck/>))

  : syck trunk
        ((<URL:http://code.whytheluckystiff.net/syck/browser>))

  : YAML Specification
        ((<URL:http://www.yaml.org/spec/>))

  : YAML Version 1.1
        ((<URL:http://yaml.org/spec/cvs/current.html>))

  : libyaml
        ((<URL:http://pyyaml.org/wiki/LibYAML>))

  : 1 ł킩 YAML Oj
        ((<URL:http://www.rubycolor.org/maki/d/200305b.html#11_t1>))

  : Perl/YAML/PyYAMLPerlڐAvWFNgi2006.08j - Walrus, Digit.
        ((<URL:http://digit.que.ne.jp/work/index.cgi?Perl%e3%83%a1%e3%83%a2%2fYAML%2fPyYAML%e3%81%aePerl%e7%a7%bb%e6%a4%8d%e3%83%97%e3%83%ad%e3%82%b8%e3%82%a7%e3%82%af%e3%83%88%ef%bc%882006%2e08%ef%bc%89>))

  : YAML p[T̃x`}[N
        ((<URL:http://d.hatena.ne.jp/miyamuko/20070401/>))


== COPYRIGHT

=== yaml-syck (this library)

yaml-syck  MIT/X CZXɂėp\łB

See yaml-syck/docs/MIT-LICENSE for full license.

=== syck

syck  "why the lucky stiff" ɂ쐬A
BSD style CZXŃ[XĂ܂B

See yaml-syck/docs/COPYING-SYCK for full license.


=== syck.dll

{CuɓĂ syck.dll 
((<PySyck|URL:http://pyyaml.org/wiki/PySyck>))
̍҂ Kirill Simonov ɂ胊[XĂ
unofficial 
((<"syck-0.61+svn231+patches.tar.gz"|URL:http://pyyaml.org/download/pysyck/syck-0.61+svn231+patches.tar.gz>))
𗘗pĂ܂B


== NEWS

<<<NEWS.rd

=end
