(provide :format-snippet)
(in-package :editor)
(export '(format-snippet-string))
;; '((key-char ((second-key-char expansion)
;; 			    (second-key-char expansion)))
;;   )
(defun format-snippet(out fmt snippet)
  (if (atom(car snippet))
	  (setq snippet (list snippet)))
  (with-input-from-string(stream fmt)
	(let(c rc bf)
	  (while(setq c (read-char stream nil nil))
		(cond ((setq bf (assoc c snippet))
			   (or(and(setq rc (read-char stream nil nil))
					  (setq bf (cadr (assoc rc (cadr bf))))
					  (setq bf (eval bf))
					  (princ bf out))
				  (progn(princ c out)(and rc (princ rc out)))))
			  (t (princ c out)))))))

(defun format-snippet-string(fmt snippet)
  (with-output-to-string(output)
	(format-snippet output fmt snippet)))
#|
(setq *format-snippet1*
	  '((#\$ (
			  (#\& (match-string 0))
			  (#\0 (match-string 0)) 
			  (#\1 (match-string 1))
			  (#\2 (match-string 2)) 
			  (#\3 (match-string 3))
			  (#\4 (match-string 4))
			  (#\5 (match-string 5))
			  (#\6 (match-string 6))
			  (#\7 (match-string 7))
			  (#\8 (match-string 8))
			  (#\9 (match-string 9))
			  (#\` (match-beginning 0))
			  (#\' (match-end 0))
			  (#\: (format nil "~{~A~^ ~}" *load-path*))
			  (#\f (if(get-buffer-file-name)(buffer-name(selected-buffer))""))
			  (#\\ (if(get-buffer-file-name)
					   (directory-namestring(get-buffer-file-name))
					 (buffer-name(selected-buffer))))
			  ))
		))
|#

