=begin

= xml-http-request - 񓯊 HTTP ʐMCu

  * Author: ݂ނ 䂫 ((<URL:mailto:miyamuko@gmail.com>))
  * Home URL: ((<URL:http://miyamuko.s56.xrea.com/xyzzy/xml-http-request/intro.htm>))
  * Version: 1.2.1


== SYNOPSIS

    (in-package :your-cool-app)

    (require "xml-http-request")
    (use-package :xml-http-request)

    ;;;  API

    (let ((res (xhr-get "http://www.google.co.jp/")))
      (msgbox "~S" (xhr-response-text res)))

    (multiple-value-bind (response http-status header)
        (xhr-get "http://www.google.com/search"
                 :query '(:hl "ja" :lr "lang_ja" :ie "UTF-8" :oe "UTF-8" :num 50
                          :q "xyzzy ǂݕ")
                 :encoding *encoding-utf8n*
                 :since :epoch
                 :key 'xhr-response-values)
      (msgbox "~S~%~S" http-status header))


    ;;; 񓯊 API (Future p^[)

    (let ((future (xhr-get-future "http://www.google.co.jp/")))
      (msgbox "do something~%~S" future)
      (let ((res (xhr-future-value future)))
        (msgbox "~S~%~S" (xhr-response-text res) future)))


    ;;; 񓯊 API (}N)

    (with-xhr-post-async ("http://www.excite.co.jp/world/english/"
                          '(:wb_lp "JAEN" :before "Ⴊ~܂B\nełB"))
      (on 200 (res)
          (when (string-match
                 "<textarea cols=36 rows=15 name=\"after\".*?>\\([^<>]+?\\)</textarea>"
                 (xhr-response-text res))
            (msgbox "~A" (match-string 1))))
      (on :success (res)
          (msgbox "܂"))
      (on :failure (res)
          (msgbox "s܂... orz"))
      (on :complete (res)
          (msgbox "I܂")
          (msgbox "~A~%~A" (xhr-response-header res "Server") (xhr-status res))))


    ;; 񓯊 API (֐)

    (xhr-post-async "http://search.hatena.ne.jp/questsearch"
                    '(:wb_lp "ENJA" :before "xyzzy is awesome!")
                    :oncomplete #'(lambda (res)
                                    (msgbox "I܂")
                                    (msgbox "http status: ~A" (xhr-status res))
                                    (msgbox "response text: ~A" (xhr-response-text res))))


== DESCRIPTION

xml-http-request  HTTP ʐMs߂̃CułB
񓯊ʐMŝ xyzzy ~߂邱ƂȂʐMł܂B

܂AWindows 񋟂 XMLHttpRequest IuWFNg𗘗pĂ邽
Proxy  Basic F؁ASSL ɂΉĂ܂B

Cookie LbV̊Ǘ XMLHttpRequest ōs܂B
 IE ƋL܂B


== INSTALL

=== NetInstaller ŃCXg[

(1) ((<NetInstaller|URL:http://www7a.biglobe.ne.jp/~hat/xyzzy/ni.html>))
     xml-http-request CXg[܂B

=== NetInstaller g킸ɃCXg[

(1) A[JCu_E[h܂B

    ((<URL:http://miyamuko.s56.xrea.com/xyzzy/archives/xml-http-request.zip>))

(2) A[JCuWJāA$XYZZY/site-lisp zɃt@CRs[܂B



== MODULE

=== PACKAGE

xml-http-request ͈ȉ̃pbP[W𗘗pĂ܂B

* xml-http-request

  nickname  xhr  msxml łB


=== VARIABLE

ȂB


=== CONSTANT

ȂB


=== CODITION

--- xhr-error

    xml-http-request ʒmRfBV̐eRfBVłB
    xhr-error ̂ʒm邱Ƃ͂܂B

--- xhr-open-error

    w肵 URL ɐڑłȂꍇɒʒmRfBVłB

    񓯊 API ̎͒ʒm܂B

--- xhr-too-long-url-error

    w肵 URL ꍇɒʒmRfBVłB

    񓯊 API ̎͒ʒm܂B


=== COMMAND

ȂB


=== FUNCTION

--- xhr-get URL &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS QUERY ENCODING

    w肳ꂽ URL ̃\[X get ܂B

     API ͓ API łB
    get I܂ŃubNX|XIuWFNgԂ܂B

    * BASIC-AUTH ɂ
      ((<xhr-credential|xhr-credential USER PASSWORD>))
      ō쐬 Basic Fؗp̏w肵܂B

        (defun gmail-unread (tag user password)
          (xhr-get (concat "https://mail.google.com/mail/feed/atom/" tag)
                   :basic-auth (xhr-credential user password)
                   :key 'xhr-response-xml
                   :since :epoch))

    * NOMSG  non-nil w肷ƃbZ[Wo͂܂B

      nil ̏ꍇbZ[ẄɒʐMԂ\܂B
      ftHg nil łB

    * KEY Ɋ֐w肷ƁÅ֐X|XIuWFNgɓKpʂԂ܂B

        (xhr-get "http://www.google.co.jp/")                  ;=> #S(xml-http-request::http-response ...)
        (xhr-get "http://www.google.co.jp/" :key 'xhr-status) ;=> 200

    * SINCE ɂ͑M If-Modified-Since wb_w肵܂B

      SINCE ɂ͈ȉ̒lwł܂B

      : :epoch
          Unix epoch (1970-01-01 00:00:00) 𑗐M܂B
          ̒lw肷ƃLbVg킸Ƀlbg[N擾܂B

      : <l>
          lw肵ꍇ̓[JԂ universal-time ƌȂ
          ɕϊ܂B

      : <>
          w肵ꍇ͂̂܂ܑM܂B

    * HEADERS ɂ͑M HTTP wb_XgŎw肵܂B

      HEADERS  If-Modified-Since w肵A SINCE Ɏw肵ꍇ
      SINCE ̎w肪LɂȂ܂B

    * QUERY  query string 𕶎܂̓XgŎw肵܂B

      w肵 query string  URL ɒڋLqĂ query string
      Ƃ킹 URL ɒǉ܂B

        (xhr-get "http://www.google.com/search?hl=ja&lr=lang_ja"
                 :query '(:ie "UTF-8" :oe "UTF-8" :num 50
                          :q "xyzzy ǂݕ")
                 :encoding *encoding-utf8n*)
        ;;=> GET from http://www.google.com/search?hl=ja&lr=lang_ja&ie=UTF-8&oe=UTF-8&num=50&q=xyzzy%20%E8%AA%AD%E3%81%BF%E6%96%B9

      w肷Ƃ̂܂ URL ɒǉ܂B
      si:www-url-encode ȂǂœK؂ɃGR[hlw肵ĂB

      L[ƒlȂ郊Xgw肷ƎIɃGR[h܂B
      ENCODING w肷ƕR[hϊ RFC3986 ɂx] url GR[h܂
      (si:www-url-encode ̃ftHgƂ͈Ⴂ܂)B
      ENCODING w肵Ȃꍇ Shift_JIS ̂܂܃GR[h܂B

    :
        (xhr-response-text
         (xhr-get "http://www.google.co.jp/"
                  ;; alist Ŏw肵Ă ok
                  :headers '(:User-Agent "Firefox"
                             :Accept-Language "en, ja")
                  :since :epoch))


    ȂAX-Yzzy-Version Ƃwb_KM܂ (l xyzzy ̃o[W)B

--- xhr-get-async URL &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS QUERY ENCODING ONSUCCESS ONFAILURE ONCOMPLETE HANDLER

    w肳ꂽ URL ̃\[X get ܂B

     API ͔񓯊 API łB
    API ĂяoƂɐԂALZIuWFNgԂ܂B

    NGXg~ꍇ̓LZIuWFNg
    ((<xhr-abort|xhr-abort TRANSPORT>))
    Ɏw肵܂B

    get IƎw肳ꂽ callback Ăяo܂B

    * BASIC-AUTH NOMSG, KEY, SINCE, HEADERS ̎w@
      ((<xhr-get|xhr-get URL &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS QUERY ENCODING>))
      QƂĂB

      KEY w肷 KEY ̖߂lCxgnhɎw肳܂B
      KEY lԂꍇ́Al̒lCxgnĥꂼ̈Ɏw肳܂B

      :
        (xhr-get-async "http://www.google.co.jp/"
                       :key #'(lambda (res)
                                (values (xhr-requested-uri res)
                                        (xhr-status res)))
                       :oncomplete #'(lambda (uri status)
                                       (msgbox "~S => ~S" uri status)))


    * Cxgnh ONSUCCESS ONFAILURE ONCOMPLETE HANDLER Ŏw肵܂B

      * ONSUCCESS

        I (http status  20x) ꍇɌĂ΂܂B

      * ONFAILURE

        ُI (http status  20x ȊO) ꍇɌĂ΂܂B

      * ONCOMPLETE

        ʐMIɏɌĂ΂܂BONSUCCESS, ONFAILURE ɌĂ΂܂B

      * HANDLER

        HTTP Xe[^XƂɃCxgnhsꍇ HANDLER Ŏw肵܂B

    :
        (xhr-get-async "http://www.google.co.jp/"
                       :headers '(:User-Agent "Mozilla Firefox"
                                  :Accept-Language "ja")
                       :since :epoch
                       :oncomplete #'(lambda (res)
                                       (msgbox "~D ~A"
                                               (xhr-status res)
                                               (xhr-status-text res)))
                       :handler (list
                                 200 #'(lambda (res) (msgbox "OK"))
                                 304 #'(lambda (res) (msgbox "not modified"))
                                 404 #'(lambda (res) (msgbox "not found"))))

    ȂAX-Yzzy-Version Ƃwb_KM܂ (l xyzzy ̃o[W)B

--- xhr-get-future URL &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS QUERY ENCODING

    w肳ꂽ URL ̃\[X get ܂B

     API ͔񓯊 API łB
    API ĂяoƂɐԂAFuture IuWFNgԂ܂B
    ((<xhr-future-value|xhr-future-value FUTURE &KEY NOWAIT NO-REDRAW SLEEP TIMEOUT INTERVAL>))
     Future IuWFNgl擾悤Ƃ_ł܂ get ĂȂꍇ̓ubN܂B

    NGXg~ꍇ Future IuWFNg
    ((<xhr-abort|xhr-abort TRANSPORT>))
    Ɏw肵܂B

    * BASIC-AUTH, NOMSG, KEY, SINCE, HEADERS ̎w@
      ((<xhr-get|xhr-get URL &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS QUERY ENCODING>))
      QƂĂB

    * ߂l Future IuWFNgԂ܂B

    :
        (let ((future (xhr-get-future "http://www.google.co.jp/"
                                      :key 'xhr-status-text
                                      :since :epoch)))
          (msgbox "do something~%~S" future)
          (msgbox "~S~%~S"
                  (xhr-future-value future :timeout 10)
                  future))

    ȂAX-Yzzy-Version Ƃwb_KM܂ (l xyzzy ̃o[W)B

    See Also:

    * ((<xhr-future-p|xhr-future-p OBJ>))
    * ((<xhr-future-completed-p|xhr-future-completed-p FUTURE>))
    * ((<xhr-future-value|xhr-future-value FUTURE &KEY NOWAIT NO-REDRAW SLEEP TIMEOUT INTERVAL>))

--- xhr-head URL &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS QUERY ENCODING

    w肳ꂽ URL  HEAD NGXg𓯊IɑM܂B

    ڍׂ
    ((<xhr-get|xhr-get URL &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS QUERY ENCODING>))
    QƂĂB

--- xhr-head-async URL &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS QUERY ENCODING ONSUCCESS ONFAILURE ONCOMPLETE HANDLER

    w肳ꂽ URL  HEAD NGXg񓯊ɑM܂B

    ڍׂ
    ((<xhr-get-async|xhr-get-async URL &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS QUERY ENCODING ONSUCCESS ONFAILURE ONCOMPLETE HANDLER>))
    QƂĂB

--- xhr-head-future URL &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS QUERY ENCODING
    w肳ꂽ URL  HEAD NGXg񓯊ɑM܂B

    ڍׂ
    ((<xhr-get-future|xhr-get-future URL &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS QUERY ENCODING>))
    QƂĂB

--- xhr-post URL DATA &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS ENCODING

    w肳ꂽ URL  DATA 𓯊I POST ܂B

    * DATA ͕܂̓XgŎw肵܂B

      w肷Ƃ̂܂ܑM܂B
      si:www-url-encode ȂǂœK؂ɃGR[hlw肵ĂB

      L[ƒlȂ郊Xgw肷ƎIɃGR[h܂B
      ENCODING w肷ƕR[hϊ RFC3986 ɂx] url GR[h܂
      (si:www-url-encode ̃ftHgƂ͈Ⴂ܂)B
      ENCODING w肵Ȃꍇ͂̂܂ url GR[h܂B

      ȉ 2 ̌Ăяo͓łB

        (xhr-post "https://www.hatena.ne.jp/login"
                  "name=foo&password=bar&persistent=1"
                  :key 'xhr-response-text
                  :since :epoch)

        (xhr-post "https://www.hatena.ne.jp/login"
                  '(:name "foo" :password "bar" :persistent 1)
                  :key 'xhr-response-text
                  :since :epoch)

    * HEADERS  Content-Type w肳ĂȂꍇ
      application/x-www-form-urlencoded IɃZbg܂B

        (xhr-post url
                  octet-data
                  :headers '(:Content-Type "application/octet-stream"))


    ̑̈і߂l
    ((<xhr-get|xhr-get URL &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS QUERY ENCODING>))
    ƓłB

--- xhr-post-async URL DATA &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS ENCODING ONSUCCESS ONFAILURE ONCOMPLETE HANDLER

    w肳ꂽ URL  DATA 񓯊 POST ܂B

    ڍׂ͈ȉQƂĂB

    * ((<xhr-post|xhr-post URL DATA &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS ENCODING>))
    * ((<xhr-get-async|xhr-get-async URL &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS QUERY ENCODING ONSUCCESS ONFAILURE ONCOMPLETE HANDLER>))

--- xhr-post-future URL DATA &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS ENCODING

    w肳ꂽ URL  DATA 񓯊 POST ܂B

    ڍׂ͈ȉQƂĂB

    * ((<xhr-post|xhr-post URL DATA &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS ENCODING>))
    * ((<xhr-get-future|xhr-get-future URL &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS QUERY ENCODING>))

--- xhr-request METHOD URL DATA &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS QUERY ENCODING

    w肳ꂽ HTTP METHOD 𑗐M܂B
    DATA Ȃꍇ nil w肵ĂB

    ̑̈
    ((<xhr-post|xhr-post URL DATA &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS ENCODING>))
    ƓłB

    :

        (xhr-request "OPTIONS" url  nil
                     :key #'(lambda (res)
                              (split-string (or (xhr-response-header res "Allow") "") #\,)))
        ;=> ("GET" "HEAD" "OPTIONS" "POST")

--- xhr-request-async METHOD URL DATA &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS QUERY ENCODING HANDLER ONSUCCESS ONFAILURE ONCOMPLETE

    w肳ꂽ URL  METHOD 񓯊ɑM܂B

    ڍׂ͈ȉQƂĂB

    * ((<xhr-request|xhr-request METHOD URL DATA &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS QUERY ENCODING>))
    * ((<xhr-get-async|xhr-get-async URL &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS QUERY ENCODING ONSUCCESS ONFAILURE ONCOMPLETE HANDLER>))

--- xhr-request-future METHOD URL DATA &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS QUERY ENCODING

    w肳ꂽ URL  METHOD 񓯊ɑM܂B

    ڍׂ͈ȉQƂĂB

    * ((<xhr-request|xhr-request METHOD URL DATA &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS QUERY ENCODING>))
    * ((<xhr-get-future|xhr-get-future URL &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS QUERY ENCODING>))

--- xhr-future-p OBJ

    w肳ꂽ OBJ  Future IuWFNgȂ non-nil Ԃ܂B

--- xhr-future-uri FUTURE

    w肳ꂽ Future IuWFNg烊NGXg URI 擾܂B

--- xhr-future-completed-p FUTURE

    w肳ꂽ Future IuWFNg̃NGXgĂ non-nil Ԃ܂B

--- xhr-future-value FUTURE &KEY NOWAIT NO-REDRAW SLEEP TIMEOUT INTERVAL

    w肳ꂽ Future IuWFNg猋ʂ擾܂B
    ʂ̓NGXgMɎw肵 KEY KpꂽʂԂ܂B

    NGXgĂȂꍇ͊҂킹܂B

    * NOWAIT  non-nil w肷ƃNGXgĂȂꍇ
      ҂킹ɂ nil Ԃ܂B

      ftHg nil łB

    * NO-REDRAW  non-nil w肷ƃNGXg̊҂
      ʂ̍ĕ`s܂B

      ftHg nil łB

    * SLEEP  non-nil w肷ƃNGXg̊҂
      L[͂Ăf܂B

      SLEEP  nil ̏ꍇL[͂҂킹𒆒f܂B
      f_ŃNGXgĂȂꍇ nil Ԃ܂B

      SLEEP w肵ꍇ͉ʂ̍ĕ`s܂B

      ftHg nil łB

    * TIMEOUT w肷Ǝw肵bȓɃNGXgȂꍇA
      nil Ԃ܂B

      TIMEOUT  nil w肷ƃ^CAEgɖɑ҂킹܂B

      ftHg 3 błB

    * INTERVAL ͊ĎԊułB

      ftHg 0.3 błB

--- xhr-requested-uri RES

    w肳ꂽX|XIuWFNg URI 擾܂B

      (xhr-requested-uri (xhr-get "http://www.google.co.jp/"))
      ;=> http://www.google.co.jp/

--- xhr-all-response-header RES

    ׂĂ HTTP wb_擾܂B
    ߂l͑Swb_܂Ƃ߂ŕԂ܂B

--- xhr-all-response-header-alist RES

    ׂĂ HTTP wb_ alist Ŏ擾܂B

--- xhr-all-response-header-hash RES

    ׂĂ HTTP wb_ hashtable Ŏ擾܂B

--- xhr-response-header RES HEADER

    w肵 HTTP wb_擾܂B
    header ɂ "Content-Length"  "Last-Modified" Ȃǂw肵܂B

--- xhr-response-text RES

    HTTP ʐM̌ (body) 擾܂B

--- xhr-response-xml RES

    擾 XML  SŕԂ܂B
    S  xml-parser-modoki ƌ݊܂iԂjB

    擾̃\[X XML łȂꍇ nil Ԃ܂B
    XML eLXg`Ŏ擾ꍇ
    ((<xhr-response-text|xhr-response-text RES>))
    gpĂB

--- xhr-response-values RES

    ȉ̒l𑽒lŕԂ܂B
    * ((<"X|X{"|xhr-response-text RES>))
    * ((<"HTTP Xe[^X"|xhr-status RES>))
    * ((<"X|Xwb_ (alist)"|xhr-all-response-header-alist RES>))

--- xhr-status RES

    HTTP status 擾܂B

--- xhr-status-text RES

    HTTP status ̕\擾܂B

--- xhr-abort TRANSPORT

    w肵NGXg~܂B

    ɂ Future IuWFNg (xhr-xxx-future ̖߂l)A
    LZIuWFNg (xhr-xxx-async ̖߂l) w\łB

    ʐM𒆒fȂ t Ԃ܂B
    ɒʐMIĂ牽 nil Ԃ܂B

    :

        ;; 5 bȓɌʂԂȂ΃RlNVؒfėO𓊂
        (let ((future (xhr-get-future url)))
          (let ((v (xhr-future-value future :timeout 5)))
            (unless (xhr-future-completed-p future)
              (xhr-abort future)
              (plain-error "timeout"))
            v))

--- xhr-credential USER PASSWORD

    eNGXg֐ :basic-auth Ɏw肷邽߂
    [UFؗp̏쐬܂B

--- xml-http-request-version

    {Cũo[WԂ܂B
    o[W major.minor.teeny Ƃ`łB

    ꂼ̔ԍ͕K 1 ɂ̂ŁAȉ̂悤ɔr邱Ƃł܂B

        (if (string<= "1.1.0" (xml-http-request-version))
            (1.1.0 ȍ~ŗLȏ)
          (1.1.0 Õo[Wł̏))


=== MACRO

--- with-xhr-get-async (URL &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS QUERY ENCODING>) &BODY HANDLER

    ((<xhr-get-async|xhr-get-async URL &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS QUERY ENCODING ONSUCCESS ONFAILURE ONCOMPLETE HANDLER>))
    ̃bp[}NłB

    }N̖{̂ɂ͈ȉ̌`ŃCxgnhLqł܂B

      (on <(or HTTPXe[^X :success :failure :complete)> (<>...)
          <Cxgnh̖{>)

    )

      (with-xhr-get-async ("http://www.google.co.jp/" :since :epoch)
        (on 200 (res)
            (msgbox "200 OK"))
        (on :success (res)
            (msgbox "܂ ~S" (xhr-response-header res "Server")))
        (on :failure (res)
            (msgbox "s܂... orz"))
        (on :complete (res)
            (msgbox "I܂")
            (msgbox "http status: ~A" (xhr-status res))))

    on ̒g̓N[Wɕϊ̂ňȉ̂悤ȂƂł܂B

      (setf result (let ((r nil))
                     (with-xhr-get-async ("http://www.google.co.jp/"
                                          :key 'xhr-response-values)
                       (on :complete (text status header)
                           (setf r (list status header text))))
                     #'(lambda () r)))
      (funcall result)

--- with-xhr-head-async (URL &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS QUERY ENCODING) &BODY HANDLER

    ((<xhr-head-async|xhr-head-async URL &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS QUERY ENCODING ONSUCCESS ONFAILURE ONCOMPLETE HANDLER>))
    ̃bp[}NłB

--- with-xhr-post-async (URL BODY &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS ENCODING) &BODY HANDLER

    ((<xhr-post-async|xhr-post-async URL DATA &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS ENCODING ONSUCCESS ONFAILURE ONCOMPLETE HANDLER>))
    ̃bp[}NłB

--- with-xhr-request-async (METHOD URL BODY &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS QUERY ENCODING) &BODY HANDLER

    ((<xhr-request-async|xhr-request-async METHOD URL DATA &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS QUERY ENCODING HANDLER ONSUCCESS ONFAILURE ONCOMPLETE>))
    ̃bp[}NłB


=== OBSOLETE FUNCTION

--- http-get URL &KEY HEADERS ONFAILURE ONSUCCESS ONCOMPLETE

    ͌݊̂߂ɎcĂ 񐄏 API łB

    ς
    ((<xhr-get|xhr-get URL &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS QUERY ENCODING>))A
    ((<xhr-get-async|xhr-get-async URL &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS QUERY ENCODING ONSUCCESS ONFAILURE ONCOMPLETE HANDLER>))
    gĂB

--- http-post URL DATA &KEY HEADERS ONFAILURE ONSUCCESS ONCOMPLETE

    ͌݊̂߂ɎcĂ 񐄏 API łB

    ς
    ((<xhr-post|xhr-post URL DATA &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS ENCODING>))A
    ((<xhr-post-async|xhr-post-async URL DATA &KEY BASIC-AUTH NOMSG KEY SINCE HEADERS ENCODING ONSUCCESS ONFAILURE ONCOMPLETE HANDLER>))
    gĂB

--- response-text TRANSPORT

    ͌݊̂߂ɎcĂ 񐄏 API łB

    ς
    ((<xhr-response-text|xhr-response-text RES>))
    gĂB

--- status TRANSPORT

    ͌݊̂߂ɎcĂ 񐄏 API łB

    ς
    ((<xhr-status|xhr-status RES>))
    gĂB

--- status-text TRANSPORT

    ͌݊̂߂ɎcĂ 񐄏 API łB

    ς
    ((<xhr-status-text|xhr-status-text RES>))
    gĂB

--- abort TRANSPORT

    ͌݊̂߂ɎcĂ 񐄏 API łB

    ς
    ((<xhr-abort|xhr-abort TRANSPORT>))
    gĂB

--- all-response-headers TRANSPORT

    ͌݊̂߂ɎcĂ 񐄏 API łB

    ς
    ((<xhr-all-response-header|xhr-all-response-header RES>))
    gĂB

--- response-header TRANSPORT HEADER

    ͌݊̂߂ɎcĂ 񐄏 API łB

    ς
    ((<xhr-response-header|xhr-response-header RES HEADER>))
    gĂB


== TODO

* tbN
* g[XO
* Msxml2.ServerXMLHTTP
  * proxycfg
  * netsh (vista)
  * oledata ̍ėp
    * xhr-agent ?


== KNOWN BUGS

* 󔒕 + ł͂Ȃ %20 ɃGR[h܂B

* T[o charset Ԃ UTF-8 ȊȌꍇ͕܂B

   ((<URL:http://d.hatena.ne.jp/miyamuko/20050913#p1>))

*  xyzzy  Shift_JIS ɕϊ܂B

  Shift_JIS O̕ ? ɉ܂ (pƓ{ȊO͂܂ƂɈ܂)B


== AUTHOR

݂ނ 䂫 (((<URL:mailto:miyamuko@gmail.com>)))


== SEE ALSO

ȂB


== COPYRIGHT

xml-http-request  MIT/X CZXɊÂėp\łB

See xml-http-request/docs/MIT-LICENSE for full license.


== NEWS

<<<NEWS.rd

=end
