;;; -*- Mode: Lisp; Package: EDITOR; Last modified: <2007/12/31 01:16:01> -*-
;;;
;;; This file is not part of xyzzy.
;;;
;;;   winbatch-mode.l --- Simple mode for Batch File Enhancer for Windows (WinBatchEh)
;;;
;;;     by HIE Masahiro <madoinu@ybb.ne.jp>
#|

Tv

  WinBatchEh p̃[hB

  OHKUBO Hiroshi  bat-mode.l x[X WinBatchEh p̉i
  Ă݂B

   mɂ낢ƃAhoCX𒸂܂BӂłB

  ̑AQlɂẮBiƂAقڂ̂܂܎g킹
  ́Bj
  
    htmlmode.l
    php-mode.l
    csv-mode.l
    xyzzy ML
    ̑R...

  ̗LpȃR[hJĒĂ鏔yɑӁB


gp̒

  EWinBatchEh ̎spX́AWXg(̂Ԃ֘At̕)
    擾悤ɂĂ݂ANȂꍇъ֘At̂Ă
    ꍇ́A*winbatch-path* 𒼐ڎw肵ȂƂȂƎvB
  
      : (setq *winbatch-path* "c:/utility/winbatch/")
  
  ECCRgɂ́A//  # ̂ǂ炩włȂB
  
  EtbO(MB_* Ƃ)̕⊮ꉞł邪A
      MESSAGEBOX=MB_
    ܂ŋLq C-. Ă No match ɂȂĂ܂BA
      MESSAGEBOX= MB_
    ȂǂƂĂ(= ̌ɃXy[XĂ)ƂłȂȂB
    AŃXy[XȂƂȂ̂ŁA͂ʓ|Ȃ̂ł
    B
  
  ER}h̃L[[h⊮́Ał̂ݗLB啶ł
    ꍇ́AL[[ht@C (WINBATCH) ̃L[[h啶
    ɂΗǂƎvBitbOƂ͑啶j
  
  EtbO̐Ft́A擪 GCD,MB,OFN,SC,SPI,SPIF,STF,SW,VK,WM + _
    Ŏn܂PSĂɑ΂čsĂ̂ŁAۂɂ݂͑ȂtO
    ɂFtB
  
  ExƃRg̐F͂łĂB
  
  EWinBatchEh ̌f̃AhX́AT[o̕׏󋵂ȂǂɂύX
    邱Ƃ邻Ȃ̂ŁANij[ɕ\jꍇ́A
     *winbatch-forum-url* ݒ肷KvBftHgł́A
    \ȂB
  
  ELisp  WinBatchEh ǂȂ܂܍Ă̂ŁAB


CXg[

  1. winbatch-mode.l  ~/site-lisp ɁAWINBATCH  ~/etc 
     Rs[B

  2. KvȂ΃oCgRpCB

  3. *.btw ǂ݂񂾂ƂɎI batch-mode ɂ邽߂ɁA
     ȉ̃R[ht@Cɒǉ(Ԃ)B

      .xyzzyɒǉꍇ
           (export 'ed::winbatch-mode "ed")
           (autoload 'winbatch-mode "winbatch-mode" t)
           (pushnew '("\\.btw$" . winbatch-mode) *auto-mode-alist* :test 'equal)

      siteinit.lɒǉꍇ
           (in-package "editor")
           (export 'winbatch-mode)
           (autoload 'winbatch-mode "winbatch-mode" t)
           (pushnew '("\\.btw$" . winbatch-mode) *auto-mode-alist* :test 'equal)
           (in-package "user")

   4. ⊮|bvAbvꗗ\ꍇ́Aȉ̃R[h
      t@CɒǉB

           (setq *popup-completion-list-default* :always)

   5. L̐ݒ𔽉f邽߂ɁAxyzzyċNB


g

  M-x winbatch-mode

  XNvgs܂͊JꍇɁAp[^w肷ꍇ́A
  Parameters: ɓ͂Bw肷ꍇ́ApXy[X؂
  ŁApXy[Xw肷ꍇ́A"" łĎw
  Bp[^svȏꍇ́A͂̂܂ Enter  OKB


L[oCh

  F1       wv
  C-.      L[[h⊮
  C-;      ZNV΃ZNVɃRg}A
           ȂΌݍs̃RggO
  M-C-;    ZNṼRg폜
  C-c x    XNvgs
  C-c o    XNvg winbat32.exe ŊJ
  C-c c    t@CNbv{[hɃRs[āARpCN


ݒ

  ;; Rg ("REM " or ":/ ")
  (setq *winbatch-mode-comment-start* ":/ ")
  
  ;; CCRg ("//", "#" or nil)
  (setq *winbatch-inlinecomment-string* "#")
  
  ;; XNvgsȂǂɃt@Cۑ
  (setq *winbatch-auto-save* nil)
  
  ;; WinBatchEh f̃y[Wj[ɕ\ (nil or "url")
  (setq *winbatch-forum-url* "http://hpcgi3.nifty.com/b7/bbs/wforum.cgi")
  
  ;; sO̍sɍ킹ăCfg
  (setq *winbatch-use-newline-and-indent* t)

  ;; WinBatchEh XNvgۑtH_iex: c:\winbatch\data\ ̏ꍇj
  (setq *winbatch-script-directory* "c:/winbatch/data/")


XV

  [Version 1.16] 2007-12-31 ()
  ECZX(MITCZX)LځB

  [Version 1.15] 2002/09/21 01:58:52 +0900
  Ewinbatch-open-filer ǉB
      primary-directory:   \̃t@ĈtH_
      secondary-directory: *winbatch-script-directory* Ɏw肵tH_
    Ђ炭B
  EWinBatchEh ̃pX local-machine łȂ classes-root 擾
    悤ɂB
  ȆׂȕύXB
  EiɁA͂߂ list gĂ݂Bj

  [Version 1.14.1] 2002/09/15 12:06:01 +0900
  E⊮̃|bvAbvꗗ\̐ݒ́AKvȕ݂̂Ƃ()B

  [Version 1.14] 2002/09/15 00:14:46 +0900
  EWinBatchEh ĂȂƁANɃG[ɂȂ̂CB
  E⊮̈ꗗ\́AR{ ׎O Tips gĂ̂v
    oAǉB

  [Version 1.12] 2002/09/14 09:53:55 +0900
  EXNvg̎sAJ̈wɁAminibuffer-prompt g
    Ȃ悤ɂB
  E*winbatch-auto-save* ̊l t ɂB
  
  [Version 1.11] 2002/09/12 22:21:07 +0900
  EʂɑRgʃt@CɂčB
  ȆɗȂύXB
  
  [Version 1.10] 2002/09/11 23:18:52 +0900
  E܂ɂ bat-mode ɐ܂Ă܂̂ŁAbat-mode x[X
    ďB
  E*winbatch-regexp-keyword-list* B
  Et@CsAۑĂȂꍇ́Aۑ邱Ƃł悤
    B  *winbatch-auto-save*
  Ebatch-mode  winbatch-mode ɕύXBi{̖ړItc[
    (?)ob`t@CŎgpKv̂ŁjB
  
  [Version 1.09] 2002/09/03 10:36:05 +0900
  EςfȂ̂ŁAf̕\͂ꍇA
    ł悤ɂB *winbatch-forum-url*
  EJX^}CY邩Ȃ export B
  
  [Version 1.08] 2002/09/03 06:27:27 +0900
  ERg̑}A폜̕@ύXB܂A:/ gp
    悤ɂB
  EL[oChWI(?)łȂ̂ύXB
  ȆׂȕύXђӏ̒ǉB
  
  [Version 1.07] 2002/09/02 10:58:10 +0900
  Ex[J[X̕u(http://members.tripod.co.jp/mystery_trick_room/)
    ݂āAڂ؁Bwv̌ȊȒPɂłȂ...B
  
  [Version 1.06] 2002/09/02()
  Ewinbat32.exe ֓nt@C"" ł悤ɂB
  ERgƃxs̐Ft@ύXB
  
  [Version 1.05] 2002/09/01()
  E mɋĂ@gāAWinBatchHelp.btw
    gȂĂwvł悤ɂȂBiAPI𒼐ڌĂ
    o@ł΁A WinBatchEh gȂĂ xyzzy
    璼ڎsł̂Hj
  
  [Version 1.04] 2002/08/30()
  EWXg WinBatchEh ̃CXg[fBNg擾
    悤ɂB
  ERpCNƂAf\ƂB
  
  [Version 1.03] 2002/08/29()
  Ecsv-mode QlɁA[Jȃj[B
  
  [Version 1.02] 2002/08/28()
  Ebat-mode  indent B
    قƂǁAbat-mode x[X̉iɂȂB
  Ewinbatch-open-script ǉB
  Ebatch-search-help-selection ɁAwinbat32.exe ܂
    WinBatchHelp.btw Ȃꍇ̏ǉB
  ȆׂCB
  
  [Version 1.01] 2002/08/12()
  Eversion ̓ mode-name ߂B
  EFt炩ύX
  
  [Version 1.00] 2002/08/11()
  Ewinbatch-run-script ǉB
  
  [Version 0.4] 2002/08/10(y)
  E:/ RgƂĔF悤ɂB
  Einlinecomment ƂāA//  # ̂ǂ炩gpł悤ɂB
    ĺA// B
  
  [Version 0.3] 2002/08/10(y)
  Ebatch-encomment-selection, batch-outcomment-selection
    ǉB
  
  [Version 0.2] 2002/08/08()
  Emy-bat-mode  batch-mode ɕύXB
  Esearch-winbatch-help-selection ǉBiv WinBatchEhj
  Ebat-mode A*bat-regexp-keyword-list* 𒸂B
  Ephp-mode A"L[[h⊮" 𒸂B
  Ehtmlmode.l ̕svƎv邠폜B
  
  [Version 0.1]
  Ehtmlmode.l ̃L[[h`݂̂ύXĂƂ肠B


CZX

  winbatch-mode.l MITCZXɊÂėp\łB
  <http://www.opensource.org/licenses/mit-license.php>

Copyright (c) 2002-2007 HIE Masahiro

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

|#

(provide "winbatch-mode")

(in-package "editor")

(eval-when (:compile-toplevel :load-toplevel :execute)
  (export '(*winbatch-mode-hook*
            *winbatch-mode-map*
            *winbatch-mode-version*
            *winbatch-keyword-file*
            *winbatch-keyword-file-use*
            *winbatch-regexp-keyword-list*
            *winbatch-mode-comment-start*
            *winbatch-comment-column*
            *winbatch-mode-abbrev-table*
	    *winbatch-inlinecomment-string*
	    *winbatch-use-newline-and-indent*
	    *winbatch-path*
	    *winbatch-auto-save*
	    *winbatch-home-url*
	    *winbatch-forum-url*
	    )))
(eval-when (:compile-toplevel :load-toplevel :execute)
  (export '(winbatch-mode
            winbatch-indent-line
            winbatch-newline-and-indent
	    winbatch-comment-indent
	    winbatch-completion
	    winbatch-encomment-selection-or-comment-toggle-line
	    winbatch-outcomment-selection
	    winbatch-show-winhelp
	    winbatch-run-script
	    winbatch-open-script
	    winbatch-compile-script
	    )))

(defconstant *winbatch-mode-version* "1.15")

;; L[[ht@Cgp
(defvar *winbatch-keyword-file-use* t)

;; Rg ("REM " or ":/ ")
(defvar *winbatch-mode-comment-start* "REM ")

;; CCRg ("//", "#" or nil)
;;   gpȂꍇ́Anil ݒ
(defvar *winbatch-inlinecomment-string* "//")

;; XNvgsȂǂɃt@Cۑ
(defvar *winbatch-auto-save* t)

;; sO̍sɍ킹ăCfg
(defvar *winbatch-use-newline-and-indent* nil)

;;  m̂؁[
(defvar *winbatch-home-url* "http://www.vector.co.jp/authors/VA000007/")

;; WinBatchEh f̃y[W (nil or "url")
(defvar *winbatch-forum-url* nil)

;; WinBatchEh ̃CXg[fBNg
(defvar *winbatch-path*
  (let (list)
    (setq list
	  (let ((result nil))
	    (dolist (item '(".BTW\\shell\\open\\command"
			    "BTW_auto_file\\shell\\open\\command")
			  (nreverse result))
	      (push
	       (let ((p (read-registry item "" :classes-root)))
		 (if p
		     (map-backslash-to-slash
		      (substring p 0 (string-match "[wW][iI][nN][bB][aA][tT]32.[eE][xX][eE]" p)))))
	       result))))
    ;list ܂Ȃ...
    (let ((path1 (car list))
	  (path2 (cadr list)))
      (or path1 path2 ""))))

;; WinBatchEh XNvgۑfBNg
(defvar *winbatch-script-directory* (concat *winbatch-path* "sample/"))

;; winbat32.exe ̃tpX
(defvar *winbatch-prog* (merge-pathnames "winbat32.exe" *winbatch-path*))

;; wbatcp.exe ̃tpX
(defvar *winbatch-compiler-prog* (merge-pathnames "wbatcp.exe" *winbatch-path*))

;; wvt@C̃tpX
(defvar *winbatch-winhelp-file* (merge-pathnames "winbat32.hlp" *winbatch-path*))

;; Fݒ
;Rg
(defvar *winbatch-comment-color* '(:keyword :comment))
;x
(defvar *winbatch-lavel-color* '(:color 1 0))
;GOTO ̃x
(defvar *winbatch-goto-label-color* '(:color 1 0))
;ECHO {
(defvar *winbatch-echo-color* '(:color 15 0))
;GR[}~
(defvar *winbatch-echo-stop-color* '(:keyword 1))
;[vϐ
(defvar *winbatch-loop-variable-color* '(:color 14 0))
;
(defvar *winbatch-argument-color* '(:color 14 0))
;ϐ
(defvar *winbatch-variable-color* '(:color 14 0))
;ϐQ
(defvar *winbatch-variable-reference-color* '(:color 14 0))
;keyword 0
(defvar *winbatch-keyword0-color* '(:keyword 0))
;keyword 2
(defvar *winbatch-keyword2-color* '(:keyword 2))
;tO
(defvar *winbatch-flag-color* '(:color  9 0))

;; startup message
(defvar *winbatch-startup-message* t)

(defvar *winbatch-mode-hook* nil)
(defvar *winbatch-keyword-hash-table* nil)
(defvar *winbatch-keyword-file* "WINBATCH")
(defvar *winbatch-completion-list* nil)

(defvar *winbatch-mode-map* nil)
(unless *winbatch-mode-map*
  (setq *winbatch-mode-map* (make-sparse-keymap))
  (define-key *winbatch-mode-map*   #\F1       'winbatch-show-winhelp)
  (define-key *winbatch-mode-map*   #\TAB      'winbatch-indent-line)
  (if *winbatch-use-newline-and-indent*
      (define-key *winbatch-mode-map* #\RET    'winbatch-newline-and-indent))
  (define-key *winbatch-mode-map*   #\C-.      'winbatch-completion)
  (define-key *winbatch-mode-map*   #\C-\;     'winbatch-encomment-selection-or-comment-toggle-line)
  (define-key *winbatch-mode-map*   #\M-\C-\;  'winbatch-outcomment-selection)
  (define-key *winbatch-mode-map* '(#\C-c #\x) 'winbatch-run-script)
  (define-key *winbatch-mode-map* '(#\C-c #\o) 'winbatch-open-script)
  (define-key *winbatch-mode-map* '(#\C-c #\c) 'winbatch-compile-script)
  (define-key *winbatch-mode-map* '(#\C-c #\f) 'winbatch-open-filer)
  (define-key *winbatch-mode-map* '(#\C-c #\?) 'winbatch-mode-show-version))

(defvar *winbatch-mode-abbrev-table* nil)
(unless *winbatch-mode-abbrev-table*
  (define-abbrev-table '*winbatch-mode-abbrev-table*))

(defvar *winbatch-mode-syntax-table* nil)
(unless *winbatch-mode-syntax-table*
  (setq *winbatch-mode-syntax-table* (make-syntax-table))
  (cond ((string= *winbatch-inlinecomment-string* "//")
	 (progn
	   (set-syntax-start-c++-comment *winbatch-mode-syntax-table* #\/)
	   (set-syntax-end-c++-comment *winbatch-mode-syntax-table* #\LFD)))
	((string= *winbatch-inlinecomment-string* "#")
	 (progn
	   (set-syntax-start-comment *winbatch-mode-syntax-table* #\#)
	   (set-syntax-end-comment *winbatch-mode-syntax-table* #\LFD))))
  (set-syntax-string *winbatch-mode-syntax-table* #\")
  (set-syntax-string *winbatch-mode-syntax-table* #\'))

(defvar *winbatch-regexp-keyword-list* nil)

(setq *winbatch-regexp-keyword-list*
  (compile-regexp-keyword-list
   `(
     ;xs
     (,(concat "^[ \t]*\\(:[^/ \t\n]+\\)"
	       "\\(?:[ \t]\\(.*\\)\\)?") t ((1 . ,*winbatch-lavel-color*)
					    (2 . ,*winbatch-comment-color*)))
     ;GR[}~
     ("^[ \t]*\\(@\\)" t ((1 . ,*winbatch-echo-stop-color*)))
     ;Rg
     ("\\<\\(REM\\)\\>\\(?:[ \t]\\(.*\\)\\)?" t ,*winbatch-comment-color*)
     ;xsɃ}b`Ȃ:Ŏn܂s̓Rg
     ("^[ \t]*:.*" t ,*winbatch-comment-color*)
     ;
     ("%[0-9]" nil ,*winbatch-argument-color*)
     ;[vϐ
     ("%%[a-zA-Z]" nil ,*winbatch-loop-variable-color*)
     ;ϐ
     ("%@*[a-zA-Z][a-zA-Z0-9_]*\\(\\[[0-9]+\\]\\)*%" nil ,*winbatch-variable-reference-color*)
     ;goto, gosub
     (,(concat "\\<\\(GOTO\\|GOSUB\\)\\>"
	       "\\(?:[ \t]+\\([^/ \t\n]+\\)\\)?"
	       "\\(?:[ \t]+\\(.*\\)\\)?") t ((1 . ,*winbatch-keyword0-color*)
					     (2 . ,*winbatch-goto-label-color*)
					     (3 . ,*winbatch-comment-color*)))
     ;echo
     ("\\<\\(ECHO\\)[ \t]+\\(ON\\|OFF\\)[ \t]*$" t ((0 . ,*winbatch-keyword2-color*)))
     (,(concat "\\<\\(ECHO\\.?\\)\\>"
               "\\(?:[ \t]\\(.*\\)\\)?") t ((1 . ,*winbatch-keyword2-color*)
                                            (2 . ,*winbatch-echo-color*)))
     ;set
     ("\\<\\(SET\\)\\(?:[ \t]+\\([^=\n]+\\)\\(?:=\\)?\\)?" t ((1 . ,*winbatch-keyword2-color*)
							      (2 . ,*winbatch-variable-color*)))
     ;hCuw
     ("^[ \t]*\\([a-zA-Z]:$\\|[a-zA-Z]: \\)" t ,*winbatch-keyword2-color*)
     ;...
     ("\\(winbat\\(?:32\\|ch\\)\\) *==" t ((1 . ,*winbatch-keyword0-color*)))
     ;tO
     ("\\(GCD\\|MB\\|OFN\\|SC\\|SPI\\|SPIF\\|STF\\|SW\\|VK\\|WM\\)_[A-Z]+[0-9]*" t ,*winbatch-flag-color*)
     )))

;; [h̐ݒ
(defun winbatch-mode ()
  (interactive)
  (kill-all-local-variables)
  (if *winbatch-startup-message*
      (message "WinBatchEh mode ~A for xyzzy."
	       *winbatch-mode-version*))
  (setq buffer-mode 'winbatch-mode)
  (setq mode-name "WinBatchEh")
  (use-keymap *winbatch-mode-map*)
  (use-syntax-table *winbatch-mode-syntax-table*)

  (make-local-variable 'mode-specific-indent-command)
  (setq mode-specific-indent-command 'winbatch-indent-line)

  (cond
   (*winbatch-keyword-file-use*
    (and *winbatch-keyword-file*
         (null *winbatch-keyword-hash-table*)
         (setq *winbatch-keyword-hash-table*
               (load-keyword-file *winbatch-keyword-file* t)))
    (when *winbatch-keyword-hash-table*
      (make-local-variable 'keyword-hash-table)
      (setq keyword-hash-table *winbatch-keyword-hash-table*)))
   (t
    (make-local-variable 'keyword-hash-table)
    (setq keyword-hash-table '())))

  (make-local-variable 'regexp-keyword-list)
  (setq regexp-keyword-list *winbatch-regexp-keyword-list*)
  
  (setq *local-abbrev-table* *winbatch-mode-abbrev-table*)
  (winbatch-menu-update)
  (run-hooks '*winbatch-mode-hook*))

(defun winbatch-newline-and-indent (&optional (arg 1))
  "s{Cfgt"
  (interactive "*p")
  (insert #\LFD arg)
  (winbatch-indent-line))

(defun winbatch-indent-line ()
  "݂̃Cfgt"
  (interactive "*")
  (if (save-excursion
        (skip-chars-backward " \t")
        (bolp))
      (let ((column 0))
        (save-excursion
          (while (forward-line -1)
            (unless (progn
                      (skip-chars-forward " \t")
                      (eolp))
              (skip-chars-forward " \t")
              (setq column (current-column))
              (return))))
        (smart-indentation column)
        (skip-chars-forward " \t"))
    (insert "\t")))

;php-mode B
(defun winbatch-completion ()
  "L[[h⊮"
  (interactive)
  (or *winbatch-completion-list*
      (setq *winbatch-completion-list* (make-list-from-keyword-table *winbatch-keyword-hash-table*))
      (return-from winbatch-completion nil))
  (let ((opoint (point)))
    (when (skip-syntax-spec-backward "w_.")
      (let ((from (point)))
	(goto-char opoint)
	(do-completion from opoint :list *winbatch-completion-list*)))))

;[xyzzy:06776] B
(defun winbatch-encomment-selection-or-comment-toggle-line ()
  "Rg}܂̓gO"
  (interactive)
  (if (pre-selection-p)
      ;ZNV΁AI͈͂̍sɃRg}
    (let ((from (selection-mark))
	  (to (selection-point)))
      (if (> from to)
	  (rotatef from to))
      (save-excursion
	(save-restriction
	  (narrow-to-region from to)
	  (goto-char from)
	  (insert *winbatch-mode-comment-start*)
	  (while (forward-line 1)
	    (insert *winbatch-mode-comment-start*)))))
    ;ZNVȂ΁ARggO
    (save-excursion
      (let (bol eol)
	(goto-eol)
	(setq eol (point))
	(goto-bol)
	(setq bol (point))
	(if (string-match "^[ \t]*\\(?:[rR][eE][mM]\\|:/\\)\\(?:[ \t]*$\\|[ \t]\\)"
			  (buffer-substring bol eol))
	    (delete-region (+ bol (match-beginning 0)) (+ bol (match-end 0)))
	  (insert *winbatch-mode-comment-start*))))))

;[xyzzy:06789] B
(defun winbatch-outcomment-selection ()
  "I͈͂̍sRg폜"
  (interactive)
  (or (pre-selection-p)
      (error "selectionȂB"))
  (let ((from (selection-mark))
        (to (selection-point)))
    (if (> from to)
        (rotatef from to))
    (save-excursion
      (save-restriction
        (narrow-to-region from to)
        (goto-char from)
	(replace-buffer (concat "^" *winbatch-mode-comment-start*) "" :regexp t)))))

(defun winbatch-run-script (&optional arg)
  "XNvg𑖂点"
  (interactive "sParameters: ")
  (winbatch-exec "x" arg))

(defun winbatch-open-script (&optional arg)
  "XNvgJ"
  (interactive "sParameters: ")
  (winbatch-exec "?" arg))

(defun winbatch-exec (option arg)
  "XNvg WinBatchEh ɓn"
  (let (opt)
    (if (equal option "?")
	(setq opt "?")
      (setq opt ""))
    (if (winbatch-prog-p)
	(progn
	  (if (and (buffer-modified-p) *winbatch-auto-save*)
	      (save-buffer-dialog))
	  (if (not (buffer-modified-p))
		(call-process (concat *winbatch-prog* " " opt "\""
				      (map-slash-to-backslash (get-buffer-file-name)) "\" " arg)
			      :wait nil)
	    (message "ۑĂȂB")))
      (message (concat *winbatch-prog* " ݂ȂB")))))

(defun winbatch-compile-script ()
  "RpCN"
  (interactive)
  (if (winbatch-compiler-prog-p)
      (progn
	(if (and (buffer-modified-p) *winbatch-auto-save*)
	    (save-buffer-dialog))
	(if (not (buffer-modified-p))
	    (progn
	      (copy-to-clipboard (map-slash-to-backslash (get-buffer-file-name)))
	      (call-process *winbatch-compiler-prog* :wait nil))
	  (message "ۑĂȂB")))
    (message (concat *winbatch-compiler-prog* " ݂ȂB"))))

(defun winbatch-show-winhelp ()
  "wv̌"
  (interactive)
  (if (winbatch-help-file-p)
      (run-winhelp *winbatch-winhelp-file*
		   (let ((topic (get-winhelp-topic)))
		     (and (not (equal topic "")) topic)))
    (message (concat *winbatch-winhelp-file* " ݂ȂB"))))

(defun winbatch-open-filer ()
  "WinBatchEh pt@C̋N"
  (interactive)
  (toggle-ime nil)
  (setq *filer-primary-directory* nil)
  (setq *filer-secondary-directory* *winbatch-script-directory*)
  (multiple-value-bind (files result)
      (filer nil t "WinBatch mode" t)
    (when result
      (dolist (f files t)
	(unless (file-directory-p f)
	  (find-file f)
	  (add-history f '*minibuffer-file-name-history*))))))

(defun winbatch-home ()
  (interactive)
  (shell-execute *winbatch-home-url* t))

(defun winbatch-forum ()
  (interactive)
  (shell-execute *winbatch-forum-url* t))

(defun winbatch-mode-show-version ()
  (interactive)
  (message-box (concat "winbatch-mode.l version " *winbatch-mode-version*) "winbatch-mode"))

(defun winbatch-prog-p ()
  "winbat32.exe ̑݊mF"
  (or (file-exist-p *winbatch-prog*) nil))

(defun winbatch-compiler-prog-p ()
  "wbatcp.exe ̑݊mF"
  (or (file-exist-p *winbatch-compiler-prog*) nil))

(defun winbatch-help-file-p ()
  "winbat32.hlp ̑݊mF"
  (or (file-exist-p *winbatch-winhelp-file*) nil))


;; Menu

;csv-mode QlɁB
(defvar *winbatch-menu-name*  "WinBatchEh(&B)")

(defun winbatch-menu-update ()
  (interactive)
  (use-local-menu (winbatch-add-menu)))

(defun winbatch-add-menu ()
  (let ((menu (copy-menu-items *app-menu* (create-menu))))
    (insert-popup-menu menu (get-menu-position menu 'help)
                       *winbatch-menu-default*
                       *winbatch-menu-name*)
    menu))

(defvar *winbatch-menu-default* nil)
(unless *winbatch-menu-default*
  (setq *winbatch-menu-default*
        (let ((menu (create-popup-menu nil)))
          (add-menu-item menu nil "wv(&H)"     'winbatch-show-winhelp
			 #'(lambda () (unless (winbatch-help-file-p) :disable)))
	  (add-menu-separator menu)
	  (add-menu-item menu nil "t@C(&F)"         'winbatch-open-filer)
	  (add-menu-separator menu)
          (add-menu-item menu nil "XNvgs(&X)" 'winbatch-run-script
			 #'(lambda () (unless (winbatch-prog-p) :disable)))
	  (add-menu-item menu nil "XNvgJ(&O)" 'winbatch-open-script
			 #'(lambda () (unless (winbatch-prog-p) :disable)))
	  (add-menu-item menu nil "RpCN(&C)"   'winbatch-compile-script
			 #'(lambda () (unless (winbatch-compiler-prog-p) :disable)))
	  (add-menu-separator menu)
	  (add-menu-item menu nil "L[[h⊮(&K)"     'winbatch-completion)
	  (add-menu-item menu nil "Rg}܂̓gO(&R)"
			 'winbatch-encomment-selection-or-comment-toggle-line)
	  (add-menu-item menu nil "Rg폜(&D)" 'winbatch-outcomment-selection)
	  (add-menu-separator menu)
	  (add-menu-item menu nil " m̃y[W(&W)" 'winbatch-home)
	  (if *winbatch-forum-url*
	    (add-menu-item menu nil "WinBatcȟf(&B)"    'winbatch-forum))
          (add-menu-item menu nil "ɂ(&A)..."           'winbatch-mode-show-version)
          menu)))


;;;  winbatch-mode.l ends here.
