;;; -*- Mode: Lisp; Package: EDITOR; Last modified: <2007/12/31 01:15:39> -*-
;;;
;;; This file is not part of xyzzy.
;;;
;;;   ttl-mode.l --- Simple mode for Tera Term Language
;;;
;;;     by HIE Masahiro <madoinu@ybb.ne.jp>
#|

Tv

  Tera Term }Np̃[hB

  ̑AQlɂẮBiƂAقڂ̂܂܎g킹
  ́Bj

    htmlmode.l
    bat-mode.l
    php-mode.l
    csv-mode.l
    xyzzy ML
    ̑R...

  ̗LpȃR[hJĒĂ鏔yɑӁB


gp̒

  ETera Term ̎spX́AWXg(̂Ԃ֘At̕)
    擾悤ɂĂ݂ANȂꍇiъ֘At̂
    Ȃꍇj́A*ttl-path* 𒼐ڎw肵ȂƂȂƎvB

  ELisp  TTL ǂȂ܂܍Ă̂ŁAB


CXg[:

  1. ttl-mode.l  ~/site-lisp ɁATTL  ~/etc ɃRs[B

  2. KvȂ΃oCgRpCB

  3. *.ttl ǂ݂񂾂ƂɎI ttl-mode ɂ邽߂ɁAȉ
     ̃R[hǉiԂjB

      .xyzzyɒǉꍇ
           (export 'ed::ttl-mode "ed")
           (autoload 'ttl-mode "ttl-mode" t)
           (pushnew '("\\.ttl$" . ttl-mode) *auto-mode-alist* :test 'equal)

      siteinit.lɒǉꍇ
           (in-package "editor")
           (export 'ttl-mode)
           (autoload 'ttl-mode "ttl-mode" t)
           (pushnew '("\\.ttl$" . ttl-mode) *auto-mode-alist* :test 'equal)
           (in-package "user")

   4. ⊮|bvAbvꗗ\ꍇ́Aȉ̃R[h
      t@CɒǉB

           (setq *popup-completion-list-default* :always)

   5. L̐ݒ𔽉f邽߂ɁAxyzzyċNB


g

  M-x ttl-mode

  XNvgsꍇɁAp[^w肷ꍇ́A
  Parameters: ɓ͂Bw肷ꍇ́ApXy[X؂
  ŁApXy[Xw肷ꍇ́A"" łĎw
  Bp[^svȏꍇ́A͂̂܂ Enter  OKB


L[oCh

  F1       wv
  C-.      L[[h⊮
  C-;      ZNV΃ZNVɃRg}A
           ȂΌݍs̃RggO
  M-C-;    ZNṼRg폜
  C-c x    TTL XNvgs


ݒ

  ;; XNvgsɃt@Cۑ
  (setq *ttl-auto-save* nil)


XV

  [Version 1.08] 2007-12-31 ()
  ECZX(MITCZX)LځB

  [Version 1.07.1] 2002/09/15 12:06:11 +0900
  E⊮̃|bvAbvꗗ\̐ݒ́AKvȕ݂̂Ƃ()B

  [Version 1.07] 2002/09/15 00:14:52 +0900
  E⊮̈ꗗ\́AR{ ׎O Tips gĂ̂v
    oAǉB

  [Version 1.06] 2002/09/14 08:46:48 +0900
  EXNvgsA擾̂ minibuffer-prompt gp
    ̂߂B܂Ast@C "" ł悤ɂ
    B
  E*ttl-auto-save* ̊l t ɂB

  [Version 1.05] 2002/09/14 00:32:56 +0900
  EXNvgsɁAobt@ҏW󋵂`FbNAꍇɂ
    ͕ۑĂ炷悤ɂB

  [Version 1.04] 2002/09/03 11:13:47 +0900
  ERg̑}A폜̕@ύXB
  EL[oChWI(?)łȂ̂ύXB
  EJX^}CY邩Ȃ export B
  EꉞAf Tera Term ̃y[WɃN̂߂B

  [Version 1.03] 2002/09/02 11:16:40 +0900
  Ex[J[X̕u(http://members.tripod.co.jp/mystery_trick_room/)
    QlɃwv̌@𐳂(?)@ɕύXB

  [Version 1.02] 2002/08/30()
  EWXg Tera Term ̃CXg[fBNg擾
    悤ɂB
  Ej[B

  [Version 1.01] 2002/08/28()
  ECfg悤ɂB
  ȆׂCB

  [Version 1.00] 2002/08/12()
  Ettl-run-script ǉB
  Ettl-search-help-selection ɁAwinbat32.exe ܂ TTLHelp.btw 
    Ȃꍇ̏ǉB

  [Version 0.4] 2002/08/10(y)
  Ettl-encomment-selection, ttl-outcomment-selection
    ǉB

  [Version 0.3] 2002/08/08()
  Eini-mode x[XAbatch-mode x[XɕύXB
  Ettl-search-help-selection ǉBiv WinBatchEhj
  Erito-ttl-outcomment-selection, rito-ttl-outcomment-selection
    폜B
     siteinit.l Őݒ肷悤ɂB

  [Version 0.3] 2002/04/09
  Erito-ttl-outcomment-selection, rito-ttl-outcomment-selection
    ǉB

  [Version 0.2] 2001/11/22
  Elisp-mode x[XAini-mode x[XɕύXB

  [Version 0.1]
  Elispmode.l ̃RgFtgp邽߂ɁAĂB


CZX

  ttl-mode.l MITCZXɊÂėp\łB
  <http://www.opensource.org/licenses/mit-license.php>

Copyright (c) 2001-2007 HIE Masahiro

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

|#

(provide "ttl-mode")

(in-package "editor")

(export '(ttl-mode
	  ttl-show-winhelp
	  ttl-run-script
	  ttl-completion
	  ttl-encomment-selection-or-comment-toggle-line
	  ttl-outcomment-selection
	  *ttl-mode-hook*
	  *ttl-mode-map*
	  *ttl-keyword-file*
	  *ttl-prog*
	  ))

(defconstant *ttl-mode-version* "1.07.1")

;; XNvgsɃt@Cۑ
(defvar *ttl-auto-save* t)

(defun ttl-path ()
  "WXg Tera Term ̃pX擾"
  (let ((dat (read-registry "SOFTWARE\\Classes\\TTL_auto_file\\shell\\open\\command"
			    "" :local-machine)))
    (if dat (directory-namestring dat)
      "C:/Program Files/TTERMPRO/")))

;; Tera Term ̃CXg[fBNg
(defvar *ttl-path* (ttl-path))

;; ttpmacro.exe ̃tpX
(defvar *ttl-prog* (merge-pathnames "ttpmacro.exe" *ttl-path*))

;; wvt@C̃tpX
(defvar *ttl-winhelp-path* (merge-pathnames "macroj.hlp" *ttl-path*))

;; startup message
(defvar *ttl-startup-message* t)

(defvar *ttl-mode-hook* nil)

(defvar *ttl-keyword-hash-table* nil)
(defvar *ttl-keyword-file* "TTL")
(defvar *ttl-completion-list* nil)

(defvar *ttl-mode-map* nil)
(unless *ttl-mode-map*
  (setq *ttl-mode-map* (make-sparse-keymap))
  (define-key *ttl-mode-map*   #\F1       'ttl-show-winhelp)
  (define-key *ttl-mode-map*   #\TAB      'ttl-indent-line)
  (define-key *ttl-mode-map*   #\RET      'ttl-newline-and-indent)
  (define-key *ttl-mode-map*   #\C-.      'ttl-completion)
  (define-key *ttl-mode-map*   #\C-\;     'ttl-encomment-selection-or-comment-toggle-line)
  (define-key *ttl-mode-map*   #\M-\C-\;  'ttl-outcomment-selection)
  (define-key *ttl-mode-map* '(#\C-c #\x) 'ttl-run-script)
  (define-key *ttl-mode-map* '(#\C-c #\?) 'ttl-mode-version))

(defvar *ttl-mode-abbrev-table* nil)
(unless *ttl-mode-abbrev-table*
  (define-abbrev-table '*ttl-mode-abbrev-table*))

(defvar *ttl-mode-syntax-table* nil)
(unless *ttl-mode-syntax-table*
  (setq *ttl-mode-syntax-table* (make-syntax-table))
  (set-syntax-start-comment *ttl-mode-syntax-table* #\; t)
  (set-syntax-end-comment *ttl-mode-syntax-table* #\LFD t t)
  (set-syntax-string *ttl-mode-syntax-table* #\")
  (set-syntax-string *ttl-mode-syntax-table* #\'))

(defun ttl-mode ()
  (interactive)
  (kill-all-local-variables)
  (if *ttl-startup-message*
      (message "Tera Term Language mode ~A for xyzzy."
	       *ttl-mode-version*))
  (setq buffer-mode 'ttl-mode)
  (setq mode-name "TTL")
  (use-keymap *ttl-mode-map*)
  (use-syntax-table *ttl-mode-syntax-table*)
  (and *ttl-keyword-file*
       (null *ttl-keyword-hash-table*)
       (setq *ttl-keyword-hash-table*
	     (load-keyword-file *ttl-keyword-file* t)))
  (when *ttl-keyword-hash-table*
    (make-local-variable 'keyword-hash-table)
    (setq keyword-hash-table *ttl-keyword-hash-table*))
  (setq *local-abbrev-table* *ttl-mode-abbrev-table*)
  (ttl-menu-update)
  (run-hooks '*ttl-mode-hook*))

(defun ttl-newline-and-indent (&optional (arg 1))
  "s{Cfg"
  (interactive "*p")
  (insert #\LFD arg)
  (ttl-indent-line))

(defun ttl-indent-line ()
  "݂̍s̃Cfgt"
  (interactive "*")
  (if (save-excursion
        (skip-chars-backward " \t")
        (bolp))
      (let ((column 0))
        (save-excursion
          (while (forward-line -1)
            (unless (progn
                      (skip-chars-forward " \t")
                      (eolp))
              (skip-chars-forward " \t")
              (setq column (current-column))
              (return))))
        (smart-indentation column)
        (skip-chars-forward " \t"))
    (insert "\t")))

(defun ttl-completion ()
  "L[[h⊮"
  (interactive)
  (or *ttl-completion-list*
      (setq *ttl-completion-list* (make-list-from-keyword-table *ttl-keyword-hash-table*))
      (return-from ttl-completion nil))
  (let ((opoint (point)))
    (when (skip-syntax-spec-backward "w_.")
      (let ((from (point)))
	(goto-char opoint)
	(do-completion from opoint :list *ttl-completion-list*)))))

(defun ttl-encomment-selection-or-comment-toggle-line ()
  "Rg}܂̓gO"
  (interactive)
  (if (pre-selection-p)
      ;ZNV΁AI͈͂̍sɃRg}
    (let ((from (selection-mark))
	  (to (selection-point)))
      (if (> from to)
	  (rotatef from to))
      (save-excursion
	(save-restriction
	  (narrow-to-region from to)
	  (goto-char from)
	  (insert ";")
	  (while (forward-line 1)
	    (insert ";")))))
    ;ZNVȂ΁ARggO
    (save-excursion
      (let (bol eol)
	(goto-eol)
	(setq eol (point))
	(goto-bol)
	(setq bol (point))
	(if (string-match "^[ \t]*\\;+"
			  (buffer-substring bol eol))
	    (delete-region (+ bol (match-beginning 0)) (+ bol (match-end 0)))
	  (insert ";"))))))

(defun ttl-outcomment-selection ()
  "I͈͂̍sRg폜"
  (interactive)
  (or (pre-selection-p)
      (error "selectionȂB"))
  (let ((from (selection-mark))
        (to (selection-point)))
    (if (> from to)
        (rotatef from to))
    (save-excursion
      (save-restriction
        (narrow-to-region from to)
        (goto-char from)
	(replace-buffer (concat "^" ";") "" :regexp t)))))

(defun ttl-run-script (&optional arg)
  "XNvg摖"
  (interactive "sParameters: ")
  (if (file-exist-p *ttl-prog*)
      (progn
	(if (and (buffer-modified-p) *ttl-auto-save*)
	    (save-buffer-dialog))
	(if (not (buffer-modified-p))
	      (call-process (concat *ttl-prog* " \""
				    (map-slash-to-backslash (get-buffer-file-name)) "\" " arg)
			    :wait nil)
	  (message "ۑĂȂB")))
    (message (concat *ttl-prog* " ݂ȂB"))))

(defun ttl-show-winhelp ()
  "wv̌"
  (interactive)
  (run-winhelp *ttl-winhelp-path*
	       (let ((topic (get-winhelp-topic)))
		 (and (not (equal topic "")) topic))))

(defun teraterm-home ()
  (interactive)
  (shell-execute "http://hp.vector.co.jp/authors/VA002416/teraterm.html" t))

(defun ttl-mode-version ()
  (interactive)
  (message-box (concat "ttl-mode.l version " *ttl-mode-version*)))


;; Menu

(defvar *ttl-menu-name*  "TTL(&T)")

(defun ttl-menu-update ()
  (interactive)
  (use-local-menu (ttl-add-menu)))

(defun ttl-add-menu ()
  (let ((menu (copy-menu-items *app-menu* (create-menu))))
    (insert-popup-menu menu (get-menu-position menu 'help)
                       *ttl-menu-default*
                       *ttl-menu-name*)
    menu))

(defvar *ttl-menu-default* nil)
(unless *ttl-menu-default*
  (setq *ttl-menu-default*
        (let ((menu (create-popup-menu nil)))
          (add-menu-item menu nil "wv(&H)"     'ttl-show-winhelp)
          (add-menu-item menu nil "XNvgs(&X)" 'ttl-run-script)
	  	  (add-menu-separator menu)
	  (add-menu-item menu nil "L[[h⊮(&K)"     'ttl-completion)
	  (add-menu-item menu nil "Rg}܂̓gO(&R)"
			 'ttl-encomment-selection-or-comment-toggle-line)
	  (add-menu-item menu nil "Rg폜(&D)" 'ttl-outcomment-selection)
	  (add-menu-separator menu)
	  ;(add-menu-item menu nil "Tera Term Home Page(&W)" 'teraterm-home)
          (add-menu-item menu nil "o[W(&V)"      'ttl-mode-version)
          menu)))


;;; ttl-mode.l ends here.
