;;; -*- Mode: Lisp; Last modified: <2007/12/31 01:12:59> -*-
;;;
;;; This file is not part of xyzzy.
;;;
;;;   rv-region.l --- [W𔽓]\
;;;
;;;     by HIE Masahiro <madoinu@ybb.ne.jp>
#|

Tv

  [W𔽓]\BāAȂɉB
  ΁A[W̍쐬ƓɃZNV쐬B


CXg[

  1. rv-region.l  ~/site-lisp ɃRs[B

  2. KvȂ΃oCgRpCB

       M-x byte-compile-file

  3. .xyzzy  siteinit.l Ɉȉ̋LqǉB

      (require "rv-region")


g

  [W̔]Jn邽߂ɁAûPv܂́ûQv̐ݒ
  sB

  [WAZNVA`A}EX֌W̃R}hsƁA
  ]\B

  Iɔ]\~߂ꍇ́AC-g B

  ]\F́AujZ]FvŐݒ肳ꂽ́BC[ʐݒ
  ][\][Ɣ]]Ƀ`FbNĂƁAujZ]Fv
  ͎gpȂ悤łB


  ̂P

  ]\JnpR}hŝ݁A]\JnBȉ̐ݒ
  ł́AC-@ Ń}[Nݒ肷ƁA[W̔]\JnB
  ̑̃R}hŃ}[Nݒ肵ꍇ́A]\ȂB

    (global-set-key #\C-@ 'rv-set-mark-command)

  ̐ݒł́A]\JnA]\܂ł̊Ԃ̂݁A
  ]\pR}hA*post-command-hook* ɐݒ肳ĂB

  *post-command-hook* ւ̐ݒR}hixyzzy ւׂ̕jAɗ
  炵ɂ́A̕ǂB


  ̂Q

  }[NZbg͕K]\JnBȉ̐ݒƁA
  *rv-start-command-list* ɓo^ꂽR}hsA[W
  ̔]\JnB

    (setq *rv-region-stay-on* t)

  ̐ݒł́A펞A]\JnpR}hA*post-command-hook*
  ɐݒ肳ĂB

  ]\ҋ@̒~/JńAM-x rv-toggle-watch B


ݒ

  E[W̍쐬ƓɃZNV쐬A]\̓ZN
    VɔCB

      (setq *rv-region-use-selection* t)

  E]~߂R}hsÃR}hs܂Ŕ]\
    B

      (setq *rv-region-keep-reverse* t)

  E]\JnR}hǉBiûQv̏ꍇɗLj

      (pushnew 'command *rv-start-command-list*)

  E]\~߂R}hǉB

      (setq *rv-exit-command-list* (list 'command1 'command2))

  E]\𑱂R}hǉB

      (setq *rv-continue-command-list* (list 'command1 'command2))

  E]ĂȂ[Wɑ΂]JnB(M-R)

      (global-set-key #\M-R 'rv-restart)

  E]ĂȂ[WꎞIɔ]B(M-V)

      (global-set-key #\M-V 'rv-check)


XV

  [Version 2.04] 2007-12-31 ()
  ECZX(MITCZX)LځB

  [Version 2.03.2] 2004/04/09
  E*rv-exit-command-regexp* ɁCregister ǉB

  [Version 2.03.1] 2003/04/19
  E*rv-exit-command-regexp* ɁAtabify ǉB

  [Version 2.03] 2003/01/28
  Erv-restart ̒ǉя炩łyȂ邱Ƃ
    rv-region-command Ă݂B
  E*rv-exit-command-regexp* ɂ炩ǉB
  Erv-region-toggle-watch  rv-toggle-watch ɕύXB
  Erv-region-check  rv-check ɕύXB
  Eugv́ûPvƁûQvւAûPvXX
    ƂB

  [Version 2.02.1] 2003/01/26
  E2.02 ŏCłĂȂ̂CB
    킾񂪏ڂĂĂ̂ɁDDDB;(;_;);

  [Version 2.02] 2003/01/26 ()
  E*rv-region-use-selection*  t ɂĂƁAset-mark-command
    ł]\iZNVjJnȂ̂CB

  [Version 2.01] 2003/01/26 ()
  E킾̂QlɁA[W̍쐬ƓɃZNV
    쐬A]\̓ZNVɔCƂł悤ɂB
  Erv-region-start, rv-region-stop  interactive łȂB

  [Version 2.00] 2003/01/22 ()
  ETKI ̂QlɁA}[Nݒ肷R}h̎s҂ă[
    W̔]\Jn邱Ƃł悤ɂB
  E]~߂R}hsÃR}hs܂Ŕ]\
    邱Ƃł悤ɂB
  E`sɂA]\悤ɂB
  Ȇ낢B

  [Version 1.02] 2003/01/18 (y) 
  EIR}hSėLȂŁÂŔf悤ɂB
  E*rv-continue-command-list* ǉB

  [Version 1.01] 2003/01/18 (y) 
  Erv-quit 폜B

  [Version 1.00] 2003/01/17 ()
  EB


CZX

  rv-region.l MITCZXɊÂėp\łB
  <http://www.opensource.org/licenses/mit-license.php>

Copyright (c) 2003-2007 HIE Masahiro

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
|#

(provide "rv-region")

;;;  ;;;
;;;   ϐݒ
;;;  ;;;

(defvar *rv-region-stay-on* nil
  "rv-region: }[NZbg͏ɔ]\Jn")

(defvar *rv-region-keep-reverse* nil
  "rv-region: ̃R}hs܂Ŕ]\𑱂")

(defvar *rv-region-use-selection* nil
  "rv-region: [WƃZNV𓯎ɍ쐬")

(defvar *rv-start-command-list*
  (list 'set-mark-command 'mark-paragraph 'mark-page 'mark-defun
	'mark-sexp 'mark-word 'mark-whole-buffer 'rv-restart)
  "rv-region: ]\JnR}h̃Xg")

(defvar *rv-exit-command-list* nil
  "rv-region: ]\~߂R}h̃Xg")

(defvar *rv-continue-command-list* nil
  "rv-region: ]\𑱂R}h̃Xg")

(defvar *rv-exit-command-regexp*
  (compile-regexp (concat
		   "\\(quit\\|self-insert-command"
		   "\\|.*\\(region\\|selection\\|rectangle\\|mouse\\|newline\\|indent\\|tabify\\|register\\).*\\)"))
  "rv-region: ]\~߂R}h\K\")


;;;  ;;;
;;;   [W]\p֐
;;;  ;;;

(defun rv-region ()
  (let ((com (if *rv-region-keep-reverse* *last-command* *this-command*)))
    (if (and (not (member com *rv-continue-command-list*))
	     (or (member com *rv-exit-command-list*)
		 (string-match *rv-exit-command-regexp* (format nil "~S" com))))
	(rv-region-stop)
      (let ((m (mark t)))
	(and m (rv-region-command m com))))))

(defun rv-region-command (m com)
  (let ((p (point)))
    (if *rv-region-use-selection*
	(if (member com (remove 'set-mark-command *rv-start-command-list*))
	    (save-excursion
	      (save-restriction
		(narrow-to-region m p)
		(if (> m p)
		    (progn
		      (goto-char (point-max))
		      (selection-beginning-of-buffer))
		  (progn
		    (goto-char (point-min))
		    (selection-end-of-buffer)))))
	  (ed::begin-selection))
      (reverse-region m p t))))

(defun rv-region-watch ()
  (let ((m (mark t))
	(com *this-command*))
    (when (and m (member com *rv-start-command-list*))
      (rv-region-start)
      (rv-region-command m com))))

(defun rv-region-start ()
  (stop-selection)
  (add-hook '*post-command-hook* 'rv-region))

(defun rv-region-stop ()
  (delete-hook '*post-command-hook* 'rv-region))


;;;  ;;;
;;;   ΘbIȊ֐
;;;  ;;;

(defun rv-set-mark-command ()
  "rv-region: }[Nt[W]\Jn"
  (interactive)
  (set-mark-command)
  (rv-region-start))

(defun rv-restart ()
  "rv-region: [W]\Jn"
  (interactive)
  (rv-region-start))

(defun rv-check ()
  "rv-region: ]ĂȂ[WꎞIɔ]\"
  (interactive)
  (let ((m (mark t)))
    (and m (reverse-region m (point) t))))

(defun rv-toggle-watch ()
  "rv-region: }[NZbgɔ]\̃gO"
  (interactive)
  (if *rv-region-stay-on*
      (progn
	(delete-hook '*post-command-hook* 'rv-region-watch)
	(setq *rv-region-stay-on* nil)
	(message "rv-region: off"))
    (progn
      (add-hook '*post-command-hook* 'rv-region-watch)
      (setq *rv-region-stay-on* t)
      (message "rv-region: on"))))


;;;  ;;;
;;;   N
;;;  ;;;

(add-hook '*post-startup-hook*
	  #'(lambda ()
	      (when *rv-region-stay-on*
		(add-hook '*post-command-hook* 'rv-region-watch))))


;;; rv-region.l ends here.
