; -*- Mode: Lisp; Package: editor -*-

#|
= properties-mode - Java  properties t@CҏW肷

* Author:  miyamuko ((<URL:mailto:miyamuko (at) mtb.biglobe.ne.jp>))
* URL: ((<URL:http://miyamuko.s56.xrea.com/xyzzy/properties-mode.html>))
* Version: $Id: properties-mode.l,v 1.12 2004/08/09 14:03:17 miyamuko Exp $


== 

Java  properties t@CҏW邽߂̃W[[hłB

* [h (({native2ascii -reverse})) Ɏs
* ۑ ((%native2ascii%)) Ɏs
* KȃCfg
* KȐFÂ
* ÕL[Rs[ł
* J̎


== CXg[

((<NetInstaller|URL:http://www.mirai.ne.jp/~gyo/xyzzy/ni.html>)) ŃCXg[ꍇ 3 ȍ~A
NetInstaller + (({ni-autoload})) gĂl 4 ȍ~ OK łB

(1) A[JCu_E[h܂B

    ((<URL:http://miyamuko.s56.xrea.com/xyzzy/archives/properties-mode.zip>))

(2) A[JCuWJāA$XYZZY/site-lisp zɃt@CRs[܂B

(3) gq properties ̃t@CJƂɎI properties-mode ɂȂ悤
    ~/.xyzzy ܂ $XYZZY/site-lisp/siteinit.l Ɉȉ̃R[hǉ܂B

        ;; properties-mode
        (load-library "properties-mode")
        (pushnew '("\\.properties$" . properties-mode) *auto-mode-alist* :test 'equal)

(4) ݒ𔽉fɂ xyzzy ċNĂB

    siteinit.l ɋLqꍇɂ͍ă_vKvłB


== t@X

=== L[蓖

: ((%TAB%))
    CfgB

    * psȂ value ̊JnƃCfg낦܂B
    * vpeBp镶ȂꍇAʏCfg܂B

    vpeB𕡐sɂ킽ďꍇ͎̂悤ɒl̐擪낦悤
    Cfg܂B

        font = family1 family2 family3 family4 \
               - size1 size2 size3 size4 size5 \
               - bold italic underline

    key ̒ŉsꍇ͎̂悤ɃCfg܂B
    ((({*properties-indent-level*}))  2 ̏ꍇ)

        fontLabel=\
          Font

: ((%RET%))
    s{CfgtB

: ((%C-M-\%))
    ÕL[Rs[B

    AĎsƂ̂ڂăL[Rs[Ă܂B

: ((%C-c n%))
    [W ((%native2ascii -reverse%)) ܂B

: ((%C-c a%))
    [W ((%native2ascii%)) ܂B

: ((%C-c C-a%))
    [W̃vpeB̃J낦B

    * before

          a.b=      c
          a b
          a.b.c: d

    * after

          a.b   =     c
          a           b
          a.b.c :     d

: ((%C-c C-o%))
    [W̃Zp[^̗]vȋ󔒂܂B

    * before

          a.b  = c
          a      b

    * after

          a.b=c
          a b

: ((%C-c C-c%))
    [WRgAEg܂B

: ((%C-c C-u%))
    [WRg܂B

: ((%C-/%))
    ݍs̃RgERg؂ւ܂B

: ((%C-c C-s C-v%))
    obt@Ŝ csv ɕϊ܂B

    ((<csv-mode|URL:http://members.tripod.co.jp/ohkubo/xyzzy/#csv-mode>))
    CXg[Ă (({*properties-auto-csv-mode*})) 
    ((|non-nil|)) ̏ꍇAϊ㎩I csv-mode s܂B

=== ϐ

--- *properties-indent-level*
    ps̃Cfgݒ肵܂B
    ftHgl 2 łB

      properties.key = \
      ____properties.value

    :

      ;; Cfg 4 ɂ
      (setq *properties-indent-level* 4)

--- *properties-n2a-buffer-name*
    native2ascii ʂ̃obt@łB

--- *properties-auto-csv-mode*
    (({properties-convert-to-csv})) sƂɎI
    csv-mode ɂ邩ǂ̃tOłB

    ((|non-nil|))  csv-mode CXg[ĂꍇA
    I csv-mode ɂ܂B

    ftHg t łB

--- *properties-auto-native2ascii*
    I native2ascii s邩ǂ̃tOłB

    ((|non-nil|)) Ȃ玩IɃ[hEۑ native2ascii ܂B

    ftHg t łB


== ֘A邩Ȃy[W

: java.util.properties#load
    ((<URL:http://java.sun.com/j2se/1.4/ja/docs/ja/api/java/util/Properties.html#load(java.io.InputStream)>))

== CZX

properties-mode ͏C BSD CZXɊÂėp\łB

  Copyright (C) 2003-2004 MIYAMUKO Katsuyuki. All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are
  met:

  1 Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer as the first lines
  of this file unmodified.

  2 Redistributions in binary form must reproduce the above copyright
  notice, this list of conditions and the following disclaimer in the
  documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
  SUCH DAMAGE.
|#


(provide "properties-mode")
(in-package "editor")
(export '(*properties-mode-hook*
          *properties-mode-map*
          *properties-comment-column*
          *properties-indent-level*
          *properties-n2a-buffer-name*
          *properties-auto-csv-mode*
          *properties-auto-native2ascii*
          properties-toggle-auto-n2a
          properties-completion
          properties-adjust-property
          properties-optimize-property
          properties-comment-toggle-line
          properties-comment-region
          properties-uncomment-region
          properties-convert-to-csv
          properties-mode))

; tbN
(defvar *properties-mode-hook* nil
  "properties-mode: tbNϐ")

; configuration
(defvar *properties-comment-column* nil
  "properties-mode: comment ̂Ȃɂ")
(defvar *properties-indent-level* 2
  "properties-mode: value Ȃꍇ̌ps̃Cfgx
   key = \\
   __<- hear!")
(defvar *properties-n2a-buffer-name* "*native2ascii*"
  "native2ascii Ƃ̃obt@")
(defvar *properties-auto-csv-mode* t
  "non-nil: properties-convert-to-csv ƂɎI csv-mode ɂB")
(defvar *properties-auto-native2ascii* t
  "non-nil: ǂݍ݁Eۑ native2ascii IB
nil: ǂݍ݁EۑɂȂɂȂB")

;; ----------------------------------------------------------------------
;; regex pattern

(defvar *properties-escaped-char-pattern*
  "\\\\\\(?:.\\|\n\\)"
  "properties-mode: escape ̃p^[B
sGXP[vꍇs̍s̋󔒂͖B")

(defvar *properties-key-pattern*
  (concat "\\("
          "\\(?:" "[^#!:= \t\r\n\\]" "\\|" *properties-escaped-char-pattern* "\\)"
          "\\(?:" "[^:= \t\r\n\\]" "\\|" *properties-escaped-char-pattern* "\\)*"
          "\\)")
  "properties-mode: key ̃p^[, $1 = key")

(defvar *properties-separator-pattern*
  "\\([ \t]*[:=][ \t]*\\|[ \t]+\\)"
  "properties-mode: separator ̃p^[, $1 = separator")

(defvar *properties-value-pattern*
  (concat "\\("
          "\\(?:" "[^\r\n\\]" "\\|" *properties-escaped-char-pattern* "\\)+"
          "\\)")
  "properties-mode: value ̃p^[, $1 = value")

(defvar *properties-pattern*
  (concat "^[ \t]*" *properties-key-pattern*
          "\\(?:"
          *properties-separator-pattern*
          *properties-value-pattern*
          "\\)?")
  "properties-mode: key = value ̃p^[, $1 = key, $2 = separator, $3 = value")

;; ----------------------------------------------------------------------
;; keyword
(defvar *properties-key-color* '(:keyword 0)
  "properties-mode: key ̐F")

(defvar *properties-regexp-keyword-list* nil
  "properties-mode: K\L[[hXg")

(setq *properties-regexp-keyword-list*
  (compile-regexp-keyword-list
   `(
     ; P̂ߍsɋ󔒂L[͖
     (,(concat "^" *properties-key-pattern*) t ((1 . ,*properties-key-color*)))
     )))

;; ----------------------------------------------------------------------
;; V^bNXe[u
(defvar *properties-mode-syntax-table* nil)
(unless *properties-mode-syntax-table*
  (setq *properties-mode-syntax-table* (make-syntax-table))
  (do ((x #x21 (1+ x))) ((>= x #x7f))
    (let ((c (code-char x)))
      (unless (alphanumericp c)
        (set-syntax-punctuation *properties-mode-syntax-table* c))))
  ; ȉmodeɍ킹Đݒ
  (set-syntax-escape *properties-mode-syntax-table* #\\)
  (set-syntax-start-comment *properties-mode-syntax-table* #\#)
  (set-syntax-start-comment *properties-mode-syntax-table* #\!)
  (set-syntax-end-comment *properties-mode-syntax-table* #\LFD))

; L[}bv
(defvar *properties-mode-map* nil)
(unless *properties-mode-map*
  (setq *properties-mode-map* (make-sparse-keymap))
  ; ȉL[
  (define-key *properties-mode-map* #\C-h 'backward-delete-char-untabify-or-selection)
  (define-key *properties-mode-map* #\TAB 'properties-indent-line)
  (define-key *properties-mode-map* #\C-M-q 'indent-sexp)
  (define-key *properties-mode-map* #\C-M-\, 'properties-copy-key)
  (define-key *properties-mode-map* #\RET 'properties-newline-and-indent)
  (define-key *properties-mode-map* '(#\C-c #\n) 'properties-ascii-to-native-region)
  (define-key *properties-mode-map* '(#\C-c #\a) 'properties-native-to-ascii-region)
  (define-key *properties-mode-map* '(#\C-c #\C-a) 'properties-adjust-property)
  (define-key *properties-mode-map* '(#\C-c #\C-o) 'properties-optimize-property)
  (define-key *properties-mode-map* '(#\C-c #\C-c) 'properties-comment-region)
  (define-key *properties-mode-map* '(#\C-c #\C-u) 'properties-uncomment-region)
  (define-key *properties-mode-map* '(#\C-c #\C-s #\C-v) 'properties-convert-to-csv)
  (define-key *properties-mode-map* '(#\C-/) 'properties-comment-toggle-line)
  )

;; ----------------------------------------------------------------------
;; ǂݍݎA[h narive2ascii s
(defvar *properties-n2a-buffer* nil)
(defun properties-ascii-to-native-region (start end)
  (interactive "*r")
  (filter-region "native2ascii.exe -reverse" start end))

(defun properties-native-to-ascii-region (start end)
  (interactive "*r")
  (filter-region "native2ascii.exe" start end))

(defun properties-contain-multibyte-char-p ()
  "RgȊOɃ}`oCg܂܂Ă t"
  (save-excursion
    (beginning-of-buffer)
    (while (scan-buffer "[^\x00-\x7f]" :regexp t :tail t)
      (unless (eq (parse-point-syntax) :comment)
        (return-from properties-contain-multibyte-char-p t)))
    nil))

(defun properties-contain-unicode-char-p ()
  "Unicode (\uxxxx) ܂܂Ă t"
  (save-excursion
    (beginning-of-buffer)
    (scan-buffer "\\u[a-fA-F0-9]\\{4\\}" :regexp t)))

(defun properties-on-load ()
  "t@CǂݍݎɌĂяoB
   }`oCg܂܂ĂȂꍇ ascii2native ăobt@̍XVC"
  (when (and (not (properties-contain-multibyte-char-p))
             (properties-contain-unicode-char-p)
             *properties-auto-native2ascii*)
    (message "ascii2native")
    (properties-ascii-to-native-region (point-min) (point-max))
    (update-visited-file-modtime)
    (set-buffer-modified-p nil)))

(defun properties-save-buffer ()
  "native2ascii ĕۑ"
  (interactive "*")
  (if (or (not (properties-contain-multibyte-char-p))
          (not *properties-auto-native2ascii*))
      (return-from properties-save-buffer nil))

  (let ((current-buffer (selected-buffer))
        (content (properties-get-buffer-content))
        (filename (get-buffer-file-name)))

    (set-buffer (properties-n2a-buffer))
    (properties-set-buffer-content content)
    (properties-native-to-ascii-region (point-min) (point-max))

    (write-file filename)

    (set-buffer current-buffer)
    (update-visited-file-modtime)
    (set-buffer-modified-p nil)
    t))

(defun properties-set-buffer-content (content)
  "current buffer ̓eu"
  (save-restriction
    (widen)
    (erase-buffer (selected-buffer))
    (insert content)))

(defun properties-get-buffer-content ()
  "current buffer ̑Se擾"
  (save-restriction
    (widen)
    (buffer-substring (point-min) (point-max))))

(defun properties-n2a-buffer ()
  "properties-mode: n2a obt@̎擾"
  (unless (and *properties-n2a-buffer*
               (find-buffer *properties-n2a-buffer-name*))
    (when (setq *properties-n2a-buffer*
                (switch-to-buffer *properties-n2a-buffer-name*))
      (make-local-variable 'kept-undo-information)
      (setq kept-undo-information nil)
      (make-local-variable 'need-not-save)
      (setq need-not-save t)))
  *properties-n2a-buffer*)

(defun properties-toggle-auto-n2a ()
  (interactive)
  (setf *properties-auto-native2ascii*
        (not *properties-auto-native2ascii*))
  (message "auto native2ascii: ~A" *properties-auto-native2ascii*))

;; ----------------------------------------------------------------------
;; ÕL[Rs[
;;   AăR}hsꍇ̂ڂăRs[
(defvar-local *properties-copy-last-line* nil)
(defvar-local *properties-copy-dst-point* nil)
(defun properties-copy-key ()
  "properties-mode: ÕL[Rs["
  (interactive "*")
  (let ((key nil))
    (save-excursion
      (cond
       ;; ̃R}hAĎsĂ
       ((and (eq *last-command* 'properties-copy-key)
             (integerp *properties-copy-last-line*))
        (goto-line *properties-copy-last-line*)
        (clear-undo-boundary))

       ;; s
       (t
        (setf *properties-copy-dst-point* (point))))

      (when (and (properties-previous-line)
                 (scan-buffer *properties-pattern* :regexp t))
        (setf key (match-string 1))
        (setf *properties-copy-last-line* (current-line-number))))

    (unless key
      (message "ȂłB")
      (return-from properties-copy-key))

    (delete-region *properties-copy-dst-point* (point))
    (insert key)))

;; ----------------------------------------------------------------------
;; [W̃vpeB̃J낦

(defun properties-adjust-property (start end)
  (interactive "*r")
  (if (< end start) (rotatef start end))

  (let ((key-width 0) (sep-width 0)
        (key nil) (sep nil) (value nil))
    (save-excursion
      (save-restriction
        (narrow-to-region start end)

        ;; CfgĂ
        (indent-region start end)

        ;; Œ̃J擾
        ;;   key  =  value
        ;;   <--->    : key-width
        ;;        <-> : sep-width
        (goto-char (point-min))
        (while (scan-buffer *properties-pattern* :regexp t :tail t)
          (setf key (match-string 1))
          (setf sep (match-string 2))
          (setf value (match-string 3))

          (when (and key sep)
            (when (<= key-width (+ (length key) (or (string-match "[:=]" sep) 0)))
              (setf key-width (+ (length key) (or (string-match "[:=]" sep) 0)))
              (if (string-match "^[:=]" sep) (incf key-width))))
          (when (and sep value)
            (when (<= sep-width (- (length sep) (or (string-match "[:=]" sep) (length sep))))
              (setf sep-width (- (length sep) (or (string-match "[:=]" sep) (length sep))))
              (if (string-match "[:=]$" sep) (incf sep-width))))
          )

        ;; Zp[^󔒕݂̂̏ꍇ sep-width  0 Ȃ̂ 1 ݒ
        (if (zerop sep-width) (setf sep-width 1))

        ;; ŁAɂ킹
        (goto-char (point-min))
        (while (scan-buffer *properties-pattern* :regexp t :tail t)
          (setf key (match-string 1))
          (setf sep (string-trim " \t\r\f\n" (match-string 2)))
          (setf value (match-string 3))

          (when (and key sep value)
            (delete-region (match-beginning 0) (match-end 0))
            (insert (format nil
                            (format nil "~~~D@A~~~D@A~~A" key-width sep-width)
                            key sep value))))

        ;; CfgĂ
        (indent-region (point-min) (point-max))
        ))))

;; ----------------------------------------------------------------------
;; [W̃Zp[^̋󔒂폜

(defun properties-optimize-property (start end)
  (interactive "*r")
  (if (< end start) (rotatef start end))

  (save-excursion
    (save-restriction
      (narrow-to-region start end)

      (goto-char (point-min))
      (while (scan-buffer *properties-pattern* :regexp t :tail t)
        (let ((key (match-string 1))
              (sep (match-string 2))
              (val (match-string 3)))
          (when (and key sep)
            (delete-region (match-beginning 0) (match-end 0))
            (insert (format nil "~A~A~A"
                            key
                            (funcall #'(lambda (str) (if (equal str "") " " str))
                                     (string-trim " \t\r\f\n" sep))
                            (or val "")))))))
    ;; CfgĂ
    (indent-region start end)
    ))

;; ----------------------------------------------------------------------
;; }[Ns猻ݍs܂ł csv ɕϊ
(defvar *properties-buffer-convert* "*Properties Convert*")
(defun properties-convert-to-csv ()
  (interactive)

  (let ((in-buffer (selected-buffer)))
    (save-excursion
      (with-output-to-temp-buffer (*properties-buffer-convert*)
        (set-buffer in-buffer)
        (goto-char (point-min))
        (while (scan-buffer *properties-pattern* :regexp t :tail t)
          (let ((key (match-string 1))
                (val (match-string 3)))
            (when (and key val)
              (format t "~A,~A~%"
                      (properties-escape-csv (properties-unescape-property key))
                      (properties-escape-csv (properties-unescape-property val))))
            ))
        ))

    ;; csv-mode ɂ
    (when (and *properties-auto-csv-mode*
               (find-load-path "csv-mode"))
      (set-buffer *properties-buffer-convert*)
      (require "csv-mode")
      (csv-mode))))

;; \ " '  ! # : = ̓GXP[vď܂ĂB
;; CR LF TAB GXP[v邯ǂ͌ɖ߂ȂB
(defun properties-unescape-property (str)
  (setf str (substitute-string str "\\\\\n[ \t]*" ""))
  (setf str (string-trim "[ \t\r\f\n]" str))
  (setf str (substitute-string str "\\\\\\([\"\\' !#:=]\\)" "\\1")))

(defun properties-escape-csv (str)
  (setf str (substitute-string str "\"" "\"\""))
  (if (string-match "[\n\r\",]" str)
      (concat "\"" str "\"")
    str))

;; ----------------------------------------------------------------------
;; s̃RggO

(defun properties-comment-toggle-line ()
  "properties-mode: s̃RggO"
  (interactive "*")
  (save-excursion
    (let ((start (progn (goto-bol) (point)))
          (end (progn (goto-eol) (point))))
      (if (properties-comment-line)
          (properties-uncomment-region start end)
        (properties-comment-region start end)))))

;; ----------------------------------------------------------------------
;; [WRgAEg

(defun properties-comment-region (start end)
  "properties-mode: [WRg"
  (interactive "*r")
  (if (< end start) (rotatef start end))

  (save-excursion
    (save-restriction
      (narrow-to-region (progn (goto-char end) (goto-eol) (point))
                        (progn (goto-char start) (goto-bol) (point)))
      (loop
        (goto-bol)
        (insert comment-start)
        (goto-eol)
        (insert comment-end)
        (unless (forward-line 1) (return)))
      )))

;; ----------------------------------------------------------------------
;; [WRg

(defun properties-uncomment-region (start end)
  "properties-mode: [WRg"
  (interactive "*r")
  (if (< end start) (rotatef start end))

  (save-excursion
    (save-restriction
      (narrow-to-region (progn (goto-char end) (goto-eol) (point))
                        (progn (goto-char start) (goto-bol) (point)))
      (loop
        (goto-bol)
        (if (scan-buffer comment-start :regexp t)
            (delete-region (match-beginning 0) (match-end 0)))
        (goto-eol)
        (if (scan-buffer comment-end :regexp t :reverse t)
            (delete-region (match-beginning 0) (match-end 0)))
        (unless (forward-line 1) (return)))
      )))

;; ----------------------------------------------------------------------

(defun properties-electric-insert (&optional (arg 1))
  (interactive "*p")
  (self-insert-command arg)
  (properties-indent-line))

(defun properties-newline-and-indent (&optional (arg 1))
  (interactive "*p")
  (insert #\LFD arg)
  (properties-indent-line))

;; indent
(defun properties-indent-line ()
  (interactive "*")
  (let ((column (calc-properties-indent)))
    (when (integerp column)
      (smart-indentation column)))
  t)

(defun properties-continued-line ()
  "psǂ"
  (save-excursion
    (if (not (forward-line -1))
        (return-from properties-continued-line nil))
    (let ((limit (progn (goto-eol) (point))))
      (goto-bol)
      (and (scan-buffer "\\(\\\\+\\)[ \t]*$" :regexp t :limit limit)
           (oddp (length (match-string 1)))))))

(defun properties-previous-line ()
  "O̍s܂Ŗ߂"
  (while (forward-line -1)
    (unless (or (properties-space-line)
                (properties-comment-line)
                (properties-continued-line))
      (return-from properties-previous-line t))))

(defun properties-space-line ()
  "sǂ"
  (save-excursion
    (goto-bol)
    (and (not (properties-continued-line))
         (looking-at "[ \t]*$"))))

(defun properties-comment-line ()
  "Rgsǂ"
  (save-excursion
    (goto-bol)
    (looking-at "^[ \t]*[#!]")))

(defun calc-properties-indent ()
  "Cfg鐔𐔂"
  (let ((column 0)
        (continued-line-p (properties-continued-line)))
    (save-excursion
      ; O̍s𒲂ׂ
      (when (properties-previous-line)
        (goto-bol)
        (when continued-line-p
          ;; O̍s value ̃Cfg
          (scan-buffer (concat "^[ \t]*"
                               *properties-key-pattern*
                               "\\(" *properties-separator-pattern* "\\)?")
                       :regexp t :tail t)
          ;; value Ȃ *properties-indent-level*
          (if (looking-at "\\\\$")
              (incf column *properties-indent-level*)
            (setf column (current-column)))
          )))
    column
    ))

;; ----------------------------------------------------------------------
;; key ̈ꗗ: list-function ŕ\
(defun properties-build-summary-of-functions ()
  (let ((result nil))
    (save-excursion
      (goto-char (point-min))
      (while (scan-buffer *properties-pattern* :regexp t :tail t)
        (push (list (current-line-number) (match-string 1)) result)))
    (nreverse result)
    ))

; mode̎s
(defun properties-mode ()
  "properties-mode"
  (interactive)
  (kill-all-local-variables)
  (setq mode-name "Properties")
  (setq buffer-mode 'properties-mode)
  (use-syntax-table *properties-mode-syntax-table*)
  (use-keymap *properties-mode-map*)

  (make-local-variable 'paragraph-start)
  (setq paragraph-start "^$\\|\f")
  (make-local-variable 'paragraph-separate)
  (setq paragraph-separate paragraph-start)

  ; indent
  (make-local-variable 'mode-specific-indent-command)
  (setq mode-specific-indent-command 'properties-indent-line)
  (make-local-variable 'mode-newline-and-indent-command)
  (setq mode-newline-and-indent-command 'properties-newline-and-indent)

  ; list of key
  (make-local-variable 'build-summary-function)
  (setf build-summary-function 'properties-build-summary-of-functions)

  ; keyword
  (make-local-variable 'regexp-keyword-list)
  (setq regexp-keyword-list *properties-regexp-keyword-list*)

  ; comment
  (setq comment-start "# " comment-end "")
  (setq comment-start-skip "[#!]+[ \t]*")
  (setq comment-indent-function 'calc-properties-indent)
  (when *properties-comment-column*
    (setq comment-column *properties-comment-column*))

  (make-variable-buffer-local '*before-save-buffer-hook*)
  (add-hook '*before-save-buffer-hook*
            #'properties-save-buffer)

  ; ascii2native 
  (properties-on-load)

  ; tbN̎s
  (run-hooks '*properties-mode-hook*))
