; -*- Mode: Lisp; Package: editor -*-

#|
= nsis-mode - NSIS t@CҏW肷

* Author:  miyamuko ((<URL:mailto:miyamuko (at) mtb.biglobe.ne.jp>))
* URL: ((<URL:http://miyamuko.s56.xrea.com/xyzzy/nsis-mode.html>))
* Version: $Id: nsis-mode.l,v 1.9 2004/08/09 14:03:15 miyamuko Exp $


== 

NSIS XNvgt@C̕ҏWp[hłB

* KȃCfg
* KȐFÂ
* L[[h̕⊮
* Function  !define ̃^OWv


== CXg[

((<NetInstaller|URL:http://www.mirai.ne.jp/~gyo/xyzzy/ni.html>)) ŃCXg[ꍇ 3 ȍ~A
NetInstaller + (({ni-autoload})) gĂl 4 ȍ~ OK łB

(1) A[JCu_E[h܂B

    ((<URL:http://miyamuko.s56.xrea.com/xyzzy/archives/nsis-mode.zip>))

(2) A[JCuWJāA$XYZZY/site-lisp zɃt@CRs[܂B

(3) gq nsi (NSIS Script File) ܂ nsh (NSIS Header File)
    ̃t@CJƂɎI nsis-mode ɂȂ悤
    ~/.xyzzy ܂ $XYZZY/site-lisp/siteinit.l Ɉȉ̃R[hǉ܂B

        ;; nsis-mode
        (require "nsis-mode")
        (pushnew '("\\.ns[ih]$" . nsis-mode) *auto-mode-alist* :test 'equal)

(4) ݒ𔽉fɂ xyzzy ċNĂB

    siteinit.l ɋLqꍇɂ͍ă_vKvłB


== t@X

=== L[蓖

: ((%TAB%))
    CfgB

    Compiler directive (!defineƂ) ̓Cfg܂B

: ((%RET%))
    s{CfgtB

: ((%M-TAB%))
    L[[hƑgݍ݊֐̕⊮B

    s镶΂̕n܂L[[hc[`bvŕ\܂B
    s镶Ȃ΂ׂẴL[[h\܂B

=== ϐ

--- *nsis-indent-level*
--- *nsis-continued-statement-offset*

Cfgxݒ肵܂B

    ;; Cfg̕(} _ ̕, default=2)
    (setq *nsis-indent-level* 4)

    ;; ps̃ItZbg(} - ̕, default=4)
    (setq *nsis-continued-statement-offset* 4)

    ;; Section "Modern User Interface" SecContribModernUI
    ;; ____SetOutPath "$INSTDIR" \
    ;; ____----"\Examples\Modern UI"
    ;; EndSection


== ꂩ邩Ȃ

* ւȂ傱Ȃ̂ŕu
  * ꂩĂB


== ֘A邩Ȃy[W

: Nullsoft Scriptable Install System // NSIS Developer Site
    ((<URL:http://nsis.sf.net/>))

: NSIS related software - NSIS Archive
    ((<URL:http://nsis.sourceforge.net/archive/nsisweb.php?page=8&instances=0>))


== CZX

nsis-mode ͏C BSD CZXɊÂėp\łB

  Copyright (C) 2003-2004 MIYAMUKO Katsuyuki. All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are
  met:

  1 Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer as the first lines
  of this file unmodified.

  2 Redistributions in binary form must reproduce the above copyright
  notice, this list of conditions and the following disclaimer in the
  documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
  SUCH DAMAGE.
|#


(provide "nsis-mode")
(in-package "editor")
(export '(*nsis-mode-hook*
          *nsis-mode-map*
          *nsis-comment-column*
          *nsis-indent-level*
          *nsis-continued-statement-offset*
          nsis-completion
          nsis-mode))

; tbN
(defvar *nsis-mode-hook* nil
  "nsis-mode: tbNϐ")

; configuration
(defvar *nsis-comment-column* nil)
(defvar *nsis-indent-level* 2
  "CfgœXy[X̐")
(defvar *nsis-continued-statement-offset* 4
  "obNXbVŌps̃Cfg")

; L[[h
(defvar *nsis-completion-list* nil
  "nsis-mode: ⊮Xg̃|bvAbv")

(defvar *nsis-keyword-hash-table* nil)
(defvar *nsis-keyword-file* "NSIS")

;; label color
(defvar *nsis-label-color* '(:keyword 0 :bold)
  "nsis-mode: x̐F")

(defvar *nsis-regexp-keyword-list* nil
  "nsis-mode: K\L[[hXg")

(setq *nsis-regexp-keyword-list*
  (compile-regexp-keyword-list
   `(
     ;; xs
     ("[a-zA-Z0-9_]+:" t ((0 . ,*nsis-label-color*)))
     )))


;; V^bNXe[u
(defvar *nsis-mode-syntax-table* nil)
(unless *nsis-mode-syntax-table*
  (setq *nsis-mode-syntax-table* (make-syntax-table))
  (do ((x #x21 (1+ x))) ((>= x #x7f))
    (let ((c (code-char x)))
      (unless (alphanumericp c)
        (set-syntax-punctuation *nsis-mode-syntax-table* c))))
  ; ȉmodeɍ킹Đݒ
  (set-syntax-word *nsis-mode-syntax-table* #\$)
  (set-syntax-string *nsis-mode-syntax-table* #\")
  (set-syntax-string *nsis-mode-syntax-table* #\')
  (set-syntax-escape *nsis-mode-syntax-table* #\\)
  (set-syntax-symbol *nsis-mode-syntax-table* #\_)
  (set-syntax-symbol *nsis-mode-syntax-table* #\!)
  (set-syntax-symbol *nsis-mode-syntax-table* #\.)
  (set-syntax-start-comment *nsis-mode-syntax-table* #\;)
  (set-syntax-start-comment *nsis-mode-syntax-table* #\#)
  (set-syntax-end-comment *nsis-mode-syntax-table* #\LFD))

;; L[}bv
(defvar *nsis-mode-map* nil)
(unless *nsis-mode-map*
  (setq *nsis-mode-map* (make-sparse-keymap))
  ; ȉL[
  (define-key *nsis-mode-map* #\! 'nsis-electric-insert)
  (define-key *nsis-mode-map* #\C-h 'backward-delete-char-untabify-or-selection)
  (define-key *nsis-mode-map* #\TAB 'nsis-indent-line)
  (define-key *nsis-mode-map* #\C-M-q 'indent-sexp)
  (define-key *nsis-mode-map* #\RET 'nsis-newline-and-indent)
  (define-key *nsis-mode-map* #\M-TAB 'nsis-completion)       ; ⊮
  )


(defun nsis-electric-insert (&optional (arg 1))
  (interactive "*p")
  (self-insert-command arg)
  (nsis-indent-line))

(defun nsis-newline-and-indent (&optional (arg 1))
  (interactive "*p")
  (nsis-indent-line)
  (delete-trailing-spaces)
  (insert #\LFD arg)
  (nsis-indent-line))

(defun nsis-indent-line ()
  (interactive "*")
  (if (or (not (interactive-p))
          *c-tab-always-indent*
          (save-excursion
            (skip-chars-backward " \t")
            (bolp)))
      ; ς
      (let ((column (calc-nsis-indent)))
        (when (integerp column)
          (save-excursion
            (goto-bol)
            (delete-region (point)
                           (progn
                             (skip-chars-forward " \t")
                             (point)))
            (indent-to column)))
        (if (and (bolp) column)
            (skip-chars-forward " \t")))
    (insert "\t"))
  t)

(defun nsis-previous-line ()
  "O̗Lȍs܂Ŗ߂"
  (let ((in-conditional-compilation nil))
    (save-restriction
      (while (forward-line -1)
        (goto-bol)
        (cond
         ;; !else ̒ɂꍇ !ifdef ̑O܂Ŗ߂
         (in-conditional-compilation
          (if (looking-at "[ \t]*!ifn?def")
              (setq in-conditional-compilation nil)))
         ((looking-at "[ \t]*!else")
          (setq in-conditional-compilation t))
         ((not (or (nsis-space-line) (nsis-continued-line) (nsis-compiler-directive)))
          (return-from nsis-previous-line t))
         ))
      )))

(defun nsis-space-line ()
  "sǂ"
  (save-excursion
    (goto-bol)
    (looking-at "[ \t]*$")))

(defun nsis-continued-line ()
  "psǂ"
  (let ((result nil))
    (save-excursion
      (if (equal nil (forward-line -1))
          (return-from nsis-continued-line nil))
      (goto-eol)
      (setq result (looking-back "\\"))
      (forward-line +1)
;      (msgbox "~D is continue? => ~A" (current-line-number) result)
      result
      )))

(defun nsis-compiler-directive ()
  "compiler directive ǂ"
  (save-excursion
    (goto-bol)
    (looking-at "[ \t]*!")))

(defun calc-nsis-indent ()
  "Cfg鐔𐔂BpsȂ + *nsis-continued-statement-offset*"
  (let ((column 0))
    ; compiler directive ̓CfgȂ
    (if (nsis-compiler-directive)
        (return-from calc-nsis-indent 0))

    (save-excursion
      ;O̍s𒲂ׂ
      (when (nsis-previous-line)
        (save-restriction
          (narrow-to-region (progn (goto-eol) (point))
                            (progn (goto-bol) (point)))
          (goto-bol)
          (skip-chars-forward " \t")
          ; Cfg
          (setq column (current-column))
;          (msgbox "base indent(line ~D): ~D" (current-line-number) column)

          ; Ĵ΃Cfg𑝂₷
          (cond
           ((looking-at "\\<\\(Function\\|SubSection\\|Section\\)\\>")
            (incf column *nsis-indent-level*)
;            (msgbox "Function | Section | SubSection ~D" column)
            ))
          )))
    ; ݂̍s𒲂ׂ
    (save-excursion
      (save-restriction
        ; ݍspsȂ *nsis-continued-statement-offset* ₷
        (if (nsis-continued-line)
            (return-from calc-nsis-indent
              (+ column *nsis-continued-statement-offset*)))

        (narrow-to-region (progn (goto-eol) (point))
                          (progn (goto-bol) (point)))
        (goto-bol)
        (skip-chars-forward " \t")
        ; ̂΃Cfg炷
        (cond
         ((looking-at "\\<\\(Function\\|Section\\|SubSection\\)End\\>")
          (decf column *nsis-indent-level*)
;          (msgbox "End ~D" column)
          ))
        ))
    column
    ))


; ⊮
;; addrev-table
(defvar *nsis-mode-abbrev-table* nil)
(unless *nsis-mode-abbrev-table*
  (define-abbrev-table '*nsis-mode-abbrev-table*))

;; popup ⊮
(defun nsis-completion ()
  "nsis-mode: ⊮"
  (interactive)
  (or *nsis-completion-list*
      (setq *nsis-completion-list* (make-list-from-keyword-table *nsis-keyword-hash-table*))
      (return-from nsis-completion nil))
  (let ((opoint (point)))
    (skip-syntax-spec-backward "w_")
    (let ((from (point)))
      (goto-char opoint)
      ; :list-ignore-case=⊮ő啶ʂȂ, :list=
      (do-completion from opoint :list-ignore-case *nsis-completion-list*
                     nil nil *nsis-completion-list* ; xyzzy 0.2.2.211ȑOgꍇ̓RgAEg
                     ))))

; Function ̈ꗗ
(defun nsis-build-summary-of-functions ()
  (let ((result nil))
    (save-excursion
      (goto-char (point-min))
      (while (scan-buffer "^[ \t]*Function[ \t]+\\([a-zA-Z0-9_.]+\\)" :regexp t :tail t)
        (push (list (current-line-number)
                    (match-string 1))
              result )))
    (nreverse result) ))

; tag
(pushnew '(nsis-maketags "*.ns[ih]") *maketags-list* :key #'car)

(defun tags-find-nsis-point (class name functionp point)
  (goto-char (- point *jump-tag-limit*))
  (and (or (scan-buffer "^!define[ \t]+[A-Z_]+"
                        :regexp t :limit (+ point *jump-tag-limit*))
           (scan-buffer (concat "^[ \t]*Function[ \t]+"
                                (regexp-quote name)
                                "[ \t]+")
                        :regexp t :limit (+ point *jump-tag-limit*)))
       (point)))

;; Function ^Ot
;;   Function name
(defun nsis-maketags (file count)
  (goto-char (point-min))
  (while (scan-buffer "^[ \t]*\\(!define\\|Function\\)[ \t]+" :regexp t :tail t :case-fold t)
    (do-events)
    (let ((opoint (point)))
      (skip-chars-forward "a-zA-Z0-9_.")
      (unless (= opoint (point))
        (format t "~A~A~D" (buffer-substring opoint (point)) file opoint)
        (setq count (1+ count)))))
  count)


; mode̎s
(defun nsis-mode ()
  "nsis-mode"
  (interactive)
  (kill-all-local-variables)
  (setq mode-name "NSIS")
  (setq buffer-mode 'nsis-mode)
  (use-syntax-table *nsis-mode-syntax-table*)
  (use-keymap *nsis-mode-map*)

  ; WJ
  (setq *local-abbrev-table* *nsis-mode-abbrev-table*)

  (make-local-variable 'paragraph-start)
  (setq paragraph-start "^$\\|\f") ; forward|backward-paragraph ňړiʒu
  (make-local-variable 'paragraph-separate)
  (setq paragraph-separate paragraph-start)

  ; ^O֘A
  (make-local-variable 'tags-find-target)
  (setq tags-find-target #'tags-find-target-simple)
  (make-local-variable 'tags-find-point)
  (setq tags-find-point #'tags-find-nsis-point)
  (make-local-variable 'build-summary-function)
  (setq build-summary-function 'nsis-build-summary-of-functions)

  ; indent
  (make-local-variable 'mode-specific-indent-command)
  (setq mode-specific-indent-command 'nsis-indent-line)
  (make-local-variable 'mode-newline-and-indent-command)
  (setq mode-newline-and-indent-command 'nsis-newline-and-indent)

  ; comment
  (setq comment-start "; " comment-end "") ; indent-for-commentő}z
  (setq comment-start-skip ";+[ \t]*")
  (setq comment-indent-function 'calc-nsis-indent)
  (when *nsis-comment-column*
    (setq comment-column *nsis-comment-column*))

  ; keyword
  (and *nsis-keyword-file*
       (null *nsis-keyword-hash-table*)
       (setq *nsis-keyword-hash-table*
             (load-keyword-file *nsis-keyword-file* t))) ; t=啶ʂȂ, nil=
  (when *nsis-keyword-hash-table*
    (make-local-variable 'keyword-hash-table)
    (setq keyword-hash-table *nsis-keyword-hash-table*))
  (make-local-variable 'regexp-keyword-list)
  (setq regexp-keyword-list *nsis-regexp-keyword-list*)

  ; tbN̎s
  (run-hooks '*nsis-mode-hook*))
