; nippo-mode
; programed by yo-sugi

(provide "nippo")
(in-package "editor")

(export '(nippo-mode *nippo-mode-map* *nippo-mode-hook*
		  *nippo-save-with-mail* *nippo-default-category*
		  *nippo-log-separate-format* *nippo-directory*
		  *nippo-smtp-server* *nippo-smtp-port*))

; TODO: ϐ
; *nippo-replace-alist*
(defvar *nippo-mode-version* "0.2.0" "o[W")
(defvar *nippo-mode-name* "nippo" "̃[h̖O")
(defvar *nippo-pframe-name* *nippo-mode-name* "t[̖O")

(defvar *nippo-mode-hook* nil "nippo-mode tbN")
(defvar *nippo-save-with-mail* nil "[Mɕۑ邩")

(defvar *nippo-directory* "~/.nippo" "u")
(defvar *nippo-default-category* "nippo" "ŏɏoĂJeS")

(defvar *nippo-smtp-server* nil "smtp T[o")
(defvar *nippo-smtp-port* "25" "smtp |[g")

; et@C
(defvar *nippo-recent-filename* "recent.txt" "Ōɏ")
(defvar *nippo-log-filename* "log.txt" "̃O")
(defvar *nippo-template-filename* "template.txt" "[̃ev[g")

; et@Cւ̃pX
(defvar *nippo-recent-filepath* nil "Ōɏ")
(defvar *nippo-log-filepath* nil "̃O")
(defvar *nippo-template-filepath* nil "[̃ev[g")

; {u鎞̃^O
(defvar *nippo-contents-tag* "$CONTENTS" "{up^O")

; Ő؂s
(defvar *nippo-log-separate-format* nil "Ő؂s")

;; L[}bv̒`
(defvar *nippo-mode-map* nil "nippo-mode L[}bv")
(unless *nippo-mode-map*
  (setq *nippo-mode-map* (make-sparse-keymap))
  ; Z[u & [M
  (define-key *nippo-mode-map* '(#\C-c #\C-c) 'send-nippo-mail)
  ; Z[u
  (define-key *nippo-mode-map* '(#\C-x #\C-s) 'save-nippo-files))

; Jgobt@u
; replace-alist  L[u^O()ŁA
; lu̕񖔂͕Ԃ S 
(defun replace-buffer-tag (replace-alist)
  "Jgobt@u"

  ; nbVĒu
  (mapcar
   #'(lambda (replace-element)
	   (let ((tag (car replace-element))
			 (replacement (cdr replace-element)))
		 (beginning-of-buffer)
		 (replace-buffer tag
						 (eval replacement)
						 :regexp nil)))
   replace-alist))

; header-string: ǉ镶
; ߂l: nil s, t 
(defun nippo-add-header (header-string)
  "wb_ǉ"
  (beginning-of-buffer)

  ; obt@sĂ(swb_͏I)
  (while (progn
		   (setq current-line (buffer-substring (progn (goto-bol) (point))
												(progn (goto-eol) (point))))
		   (> (length current-line) 0))

	; sOɃt@CIG[
	(if (null (forward-line)) (return-from nippo-add-header)))

  ; wb_IAs̑Oɕ
  (insert header-string))

;TODO: ֐
;(nippo-add-replacement)

(defun send-nippo-mail ()
  "񃁁[𑗐M"
  (interactive)

  ; ꉞmFƂ
  (if (not (yes-or-no-p "[𑗐M܂"))
	  (return-from send-nippo-mail))

  ; recent-buffer: ݂̃obt@(*nippo-recent-filename* ̃pbt@ł鎖)
  ; template-buffer: e|obt@
  (let ((recent-buffer (selected-buffer)) template-buffer)

	; e|obt@
	(set-buffer (get-buffer-create "*nippo-send-mail*"))
	(setq template-buffer (selected-buffer))

	;; e|obt@̊eݒ
	(erase-buffer (selected-buffer))
	(kill-all-local-variables)
	(make-local-variable 'need-not-save)
	(setq need-not-save t)						; Z[uKvȂ
	(set-buffer-modified-p nil)					; ύXꂽoȂĂ悵
	(change-fileio-encoding *encoding-jis*)		; [Ȃ̂œo͂ jis 

	;; ΃[pev[gt@Cǂݍ
	(if (file-exist-p *nippo-template-filepath*)
		(with-open-file (fp *nippo-template-filepath* :direction :input)
		  (let (line)
			(while (setq line (read-line fp nil))
			  (insert (format nil "~A~%" line)))))

	  ; ȂΏI
	  (progn
		(message-box "ev[gt@C܂")
		(return-from send-nippo-mail)))

	;; wb_ǉ
	(nippo-add-header
	 (concat
	  (format nil "Date: ~A~%" (format-date-string "%a, %d %b %Y %H:%M:%S %Z"))
	  (format nil "Content-Type: text/plain; charset=ISO-2022-JP~%")
	  (format nil "Mime-Version: 1.0~%")
	  (format nil "X-Mailer: nippo-mode ~A on xyzzy-~A~%"
			  *nippo-mode-version* (software-version))
	  (format nil "X-Yzzy-Version: ~A~%" (software-version))))

	;; {u
	(beginning-of-buffer)
	(when (scan-buffer *nippo-contents-tag*)
	  (delete-char (length *nippo-contents-tag*))

	  ; ݈ʒu珑݊Jn
	  (with-output-to-buffer (template-buffer (point))
		(with-input-from-buffer (recent-buffer)
		  (let (line)
			(while (setq line (read-line *standard-input* nil))
			  (map-internal-to-jis (format nil "~A~%" line) *standard-output*))))))

	;; alist Ēu
	(let ((replace-alist))
	  (macrolet ((pushnew-alist (replace-element); replace-alist)
				   `(pushnew ,replace-element replace-alist :key #'car)))
		(pushnew-alist '("$DATE" . (format-date-string "%Y\/%m\/%d")))
		(pushnew-alist '("$YEAR" . (format-date-string "%Y")))
		(pushnew-alist '("$MONTH" . (format-date-string "%m")))
		(pushnew-alist '("$HOGE" . "hoge"))
		(pushnew-alist '("$DAY" . (format-date-string "%d"))))
	  (replace-buffer-tag replace-alist))

	; wb_ mail from  M擾
	(let ((recipients (get-mail-header template-buffer '("to" "cc" "bcc")))
		  (mail-from (get-mail-header template-buffer '("from"))))

	  ; from  to Ȃ΃G[
	  (unless (and recipients mail-from)
		(message-box "wb_ from  to ܂")
		(return-from send-nippo-mail))

	  ; [AhX𒊏o
	  (let* ((get-address
			  #'(lambda (str)
				  (string-match "\\([a-zA-Z0-9_.-]+@[a-zA-Z0-9_.-]+\\)" (cdr str))
				  (match-string 1)))

			 ; from ͈Ȃ̂ car Ă
			 (from (car (mapcar get-address mail-from)))
			 (to-list (mapcar get-address recipients)))

		;; obt@̃wb_ base64 GR[h
		(encode-mail-header template-buffer)

		;; [𑗐M
		(long-operation
		  (message "~A" "sending...")
		  (unless (send-mail *nippo-smtp-server* *nippo-smtp-port*
							 (buffer-substring (point-min) (point-max))
							 from
							 to-list)

			; MɎs烁bZ[W\ďI
			(message "~A" "sending...failed")
			(message-box "Mł܂ł")
			(return-from send-nippo-mail))

		  ; ܂
		  (message "~A" "sending...done"))))

	; ̃obt@ɖ߂āAMpobt@͍폜
	(set-buffer recent-buffer)
	(delete-buffer template-buffer)

	; MɃOۑ
	(if *nippo-save-with-mail*
		(save-nippo-files))))

(defun save-nippo-files ()
  "t@CZ[u"
  (interactive)

  ; ݂̃obt@̓e nippo-recent.txt ɕۑ
  (save-buffer *encoding-jis* *eol-crlf*)

  ; ΘbIɌĂ΂ꂽ̂݊mF_CAOo
  (if (and (interactive-p)
		   (not (yes-or-no-p "Oۑ܂")))
	  (return-from save-nippo-files))

  ; nippo-log.txt ɃZp[^Ewb_
  (with-open-file (fp *nippo-log-filename*
					  :direction :output
					  :if-exists :append
					  :if-does-not-exist :create)

	(format fp "~%~A~%"
			(format-date-string (or *nippo-log-separate-format*
									"= : %yN%m%d(%v)"))))

  ; ݂̃obt@̓e log.txt ɒǉ
  (append-file *nippo-log-filename* t *encoding-sjis* *eol-crlf*)
  (message "~A~%" "save complete"))

(defun chop (str)
  "󂯎āAŌ̈ꕶ̂Ԃ"
  (if (stringp str)
	  (substring str 0 (- (length str) 1))))

(defun nippo-mode ()
  "nippo-template ǂݍŐVt[ŕ\"
  (interactive)
  ; et@CǂݍރfBNg
  ; nippo-category-dir: JeS̃fBNg
  (let (nippo-category-dir)
	(let (category)

	  ; ~/.nippo ȉɂfBNg擾
	  (setq category
			(completing-read "category: "

							 ; fBNgXg "/" ⊮Ώ
							 (mapcar #'(lambda (dir) (chop dir))
									 ; *nippo-directory* ȉ̃fBNg擾
									 (directory *nippo-directory* :directory-only t))
							 :case-fold t
							 :default *nippo-default-category*))

	  ; fBNgݒ
	  (setq nippo-category-dir (merge-pathnames category *nippo-directory*)))

	; et@C̐ݒ
	(setq *nippo-recent-filepath*
		  (merge-pathnames *nippo-recent-filename* nippo-category-dir))
	(setq *nippo-log-filepath*
		  (merge-pathnames *nippo-log-filename* nippo-category-dir))
	(setq *nippo-template-filepath*
		  (merge-pathnames *nippo-template-filename* nippo-category-dir)))

  ; Vt[ĖOt
  (new-pseudo-frame *nippo-pframe-name*)

  ; Oɏt@Cǂݍ
  (find-file *nippo-recent-filepath*)
  (kill-all-local-variables)

  ; [hp̐ݒ
  (setq mode-name "nippo")
  (setq buffer-mode 'nippo-mode)
  (use-keymap *nippo-mode-map*)
  (run-hooks '*nippo-mode-hook*))

; host: MTA
; port: |[g
; send-str: M镶
; mail-from: mail from
; recipients : M()
(defun send-mail (host port send-str mail-from recipients)
  "[𑗐M"
  ; |[gԍȂ΃ftHgl
  (if (null port) (setq port 25))
  (with-open-stream (stream (connect host port))

	; command 𑗐MĊ҂鉞R[h
	(flet ((send-cmd (command expect-code)
			 (let (ret-code)
			   
			   ; nil łȂ command 𑗐M
			   (unless (null command)
				 (format stream "~A" command))

			   ; 󂯎
			   (let ((reply (read-line stream nil)))
				 (with-open-file (fp "~/log.txt"
									 :direction :output
									 :if-exists :append
									 :if-does-not-exist :create)
				   (format fp "send: ~A~%" command)
				   (format fp "recv: ~A~%" reply))

				 ; ҂R[hłȂ΃G[
				 (if (equal (substring reply 0 3) (format nil "~3,'0D" expect-code))
					 reply
				   (return-from send-mail))))))

	  ; [𑗐M
	  (send-cmd nil 220)	; ڑ̉
	  (send-cmd (format nil "HELO ~A\n" (socket-stream-local-name stream)) 250)
	  (send-cmd (format nil "MAIL FROM: <~A>\n" mail-from) 250)

	  ; rcpt to 𑗂
	  (mapcar #'(lambda (recipient)
				  (send-cmd (format nil "RCPT TO: <~A>\n" recipient) 250))

			  ; Ȃ烊XgɂAXgȂ炻̂܂ܓn
			  (if (stringp recipients)
				  (list recipients)
				recipients))

	  ; hbgX^btBOĖ{𑗐M
	  (send-cmd (format nil "DATA\r\n") 354)
	  (with-input-from-string (instr send-str)
		(let (line)

		  ; 񂪂sǂݍ
		  (while (setq line (read-line instr nil))

			; hbgX^btBO
			(if (equal "." line)
				(format stream "..~%")
			  (format stream "~A~%" line)))))
	  
	  ; Ō . 𑗐MďI
	  (send-cmd ".\n" 250)
	  (send-cmd "QUIT\n" 221))))

;; wb_ ascii ȊO̕ base64  mime GR[h
;; w肳ꂽobt@ǂݍŁA̓e
;; R[h JIS ł鎖
;; folding Ȃǂ͍lĂȂ
(defun encode-mail-header (buffer)
  "[wb_̃GR[h"

  ; ̃obt@ۑƂ
  (let ((old-buffer (selected-buffer)))
	(set-buffer buffer)
	(goto-char (point-min))

	; ŏ̈s擾
	(let ((current-line (buffer-substring (progn (goto-bol) (point))
										  (progn (goto-eol) (point)))))

	  ; obt@sĂ(swb_͏I)
	  (while (> (length current-line) 0)

		; wb_̏Ƀ}b`Ȃ玟
		(when (string-match
			   (concat "[" ed::*ascii-chars-range* "]+:[ \t]*\\(.*\\)$")
			   current-line)

		  ; field-body: wb_̓e(':' ̌)
		  ; begin-body: wb_{fB̐擪|Cg
		  (let ((field-body (match-string 1))
				(begin-body (match-beginning 1)))

			; ascii ȊÔ̂Ă΃GR[hď
			(unless (string-match
					 (concat "^[" ed::*ascii-chars-range* " \t]+$")
					 field-body)

			  ; wb_{fB̈ʒuɈړāA݈ʒuۑ
			  (goto-bol) (forward-char begin-body)
			  (let ((begin-body-buffer (point)))

				; wb_ body 폜
				(delete-region begin-body-buffer (progn (goto-eol) (point)))
				(goto-char begin-body-buffer)

				; base64 & mime GR[ĥ}
				(insert (concat "=?ISO-2022-JP?B?"

								; Ōɉŝ trim Ƃ
								(string-trim "\n" (si::base64-encode field-body))
								"?="))))))

		; 1 sɈړ(ŏIs炻ŏI)
		(if (null (forward-line)) (return))

		; ̍s擾
		(setq current-line (buffer-substring (progn (goto-bol) (point))
											 (progn (goto-eol) (point))))
		(goto-bol)))

	; ̃obt@ɖ߂
	(set-buffer old-buffer)))

; buffer: Ăobt@
; headers: Ăwb_̃Xg(nil ȂSĂ)
(defun get-mail-header (buffer headers)
  "[̃wb_擾"
  ; ̃obt@ۑƂ
  (let ((old-buffer (selected-buffer)))
	(set-buffer buffer)
	(goto-char (point-min))

	; ŏ̈s擾
	(let ((current-line (buffer-substring (progn (goto-bol) (point))
										  (progn (goto-eol) (point))))
		  (header-alist nil))

	  ; obt@sĂ(swb_͏I)
	  (while (> (length current-line) 0)
		; wb_̏Ƀ}b`Ȃ玟
		(when (string-match
			   (concat "\\([" ed::*ascii-chars-range* "]+\\):[ \t]*\\(.*\\)$")
			   current-line)

		  ; wb_ƒlgɂAzXg
		  (push (cons (match-string 1) (match-string 2)) header-alist))

		; 1 sɈړ(ŏIs炻ŏI)
		(if (null (forward-line)) (return))
		; ̍s擾
		(setq current-line (buffer-substring (progn (goto-bol) (point))
											 (progn (goto-eol) (point)))))

	  ; NGXgwb_̂ݕԂ
	  (if headers
		  (intersection header-alist headers :test #'(lambda (x y)
													   (equalp (car x) y)))
		header-alist))))

