;;; -*- Mode: Lisp; Package: USER; Last modified: "2007/12/31 01:12:21"; -*-
;;;
;;; This file is not part of xyzzy.
;;;
;;;   nadesiko-mode.l --- Ȃł[h
;;;
;;;     by HIE Masahiro <madoinu@ybb.ne.jp>
#|

Tv

  {vO~O Ȃł (http://nadesi.com/) ҏWp
  W[[hłB


CXg[

  1. nadesiko-mode.l  site-lisp ɃRs[B

  2. KvɉCoCgRpCB

       M-x byte-compile-file

  3. .xyzzy  siteinit.l Ɉȉ̋LqǉB

      (require "nadesiko-mode")
      (pushnew '("\\.nako" . nadesiko-mode) *auto-mode-alist* :test 'equal)

  4. xyzzy ċNCݒ𔽉fB
     siteinit.l ɋLqꍇ͍ă_vB


L[oCh



ݒ

  ;;; Ȃł C:/nadesiko/ ɃCXg[ꍇ
  (defvar *nadesiko-path* "C:/nadesiko/")


ӎ

Ej[ [s] ́Cobt@̃f[^ۑĂKv܂B
  ۑɎsƁut@CɕۑHvƖ₢܂B "
  " IƎs܂BC[I͈͂܂1ss]g
  pƁCۑ̏Ԃłs邱Ƃł܂B

EȂłGfB^ŊJĕҏWꍇ́C[r]  "Ȃ"  
  "ҏWĂƂ" ɂĂȂƑʖڂłB

E̋؂蕶ƂāuvwxgƁC\ ɂGXP[v
  Bȏꍇ́C ""  `` gĂB

ECfgȂĂނƂ͂ł܂BRET(newline)  
  LFD(newline-and-indent) ւĂ邾łB


XV:

  [Version 1.04] 2007-12-31 ()
  EMITCZXɂB
  EFtɁCɗ\}b`悤ɂB

  [Version 1.03] H
  EpXy[X܂ރpX̏ŝCB
  E݂ȂΘbs폜B

  [Version 1.02]
  Erequire Ďg悤ɂB
  E֐낢ƕύXB
  EpXy[X 4 ŃCfg悤ɂB
  ETAB L[ŃCfgł悤ɂB

  [Version 1.01] 2005-03-03 (Thu)
  E^uŃCfg悤ɂB
  Eshift-selection, unshift-selection ꂼ M-i, M-u ɃoChB

  [Version 1.00] 2005-03-01 (Tue)
  EB


CZX

  nadesiko-mode.l MITCZXɊÂėp\łB
  <http://www.opensource.org/licenses/mit-license.php>

Copyright (c) 2007 HIE Masahiro

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

|#

(provide "nadesiko-mode")

(defconstant *nadesiko-mode-version* "1.03")

;;;  ;;;
;;;   ϐݒiKɃJX^}CY邠j
;;;  ;;;

;;; CXg[pX
(defvar *nadesiko-path* "C:/usr/local/nadesiko/")

;;; st@C
(defvar *nadesiko-execute-file* "vnako.exe")

;;; Ȃł Web Site
(defvar *nadesiko-home-url* "http://nadesi.com/")

;;; K\Ftp\F
(defvar *nadesiko-comment-color* '(:keyword :comment)) ; Rg
(defvar *nadesiko-syntax-keyword-color* '(:color 12 0))	; \L[[h
(defvar *nadesiko-reserve-word-color* '(:color 12 0)) ; \
(defvar *nadesiko-josi-color* '(:color 9 0)) ; 
(defvar *nadesiko-brackets-color* '(:keyword :string)) ; ʁij
(defvar *nadesiko-integer-color* '(:color 12 0)) ; l
(defvar *nadesiko-label-color* '(:color 5 0)) ; x
(defvar *nadesiko-operator-color* '(:color 4 0)) ; Zq
(defvar *nadesiko-punc-color* '(:color 14 0)) ; Ǔ_
(defvar *nadesiko-misc-color* '(:color 14 0)) ; 낢

;;; Cfg
(defvar *nadesiko-indent-columns* 4)

;;; ^uŃCfg
(defvar *nadesiko-indent-tabs-mode* nil)

(defvar *nadesiko-menu-name*  "Ȃł(&N)")


;;;  ;;;
;;;   ̑̕ϐݒ
;;;  ;;;

(defvar *nadesiko-app-menu* nil)
(defvar *nadesiko-command-menu* nil)
(defvar *nadesiko-mode-hook* nil)
(defvar *nadesiko-regexp-keyword-list* nil)

(defvar *nadesiko-mode-map* nil)
(unless *nadesiko-mode-map*
  (setq *nadesiko-mode-map* (make-sparse-keymap))
  (define-key *nadesiko-mode-map* #\RET 'newline-and-indent)
  (define-key *nadesiko-mode-map* #\LFD 'newline)
  (define-key *nadesiko-mode-map* #\TAB 'nadesiko-indent-line)
  (define-key *nadesiko-mode-map* '(#\C-c #\e) 'nadesiko-editor)
  (define-key *nadesiko-mode-map* '(#\C-c #\x) 'nadesiko-file-execute)
  (define-key *nadesiko-mode-map* '(#\C-c #\p) 'nadesiko-command-menu)
  (define-key *nadesiko-mode-map* '(#\C-c #\C-x) 'nadesiko-execute-partly)
  (define-key *nadesiko-mode-map* '(#\C-c #\?) 'nadesiko-version))

(defvar *nadesiko-mode-syntax-table* nil)
(unless *nadesiko-mode-syntax-table*
  (setq *nadesiko-mode-syntax-table* (make-syntax-table))
  (set-syntax-match *nadesiko-mode-syntax-table* #\( #\))
  (set-syntax-match *nadesiko-mode-syntax-table* #\( #\))
  (set-syntax-escape *nadesiko-mode-syntax-table* #\\)
  (set-syntax-string *nadesiko-mode-syntax-table* #\")
  (set-syntax-string *nadesiko-mode-syntax-table* #\`)
  (set-syntax-start-comment *nadesiko-mode-syntax-table* #\#)
  (set-syntax-end-comment *nadesiko-mode-syntax-table* #\LFD nil t)
  (set-syntax-start-multi-comment *nadesiko-mode-syntax-table* "/*")
  (set-syntax-end-multi-comment *nadesiko-mode-syntax-table* "*/")
  )

(setq *nadesiko-regexp-keyword-list*
      (compile-regexp-keyword-list
       `(
	 ;;Rg
	 ("\\(\\|f\\|'\\|//\\|\\).*" t ((0 . ,*nadesiko-comment-color*)))
	 ;;\L[[h
	 ("\\(Ⴆ\\|JԂ\\|JԂ\\|߂\\|\\|\\|I\\|I\\)"
	  t ((1 . ,*nadesiko-syntax-keyword-color*)))
	 ;;\
	 (,(concat "\\(\\\|\\|\\|͂\\|\\|܂\\|LZ\\|I\\|It"
		   "\\|\\|ifVR\\|\\|l\\|\\|\\|ϐ\\|z\\|"
		   "\\|nbV\\|O[v\\|ϐ錾\\|Kv\\|sv\\|\\|Ȃ\\|Ȃ"
		   "\\|\\|\\|\\|J\\|G[\\|Ď\\|\\|[v"
		   "\\|\\|\\|\\|\\)")
	  t ((0 . ,*nadesiko-reserve-word-color*)))
	 ;;
	 (,(concat "\\(łȂ\\|ɂ\\|Ȃ\\|Ƃ\\|炢\\|Ȃ̂\\|܂ł"
		   "\\|Ȃ\\|\\|\\|܂\\|ق\\|\\|\\|Ȃ\\|Ƃ\\|"
		   "\\|\\|\\|\\|\\|\\|\\|\\|\\|\\)")
	  t ((0 . ,*nadesiko-josi-color*)))
	 ("\\(?:\\([0-9O-X]+\\)\\(\\)\\|[})j]\\(\\)\\)"
	  t ((1 . ,*nadesiko-integer-color*) (2 . ,*nadesiko-reserve-word-color*)
	     (3 . ,*nadesiko-reserve-word-color*)))
	 ;;x
	 ("^[].*" t ((0 . ,*nadesiko-label-color*)))
	 ;;Ǔ_
	 ("[][ACB;]" t ((0 . ,*nadesiko-punc-color*)))
	 ;;낢
	 ("[][()ij#\\@I`]" t ((0 . ,*nadesiko-misc-color*)))
	 ;;Zq
	 ("[{|~^O!|&=]" t ((0 . ,*nadesiko-operator-color*)))
	 ("\\([ @0-9O-X]+\\)\\([<>*/+^-]\\)\\([ @0-9O-X]+\\)" t
	  ((1 . ,*nadesiko-integer-color*) (2 . ,*nadesiko-operator-color*) (3 . ,*nadesiko-integer-color*)))
	 ;;ʁi̋؂蕶j
	 ("\\(u[^v]*v\\|w[^x]*x\\)" t ((0 . ,*nadesiko-brackets-color*)))
	 ;;l
	 ;("[^a-zA-Z]+\\([0-9]+\\)[^a-zA-Z]+" t ((1 . ,*nadesiko-integer-color*)))
	 ("[0-9O-X]+" t ((0 . ,*nadesiko-integer-color*)))
	 )))


;;;  ;;;
;;;   Ȃł[h
;;;  ;;;

(defun nadesiko-mode ()
  (interactive)
  (kill-all-local-variables)
  (setq buffer-mode 'nadesiko-mode)
  (setq mode-name "Nadesiko")
  (use-keymap *nadesiko-mode-map*)
  (use-syntax-table *nadesiko-mode-syntax-table*)
  (make-local-variable 'regexp-keyword-list)
  (setq regexp-keyword-list *nadesiko-regexp-keyword-list*)
  (make-local-variable 'indent-tabs-mode)
  (setq indent-tabs-mode *nadesiko-indent-tabs-mode*)
  (nadesiko-menu-update)
  (run-hooks '*nadesiko-mode-hook*))

;;; ȂłGfB^ŊJ
(defun nadesiko-editor (&optional file)
  (interactive)
  (when (or (not (buffer-modified-p))
	    (and (yes-or-no-p "t@Cۑ܂B")
		 (save-buffer)))
    (call-process (concat (merge-pathnames "nakopad.exe" *nadesiko-path*) " \""
			  (map-slash-to-backslash (or file (get-buffer-file-name))) "\""))))

;;; Ȃłt@Cs
(defun nadesiko-file-execute (&optional file wait)
  (interactive)
  (if (or file
	  (not (buffer-modified-p))
	  (and (yes-or-no-p "t@Cۑ܂B")
	       (save-buffer)))
      (call-process (concat (merge-pathnames *nadesiko-execute-file* *nadesiko-path*) " \""
			    (map-slash-to-backslash (or file (get-buffer-file-name))) "\"")
		    :wait wait)
    (message "s𒆎~B")))

;;; Ȃłs
(defun nadesiko-execute (data &optional file)
  (interactive "sȂł: ")
  (let ((f (make-temp-file-name "_" "nako" "~/")))
    (with-open-file (s f
		       :direction :output
		       :if-exists :overwrite
		       :if-does-not-exist :create)
      (format s "~A~%" data))
    (when (file-exist-p f)
      (nadesiko-file-execute f t)
      (sit-for 1)
      (delete-file f))))

;;; ɂ
(defun nadesiko-about ()
  (interactive)
  (message "Ȃł[h for xyzzy version ~A" *nadesiko-mode-version*)
  (nadesiko-file-execute (merge-pathnames "tools/about.nako" *nadesiko-path*)))

;;; Ȃłs
(defun nadesiko-execute-partly ()
  (interactive)
  (let (s e code)
    (if (pre-selection-p)
	(selection-start-end (start end)
	  (setf s start
		e end))
      (save-excursion
	(setf s (progn (goto-bol) (point))
	      e (progn (goto-eol) (point)))))
    (reverse-region s e t)
    (next-line)
    (setf code (buffer-substring s e))
    (nadesiko-execute code)))

;;; }jA\
(defun nadesiko-manual ()
  (interactive)
  (shell-execute (merge-pathnames "index.htm" (merge-pathnames "doc" *nadesiko-path*))))

;;; z[y[W\
(defun nadesiko-home ()
  (interactive)
  (shell-execute *nadesiko-home-url* t))

;;; C`LCfg
(defun nadesiko-indent-line (&optional arg)
  (interactive "p")
  (if (pre-selection-p)
      (if arg
	  (unshift-selection *nadesiko-indent-columns*)
	(shift-selection *nadesiko-indent-columns*))
    (let ((p (bolp))
	  (x (if arg -1 1)))
      (save-excursion
	(shift-region (progn (goto-bol) (point))
		      (progn (goto-eol) (point))
		      (* x *nadesiko-indent-columns*)))
      (when p (back-to-indentation)))))


;;;  ;;;
;;;   ȂłR}hj[
;;;  ;;;

;;; R}hj[\
(defun nadesiko-command-menu ()
  (interactive)
  (unless *nadesiko-command-menu*
    (nadesiko-create-popup-menu))
  (track-popup-menu *nadesiko-command-menu*))

;;; command.txt |bvAbvj[쐬
(defun nadesiko-create-popup-menu ()
  (long-operation
    (let ((b (get-buffer-create "*nadesiko-cmd*")))
      (set-buffer b)
      (insert-file-contents
       (merge-pathnames "command.txt" (merge-pathnames "tools" *nadesiko-path*)))
      (goto-char (point-min))
      (let ((menu (create-popup-menu)) m1 m2)
	(while (not (eobp))
	  (message "Ȃłj[쐬 ... ~D" (current-line-number))
	  (when (looking-at "^+")
	    (setf m1 (create-popup-menu))
	    (add-popup-menu menu m1
			    (buffer-substring (progn (forward-char 1) (point))
					      (progn (goto-eol) (point)))))
	  (when (looking-at "^-")
	    (setf m2 (create-popup-menu))
	    (add-popup-menu m1 m2
			    (buffer-substring (progn (forward-char 1) (point))
					      (progn (goto-eol) (point)))))
	  (when (looking-at "^|")
	    (let ((c (buffer-substring (progn (forward-char 1) (point))
				       (progn (scan-buffer ",\"") (point))))
		  (s (buffer-substring (progn (scan-buffer "\",\"" :no-dup t :tail t) (point))
				       (progn (scan-buffer "\",") (point)))))
	      (add-menu-item m2 nil (concat c "	" s)
			     #'(lambda () (interactive) (insert c)))))
	  (next-line)
	  (goto-bol))
	(delete-buffer b)
	(setf *nadesiko-command-menu* menu)))))


;;;  ;;;
;;;   ȂłAvj[
;;;  ;;;

(defun nadesiko-menu-update ()
  (interactive)
  (use-local-menu (nadesiko-add-menu)))

(defun nadesiko-add-menu ()
  (let ((menu (copy-menu-items *app-menu* (create-menu))))
    (insert-popup-menu menu (get-menu-position menu 'ed::help)
                       *nadesiko-app-menu*
                       *nadesiko-menu-name*)
    menu))

(add-hook
 '*init-app-menus-hook*
 #'(lambda ()
     (unless *nadesiko-app-menu*
       (setq *nadesiko-app-menu*
	     (let ((menu (create-popup-menu)))
	       (add-menu-item menu nil "ȂłGfB^ŊJ(&E)" 'nadesiko-editor)
	       (add-menu-item menu nil "ȂłR}hj[(&P)" 'nadesiko-command-menu)
	       (add-menu-separator menu)
	       (add-menu-item menu nil "s(&X)" 'nadesiko-file-execute)
	       (add-menu-item menu nil "I͈͂܂1ss(&L)" 'nadesiko-execute-partly)
	       (add-menu-separator menu)
	       (add-popup-menu menu
			       (define-popup-menu
				 (:item nil "WGUI - vnako.exe(&G)"
				  #'(lambda () (interactive) (nadesiko-toggle-execute-file "vnako.exe"))
				  #'(lambda () (when (equal *nadesiko-execute-file* "vnako.exe") :check)))
				 (:item nil "ȈGUI - gnako.exe(&U)"
				  #'(lambda () (interactive) (nadesiko-toggle-execute-file "gnako.exe"))
				  #'(lambda () (when (equal *nadesiko-execute-file* "gnako.exe") :check)))
				 (:item nil "R\[ - cnako.exe(&C)"
				  #'(lambda () (interactive) (nadesiko-toggle-execute-file "cnako.exe"))
				  #'(lambda () (when (equal *nadesiko-execute-file* "cnako.exe") :check)))
				 ) "Ȃłs(&Y)")

	  (add-menu-separator menu)
	  (add-menu-item menu nil "}jA(&H)" 'nadesiko-manual)
	  (add-menu-item menu nil "Ȃł̃y[W(&H)" 'nadesiko-home)
	  (add-menu-item menu nil "ɂ(&A)..."  'nadesiko-about)
	  menu)))))

(defun nadesiko-toggle-execute-file (&optional file)
  (interactive)
  (setf *nadesiko-execute-file*
	(or file (cond ((equal *nadesiko-execute-file* "vnako.exe") "gnako.exe")
		       ((equal *nadesiko-execute-file* "gnako.exe") "cnako.exe")
		       (t "vnako.exe")))))


;;; nadesiko-mode.l ́C܂ŁB
