;;; -*- Mode: Lisp; Package: EDITOR -*-
;;; multiple-replace.l

;; Copyright (C) 2001-2008 OHKUBO Hiroshi <ohkubo@s53.xrea.com>

;; Author: OHKUBO Hiroshi <ohkubo@s53.xrea.com>
;; Time-stamp: <2008/02/10 14:38:35 +0900>

;;; Commentary:

;; Description:
;;
;;  ̒us܂B
;;

;; Installation:
;;
;;      1. A[JCuWJ multiple-replace.l  $XYZZY/site-lisp 
;;         Rs[܂B
;;
;;      2. oCgRpC܂B
;;
;;              M-x byte-compile-file
;;              Byte compile file: $XYZZY/site-lisp/multiple-replace.l
;;
;;      3. ~/.xyzzy ܂ $XYZZY/site-lisp/siteinit.l Ɉȉ̃R[h
;;         ǉ܂B
;;
;;              (require "multiple-replace")
;;
;;      4. L̐ݒ𔽉f邽߂ɁAxyzzy ċN܂B
;;         siteinit.l ɋLqꍇ Ctrl L[ Shift L[Ȃ
;;         xyzzy ċNA_vt@Cč\z܂B
;;

;; Uninstallation:
;;
;;      1. ESC ESC (ed::multiple-replace-uninstall) ƃ^CvA
;;         multiple-replace.l ֘Ȁ xyzzy 폜܂B
;;
;;      2. multiple-replace.l ɊւLq폜܂B
;;
;;      3. siteinit.l ɋLqĂꍇ Ctrl L[ Shift L[
;;         Ȃ xyzzy ċNA_vt@Cč\z܂B
;;

;; Usage:
;;
;;      M-x multiple-replace-string
;;      M-x query-multiple-replace
;;
;;      M-x multiple-replace-regexp
;;      M-x query-multiple-replace-regexp
;;
;;      M-x multiple-replace-dialog
;;

;; Changes:
;;
;;      Thu, 10 May 2007 00:18:24 +0900
;;        Emultiple-replace-dialog ̐ݒOt@Cɕۑ\ɁB
;;          *multiple-replace-setting-file-directory* tH_
;;          (l "~/.multiple-replace") ݂ꍇ́Aݒ̃t@C
;;          ւ̕ۑAt@Cǂݍ݂sB
;;          Ԃł́A̐ݒ(݂̐ݒ)ɂĂAt@C֕ۑ
;;          BݒɂĂ̓t@Cۑ/ǍȂꍇ́A
;;          *multiple-replace-setting-file-current-setting-p*  nil ɂB
;;        EsvȃR[h폜B
;;
;;      Fri, 27 Apr 2007 00:21:23 +0900
;;        Edocstring ̒ǉB
;;
;;      Sat, 08 Oct 2005 12:29:40 +0900
;;        E[AhXύXB
;;        ECZX(CBSDCZX)LځB
;;
;;      Mon, 06 Jun 2005 22:22:17 +0900
;;        EhLg Usage ǉB
;;
;;      Wed, 13 Apr 2005 00:14:57 +0900
;;        Emultiple-replace-dialog ́uݒv͂ĂȂ
;;          ԂŁuۑvꍇA̎_̓ݒ薼肷
;;          悤ɊgB
;;
;;      Mon, 11 Apr 2005 21:22:43 +0900
;;        Exyzzy 0.2.2.234 Ή
;;          - "lr oSVbN"  "MS UI Gothic"
;;          - pJiSpJiɕύXB
;;          - multiple-replace-insert-menu-items XVB
;;            uuvj[ǉʒũftHg
;;            uuv̉ɁB
;;        ERgCB
;;
;;      Sun, 21 Dec 2003 08:20:37 +0900
;;        EsڂɌ͂ȂꍇAύX
;;          łȂ_CB
;;        Emenu ֘ACB
;;        Euninstall ֘AǉB
;;
;;      Sat, 04 Oct 2003 03:15:19 +0900
;;        EǗǉB
;;          ƂȂݒ̕ϐ multiple-replace Ǝ̂̂p悤ɁB
;;
;;      Mon, 14 Apr 2003 02:38:54 +0900
;;        Eō쐬B
;;

;; Licence:
;;
;;    multiple-replace ͏CBSDCZXɊÂėp\łB
;;    <http://www.opensource.org/licenses/bsd-license.php>
;;
;;
;;    Copyright (C) 2001-2008, OHKUBO Hiroshi.  All rights reserved.
;;
;;    Redistribution and use in source and binary forms, with or without
;;    modification, are permitted provided that the following conditions
;;    are met:
;;
;;    1. Redistributions of source code must retain the above copyright
;;       notice, this list of conditions and the following disclaimer.
;;
;;    2. Redistributions in binary form must reproduce the above copyright
;;       notice, this list of conditions and the following disclaimer in
;;       the documentation and/or other materials provided with the
;;       distribution.
;;
;;    3. Neither the name of the University nor the names of its
;;       contributors may be used to endorse or promote products derived
;;       from this software without specific prior written permission.
;;
;;    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
;;    ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
;;    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
;;    A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
;;    OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
;;    SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
;;    LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
;;    DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
;;    THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
;;    (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
;;    OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
;;

;;; Code:

(provide "multiple-replace")

(in-package "editor")

(require "search")
(require "dialogs")

(export '(multiple-replace-string
          query-multiple-replace
          multiple-replace-regexp
          query-multiple-replace-regexp
          multiple-replace-dialog
          *multiple-replace-setting-file-directory*
          *multiple-replace-setting-file-current-setting-p*
          multiple-replace-setting-file-create-directory))

(define-history-variable *last-multiple-search-replace-string-list* nil
  "Óu(񐳋K\)AuṽyAȂ郊XgۑĂB")
(define-history-variable *last-multiple-search-replace-regexp-list* nil
  "Óu(K\)AuṽyAȂ郊XgۑĂB")
; (((pattern1 . replace1) (pattern2 . replace2) ...) ((decode-pattern1 . decode-replace1) ...))
(define-history-variable *last-multiple-search-replace-string-list-pair* nil
  "multiple-replace-dialog ֐ł̂ݗpB
*last-multiple-search-replace-string-list* y
*last-multiple-search-replace-regexp-list* ̓GXP[vV[PXfR[h
ێĂBA_CAO\́AGXP[vV[PX
fR[hO̕\Ȃ΂ȂȂ߁AfR[hO̕ێ
ĂKvB
āA̕ϐ́AŌɎsũXg
(*last-multiple-search-replace-string-list* ܂
 *last-multiple-search-replace-regexp-list*) ɂāA̒l̂̂ƁA
當GXP[vV[PXfR[hlێB

A*last-multiple-search-replace-string-list-pair* Ɋւ́A
ݕs\B_CAO畡u{Ƃ
*last-multiple-search-replace-string-list-pair* ̒lۑĂȂ߁A
~jobt@sA^uȂǂ܂ޕus
multiple-replace-dialog sƁA҂Ȃ\ƂȂB")

(define-history-variable *last-multiple-replace-setting* nil
  "ŌɎsu̐ݒێB
萳mɂ́AɎs镡ũftHglƂȂׂݒێB
āAusAʂ̐ݒǂݍ񂾏ꍇ́Aǂݍ񂾐ݒ
ێB")
; ((("hisitory-name" . string) ("setting" . sexp)) ...)
(define-history-variable *multiple-replace-setting-history* nil
  "multiple-replace-dialog ֐ł̂ݗpB
_CAO畡usꍇA̐ݒɖOĕێB
ߋݒɂĂێB
~jobt@s镡uł́A̒lXV邱ƂAQ
邱ƂȂB")

(defconstant *multiple-replace-dialog-number-of-input-min* 1
  "multiple-replace-dialog ł́Aŏ̓tB[hB
TCYݒ莞̉lB")
(defvar *multiple-replace-dialog-number-of-input* 5
  "* multiple-replace-dialog ŕ\̓tB[hB")
(defvar *multiple-replace-case-fold-search* *case-fold-search*
  "* ɂ ASCII ̑啶/̋ʂ̕@w肷B
        nil     - 啶/ʂČB
        :smart  - PATTERN ɑ啶܂܂ĂȂꍇA啶/
                  ʂɌB
        LȊO- 啶/ʂɌB

search.l dialogs.l  *case-fold-search* QƁB")
(defvar *multiple-replace-word-search* *word-search*
  "* ̋E}b`̎wB
        nil      - }b`EɊւ炸}b`
        :symbol  - (Tv)}b`ẼV^bNX word, symbol ̏ꍇe
        LȊO -  (Tv)}b`ẼV^bNX word ̏ꍇe
multiple-replace-dialog ɂăC^NeBuɒl̕ύX\B
lɂĉeł֐ multiple-replace-dialog, multiple-replace-string,
query-multiple-replaceB

ŏII scan-buffer  :left-bound, :right-bound Ɏw肷邽߁A
wl̏ڍׂ scan-buffer ̃t@XQƁB

*multiple-replace-word-search*  *multiple-replace-regexp-search* 
 non-nil ̏ꍇA*multiple-replace-word-search* ̐ݒ肪LƂȂB
܂AK\͍sȂB

scan-buffer  :regexp  non-nil w肵ꍇ :left-bound,
:right-bound ̎w nil ƂĈB(:regexp w肪D悳)
multiple-replace-dialog ł́Adialogs.l  replace-dialog ƓlA
perform-multiple-replace ɓnO *multiple-replace-word-search* 
*multiple-replace-regexp-search* 𔻒f *multiple-replace-word-search*
̎wD悵ĂB

܂Amultiple-replace-dialog ɂ *multiple-replace-word-search* ̒l
ύXƁAmultiple-replace-string, query-multiple-replace ɂe^B
multiple-replace-regexp, query-multiple-replace-regexp ł͐K\
D悷邽߁A*multiple-replace-word-search* ̒lɂe͂ȂB

search.l dialogs.l  replace-dialog, replace-string query-replace ł
l *word-search* ɂeB

search.l dialogs.l  *word-search* QƁB")
(defvar *multiple-replace-regexp-search* *regexp-search*
  "* K\邩ۂ̎wB
        nil     - [] Ƃ݂ȂB
        non-nil - [K\] Ƃ݂ȂB
*multiple-replace-word-search*  non-nil ̏ꍇAD悷B
{ multiple-replace-dialog ݂̂ŎgpB
qXgɋL^邽߂ɉL3֐łgpB
  - perform-multiple-replace
  - multiple-replace-load-setting
  - multiple-replace-make-setting

multiple-replace-dialog ł́Adialogs.l  replace-dialog ֐ƓlA
perform-multiple-replace ɓnO *multiple-replace-word-search* 
*multiple-replace-regexp-search* 𔻒f *multiple-replace-word-search*
̎wD悵ĂB

dialogs.l  *regexp-search* QƁB")
(defvar *multiple-replace-understand-escape-sequences* *understand-escape-sequences*
  "* GXP[vV[PX𗝉邩ۂ̎wB
        nil     - GXP[vV[PX𗝉Ȃ
        non-nil - GXP[vV[PX𗝉
{ multiple-replace-dialog ݂̂ŎgpB
qXgɋL^邽߂ɉL2֐łgpB
  - multiple-replace-load-setting
  - multiple-replace-make-setting")
(defvar *multiple-replace-replace-whole-buffer* *replace-whole-buffer*
  "* obt@̐擪usۂ̎wB
        nil     - ݂̃|Cgus
        non-nil - obt@̐擪us
{ multiple-replace-dialog ݂̂ŎgpB
qXgɋL^邽߂ɉL2֐łgpB
  - multiple-replace-load-setting
  - multiple-replace-make-setting")

(defvar *multiple-replace-setting-file-directory* "~/.multiple-replace"
  "* multiple-replace-dialog ̐ݒ̕ۑtH_B
tH_݂ꍇ́Axyzzy ̃qXgϐƋɁAt@CɂۑB")
(defvar *multiple-replace-setting-file-current-setting-p* t
  "* ̐ݒ(݂̐ݒ)ɂĂAt@Cۑ/Ǎ邩ۂB
        nil     t@Cۑ/ǍȂ
        non-nil t@Cۑ/Ǎ")
(defvar *multiple-replace-setting-file-alist* nil
  "multiple-replace-dialog ̐ݒ薼ƃt@C֘AtpϐB")

(defun perform-multiple-replace (pattern-replacement-list query regexp interactive-p noerror)
  "ũCsB
ȉ֐ŎgpB
  - multiple-replace-string
  - query-multiple-replace
  - multiple-replace-regexp
  - query-multiple-replace-regexp
  - multiple-replace-dialog"
  (let ((literal (null regexp))
        (count 0)
        (nodup nil)
        (opoint (point))
        (not-found t)
        (def nil)
        (last-match nil)
        (last-match-char nil)
        (undo-bound (or interactive-p query))
        (pattern nil)
        (replacement nil)
        (point-pattern-list nil)
        (point-search nil))
    (undo-boundary)
    (when interactive-p
      (if regexp
          (setq *last-multiple-search-replace-regexp-list*
                pattern-replacement-list)
        (setq *last-multiple-search-replace-string-list*
              pattern-replacement-list))
      (let ((*multiple-replace-regexp-search* regexp))
        (declare (special *multiple-replace-regexp-search*))
        (setq *last-multiple-replace-setting* (multiple-replace-make-setting))))
    (if regexp
        (setq pattern-replacement-list
              (mapcar #'(lambda (pattern-replacement)
                          (cons
                           (if (stringp (car pattern-replacement))
                               (compile-regexp (car pattern-replacement) *multiple-replace-case-fold-search*)
                             (car pattern-replacement))
                           (cdr pattern-replacement)))
                      pattern-replacement-list)))
    (unless query
      (begin-wait-cursor))
    (loop
      (setq point-pattern-list nil)
      (save-excursion
        (setq search-point (point))
        (dolist (pattern (mapcar 'car pattern-replacement-list))
          (when (and (or (regexpp pattern) (stringp pattern))
                     (scan-buffer pattern
                                  :regexp regexp
                                  :no-dup nodup
                                  :last-match (cons last-match last-match-char)
                                  :case-fold *multiple-replace-case-fold-search*
                                  :left-bound *multiple-replace-word-search*
                                  :right-bound *multiple-replace-word-search*))
            (push (cons (point) pattern) point-pattern-list))
          (goto-char search-point)))
      (unless point-pattern-list
        (return))
      (setq pattern (cdar (stable-sort (nreverse point-pattern-list) '< :key 'car)))
      (setq replacement (cdr (assoc pattern pattern-replacement-list :test 'equal)))
      (scan-buffer pattern
                   :regexp regexp
                   :no-dup nodup
                   :last-match (cons last-match last-match-char)
                   :case-fold *multiple-replace-case-fold-search*
                   :left-bound *multiple-replace-word-search*
                   :right-bound *multiple-replace-word-search*)
      (if (and (eql (match-beginning 0) (match-end 0))
               (eql last-match (match-beginning 0)))
          (setq nodup t)
        (progn
          (setq not-found nil)
          (show-match)
          (unless (pos-visible-in-window-p (point))
            (recenter))
          (if query
              (progn
                (refresh-screen)
                (message (if (eq def 'help)
                             "(y)u, (n)XLbv, (!)cS, (u)AhD, (C-g)~, (.)~Ė߂"
                           (format nil "u?:  ~S" replacement)))
                (setq def (lookup-keymap *query-replace-map* (read-char *keyboard*) t)))
            (setq def 'automatic))
          (when (cond ((eq def 'act)
                       t)
                      ((eq def 'skip)
                       (setq nodup t)
                       nil)
                      ((eq def 'automatic)
                       (setq query nil)
                       t)
                      ((eq def 'undo)
                       (and (plusp count)
                            (undo)
                            (setq count (1- count)))
                       (setq nodup nil)
                       nil)
                      ((eq def 'quit-and-back)
                       (goto-char opoint)
                       (setq def 'quit)
                       (return))
                      ((eq def 'quit)
                       (return))
                      ((eq def 'recenter)
                       (recenter)
                       (setq nodup nil)
                       nil)
                      ((and (consp def)
                            (eq (car def) 'throw))
                       (throw (cdr def) count))
                      (t (setq def 'help)
                         (setq nodup nil)
                         nil))
            (setq last-match-char (unless (= (match-end 0) (point-min))
                                    (char-before (match-end 0))))
            (unless (replace-match replacement :literal literal)
              (return))
            (setq last-match (point))
            (setq nodup (= (match-beginning 0) (match-end 0)))
            (when (and undo-bound query)
              (undo-boundary))
            (setq count (1+ count)))))
      (when (eobp)
        (return)))
    (unless query
      (end-wait-cursor))
    (hide-match)
    (unless noerror
      (and (eq def 'quit)
           (quit))
      (and not-found
           (error "񂪌܂")))
    (when (and interactive-p
               (null *executing-macro*))
      (message "~du܂" count))
    count))

(defun multiple-replace-string (pattern-replacement-list &optional noerror)
  "(񐳋K\)̈ꊇus"
  (interactive
      (let (pattern replacement pat-rep-list (i 1))
        (loop
          (setq pattern
                (read-string (format nil "Replace string (~D): " i)
                             :default (elt (mapcar 'car *last-multiple-search-replace-string-list*) (1- i))
                             :history 'search))
          (if (string= pattern "")
              (return)
            (progn
              (setq replacement
                    (read-string (format nil "with (~D): " i)
                                 :default (elt (mapcar 'cdr *last-multiple-search-replace-string-list*) (1- i))
                                 :history 'search))
              (push (cons pattern replacement) pat-rep-list)))
          (incf i))
        (list (nreverse pat-rep-list))))
  (when buffer-read-only
    (error "݋֎~obt@ł"))
  (perform-multiple-replace pattern-replacement-list nil nil (interactive-p) noerror))

(defun query-multiple-replace (pattern-replacement-list &optional noerror)
  "mF𔺂Ȃ畡(񐳋K\)̒us"
  (interactive
      (let (pattern replacement pat-rep-list (i 1))
        (loop
          (setq pattern
                (read-string (format nil "Query replace (~D): " i)
                             :default (elt (mapcar 'car *last-multiple-search-replace-string-list*) (1- i))
                             :history 'search))
          (if (string= pattern "")
              (return)
            (progn
              (setq replacement
                    (read-string (format nil "with (~D): " i)
                                 :default (elt (mapcar 'cdr *last-multiple-search-replace-string-list*) (1- i))
                                 :history 'search))
              (push (cons pattern replacement) pat-rep-list)))
          (incf i))
        (list (nreverse pat-rep-list))))
  (when buffer-read-only
    (error "݋֎~obt@ł"))
  (perform-multiple-replace pattern-replacement-list t nil (interactive-p) noerror))

(defun multiple-replace-regexp (pattern-replacement-list &optional noerror)
  "K\̈ꊇus"
  (interactive
      (let (pattern replacement pat-rep-list (i 1))
        (loop
          (setq pattern
                (read-string (format nil "Replace regexp (~D): " i)
                             :default (elt (mapcar 'car *last-multiple-search-replace-regexp-list*) (1- i))
                             :history 'search))
          (if (string= pattern "")
              (return)
            (progn
              (setq replacement
                    (read-string (format nil "with (~D): " i)
                                 :default (elt (mapcar 'cdr *last-multiple-search-replace-regexp-list*) (1- i))
                                 :history 'search))
              (push (cons pattern replacement) pat-rep-list)))
          (incf i))
        (list (nreverse pat-rep-list))))
  (when buffer-read-only
    (error "݋֎~obt@ł"))
  (perform-multiple-replace pattern-replacement-list nil t (interactive-p) noerror))

(defun query-multiple-replace-regexp (pattern-replacement-list &optional noerror)
  "mF𔺂Ȃ畡K\̒us"
  (interactive
      (let (pattern replacement pat-rep-list (i 1))
        (loop
          (setq pattern
                (read-string (format nil "Query replace regexp (~D): " i)
                             :default (elt (mapcar 'car *last-multiple-search-replace-regexp-list*) (1- i))
                             :history 'search))
          (if (string= pattern "")
              (return)
            (progn
              (setq replacement
                    (read-string (format nil "with (~D): " i)
                                 :default (elt (mapcar 'cdr *last-multiple-search-replace-regexp-list*) (1- i))
                                 :history 'search))
              (push (cons pattern replacement) pat-rep-list)))
          (incf i))
        (list (nreverse pat-rep-list))))
  (when buffer-read-only
    (error "݋֎~obt@ł"))
  (perform-multiple-replace pattern-replacement-list t t (interactive-p) noerror))


(defun multiple-replace-get-setting-item (setting name &optional default)
  "setting 疼OɑΉl擾"
  (let (lst)
    (if (setq lst (assoc name setting :test 'string=))
        (cadr lst)
      default)))
(defun multiple-replace-load-setting (setting)
  "setting ̓e[h"
  (setq *multiple-replace-case-fold-search* (multiple-replace-get-setting-item setting "case-fold-search"))
  (setq *multiple-replace-word-search* (multiple-replace-get-setting-item setting "word-search"))
  (setq *multiple-replace-regexp-search* (multiple-replace-get-setting-item setting "regexp-search"))
  (setq *multiple-replace-understand-escape-sequences*
        (multiple-replace-get-setting-item setting "understand-escape-sequences"))
  (setq *multiple-replace-replace-whole-buffer*
        (multiple-replace-get-setting-item setting "replace-whole-buffer"))
  (setq *multiple-replace-dialog-number-of-input*
        (multiple-replace-get-setting-item setting "dialog-number-of-input"
                                           *multiple-replace-dialog-number-of-input*))
  (if *multiple-replace-regexp-search*
      (setq *last-multiple-search-replace-regexp-list*
            (multiple-replace-get-setting-item setting "pattern-replacement-list"))
    (setq *last-multiple-search-replace-string-list*
          (multiple-replace-get-setting-item setting "pattern-replacement-list")))
  (setq *last-multiple-search-replace-string-list-pair*
        (multiple-replace-get-setting-item setting "search-replace-string-list-pair"))
  nil)
(defun multiple-replace-make-setting ()
  "݂̒l setting 쐬"
  (list (list (copy-string "pattern-replacement-list")
              (if *multiple-replace-regexp-search*
                  *last-multiple-search-replace-regexp-list*
                *last-multiple-search-replace-string-list*))
        (list (copy-string "case-fold-search") *multiple-replace-case-fold-search*)
        (list (copy-string "word-search") *multiple-replace-word-search*)
        (list (copy-string "regexp-search") *multiple-replace-regexp-search*)
        (list (copy-string "understand-escape-sequences") *multiple-replace-understand-escape-sequences*)
        (list (copy-string "replace-whole-buffer") *multiple-replace-replace-whole-buffer*)
        (list (copy-string "dialog-number-of-input") *multiple-replace-dialog-number-of-input*)
        (list (copy-string "search-replace-string-list-pair") *last-multiple-search-replace-string-list-pair*)))

(defun multiple-replace-dialog (&key (setting nil sv-setting) history-name)
  "_CAOŎw肵A𓯎ɒu"
  (interactive)
  (multiple-replace-setting-file-load-all)
  (let (dialog-template
        number-of-input
        controls controls-initializers controls-handlers
        search-symbol-list replace-symbol-list
        history
        (history-name-list (mapcar
                            #'(lambda (h)
                                (multiple-replace-get-setting-item h "history-name"))
                            *multiple-replace-setting-history*)))
    (let (pos)
      (if (and (stringp history-name)
               (setq pos (position history-name *multiple-replace-setting-history*
                                   :key #'(lambda (h) (multiple-replace-get-setting-item h "history-name"))
                                   :test 'equal)))
          (setq setting (multiple-replace-get-setting-item
                         (nth pos *multiple-replace-setting-history*) "setting"))
        (progn
          (setq history-name nil)
          (if (and (null setting) (not sv-setting))
              (setq setting *last-multiple-replace-setting*)))))
    (multiple-replace-load-setting setting)
    (setq number-of-input (max *multiple-replace-dialog-number-of-input-min*
                               (if (and (numberp *multiple-replace-dialog-number-of-input*)
                                        (integerp *multiple-replace-dialog-number-of-input*)
                                        (plusp *multiple-replace-dialog-number-of-input*))
                                   *multiple-replace-dialog-number-of-input* 0)))

    ;; search, replace p symbol ̐
    (dotimes (i number-of-input)
      (push (make-symbol (concat "search" (format nil "~D" i))) search-symbol-list)
      (push (make-symbol (concat "replace" (format nil "~D" i))) replace-symbol-list))
    (setq search-symbol-list (nreverse search-symbol-list))
    (setq replace-symbol-list (nreverse replace-symbol-list))
    
    (push `(:button nil "" #x50020007
            2 2 310 ,(+ 22 (* 14 number-of-input))) controls)
    (push '(:static nil ""      #x50020001   16 10 140 8) controls)
    (push '(:static nil "u"      #x50020001  168 10 140 8) controls)
    (dotimes (i number-of-input)
      (if (< i 9)
          (push `(:static nil ,(format nil "&~D:" (1+ i)) #x50020002
                  7 ,(+ 22 (* 14 i)) 8 8) controls)
        (push `(:static nil ,(multiple-value-bind (dec num)
                                 (floor (1+ i) 10)
                               (format nil "~D&~D:" dec num)) #x50020002
                7 ,(+ 22 (* 14 i)) 8 8) controls))
      (push `(:static nil "" #x50020000
              159 ,(+ 22 (* 14 i)) 8 8) controls)
      (push `(:combobox ,(elt search-symbol-list i) nil  #x50210842
              16 ,(+ 19 (* 14 i)) 140 96) controls)
      (push `(:combobox ,(elt replace-symbol-list i) nil #x50210842
              168 ,(+ 19 (* 14 i)) 140 96) controls))
    (push `(:button case-fold "啶ʂ(&C)" #x50010006
            39 ,(+ 30 (* 14 number-of-input)) 113 10) controls)
    (push `(:button word "PPʂŌ(&W)" #x50010003
            39 ,(+ 43 (* 14 number-of-input)) 97 10) controls)
    (push `(:button regexp "K\(&E)" #x50010003
            39 ,(+ 56 (* 14 number-of-input)) 63 10) controls)
    (push `(:button escseq "GXP[vV[PX𗝉(&Y)" #x50010003
            39 ,(+ 69 (* 14 number-of-input)) 113 10) controls)
    (push `(:button whole "obt@̐擪(&O)" #x50010003
            39 ,(+ 82 (* 14 number-of-input)) 89 10) controls)

    (push `(:button query "mF(&Q)" #x50010001
            185 ,(+ 30 (* 14 number-of-input)) 50 14) controls)
    (push `(:button all "SĒu(&A)" #x50010000
            185 ,(+ 47 (* 14 number-of-input)) 50 14) controls)
    (push `(:button apply "͐ύX(&I)" #x50010000
            185 ,(+ 64 (* 14 number-of-input)) 50 14) controls)
    (push `(:static nil "(&N)" #x50020000
            264 ,(+ 67 (* 14 number-of-input)) 10 8) controls)
    (push `(:edit resize-num nil #x50812086
            238 ,(+ 64 (* 14 number-of-input)) 26 14) controls)
    (push `(:spin resize-numspin nil #x500000b6
            254 ,(+ 64 (* 14 number-of-input)) 10 14) controls)
    (push `(:button IDCANCEL "LZ" #x50010000
            185 ,(+ 81 (* 14 number-of-input)) 50 14) controls)

    (push `(:static nil "ݒ(&T):" #x50020001
            120 ,(+ 102 (* 14 number-of-input)) 30 8) controls)
    (push `(:combobox history nil #x50210842
            150 ,(+ 100 (* 14 number-of-input)) 80 80) controls)
    (push `(:button history-save "ۑ"  #x50010000
            234 ,(+ 100 (* 14 number-of-input)) 24 14) controls)
    (push `(:button history-load "Ǎ"  #x50010000
            260 ,(+ 100 (* 14 number-of-input)) 24 14) controls)
    (push `(:button history-del "폜"  #x50010000
            286 ,(+ 100 (* 14 number-of-input)) 24 14) controls)

    (setq controls (nreverse controls))

    ;; controls-initializers ̐
    (push `(case-fold . ,(cfs2dialog *multiple-replace-case-fold-search*)) controls-initializers)
    (push `(word . ,*multiple-replace-word-search*) controls-initializers)
    (push `(regexp . ,*multiple-replace-regexp-search*) controls-initializers)
    (push `(escseq . ,*multiple-replace-understand-escape-sequences*) controls-initializers)
    (push `(whole . ,*multiple-replace-replace-whole-buffer*) controls-initializers)
    (let (pattern-replacement-list)
      (if *multiple-replace-regexp-search*
          (setq pattern-replacement-list
                *last-multiple-search-replace-regexp-list*)
        (setq pattern-replacement-list
              *last-multiple-search-replace-string-list*))

      ; decode-escape-sequence ̕Ɠl̏ꍇ decode O̕
      (if (equalp (cdr *last-multiple-search-replace-string-list-pair*)
                  pattern-replacement-list)
          (setq pattern-replacement-list (car *last-multiple-search-replace-string-list-pair*)))
      (dotimes (i (min number-of-input (length pattern-replacement-list)))
        (push `(,(elt search-symbol-list i) . ,(car (elt pattern-replacement-list i)))
              controls-initializers)
        (push `(,(elt replace-symbol-list i) . ,(cdr (elt pattern-replacement-list i)))
              controls-initializers))
      (dotimes (i number-of-input)
        (push `(,(elt search-symbol-list i) . ,*minibuffer-search-string-history*)
              controls-initializers)
        (push `(,(elt replace-symbol-list i) . ,*minibuffer-search-string-history*)
              controls-initializers)))
    (push `(resize-num . ,(format nil "~D" *multiple-replace-dialog-number-of-input*))
          controls-initializers)

    (push (cons 'history history-name) controls-initializers)
    (push (cons 'history history-name-list) controls-initializers)

    (setq controls-initializers (nreverse controls-initializers))

    ;; controls-handlers ̐
    (push '(word :disable (regexp)) controls-handlers)
    (push `(resize-num :min ,*multiple-replace-dialog-number-of-input-min*
                       :max 99 :range-error
                       ,(format nil "~D ȏ 99 ȉw肵Ă"
                                *multiple-replace-dialog-number-of-input-min*)
                       :type integer :type-error "l͂Ă")
          controls-handlers)
    (push `(resize-numspin :min ,*multiple-replace-dialog-number-of-input-min*
                           :max 99) controls-handlers)
;    (push `(,(elt search-symbol-list 0) :non-null "͂"
;            :enable (query all)) controls-handlers)

    (setq controls-handlers (nreverse controls-handlers))

    ;;
    (setq dialog-template
          `(dialog 0 0 316 ,(+ 119 (* 14 number-of-input))
                   (:caption ,(let ((str "̒u"))
                                (if (stringp history-name)
                                    (setq str (format nil "~A - [~A]" str history-name)))
                                (if (or (and (stringp history-name)
                                             (multiple-replace-setting-file-get-filename history-name))
                                        (and (not history-name)
                                             *multiple-replace-setting-file-current-setting-p*))
                                    (setq str (format nil "~A - (~A)"
                                                      str (multiple-replace-setting-file-get-filename history-name))))
                                str))
                   (:font 9 "MS UI Gothic")
                   (:control
                    ,@controls)))
    (multiple-value-bind (result data)
        (dialog-box dialog-template
                    controls-initializers
                    controls-handlers)
      (when result
        (let (pattern-replacement-list j pattern replace)
          (dotimes (i number-of-input)
            (setq j (- number-of-input 1 i))
            (setq pattern (cdr (assoc (elt search-symbol-list j) data)))
            (setq replace (cdr (assoc (elt replace-symbol-list j) data)))
            (push (cons pattern replace) pattern-replacement-list)
            (if (stringp pattern)
                (add-history pattern '*minibuffer-search-string-history*))
            (if (stringp replace)
                (add-history replace '*minibuffer-search-string-history*)))

          (setq *multiple-replace-case-fold-search* (dialog2cfs (cdr (assoc 'case-fold data))))
          (setq *multiple-replace-word-search* (cdr (assoc 'word data)))
          (setq *multiple-replace-regexp-search* (cdr (assoc 'regexp data)))
          (setq *multiple-replace-understand-escape-sequences* (cdr (assoc 'escseq data)))
          (setq *multiple-replace-replace-whole-buffer* (cdr (assoc 'whole data)))
          (setq *multiple-replace-dialog-number-of-input* (cdr (assoc 'resize-num data)))
          (if *multiple-replace-understand-escape-sequences*
              (setq *last-multiple-search-replace-string-list-pair*
                    (cons (copy-tree pattern-replacement-list)
                          (setq pattern-replacement-list
                                (mapcar #'(lambda (pattern-replacement)
                                            (cons (decode-escape-sequence
                                                   (car pattern-replacement)
                                                   *multiple-replace-regexp-search*)
                                                  (decode-escape-sequence
                                                   (cdr pattern-replacement)
                                                   *multiple-replace-regexp-search*)))
                                        pattern-replacement-list))))
            (setq *last-multiple-search-replace-string-list-pair* nil))
          ;; Ǘ̓sAperform-multiple-replace łȂAłۑ
          (if *multiple-replace-regexp-search*
              (setq *last-multiple-search-replace-regexp-list*
                    pattern-replacement-list)
            (setq *last-multiple-search-replace-string-list*
                  pattern-replacement-list))

          (setq *last-multiple-replace-setting* (multiple-replace-make-setting))
          (setq history-name (cdr (assoc 'history data)))
          (if *multiple-replace-setting-file-current-setting-p*
              (multiple-replace-setting-file-save *last-multiple-replace-setting* nil))

          (cond
           ;; Kp
           ((eq result 'apply)
            (multiple-replace-dialog))
           ;; s
           ((or (eq result 'query) (eq result 'all))
            (when (cdr (assoc (elt search-symbol-list 0) data))
              (if *multiple-replace-replace-whole-buffer*
                  (goto-char (point-min)))
              (perform-multiple-replace pattern-replacement-list (eq result 'query)
                                        (and (null *multiple-replace-word-search*)
                                             *multiple-replace-regexp-search*)
                                        t nil)))
           ;; 폜
           ((eq result 'history-del)
            (let (pos)
              (if (setq pos
                        (position history-name *multiple-replace-setting-history*
                                  :key #'(lambda (h) (multiple-replace-get-setting-item h "history-name"))
                                  :test 'equal))
                  (setq *multiple-replace-setting-history*
                        (append (subseq *multiple-replace-setting-history* 0 pos)
                                (subseq *multiple-replace-setting-history* (1+ pos))))))
            (multiple-replace-setting-file-delete history-name)
            (multiple-replace-dialog))
           ;; ۑ
           ((eq result 'history-save)
            (let (pos)
              (when (string-match "^[ \t]*$" history-name)
                (setq history-name (format-date-string "%Y/%m/%d %H:%M:%S")))
              (if (setq pos
                        (position history-name *multiple-replace-setting-history*
                                  :key #'(lambda (h) (multiple-replace-get-setting-item h "history-name"))
                                  :test 'equal))
                  (setq *multiple-replace-setting-history*
                        (append (subseq *multiple-replace-setting-history* 0 pos)
                                (subseq *multiple-replace-setting-history* (1+ pos)))))
              (push (list (list (copy-string "history-name") history-name)
                          (list (copy-string "setting") *last-multiple-replace-setting*))
                    *multiple-replace-setting-history*))
            (multiple-replace-setting-file-save *last-multiple-replace-setting* history-name)
            (multiple-replace-dialog :history-name history-name))
           ;; Ǎ
           ((eq result 'history-load)
            (let (pos setting-with-name)
              (if (setq pos
                        (position history-name *multiple-replace-setting-history*
                                  :key #'(lambda (h) (multiple-replace-get-setting-item h "history-name"))
                                  :test 'equal))
                  (progn
                    (setq setting-with-name (nth pos *multiple-replace-setting-history*))
                    (setq *last-multiple-replace-setting* (multiple-replace-get-setting-item setting-with-name "setting"))
                    (setq *multiple-replace-setting-history*
                          (append (subseq *multiple-replace-setting-history* 0 pos)
                                  (subseq *multiple-replace-setting-history* (1+ pos))))
                    (push setting-with-name *multiple-replace-setting-history*)
                    (multiple-replace-setting-file-save *last-multiple-replace-setting* history-name)
                    (multiple-replace-dialog :history-name history-name))
                (multiple-replace-dialog :setting nil)))))
          t)))))

;; t@Cւ̕ۑ@\
(defun multiple-replace-setting-file-create-directory ()
  "multiple-replace-dialog ̐ݒ̕ۑtH_쐬B
        t   tH_쐬{
        nil tH_쐬𖢎{"
  (when (and (valid-path-p *multiple-replace-setting-file-directory*)
             (not (file-exist-p *multiple-replace-setting-file-directory*)))
    (create-directory *multiple-replace-setting-file-directory*)
    t))

(defun multiple-replace-setting-file-directory-valid-p ()
  "multiple-replace-dialog ̐ݒ̕ۑtH_̑݊mFB
        t   tH_݂
        nil tH_݂Ȃ"
  (and (valid-path-p *multiple-replace-setting-file-directory*)
       (file-exist-p *multiple-replace-setting-file-directory*)
       (file-directory-p *multiple-replace-setting-file-directory*)))

(defun multiple-replace-setting-file-get-filename (history-name)
  "ݒ薼ɑΉt@CԂB"
  (when (multiple-replace-setting-file-directory-valid-p)
    (let ((filenum 1) filename)
      (cond
       ((not (stringp history-name))
        (setq filename (format nil "~8,'0d.l" 0)))
       ((setq filename (cdr (assoc history-name *multiple-replace-setting-file-alist*
                                   :test #'string=))))
       (t
        (loop
          (setq filename (format nil "~8,'0d.l" filenum))
          (unless (file-exist-p (merge-pathnames filename *multiple-replace-setting-file-directory*))
            (return))
          (incf filenum))))
      filename)))

(defun multiple-replace-setting-file-format (from to)
  (interactive "*r")
  (if (> from to) (rotatef from to))
  (save-excursion
    (lisp-mode)
    (save-restriction
      (narrow-to-region from to)
      (goto-char (point-min))
      (while (scan-buffer " *(+" :regexp t)
        (when (eq (parse-point-syntax (point)) nil)
          (unless (= (point) (point-min))
            (newline)
            (lisp-indent-line))
          (skip-chars-forward "("))))))

(defun multiple-replace-setting-file-save (setting history-name)
  "ݒۑB"
  (when (multiple-replace-setting-file-directory-valid-p)
    (save-excursion
      (let ((temp-buffer (create-new-buffer " multiple-replace"))
            (filename (multiple-replace-setting-file-get-filename history-name))
            (setting-with-name (list (list (copy-string "history-name") history-name)
                                     (list (copy-string "setting") setting)))
            setting-string)
        (save-excursion
          (set-buffer temp-buffer)
          (insert (format nil "~S~%" setting-with-name))
          (multiple-replace-setting-file-format (point-min) (point-max))
          (setq setting-string (buffer-substring (point-min) (point-max))))
        (delete-buffer temp-buffer)
        (with-open-file (fp (merge-pathnames filename *multiple-replace-setting-file-directory*)
                            :direction :output
                            :if-exists :overwrite
                            :if-does-not-exist :create)
          (format fp "~A" setting-string))))))

(defun multiple-replace-setting-file-save-all ()
  "SĂ̐ݒt@CɕۑB
ʏsȂ֐
ݒۑtH_쐬ȂǁASݒt@CꍇɎsB"
  (when (multiple-replace-setting-file-directory-valid-p)
    (let (setting history-name)
      (if *multiple-replace-setting-file-current-setting-p*
          (multiple-replace-setting-file-save *last-multiple-replace-setting* nil))
      (dolist (setting-with-name *multiple-replace-setting-history*)
        (setq history-name (multiple-replace-get-setting-item setting-with-name "history-name"))
        (setq setting (multiple-replace-get-setting-item setting-with-name "setting"))
        (multiple-replace-setting-file-save setting history-name)))))

(defun multiple-replace-setting-file-load-all ()
  "ݒt@CSĂǂݍށB
multiple-replace-dialog ̏JnɖsB"
  (when (multiple-replace-setting-file-directory-valid-p)
    (let (setting-with-name setting history-name pos)
      (setq *multiple-replace-setting-file-alist* nil)
      (dolist (file-info (stable-sort (directory *multiple-replace-setting-file-directory*
                                                 :wild "*.l"
                                                 :file-only t
                                                 :absolute t
                                                 :file-info t)
                                      #'< :key #'caddr))
        (with-open-file (fp (car file-info) :direction :input)
          (setq setting-with-name (read fp))
          (setq history-name (multiple-replace-get-setting-item setting-with-name "history-name"))
          (setq setting (multiple-replace-get-setting-item setting-with-name "setting"))
          (cond
           ;; Jg
           ((not (stringp history-name))
            (multiple-replace-load-setting setting)
            (setq *last-multiple-replace-setting* setting))
           ;; XV
           ((setq pos (position history-name *multiple-replace-setting-history*
                                :key #'(lambda (h) (multiple-replace-get-setting-item h "history-name"))
                                :test #'string=))
            (setf (nth pos *multiple-replace-setting-history*) setting-with-name))
           ;; ǉ
           (t
            (push setting-with-name *multiple-replace-setting-history*))))
        (push (cons history-name (file-namestring (car file-info)))
              *multiple-replace-setting-file-alist*)))))

(defun multiple-replace-setting-file-delete (history-name)
  "ݒt@C폜B"
  (when (multiple-replace-setting-file-directory-valid-p)
    (let ((filename (multiple-replace-setting-file-get-filename history-name)))
      (when (and (stringp filename)
                 (file-exist-p (merge-pathnames filename *multiple-replace-setting-file-directory*)))
        (delete-file (merge-pathnames filename *multiple-replace-setting-file-directory*))))))

;; e풲
(defun multiple-replace-insert-menu-items (&key menu pre-tag position head-sep tail-sep)
  "j[ɃR}hǉ"
  (if (and (not (menup menu)) (menup *app-menu*))
      (setq menu (get-menu *app-menu* 'ed::search)))
  (when (menup menu)
    (multiple-replace-delete-menu menu)
    (unless (or pre-tag position)
      (setq pre-tag 'ed::replace-dialog))
    (when (and pre-tag
               (setq position (get-menu-position menu pre-tag)))
      (incf position))
    (unless (and (numberp position) (integerp position) (not (minusp position))
                 (get-menu menu position t))
      (setq position -1)
      (while (get-menu menu (incf position) t)))
    (decf position)
    (if (and head-sep
             (not (minusp position))
             (get-menu menu position t))
        (insert-menu-separator menu (incf position) 'multiple-replace-dialog-sep))
    (insert-menu-item menu (incf position) 'multiple-replace-dialog
                      "u(&Q)..." 'multiple-replace-dialog)
    (if (and tail-sep
             (get-menu menu (incf position) t))
        (insert-menu-separator menu position 'multiple-replace-dialog-sep))))

(defun multiple-replace-delete-menu (&optional menu)
  "j[R}h폜"
  (if (and (not (menup menu)) (menup *app-menu*))
      (setq menu (get-menu *app-menu* 'ed::search)))
  (when (menup menu)
    (while (delete-menu menu 'multiple-replace-dialog))
    (while (delete-menu menu 'multiple-replace-dialog-sep))))

(defun multiple-replace-uninstall ()
  "multiple-replace ̃ACXg["
  (let ((history-variables
         '(*last-multiple-search-replace-string-list*
           *last-multiple-search-replace-regexp-list*
           *last-multiple-search-replace-string-list-pair*
           *last-multiple-replace-setting*
           *multiple-replace-setting-history*)))
    (dolist (variable history-variables)
      (unregister-history-variable variable)))
  (multiple-replace-delete-menu))

(if (menup ed::*app-menu*)
    (multiple-replace-insert-menu-items)
  (add-hook 'ed::*init-app-menus-hook*
            #'(lambda () (multiple-replace-insert-menu-items))))

;;; multiple-replace.l ends here
