;;; -*- Mode: Lisp; Package: EDITOR -*-
;;; manued-mode.l --- Manued t@CҏWp}Ci[/W[[h

;; Copyright (C) 2001-2005 OHKUBO Hiroshi <ohkubo@s53.xrea.com>

;; Author: OHKUBO Hiroshi <ohkubo@s53.xrea.com>
;; Version: 0.0.2.0
;; Time-stamp: <2005/10/08 14:25:03 +0900>

;;; Commentary:

;; Description:
;;
;;  Manued t@CҏWp}Ci[/W[[h
;;
;;    ^K (Manued : Manuscript Editing language)
;;      http://www.mpi-sb.mpg.de/~hitoshi/otherprojects/manued/index-j.shtml
;;      http://www.mpi-sb.mpg.de/~hitoshi/otherprojects/manued/manued-j/manued-j.html
;;
;;    񋟂@\
;;    EZ̃nCCg
;;    EZp̐
;;    EZL̓ZO̕𒊏o
;;    EZL̓Z̕𒊏o
;;    EZʒũT[`@\
;;    EZL͕⏕
;;    EZҏW⏕
;;    E^KV{̍Ē`
;;

;; Installation:
;;
;;      1. A[JCuWJ manued-mode.l  $XYZZY/site-lisp 
;;         Rs[܂B
;;
;;      2. oCgRpC܂B
;;
;;              M-x byte-compile-file
;;              Byte compile file: $XYZZY/site-lisp/manued-mode.l
;;
;;      3. ~/.xyzzy ܂ $XYZZY/site-lisp/siteinit.l Ɉȉ̃R[h
;;         ǉ܂B
;;
;;              (require "manued-mode")
;;
;;      4. L̐ݒ𔽉f邽߂ɁAxyzzy ċN܂B
;;         siteinit.l ɋLqꍇ Ctrl L[ Shift L[Ȃ
;;         xyzzy ċNA_vt@Cč\z܂B
;;

;; Uninstallation:
;;
;;      1. manued-mode.l ɊւLq폜܂B
;;
;;      2. siteinit.l ɋLqĂꍇ Ctrl L[ Shift L[
;;         Ȃ xyzzy ċNA_vt@Cč\z܂B
;;

;; Usage:
;;
;;      M-x manued-mode
;;      M-x manued-minor-mode
;;

;; Key bind:
;;      
;;      manued-minor-mode
;;
;;      M-n          ̃R}hֈړ
;;      M-p          ÕR}hֈړ
;;      M-N          x̎̃R}hֈړ
;;      M-P          x̑ÕR}hֈړ
;;      M-]          ΉR}hJֈړ
;;      C-l          ʕ\̍XV
;;      C-c C-m e    G[ʒuֈړ
;;      C-c C-m C-e  ÕR}h]
;;
;;      C-c C-m C-d  [W delete R}hɕϊ
;;      C-c C-m C-s  [W swap R}hɕϊ
;;      C-c C-m C-c  [W comment ɕϊ
;;
;;      C-c C-m d    delete R}h̕ҏW
;;      C-c C-m s    swap R}h̕ҏW
;;      C-c C-m c    Rg̕ҏW
;;      C-c C-m C-m  󋵂ɉR}h/Rg̕ҏW
;;
;;      S-Apps       Manued j[ (Selection p)
;;      S-ENbN Manued j[ (Selection p)
;;
;;
;;      manued-mode
;;
;;      M-n          ̃R}hֈړ
;;      M-p          ÕR}hֈړ
;;      M-N          x̎̃R}hֈړ
;;      M-P          x̑ÕR}hֈړ
;;      M-]          ΉR}hJֈړ
;;      C-l          ʕ\̍XV
;;      C-c C-m e    G[ʒuֈړ
;;      C-c C-m C-e  ÕR}h]
;;
;;      C-c C-m C-d  [W delete R}hɕϊ
;;      C-c C-m C-s  [W swap R}hɕϊ
;;      C-c C-m C-c  [W comment ɕϊ
;;
;;      C-\          undo (manued-mode Ȃ read-only ł undo)
;;      C-w          [W delete R}hɕϊ (C-c C-m C-d Ɠ)
;;      C-d          ZNV܂݈͌ʒu delete R}hɕϊ
;;      Delete       
;;      C-h          ZNV܂͒Oʒu delete R}hɕϊ
;;      C-k          ݈ʒus܂ł delete R}hɕϊ
;;
;;      C-c C-m d    delete R}h̕ҏW
;;      d            
;;      C-c C-m s    swap R}h̕ҏW
;;      s            
;;      C-c C-m c    Rg̕ҏW
;;      c            
;;      C-c C-m C-m  󋵂ɉR}h/Rg̕ҏW
;;      C-m          
;;
;;      S-Apps       Manued j[ (Selection p)
;;      S-ENbN Manued j[ (Selection p)
;;

;; Setting example:
;;
;;      (require "manued-mode")
;;

;; Customize:
;;
;;      (define-key *manued-minor-mode-map* ... ...)
;;      (define-key *manued-mode-map* ... ...)
;;
;;      (setq *manued-l-parenthesis-attributes* ...)
;;      (setq *manued-r-parenthesis-attributes* ...)
;;      (setq *manued-delete-attributes* ...)
;;      (setq *manued-swap-attributes* ...)
;;      (setq *manued-comment-attributes* ...)
;;      (setq *manued-older-contents-attributes* ...)
;;      (setq *manued-newer-contents-attributes* ...)
;;      (setq *manued-swap-a-contents-attributes* ...)
;;      (setq *manued-swap-b-contents-attributes* ...)
;;      (setq *manued-swap-c-contents-attributes* ...)
;;      (setq *manued-comment-contents-attributes* ...)
;;
;;      (setq-default manued-l-parenthesis-str "[")
;;      (setq-default manued-r-parenthesis-str "]")
;;      (setq-default manued-delete-str "/")
;;      (setq-default manued-swap-str "|")
;;      (setq-default manued-comment-str ";")
;;      (setq-default manued-escape-str "~")
;;      (setq-default manued-order-str "older-first")
;;      (setq-default manued-version-str "0.0.0.0-manued-mode_for_xyzzy")
;;
;;      (setq-default manued-command-with-comment-p t)
;;      (setq-default manued-defcommand-head-regexp "%+")
;;
;;      (setq *manued-menu-name* "&Manued")
;;      (setq *manued-menu-position* 'ed::help)
;;

;; Changes:
;;
;;      [Version 0.0.2.0]
;;      Sat, 08 Oct 2005 14:23:48 +0900
;;        E[AhXύXB
;;        ECZX(CBSDCZX)LځB
;;
;;      [Version 0.0.1.1]
;;      Sun, 13 Feb 2005 22:25:39 +0900
;;        Efind-text-attribute  find-text-attribute-if ɕύXB
;;
;;      [Version 0.0.1.0]
;;      Thu, 10 Feb 2005 00:20:04 +0900
;;        Eset-text-attribute ɈˑR[hɑSʕύXB
;;      Tue, 08 Feb 2005 21:07:19 +0900
;;        E쐬
;;      Fri, 21 Jan 2005 18:04:30 +0900
;;        E쐬Jn
;;

;; Specification:
;;
;;    manued-mode.l ver. 0.0.1.0 ł̏CL`R}h (defcommand)
;;
;;      defparentheses  [ ]
;;      defdelete       /
;;      defswap         |
;;      defcomment      ;
;;      defescape       ~
;;      deforder        older-first
;;      defversion      0.0.1.0-manued-mode_for_xyzzy
;;
;;    manued-mode.l ver. 0.0.1.0 ł Manued R}h (manued-command)
;;
;;      Manued R}h default ̋LpĐB
;;
;;      E[A/B]
;;             AAB}B
;;
;;             [A/] : A B(A 󕶎Œu)
;;             [/A] : A }B(󕶎 A Œu)
;;
;;      E[A|B|C]
;;             AC̈ʒuꊷACBA̕тŏo͂B
;;
;;             [A||C] ACꊷB
;;
;;      E[; comment ]
;;             ;  ] ܂ł̓RgƂȂB
;;
;;    manued-mode.l ł̏CL`R}h̋Lq\ꏊ
;;
;;      buffer ̐擪̂݁B
;;      narrowing ĂꍇłAbuffer 擪̏CL`R}ĥ݂
;;      ]B
;;

;; Memo
;;
;;  Manued tH[}bĝ̐
;;  
;;   Ecommand Oł́A~ ̒ command ݒłȂB
;;    
;;               fR[h㕶AR}h     
;;    񄵄
;;             command O       command     
;;    
;;       [   (l-parenthesis)  (l-parenthesis) 
;;    
;;      ~[         "["              "["       
;;    
;;     ~~[        "~["      "~"(l-parenthesis)
;;    
;;    ~~~[       "~~["             "~["       
;;    
;;
;;
;;  t̒`
;;
;;    ȉł́AManued R}hƂ default ̋LpĐB
;;
;;    Ecommand
;;        Manued R}ĥƁB[ n܂ ] ŏIB
;;
;;    Ecommand  (in-command)
;;        [ ̌̃|CgAΉ ] ̌̃|Cg܂ł͈̔́B
;;        ɂđΏ command w肹Ɂucommand vƂtg
;;        pꍇ́AlXgĂ command ̈ԊO command 
;;        ΏۂƂB
;;        command Jn [ ̃|Cǵucommand vł͂ȂB
;;
;;    Ecommand O (out-command)
;;        ucommand vłȂ̈B
;;
;;    Etop-level
;;        Manued tH[}bgł command ̓lXg\łB
;;         command ɂ܂܂Ȃ̈ top-level ƂB
;;        ucommand Ov̗̈̑̂Ƃđ邱Ƃ\B
;;
;;    Ecurrent-level
;;        ݂̃|Cg܂܂œ command  command ̈̑́B
;;        ݂̃|Cg command Oł΁Atop-level ƓB
;;
;;    Enarrow-range
;;        command A  narrow-range ƌꍇA command A 
;;        command ̈ƓB
;;        command A ̊Jn [  command A  narrow-range Ɋ܂
;;        ȂB
;;
;;    Ewide-range
;;        narrow-range ̗̈ɁAcommand Jn [ ݂̑̈
;;        ́B
;;        command A ̊Jn [  command A  wide-range Ɋ܂܂B
;;
;;    ER}h
;;        Manued ł̏CLB
;;        ۂ Manued R}h`Ă邩ۂɂ͖֌WB
;;
;;    EGXP[v
;;        uR}hv̂܂܋LڂƁAManued R}h`
;;        镶ƂĔFĂ܂ꍇɁAʏ̕ƂĔF
;;        邽߂ɍsB
;;        q́uGXP[vvΏە̑Oɑ}邱ƂōsB
;;
;;    EGXP[v (escape-str)
;;        uGXP[vv邽߂ɗp镶B
;;
;;    EGXP[v\
;;        uGXP[vvۂɍsĂ镶B
;;
;;    ER}h\
;;        ۂ Manued R}h`uR}hvB
;;        uR}hvuR}h\vł邩ۂ́A
;;        ̏oꏊ́ucommand /OvAGXP[vɂB
;;
;;
;;  Manued ł command /O ł̃GXP[vɂ
;;
;;    Manued tH[}bgł́Acommand Oł l-parenthesis-str ݂̂
;;    uR}h\vƂĂ̈ӖAGXP[vΏۂƂȂB
;;    Acommand OłĂAl-parenthesis-str ̒Oł΁A
;;    escape-str ́uGXP[v\vłAuGXP[vvƂ
;;    ̈ӖB
;;    ӂȂ΂ȂȂ_Ƃ command ȌꍇAescape-str ̑O
;;     escape-str ɂ́uGXP[vv̖͂ȂBPȂ镶łB
;;
;;    r-parenthesis-str, delete-str, swap-str, coment-str, y
;;    escape-str ͏LOAcommand ł̂݁uR}h\v
;;    uGXP[v\vłB
;;
;;  command /O ł邱Ƃ̔fKvȃV`G[V
;;
;;    r-parenthesis-str, delete-str, swap-str, comment-str 
;;      uR}h\v肷ꍇB
;;
;;    OGXP[v肷ꍇB
;;
;;      EO escape-str Ȃ          ~
;;      ݈ʒu l-parenthesis-str ꍇ
;;      EO escape-str  1        
;;      command ̏ꍇ
;;      EO escape-str     
;;      EO escape-str     ~
;;      command Ȍꍇ
;;      E==========================    
;;      ݈ʒu l-parenthesis-str Ȃꍇ
;;      command ̏ꍇ
;;      EO escape-str     
;;      EO escape-str     ~
;;      command Ȍꍇ
;;      E==========================    ~
;;      ----------------------------------------
;;         command /O 
;;      ----------------------------------------
;;      EO escape-str Ȃ          ~
;;      ݈ʒu l-parenthesis-str ꍇ
;;      EO escape-str       
;;      O escape-str ̏ꍇ
;;      Ecommand                     ~
;;      Ecommand O                    
;;      ݈ʒu l-parenthesis-str Ȃꍇ
;;      EO escape-str       ~
;;      O escape-str ̏ꍇ
;;      Ecommand                     
;;      Ecommand O                    ~
;;

;; Licence:
;;
;;    manued-mode ͏CBSDCZXɊÂėp\łB
;;    <http://www.opensource.org/licenses/bsd-license.php>
;;
;;
;;    Copyright (C) 2001-2005, OHKUBO Hiroshi.  All rights reserved.
;;
;;    Redistribution and use in source and binary forms, with or without
;;    modification, are permitted provided that the following conditions
;;    are met:
;;
;;    1. Redistributions of source code must retain the above copyright
;;       notice, this list of conditions and the following disclaimer.
;;
;;    2. Redistributions in binary form must reproduce the above copyright
;;       notice, this list of conditions and the following disclaimer in
;;       the documentation and/or other materials provided with the
;;       distribution.
;;
;;    3. Neither the name of the University nor the names of its
;;       contributors may be used to endorse or promote products derived
;;       from this software without specific prior written permission.
;;
;;    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
;;    ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
;;    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
;;    A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
;;    OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
;;    SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
;;    LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
;;    DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
;;    THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
;;    (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
;;    OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
;;

;;; Code:

(provide "manued-mode")

(in-package "editor")

(export '(*manued-version*
          *manued-minor-mode-map*
          *manued-mode-map*
          *manued-mode-hook*
          *manued-l-parenthesis-attributes*
          *manued-r-parenthesis-attributes*
          *manued-delete-attributes*
          *manued-swap-attributes*
          *manued-comment-attributes*
          *manued-older-contents-attributes*
          *manued-newer-contents-attributes*
          *manued-swap-a-contents-attributes*
          *manued-swap-b-contents-attributes*
          *manued-swap-c-contents-attributes*
          *manued-comment-contents-attributes*
          manued-l-parenthesis-str
          manued-r-parenthesis-str
          manued-delete-str
          manued-swap-str
          manued-comment-str
          manued-escape-str
          manued-order-str
          manued-version-str
          manued-command-with-comment-p
          manued-defcommand-head-regexp
          manued-insert-header
          manued-goto-last-parse-command-error-point
          manued-forward-l-parenthesis
          manued-backward-l-parenthesis
          manued-forward-l-parenthesis-current-level
          manued-backward-l-parenthesis-current-level
          manued-goto-matched-parenthesis
          manued-eval-last-command
          manued-eval-command-region
          manued-eval-command-region-old
          manued-eval-command-selection
          manued-eval-command-selection-old
          manued-undo
          manued-toggle-command-with-comment
          manued-delete-command-region
          manued-delete-command-selection
          manued-delete-command-line
          manued-delete-command-char
          manued-delete-command-backward-char
          manued-delete-command-char-or-selection
          manued-delete-command-backward-char-or-selection
          manued-swap-command-region
          manued-swap-command-selection
          manued-comment-region
          manued-comment-selection
          manued-edit-delete-newer-contents
          manued-change-swap-boundary
          manued-edit-comment-contents
          manued-edit-command
          manued-convert-to-manued-document
          manued-extract-normal-old-document
          manued-extract-normal-new-document
          manued-recenter
          manued-mouse-menu-popup
          manued-apps-popup
          manued-minor-mode
          manued-mode))

(defconstant *manued-version* "0.0.2.0"
  "manued-mode ̃o[W")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; manued-minor-mode p
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defvar-local manued-minor-mode nil)

(defvar *manued-minor-mode-map* nil
  "manued-minor-mode ̃L[}bv")
(unless *manued-minor-mode-map*
  (setq *manued-minor-mode-map* (make-sparse-keymap))
  (define-key *manued-minor-mode-map* #\M-n 'manued-forward-l-parenthesis)
  (define-key *manued-minor-mode-map* #\M-p 'manued-backward-l-parenthesis)
  (define-key *manued-minor-mode-map* #\M-N 'manued-forward-l-parenthesis-current-level)
  (define-key *manued-minor-mode-map* #\M-P 'manued-backward-l-parenthesis-current-level)
  (define-key *manued-minor-mode-map* #\M-] 'manued-goto-matched-parenthesis)
  (define-key *manued-minor-mode-map* #\C-l 'manued-recenter)
  (define-key *manued-minor-mode-map* '(#\C-c #\C-m #\e) 'manued-goto-last-parse-command-error-point)
  (define-key *manued-minor-mode-map* '(#\C-c #\C-m #\C-e) 'manued-eval-last-command)
  ;;
  (define-key *manued-minor-mode-map* '(#\C-c #\C-m #\C-d) 'manued-delete-command-region)
  (define-key *manued-minor-mode-map* '(#\C-c #\C-m #\C-s) 'manued-swap-command-region)
  (define-key *manued-minor-mode-map* '(#\C-c #\C-m #\C-c) 'manued-comment-region)
  ;;
  (define-key *manued-minor-mode-map* '(#\C-c #\C-m #\d) 'manued-edit-delete-newer-contents)
  (define-key *manued-minor-mode-map* '(#\C-c #\C-m #\s) 'manued-change-swap-boundary)
  (define-key *manued-minor-mode-map* '(#\C-c #\C-m #\c) 'manued-edit-comment-contents)
  (define-key *manued-minor-mode-map* '(#\C-c #\C-m #\C-m) 'manued-edit-command)
  ;;
  (define-key *manued-minor-mode-map* #\S-RBtnDown 'mouse-nop)
  (define-key *manued-minor-mode-map* #\S-RBtnUp 'manued-mouse-menu-popup)
  (define-key *manued-minor-mode-map* #\S-Apps 'manued-apps-popup))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; manued-mode p
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defvar *manued-mode-hook* nil
  "manued-mode ̃tbNϐ")
(defvar *manued-keyword-hash-table* nil
  "manued-mode ̃L[[hnbVe[u")
(defvar *manued-keyword-file* "MANUED"
  "manued-mode ̃L[[ht@C")

(defvar *manued-mode-map* nil
  "manued-mode ̃L[}bv")
(unless *manued-mode-map*
  (setq *manued-mode-map* (make-sparse-keymap))
  (define-key *manued-mode-map* #\M-n 'manued-forward-l-parenthesis)
  (define-key *manued-mode-map* #\M-p 'manued-backward-l-parenthesis)
  (define-key *manued-mode-map* #\M-N 'manued-forward-l-parenthesis-current-level)
  (define-key *manued-mode-map* #\M-P 'manued-backward-l-parenthesis-current-level)
  (define-key *manued-mode-map* #\M-] 'manued-goto-matched-parenthesis)
  (define-key *manued-mode-map* #\C-l 'manued-recenter)
  (define-key *manued-mode-map* '(#\C-c #\C-m #\e) 'manued-goto-last-parse-command-error-point)
  (define-key *manued-mode-map* '(#\C-c #\C-m #\C-e) 'manued-eval-last-command)
  ;;
  (define-key *manued-mode-map* '(#\C-c #\C-m #\C-d) 'manued-delete-command-region)
  (define-key *manued-mode-map* '(#\C-c #\C-m #\C-s) 'manued-swap-command-region)
  (define-key *manued-mode-map* '(#\C-c #\C-m #\C-c) 'manued-comment-region)
  ;;
  (define-key *manued-mode-map* #\C-\\ 'manued-undo)
  (define-key *manued-mode-map* #\C-w 'manued-delete-command-region)
  (define-key *manued-mode-map* #\C-d 'manued-delete-command-char-or-selection)
  (define-key *manued-mode-map* #\Delete 'manued-delete-command-char-or-selection)
  (define-key *manued-mode-map* #\C-h 'manued-delete-command-backward-char-or-selection)
  (define-key *manued-mode-map* #\C-k 'manued-delete-command-line)
  ;;
  (define-key *manued-mode-map* '(#\C-c #\C-m #\d) 'manued-edit-delete-newer-contents)
  (define-key *manued-mode-map* '(#\C-c #\C-m #\s) 'manued-change-swap-boundary)
  (define-key *manued-mode-map* '(#\C-c #\C-m #\c) 'manued-edit-comment-contents)
  (define-key *manued-mode-map* '(#\C-c #\C-m #\C-m) 'manued-edit-command)
  (define-key *manued-mode-map* #\d 'manued-edit-delete-newer-contents)
  (define-key *manued-mode-map* #\s 'manued-change-swap-boundary)
  (define-key *manued-mode-map* #\c 'manued-edit-comment-contents)
  (define-key *manued-mode-map* #\C-m 'manued-edit-command)
  ;;
  (define-key *manued-mode-map* #\S-RBtnDown 'mouse-nop)
  (define-key *manued-mode-map* #\S-RBtnUp 'manued-mouse-menu-popup)
  (define-key *manued-mode-map* #\S-Apps 'manued-apps-popup))

(defvar *manued-mode-abbrev-table* nil
  "manued-mode  abbrev-table")
(unless *manued-mode-abbrev-table*
  (define-abbrev-table '*manued-mode-abbrev-table*))

(defvar *manued-mode-syntax-table* nil
  "manued-mode ̃V^bNXe[u")
(unless *manued-mode-syntax-table*
  (setq *manued-mode-syntax-table* (make-syntax-table))
  (set-syntax-symbol *manued-mode-syntax-table* #\&)
  (set-syntax-symbol *manued-mode-syntax-table* #\*)
  (set-syntax-symbol *manued-mode-syntax-table* #\+)
  (set-syntax-symbol *manued-mode-syntax-table* #\-)
  (set-syntax-symbol *manued-mode-syntax-table* #\/)
  (set-syntax-symbol *manued-mode-syntax-table* #\<)
  (set-syntax-symbol *manued-mode-syntax-table* #\=)
  (set-syntax-symbol *manued-mode-syntax-table* #\>)
  (set-syntax-symbol *manued-mode-syntax-table* #\_)
  (set-syntax-symbol *manued-mode-syntax-table* #\|))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; \p
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defvar *manued-l-parenthesis-attributes* '(:foreground 1 :bold t)
  "l-parenthesis \")
(defvar *manued-r-parenthesis-attributes* '(:foreground 1 :bold t)
  "r-parenthesis \")
(defvar *manued-delete-attributes* '(:foreground 1 :bold t)
  "delete \")
(defvar *manued-swap-attributes* '(:foreground 1 :bold t)
  "swap \")
(defvar *manued-comment-attributes* '(:foreground 1 :bold t)
  "comment \")
(defvar *manued-older-contents-attributes* '(:foreground 15 :strike-out t)
  "older-contents \")
(defvar *manued-newer-contents-attributes* '(:background 3 :bold t)
  "newer-contents \")
(defvar *manued-swap-a-contents-attributes* '(:foreground 4 :background 3 :bold t)
  "swap-a-contents \")
(defvar *manued-swap-b-contents-attributes* '(:background 3)
  "swap-b-contents \")
(defvar *manued-swap-c-contents-attributes* '(:foreground 5 :background 3 :bold t)
  "swap-c-contents \")
(defvar *manued-comment-contents-attributes* '(:foreground 7 :background 15)
  "comment-contents \")

(defvar *manued-tag* 'manued
  "\ݒ莞^O")
(defvar *manued-eval-command-tag* 'manued-eval-command
  "]㕶̕\ݒ莞^O")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; ݒl
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defconstant *manued-default-l-parenthesis-str* "["
  "l-parenthesis-str ̃ftHgl")
(defconstant *manued-default-r-parenthesis-str* "]"
  "r-parenthesis-str ̃ftHgl")
(defconstant *manued-default-delete-str* "/"
  "delete-str ̃ftHgl")
(defconstant *manued-default-swap-str* "|"
  "swap-str ̃ftHgl")
(defconstant *manued-default-comment-str* ";"
  "comment-str ̃ftHgl")
(defconstant *manued-default-escape-str* "~"
  "escape-str ̃ftHgl")
(defconstant *manued-default-order-str* "older-first"
  "order-str ̃ftHgl")
(defconstant *manued-default-version-str*
  (format nil "~A-manued-mode_for_xyzzy" *manued-version*)
  "version-str ̃ftHgl")

(defvar-local manued-l-parenthesis-str *manued-default-l-parenthesis-str*
  "݂̃obt@ l-parenthesis-str ̒l")
(defvar-local manued-r-parenthesis-str *manued-default-r-parenthesis-str*
  "݂̃obt@ r-parenthesis-str ̒l")
(defvar-local manued-delete-str *manued-default-delete-str*
  "݂̃obt@ delete-str ̒l")
(defvar-local manued-swap-str *manued-default-swap-str*
  "݂̃obt@ swap-str ̒l")
(defvar-local manued-comment-str *manued-default-comment-str*
  "݂̃obt@ comment-str ̒l")
(defvar-local manued-escape-str *manued-default-escape-str*
  "݂̃obt@ escape-str ̒l")
(defvar-local manued-order-str *manued-default-order-str*
  "݂̃obt@ order-str ̒l")
(defvar-local manued-version-str *manued-default-version-str*
  "݂̃obt@ version-str ̒l")

(defconstant *manued-order-str-list*
  '("older-first" "older-last" "newer-first" "newer-last")
  "order-str ɐݒ\ȕ")

(defvar-local manued-command-with-comment-p t
  "R}hǉ comment-str 𖖔ɂ邩")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; }N
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defmacro with-manued-mode-edit (&body body)
  `(when (or (not buffer-read-only)
             (eq buffer-mode 'manued-mode))
     (let ((buffer-read-only nil))
       (declare (special buffer-read-only))
       ,@body)))
(setf (get 'with-manued-mode-edit 'ed:lisp-indent-hook) 0)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; defcommand ֘A
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; manued-point-min
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defvar-local manued-point-min-maker nil
  "manued-point-min p}[J[")

(defun manued-set-point-min-marker (&optional point)
  (unless (markerp manued-point-min-maker)
    (setq manued-point-min-maker (make-marker)))
  (set-marker manued-point-min-maker (or point (point))))

(defun manued-get-point-min-marker ()
  (and (markerp manued-point-min-maker)
       (marker-point manued-point-min-maker)))

(defun manued-point-min ()
  "defcommand l point-min 擾"
  (or (manued-get-point-min-marker)
      (progn
        (manued-eval-defcommand)
        (manued-get-point-min-marker))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; defcommand
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defvar-local manued-defcommand-head-regexp "%+"
  "defcommand ̑Oɑ݂Ă悢(݂ȂĂ悢)K\B
܂AQƉ\ȃO[sOgpĂĂ͂ȂB
\(obt@[J\)B")

(defvar *manued-defcommand-alist*
  '(("defparentheses" manued-l-parenthesis-str manued-r-parenthesis-str)
    ("defdelete"      manued-delete-str)
    ("defswap"        manued-swap-str)
    ("defcomment"     manued-comment-str)
    ("defescape"      manued-escape-str)
    ("deforder"       manued-order-str)
    ("defversion"     manued-version-str))
  "defcommand ƑΉϐ̐ݒ")

(defun manued-get-defcommand ()
  "ݍs defcommand (ƑΉ镶)Ԃ"
  (save-excursion
    (goto-bol)
    (looking-at (concat "\\(?:" manued-defcommand-head-regexp "\\)?"
                        "\\("
                        (substring (format nil "~{\\|~A~}"
                                           (mapcar #'(lambda (x) (regexp-quote (car x)))
                                                   *manued-defcommand-alist*))
                                   2)
                        "\\)[ \t]+\\(.*\\)"))
    (values (match-string 1) (match-string 2))))

(defun manued-defcommand-exist-p ()
  "obt@擪 defcommand ݂邩"
  (save-excursion
    (save-restriction
      (widen)
      (goto-char (point-min))
      (and (manued-get-defcommand) t))))

(defun manued-eval-defcommand ()
  "obt@擪 defcommand ]Aobt@[JϐɐݒB
manued-point-min XV"
  (interactive)
  (let (defcommand value split-values symbols)
    (if (manued-defcommand-exist-p)
        (save-excursion
          (save-restriction
            (widen)
            (goto-char (point-min))
            (while (multiple-value-setq (defcommand value) (manued-get-defcommand))
              (setq split-values (split-string value " \t"))
              (when (setq symbols (cdr (find defcommand *manued-defcommand-alist*
                                             :key #'car :test #'string=)))
                (dolist (symbol symbols)
                  (set symbol (pop split-values))))
              (unless (forward-line)
                (return)))
            (manued-set-point-min-marker)))
      (manued-set-point-min-marker 0))))

(defun manued-order-older-first-p ()
  "delete R}h older 悩"
  (not (member manued-order-str '("older-last" "newer-first")
               :test #'string=)))

(defun manued-insert-header ()
  "defcommand wb_}"
  (interactive)
  (with-manued-mode-edit
    (dolist (defcommand *manued-defcommand-alist*)
      (insert (format nil "~14@A" (car defcommand)))
      (dolist (val-symbol (cdr defcommand))
        (insert (format nil " ~A" (symbol-value val-symbol))))
      (insert "\n"))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; special-str ֘A
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun manued-get-special-str-regexp (&optional special-str-list)
  "manued ̓ʂȕ𔻒肷邽߂̐K\Ԃ"
  (unless special-str-list
    (setq special-str-list
          (list manued-l-parenthesis-str manued-r-parenthesis-str
                manued-delete-str manued-swap-str
                manued-comment-str manued-escape-str)))
  (concat "\\("
          (substring (format nil "~{\\|~A~}"
                             (mapcar #'regexp-quote special-str-list))
                     2)
          "\\)"))

(defun manued-special-str-point-p (&optional point)
  "point ʒu manued ̓ʂȕ񂪊JnĂ邩B
̊֐ł̓GXP[v͍lȂB"
  (let ((special-str-regexp (manued-get-special-str-regexp)))
    (save-excursion
      (when point (goto-char point))
      (looking-at special-str-regexp))))

(defun manued-goto-special-str-in-command (&optional no-dup)
  "special-str ܂ňړ
ӁFcommand Ŏgp\Ȋ֐B"
  (let ((special-str-regexp (manued-get-special-str-regexp))
        from match-str)
    (save-excursion
      (when no-dup (forward-char))
      (while (scan-buffer special-str-regexp :regexp t :no-dup nil)
        (setq match-str (match-string 0))
        (unless (manued-escape-p-strict t (string= match-str manued-l-parenthesis-str))
          (setq from (point))
          (return))
        (forward-char)))
    (when from
      (goto-char from)
      match-str)))

(defun manued-forward-special-str-in-command ()
  " special-str ܂ňړ
ӁFcommand Ŏgp\Ȋ֐B"
  (manued-goto-special-str-in-command t))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; ړp֐ (command /OÓIɒ܂ꍇɎgp֐Q)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; escape 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun manued-escape-p-strict (in-command-p l-parenthesis-p)
  "OGXP[vB
݂̎gp̎dł͎Q͂ȂARglĂȂB
݈ʒu r-parenthesis ȊOłGXP[vƔ肷B"
  (when (and (not in-command-p) (not l-parenthesis-p))
    (return-from manued-escape-p-strict nil))
  (let ((escape-count 0))
    (save-excursion
      (while (looking-back manued-escape-str)
        (incf escape-count)
        (backward-char (length manued-escape-str))))
    (if (zerop escape-count)
        nil
      (if l-parenthesis-p
          (cond ((oddp escape-count)   t)
                (in-command-p        nil)
                (t                     t))
        (cond ((evenp escape-count) nil)
              (in-command-p           t)
              (t                    nil))))))

(defun manued-escape-p-in-command (l-parenthesis-p)
  (manued-escape-p-strict t l-parenthesis-p))
(defun manued-escape-p-out-command (l-parenthesis-p)
  (manued-escape-p-strict nil l-parenthesis-p))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; command \񔻒
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun manued-x-p-strict (in-command-p str)
  "݈ʒu str JnĂāAAGXP[vĂȂB
RgO̔ɂ͖ΉB"
  (let ((l-parenthesis-p (string= str manued-l-parenthesis-str)))
    (and (looking-for str)
         (<= (manued-point-min) (point))
         (not (manued-escape-p-strict in-command-p l-parenthesis-p))
         (or l-parenthesis-p in-command-p)
;        (or r-parenthesis-p (not in-comment-p)) ; RgΉƂ炱Ȋ
         )))
(defun manued-x-p-in-command (str)
  (manued-x-p-strict t str))
(defun manued-x-p-out-command (str)
  (manued-x-p-strict nil str))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  command \ւ̈ړ
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun manued-forward-x-simple-strict (in-command-p str)
  " x oƂ command /Ôǂł邩
in-command-p ŕۏ؂ŁA x Ɉړ"
  (let (from to)
    (save-excursion
      (while (scan-buffer str :regexp nil :no-dup t)
        (setq from (match-beginning 0) to (match-end 0))
        (if (manued-x-p-strict in-command-p str)
            (return)
          (setq from nil to nil))))
    (when from
      (goto-char from)
      (values from to))))
(defun manued-forward-x-simple-in-command (str)
  (manued-forward-x-simple-strict t str))
(defun manued-forward-x-simple-out-command (str)
  (manued-forward-x-simple-strict nil str))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; ݂܂͎ command \ւ̈ړ
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun manued-goto-x-strict (in-command-p str)
  "ړ command /Oۏ؂ x Ɉړ"
  (if (manued-x-p-strict in-command-p str)
      (values (point) (+ (point) (length str)))
    (manued-forward-x-simple-strict in-command-p str)))
(defun manued-goto-x-in-command (str)
  (manued-goto-x-strict t str))
(defun manued-goto-x-out-command (str)
  (manued-goto-x-strict nil str))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; (l-parenthesis)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun manued-l-parenthesis-p-strict (in-command-p)
  (manued-x-p-strict in-command-p manued-l-parenthesis-str))
(defun manued-l-parenthesis-p-in-command ()
  (manued-l-parenthesis-p-strict t))
(defun manued-l-parenthesis-p-out-command ()
  (manued-l-parenthesis-p-strict nil))

(defun manued-forward-l-parenthesis-simple-strict (in-command-p)
  (manued-forward-x-simple-strict in-command-p manued-l-parenthesis-str))
(defun manued-forward-l-parenthesis-simple-in-command ()
  (manued-forward-l-parenthesis-simple-strict t))
(defun manued-forward-l-parenthesis-simple-out-command ()
  (manued-forward-l-parenthesis-simple-strict nil))

(defun manued-goto-l-parenthesis-strict (in-command-p)
  (manued-goto-x-strict in-command-p manued-l-parenthesis-str))
(defun manued-goto-l-parenthesis-in-command ()
  (manued-goto-l-parenthesis-strict t))
(defun manued-goto-l-parenthesis-out-command ()
  (manued-goto-l-parenthesis-strict nil))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; (r-parenthesis)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun manued-r-parenthesis-p-in-command ()
  (manued-x-p-in-command manued-r-parenthesis-str))
(defun manued-forward-r-parenthesis-simple-in-command ()
  (manued-forward-x-simple-in-command manued-r-parenthesis-str))
(defun manued-goto-r-parenthesis-in-command ()
  (manued-goto-x-in-command manued-r-parenthesis-str))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; (comment)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun manued-comment-p-in-command ()
  (manued-x-p-in-command manued-comment-str))
(defun manued-forward-comment-simple-in-command ()
  (manued-forward-x-simple-in-command manued-comment-str))
(defun manued-goto-comment-in-command ()
  (manued-goto-x-in-command manued-comment-str))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; (l-parenthesis -> r-parenthesis)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun manued-goto-matched-r-parenthesis-strict (in-command-p)
  "Ή r-parenthesis Ɉړ
RgΉς"
  (let ((nest-level 1) point l-from l-to r-from r-to c-from)
    (save-excursion
      (unless (manued-l-parenthesis-p-strict in-command-p)
        (return-from manued-goto-matched-r-parenthesis-strict nil))
      (forward-char (length manued-l-parenthesis-str))
      (setq point (point))
      (setq c-from (manued-goto-comment-in-command))
      (goto-char point)
      (loop
        ;; r-parenthesis
        (setq point (point))
        (setq r-from (manued-goto-r-parenthesis-in-command))
        (unless r-from
          (return-from manued-goto-matched-r-parenthesis-strict nil))
        (setq r-to (+ r-from (length manued-r-parenthesis-str)))
        ;; l-parenthesis
        (goto-char point)
        (setq l-from (manued-goto-l-parenthesis-in-command))
        (when l-from
          (setq l-to (+ l-from (length manued-l-parenthesis-str))))
        (cond
         ;; l-from Ȃ r-to 
         ((null l-from)
          (decf nest-level)
          (goto-char r-to))
         ;; r-from ̕ɂ r-to 
         ((< r-from l-from)
          (decf nest-level)
          (goto-char r-to))
         ;; l-from ̕ɂ邪ARg̒Ȃ r-to 
         ((when c-from
            (goto-char point)
            (setq c-from (manued-goto-comment-in-command))
            (and c-from (< c-from l-from)))
          (decf nest-level)
          (goto-char r-to))
         ;; l-from ̕ɂāAl-from Rg̒łȂ l-to 
         (t
          (incf nest-level)
          (goto-char l-to)))
        ;;
        (when (= nest-level 0)
          (return))))
    (goto-char r-from)
    (values r-from r-to)))
(defun manued-goto-matched-r-parenthesis-in-command ()
  (manued-goto-matched-r-parenthesis-strict t))
(defun manued-goto-matched-r-parenthesis-out-command ()
  (manued-goto-matched-r-parenthesis-strict nil))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; command-info ֘A
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; 
;; TAG           ::= (*manued-tag* <IDENTITY> <TYPE> <TYPE_LIST>)
;; IDENTITY      ::= (<COMMAND_LEVEL>)
;; COMMAND_LEVEL ::= <integer>
;; TYPE          ::= 'l-parenthesis || 'r-parenthesis || 'comment || 'delete || 'swap
;;                || 'comment-contents || 'older-contents || 'newer-contents
;;                || 'swap-a-contents || 'swap-b-contents || 'swap-c-contents
;; TYPE_LIST     ::= (<TYPE>*)
;;
;; R}h\vfۂ̔ <IDENTITY> ɑ΂ eq ōsB

(defun manued-command-info-get-l-parenthesis-range (command-info)
  (nth 0 command-info))
(defun manued-command-info-get-r-parenthesis-range (command-info)
  (nth 1 command-info))
(defun manued-command-info-get-comment-range (command-info)
  (nth 2 command-info))
(defun manued-command-info-get-delete-range (command-info)
  (nth 3 command-info))
(defun manued-command-info-get-swap-a-range (command-info)
  (nth 4 command-info))
(defun manued-command-info-get-swap-b-range (command-info)
  (nth 5 command-info))
(defun manued-command-info-get-comment-contents-range (command-info)
  (nth 6 command-info))
(defun manued-command-info-get-older-contents-range (command-info)
  (nth 7 command-info))
(defun manued-command-info-get-newer-contents-range (command-info)
  (nth 8 command-info))
(defun manued-command-info-get-swap-a-contents-range (command-info)
  (nth 9 command-info))
(defun manued-command-info-get-swap-b-contents-range (command-info)
  (nth 10 command-info))
(defun manued-command-info-get-swap-c-contents-range (command-info)
  (nth 11 command-info))

(defun manued-command-info-get-wide-range (command-info)
  (cons (car (manued-command-info-get-l-parenthesis-range command-info))
        (cdr (manued-command-info-get-r-parenthesis-range command-info))))
(defun manued-command-info-get-narrow-range (command-info)
  (cons (cdr (manued-command-info-get-l-parenthesis-range command-info))
        (cdr (manued-command-info-get-r-parenthesis-range command-info))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; level / identity ֘A
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun manued-get-field-level ()
  "݂̈ʒu field-level ԂB
<manued>document</manued>
        ^^^^^^^^^^^^^^^^^
L͈͂ 1 ĂB"
  (let ((point (point)))
    (save-excursion
      (save-restriction
        (widen)
        (multiple-value-bind (from to tag)
            (find-text-attribute-if #'(lambda (tag)
                                        (and (listp tag)
                                             (eq (car tag) *manued-tag*)
                                             (or (eq (nth 2 tag) 'l-parenthesis)
                                                 (eq (nth 2 tag) 'r-parenthesis))))
                                    :end point :from-end t)
          (cond
           ((null tag)
            0)
           ((eq (nth 2 tag) 'r-parenthesis)
            (if (<= to point)
                (1- (caadr tag))
              (caadr tag)))
           (t
            (if (< point to)
                (1- (caadr tag))
              (caadr tag)))))))))

(defun manued-get-current-command-level ()
  "݂̈ʒu command-level ԂB
<manued>document</manued>
^^^^^^^^^^^^^^^^^^^^^^^^^
L͈͂ 1 ĂB"
  (let ((point (point)))
    (save-excursion
      (save-restriction
        (widen)
        (multiple-value-bind (from to tag)
            (find-text-attribute-if #'(lambda (tag)
                                        (and (listp tag)
                                             (eq (car tag) *manued-tag*)
                                             (or (eq (nth 2 tag) 'l-parenthesis)
                                                 (eq (nth 2 tag) 'r-parenthesis))))
                                    :end (1+ point) :from-end t)
          (cond
           ((null tag)
            0)
           ((eq (nth 2 tag) 'r-parenthesis)
            (if (<= to point)
                (1- (caadr tag))
              (caadr tag)))
           (t
            (caadr tag))))))))

(defun manued-get-current-command-identity ()
  "R}h identity 擾B"
  (save-excursion
    (let ((command-level (manued-get-current-command-level)))
      (when (plusp command-level)
        (manued-goto-x 'r-parenthesis command-level)
        (multiple-value-bind (from to tag)
            (find-text-attribute-point (point))
          (nth 1 tag))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; parse-command ֘A
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defvar-local manued-last-parse-command-error-point nil
  "Ō̃R}h͂ł̃G[ʒu")
(defvar-local manued-last-parse-command-error-message nil
  "Ō̃R}h͂ł̃G[bZ[W")

(defun manued-goto-last-parse-command-error-point ()
  "R}h͂ł̃G[ʒuɈړ"
  (interactive)
  (when manued-last-parse-command-error-point
    (goto-char manued-last-parse-command-error-point)
    (message "~A" manued-last-parse-command-error-message)))

(defun manued-parse-command-from-point-strict (field-level &optional attributes)
  "݈ʒuJnR}h\͂āAeLXgݒ肵A
͌ʏ command-info ԂB"
  (let (tag identity command-level type type-list
        (in-command-p (not (zerop field-level)))
        special-str command-type (delete-count 0) (swap-count 0)
        l-parenthesis-from l-parenthesis-to r-parenthesis-from r-parenthesis-to
        delete-from delete-to comment-from comment-to
        swap-a-from swap-a-to swap-b-from swap-b-to
        first-contents-from first-contents-to
        last-contents-from last-contents-to
        older-contents-from older-contents-to
        newer-contents-from newer-contents-to
        swap-a-contents-from swap-a-contents-to
        swap-b-contents-from swap-b-contents-to
        swap-c-contents-from swap-c-contents-to
        comment-contents-from comment-contents-to)
    (unless (manued-l-parenthesis-p-strict in-command-p)
      (return-from manued-parse-command-from-point-strict nil))
    (setq manued-last-parse-command-error-point nil
          manued-last-parse-command-error-message nil)
    (setq command-level (1+ field-level))
    (setq identity (list command-level))
    (save-excursion
      (save-restriction
        ;; Jnʒu擾
        (setq l-parenthesis-from (point)
              l-parenthesis-to (+ (point) (length manued-l-parenthesis-str)))
        (push 'l-parenthesis type-list)
        ;; Iʒu擾
        (unless (manued-goto-matched-r-parenthesis-strict in-command-p)
          (setq manued-last-parse-command-error-point (point))
          (setq manued-last-parse-command-error-message
                (format nil "point ~S: Ή r-parenthesis ݂̑Ȃ l-parenthesis łB" (point)))
          (plain-error "~A" manued-last-parse-command-error-message))
        (setq r-parenthesis-from (point)
              r-parenthesis-to (+ (point) (length manued-r-parenthesis-str)))
        (narrow-to-region l-parenthesis-to r-parenthesis-from)
        (goto-char (point-min))
        (while (setq special-str (manued-goto-special-str-in-command))
          (cond
           ;; [
           ((string= special-str manued-l-parenthesis-str)
            (unless (manued-goto-matched-r-parenthesis-in-command)
              (setq manued-last-parse-command-error-point (point))
              (setq manued-last-parse-command-error-message
                    (format nil "point ~S: Ή r-parenthesis ݂̑Ȃ l-parenthesis łB" (point)))
              (plain-error "~A" manued-last-parse-command-error-message))
            (forward-char (length manued-r-parenthesis-str)))
           ;; ]
           ((string= special-str manued-r-parenthesis-str)
            (setq manued-last-parse-command-error-point (point))
            (setq manued-last-parse-command-error-message
                  (format nil "point ~S: Ή l-parenthesis ݂̑Ȃ r-parenthesis łB" (point)))
            (plain-error "~A" manued-last-parse-command-error-message))
           ;; /
           ((string= special-str manued-delete-str)
            (push 'delete type-list)
            (incf delete-count)
            (unless (member command-type '(nil delete))
              (setq manued-last-parse-command-error-point (point))
              (setq manued-last-parse-command-error-message
                    (format nil "point ~S: ʂ̃R}h(~A) delete R}ho܂B"
                            (point) (symbol-name command-type)))
              (plain-error "~A" manued-last-parse-command-error-message))
            (unless (< delete-count 2)
              (setq manued-last-parse-command-error-point (point))
              (setq manued-last-parse-command-error-message
                    (format nil "point ~S: delete R}h 2 xo܂B" (point)))
              (plain-error "~A" manued-last-parse-command-error-message))
            (setq command-type 'delete)
            (setq delete-from (point)
                  delete-to (+ (point) (length manued-delete-str))
                  first-contents-from (point-min)
                  first-contents-to (point)
                  last-contents-from delete-to)
            (goto-char delete-to))
           ;; |
           ((string= special-str manued-swap-str)
            (push 'swap type-list)
            (incf swap-count)
            (unless (member command-type '(nil swap))
              (setq manued-last-parse-command-error-point (point))
              (setq manued-last-parse-command-error-message
                    (format nil "point ~S: ʂ̃R}h(~A) swap R}ho܂B"
                            (point) (symbol-name command-type)))
              (plain-error "~A" manued-last-parse-command-error-message))
            (unless (< swap-count 3)
              (setq manued-last-parse-command-error-point (point))
              (setq manued-last-parse-command-error-message
                    (format nil "point ~S: swap R}h 3 xo܂B" (point)))
              (plain-error "~A" manued-last-parse-command-error-message))
            (setq command-type 'swap)
            (if (= swap-count 1)
                (progn
                  (setq swap-a-from (point)
                        swap-a-to (+ (point) (length manued-swap-str))
                        swap-a-contents-from (point-min)
                        swap-a-contents-to swap-a-from
                        swap-b-contents-from swap-a-to)
                  (goto-char swap-a-to))
              (progn
                (setq swap-b-from (point)
                      swap-b-to (+ (point) (length manued-swap-str))
                      swap-b-contents-to swap-b-from
                      swap-c-contents-from swap-b-to)
                (goto-char swap-b-to))))
           ;; ;
           ((string= special-str manued-comment-str)
            (push 'comment type-list)
            (setq comment-from (point)
                  comment-to (+ (point) (length manued-comment-str))
                  comment-contents-from comment-to
                  comment-contents-to (point-max))
            (cond
             ((eq command-type 'delete)
              (setq last-contents-to comment-from))
             ((eq command-type 'swap)
              (when (< swap-count 2)
                (setq manued-last-parse-command-error-point (point))
                (setq manued-last-parse-command-error-message
                      (format nil "point ~S: swap R}h 2 xoOɃRgJn܂B" (point)))
                (plain-error "~A" manued-last-parse-command-error-message))
              (setq swap-c-contents-to comment-from))
             ((and (eq command-type nil)
                   (/= l-parenthesis-to comment-from))
              (setq manued-last-parse-command-error-point (point))
              (setq manued-last-parse-command-error-message
                    (format nil "point ~S: RgJnOɁAR}h\Ȃ񂪑݂Ă܂B" (point)))
              (plain-error "~A" manued-last-parse-command-error-message)))
            (goto-char (point-max)))
           ;; ~
           ((string= special-str manued-escape-str)
            (forward-char (length manued-escape-str)))
           (t
            (setq manued-last-parse-command-error-point (point))
            (setq manued-last-parse-command-error-message
                  (format nil "point ~S: manued-mode.l ̃oOł: ꕶłȂ (~A) ꕶƂĔFĂ܂B" (point) special-str))
            (plain-error "~A" manued-last-parse-command-error-message))))
        (cond
         ((eq command-type 'delete)
          (unless last-contents-to
            (setq last-contents-to (point-max)))
          (if (manued-order-older-first-p)
              (setq older-contents-from first-contents-from
                    older-contents-to first-contents-to
                    newer-contents-from last-contents-from
                    newer-contents-to last-contents-to)
            (setq older-contents-from last-contents-from
                  older-contents-to last-contents-to
                  newer-contents-from first-contents-from
                  newer-contents-to first-contents-to)))
         ((eq command-type 'swap)
          (when (< swap-count 2)
            (setq manued-last-parse-command-error-point (point))
            (setq manued-last-parse-command-error-message
                  (format nil "point ~S: swap R}h 2 xoOɏI܂B" (point)))
            (plain-error "~A" manued-last-parse-command-error-message))
          (unless swap-c-contents-to
            (setq swap-c-contents-to (point-max))))))
      (push 'r-parenthesis type-list)
      (setq type-list (nreverse type-list))

      ;; set-text-attribute Kpɂē삪ς̂Œ

      ;; l-parenthesis
      (apply #'set-text-attribute
             (append (list l-parenthesis-from l-parenthesis-to
                           (list *manued-tag* identity 'l-parenthesis type-list))
                     (or attributes *manued-l-parenthesis-attributes*)))
      ;; delete
      (when delete-from
        (if (manued-order-older-first-p)
            (progn
              (apply #'set-text-attribute
                     (append (list older-contents-from older-contents-to
                                   (list *manued-tag* identity 'older-contents type-list))
                             (or attributes *manued-older-contents-attributes*)))
              (save-restriction
                (narrow-to-region older-contents-from older-contents-to)
                (manued-parse-commands-strict command-level (or attributes *manued-older-contents-attributes*)))
              (apply #'set-text-attribute
                     (append (list delete-from delete-to
                                   (list *manued-tag* identity 'delete type-list))
                             (or attributes *manued-delete-attributes*)))
              (apply #'set-text-attribute
                     (append (list newer-contents-from newer-contents-to
                                   (list *manued-tag* identity 'newer-contents type-list))
                             (or attributes *manued-newer-contents-attributes*)))
              (save-restriction
                (narrow-to-region newer-contents-from newer-contents-to)
                (manued-parse-commands-strict command-level (or attributes *manued-newer-contents-attributes*))))
          (progn
            (apply #'set-text-attribute
                   (append (list newer-contents-from newer-contents-to
                                 (list *manued-tag* identity 'newer-contents type-list))
                           (or attributes *manued-newer-contents-attributes*)))
            (save-restriction
              (narrow-to-region newer-contents-from newer-contents-to)
              (manued-parse-commands-strict command-level (or attributes *manued-newer-contents-attributes*)))
            (apply #'set-text-attribute
                   (append (list delete-from delete-to
                                 (list *manued-tag* identity 'delete type-list))
                           (or attributes *manued-delete-attributes*)))
            (apply #'set-text-attribute
                   (append (list older-contents-from older-contents-to
                                 (list *manued-tag* identity 'older-contents type-list))
                           (or attributes *manued-older-contents-attributes*)))
            (save-restriction
              (narrow-to-region older-contents-from older-contents-to)
              (manued-parse-commands-strict command-level (or attributes *manued-older-contents-attributes*))))))
      ;; swap
      (when swap-a-from
        ;; swap-a-contents
        (apply #'set-text-attribute
               (append (list swap-a-contents-from swap-a-contents-to
                             (list *manued-tag* identity 'swap-a-contents type-list))
                       (or attributes *manued-swap-a-contents-attributes*)))
        (save-restriction
          (narrow-to-region swap-a-contents-from swap-a-contents-to)
          (manued-parse-commands-strict command-level (or attributes *manued-swap-a-contents-attributes*)))
        ;; swap-a
        (apply #'set-text-attribute
               (append (list swap-a-from swap-a-to
                             (list *manued-tag* identity 'swap type-list))
                       (or attributes *manued-swap-attributes*)))
        ;; swap-b-contents
        (apply #'set-text-attribute
               (append (list swap-b-contents-from swap-b-contents-to
                             (list *manued-tag* identity 'swap-b-contents type-list))
                       (or attributes *manued-swap-b-contents-attributes*)))
        (save-restriction
          (narrow-to-region swap-b-contents-from swap-b-contents-to)
          (manued-parse-commands-strict command-level (or attributes *manued-swap-b-contents-attributes*)))
        ;; swap-b
        (apply #'set-text-attribute
               (append (list swap-b-from swap-b-to
                             (list *manued-tag* identity 'swap type-list))
                       (or attributes *manued-swap-attributes*)))
        ;; swap-c-contents
        (apply #'set-text-attribute
               (append (list swap-c-contents-from swap-c-contents-to
                             (list *manued-tag* identity 'swap-c-contents type-list))
                       (or attributes *manued-swap-c-contents-attributes*)))
        (save-restriction
          (narrow-to-region swap-c-contents-from swap-c-contents-to)
          (manued-parse-commands-strict command-level (or attributes *manued-swap-c-contents-attributes*))))
      ;; comment
      (when comment-from
        (apply #'set-text-attribute
               (append (list comment-from comment-to
                             (list *manued-tag* identity 'comment type-list))
                       (or attributes *manued-comment-attributes*)))
        (apply #'set-text-attribute
               (append (list comment-contents-from comment-contents-to
                             (list *manued-tag* identity 'comment-contents type-list))
                       (or attributes *manued-comment-contents-attributes*))))
      ;; r-parenthesis
      (apply #'set-text-attribute
             (append (list r-parenthesis-from r-parenthesis-to
                           (list *manued-tag* identity 'r-parenthesis type-list))
                     (or attributes *manued-r-parenthesis-attributes*))))
    ;;
    (list (cons l-parenthesis-from l-parenthesis-to)
          (cons r-parenthesis-from r-parenthesis-to)
          (if comment-from (cons comment-from comment-to))
          (if delete-from (cons delete-from delete-to))
          (if swap-a-from (cons swap-a-from swap-a-to))
          (if swap-b-from (cons swap-b-from swap-b-to))
          (if comment-contents-from (cons comment-contents-from comment-contents-to))
          (if older-contents-from (cons older-contents-from older-contents-to))
          (if newer-contents-from (cons newer-contents-from newer-contents-to))
          (if swap-a-contents-from (cons swap-a-contents-from swap-a-contents-to))
          (if swap-b-contents-from (cons swap-b-contents-from swap-b-contents-to))
          (if swap-c-contents-from (cons swap-c-contents-from swap-c-contents-to)))))

(defun manued-parse-commands-strict (field-level &optional attributes)
  "݂ narrowing ͈͂̃tB[hx filed-level ł邱ƂOɁA
narrowing ͈͂Ɋ܂܂R}hQ\͂B
̊֐gṕAK؂ narrowing ĂȂ΂ȂȂB"
  (let ((in-command-p (not (zerop field-level))) command-info command-info-list)
    (save-excursion
      (goto-char (manued-point-min))
      (while (and (manued-goto-l-parenthesis-strict in-command-p)
                  (progn
                    (setq command-info (manued-parse-command-from-point-strict field-level attributes))
                    (manued-command-info-get-l-parenthesis-range command-info)))
        (goto-char (cdr (manued-command-info-get-r-parenthesis-range command-info)))
        (push command-info command-info-list)))
    (nreverse command-info-list)))

(defun manued-parse-commands-from-top-level ()
  "݂ narrowing ͈͂̃tB[hx 0 łƂāA
narrowing ͈͂Ɋ܂܂R}hQ\͂B"
  (interactive)
  (manued-parse-commands-strict 0))

(defun manued-parse-command-from-point ()
  "݈ʒuJnR}h\͂āAeLXgݒ肵A
͌ʏ command-info ԂB
݈ʒu field-level ɉēK؂ attributes ݒ肵
manued-parse-command-from-point-strict ĂԁB"
  (let ((field-level (manued-get-field-level)) attributes)
    (when (plusp field-level)
      (multiple-value-bind (from to tag foreground background bold underline strike-out prefix extend)
          (find-text-attribute-point (point))
        (setq attributes (list :foreground foreground :background background
                               :bold bold :underline underline
                               :strike-out strike-out :prefix prefix :extend extend))))
    (manued-parse-command-from-point-strict field-level attributes)))
(defun manued-parse-commands ()
  "݂ narrowing ͈͂̃tB[hx filed-level ł邱ƂOɁA
narrowing ͈͂Ɋ܂܂R}hQ\͂B
݈ʒu field-level ɉēK؂ attributes ݒ肵
manued-parse-commands-strict ĂԁB
̊֐gṕAK؂ narrowing ĂȂ΂ȂȂB"
  (let ((field-level (manued-get-field-level)) attributes)
    (when (plusp field-level)
      (multiple-value-bind (from to tag foreground background bold underline strike-out prefix extend)
          (find-text-attribute-point (point))
        (setq attributes (list :foreground foreground :background background
                               :bold bold :underline underline
                               :strike-out strike-out :prefix prefix :extend extend))))
    (manued-parse-commands-strict field-level attributes)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; R}h\񔻒 / ړp֐ (parse-command ̌ʂp֐Q)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun manued-x-p (type)
  "݈ʒu x "
  (unless (listp type) (setq type (list type)))
  (multiple-value-bind (from to tag)
      (find-text-attribute-point (point))
    (when (and (listp tag) (member (nth 2 tag) type))
      (values from to))))

(defun manued-goto-x (type &optional field-level identity)
  "x Ɉړ"
  (or (manued-x-p type)
      (manued-forward-x type 1 field-level identity)))

(defun manued-forward-x (type &optional (n 1) field-level identity)
  " x Ɉړ
field-level  identity ̗^ꂽꍇ identity D"
  (let (goto-point matched-type from to tag field-level-error
        current-identity current-type current-command-level current-field-level)
    (unless (listp type)
      (setq type (list type)))
    (save-excursion
      (cond
       ((plusp n)
        (forward-char)
        (while (not (zerop n))
          (decf n)
          (if (multiple-value-setq (from to tag)
                (find-text-attribute-if #'(lambda (tag)
                                            (when (and (listp tag) (eq (car tag) *manued-tag*))
                                              (let* ((current-identity (nth 1 tag))
                                                     (current-type (nth 2 tag))
                                                     (current-command-level (car current-identity))
                                                     (current-field-level (if (eq current-type 'l-parenthesis)
                                                                              (1- current-command-level)
                                                                            current-command-level)))
                                                (and (member current-type type)
                                                     (if identity
                                                         (eq current-identity identity)
                                                       (or (not field-level)
                                                           (>= field-level current-field-level)))))))
                                        :start (point)))
              ;;  field-level Ƀ}b`ꍇ error L^
              (unless (or identity
                          (not field-level)
                          (progn
                            (setq current-identity (nth 1 tag)
                                  current-type (nth 2 tag)
                                  current-command-level (car current-identity)
                                  current-field-level (if (eq current-type 'l-parenthesis)
                                                          (1- current-command-level)
                                                        current-command-level))
                            (= field-level current-field-level)))
                (setq field-level-error t)))
          (if (and from (not field-level-error))
              (progn
                (setq goto-point from)
                (goto-char to))
            (return))))
       ((minusp n)
        (while (not (zerop n))
          (incf n)
          (if (multiple-value-setq (from to tag)
                (find-text-attribute-if #'(lambda (tag)
                                            (when (and (listp tag) (eq (car tag) *manued-tag*))
                                              (let* ((current-identity (nth 1 tag))
                                                     (current-type (nth 2 tag))
                                                     (current-command-level (car current-identity))
                                                     (current-field-level (if (eq current-type 'l-parenthesis)
                                                                              (1- current-command-level)
                                                                            current-command-level)))
                                                (and (member current-type type)
                                                     (if identity
                                                         (eq current-identity identity)
                                                       (or (not field-level)
                                                           (>= field-level current-field-level)))))))
                                        :end (point) :from-end t)
                )
              ;;  field-level Ƀ}b`ꍇ error L^
              (unless (or identity
                          (not field-level)
                          (progn
                            (setq current-identity (nth 1 tag)
                                  current-type (nth 2 tag)
                                  current-command-level (car current-identity)
                                  current-field-level (if (eq current-type 'l-parenthesis)
                                                          (1- current-command-level)
                                                        current-command-level))
                            (= field-level current-field-level)))
                (setq field-level-error t)))
          (if (and from (not field-level-error))
              (progn
                (setq goto-point from)
                (goto-char to))
            (return))))))
    (when goto-point
      (goto-char goto-point)
      goto-point)))
(defun manued-forward-x-current-level (type &optional (n 1))
  "̃tB[hxŁA x Ɉړ"
  (interactive "p")
  (manued-forward-x type n (manued-get-field-level)))

(defun manued-forward-x-in-current-command (type &optional (n 1))
  " command ł̎̍\vfֈړ"
  (let ((identity (manued-get-current-command-identity)))
    (when identity
      (manued-forward-x type n nil identity))))
(defun manued-goto-x-in-current-command (type)
  " command ł̍\vfֈړ"
  (let (goto-point)
    (save-excursion
      (if (manued-x-p type)
          (multiple-value-bind (from to tag)
              (find-text-attribute-point (point))
            (setq goto-point from))
        (if (manued-forward-x-in-current-command type)
            (setq goto-point (point))
          (progn
            (manued-forward-x-in-current-command 'l-parenthesis -1)
            (cond ((manued-x-p type)
                   (setq goto-point (point)))
                  ((manued-forward-x-in-current-command type)
                   (setq goto-point (point))))))))
    (when goto-point
      (goto-char goto-point)
      goto-point)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; l-parenthesis
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun manued-l-parenthesis-p ()
  (manued-x-p 'l-parenthesis))
(defun manued-goto-l-parenthesis ()
  (manued-goto-x 'l-parenthesis))
(defun manued-forward-l-parenthesis (&optional (n 1))
  (interactive "p")
  (manued-forward-x 'l-parenthesis n))
(defun manued-backward-l-parenthesis (&optional (n 1))
  (interactive "p")
  (manued-forward-l-parenthesis (- n)))
(defun manued-forward-l-parenthesis-current-level (&optional (n 1))
  (interactive "p")
  (manued-forward-x-current-level 'l-parenthesis n))
(defun manued-backward-l-parenthesis-current-level (&optional (n 1))
  (interactive "p")
  (manued-forward-l-parenthesis-current-level (- n)))
(defun manued-goto-l-parenthesis-in-current-command ()
  (interactive)
  (manued-goto-x-in-current-command 'l-parenthesis))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; r-parenthesis
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun manued-r-parenthesis-p ()
  (manued-x-p 'r-parenthesis))
(defun manued-goto-r-parenthesis ()
  (manued-goto-x 'r-parenthesis))
(defun manued-forward-r-parenthesis (&optional (n 1))
  (interactive "p")
  (manued-forward-x 'r-parenthesis n))
(defun manued-backward-r-parenthesis (&optional (n 1))
  (interactive "p")
  (manued-forward-r-parenthesis (- n)))
(defun manued-forward-r-parenthesis-current-level (&optional (n 1))
  (interactive "p")
  (manued-forward-x-current-level 'r-parenthesis n))
(defun manued-backward-r-parenthesis-current-level (&optional (n 1))
  (interactive "p")
  (manued-forward-r-parenthesis-current-level (- n)))
(defun manued-goto-r-parenthesis-in-current-command ()
  (interactive)
  (manued-goto-x-in-current-command 'r-parenthesis))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; delete
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun manued-delete-p ()
  (manued-x-p 'delete))
(defun manued-goto-delete ()
  (manued-goto-x 'delete))
(defun manued-forward-delete (&optional (n 1))
  (interactive "p")
  (manued-forward-x 'delete n))
(defun manued-backward-delete (&optional (n 1))
  (interactive "p")
  (manued-forward-delete (- n)))
(defun manued-forward-delete-current-level (&optional (n 1))
  (interactive "p")
  (manued-forward-x-current-level 'delete n))
(defun manued-backward-delete-current-level (&optional (n 1))
  (interactive "p")
  (manued-forward-delete-current-level (- n)))
(defun manued-goto-delete-in-current-command ()
  (interactive)
  (manued-goto-x-in-current-command 'delete))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; swap
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun manued-swap-p ()
  (manued-x-p 'swap))
(defun manued-goto-swap ()
  (manued-goto-x 'swap))
(defun manued-forward-swap (&optional (n 1))
  (interactive "p")
  (manued-forward-x 'swap n))
(defun manued-backward-swap (&optional (n 1))
  (interactive "p")
  (manued-forward-swap (- n)))
(defun manued-forward-swap-current-level (&optional (n 1))
  (interactive "p")
  (manued-forward-x-current-level 'swap n))
(defun manued-backward-swap-current-level (&optional (n 1))
  (interactive "p")
  (manued-forward-swap-current-level (- n)))
(defun manued-forward-swap-in-current-command (&optional (n 1))
  (interactive)
  (manued-forward-x-in-current-command 'swap n))
(defun manued-goto-swap-in-current-command ()
  (interactive)
  (manued-goto-x-in-current-command 'swap))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; comment
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun manued-comment-p ()
  (manued-x-p 'comment))
(defun manued-goto-comment ()
  (manued-goto-x 'comment))
(defun manued-forward-comment (&optional (n 1))
  (interactive "p")
  (manued-forward-x 'comment n))
(defun manued-backward-comment (&optional (n 1))
  (interactive "p")
  (manued-forward-comment (- n)))
(defun manued-forward-comment-current-level (&optional (n 1))
  (interactive "p")
  (manued-forward-x-current-level 'comment n))
(defun manued-backward-comment-current-level (&optional (n 1))
  (interactive "p")
  (manued-forward-comment-current-level (- n)))
(defun manued-goto-comment-in-current-command ()
  (interactive)
  (manued-goto-x-in-current-command 'comment))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; (l-parenthesis <-> r-parenthesis)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun manued-goto-matched-parenthesis ()
  "Ή parenthesis Ɉړ"
  (interactive)
  (cond ((manued-l-parenthesis-p)
         (manued-goto-r-parenthesis-in-current-command))
        ((manued-r-parenthesis-p)
         (manued-goto-l-parenthesis-in-current-command))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; R}h̃R}h\ʒuւ̑Oړ
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun manued-forward-any-in-current-command (&optional (n 1))
  (interactive "p")
  (manued-forward-x-in-current-command
   '(l-parenthesis r-parenthesis delete swap comment) n))
(defun manued-backward-any-in-current-command (&optional (n 1))
  (interactive "p")
  (manued-forward-any-in-current-command (- n)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; R}h
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun manued-delete-command-p ()
  (save-excursion
    (manued-goto-delete-in-current-command)))
(defun manued-swap-command-p ()
  (save-excursion
    (manued-goto-swap-in-current-command)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; R}hgpړ
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun manued-goto-older-contents-in-current-command ()
  (interactive)
  (let (goto-point)
    (save-excursion
      (when (manued-delete-command-p)
        (if (manued-order-older-first-p)
            (when (manued-goto-l-parenthesis-in-current-command)
              (forward-char (length manued-l-parenthesis-str))
              (setq goto-point (point)))
          (when (manued-goto-delete-in-current-command)
            (forward-char (length manued-delete-str))
            (setq goto-point (point))))))
    (when goto-point
      (goto-char goto-point)
      goto-point)))
(defun manued-goto-newer-contents-in-current-command ()
  (interactive)
  (let (goto-point)
    (save-excursion
      (when (manued-delete-command-p)
        (if (manued-order-older-first-p)
            (when (manued-goto-delete-in-current-command)
              (forward-char (length manued-delete-str))
              (setq goto-point (point)))
          (when (manued-goto-l-parenthesis-in-current-command)
            (forward-char (length manued-l-parenthesis-str))
            (setq goto-point (point))))))
    (when goto-point
      (goto-char goto-point)
      goto-point)))

(defun manued-goto-swap-a-contents-in-current-command ()
  (interactive)
  (let (goto-point)
    (save-excursion
      (when (manued-swap-command-p)
        (manued-goto-l-parenthesis-in-current-command)
        (forward-char (length manued-l-parenthesis-str))
        (setq goto-point (point))))
    (when goto-point
      (goto-char goto-point)
      goto-point)))
(defun manued-goto-swap-b-contents-in-current-command ()
  (interactive)
  (let (goto-point)
    (save-excursion
      (when (manued-swap-command-p)
        (manued-goto-l-parenthesis-in-current-command)
        (manued-forward-swap-in-current-command 1)
        (forward-char (length manued-swap-str))
        (setq goto-point (point))))
    (when goto-point
      (goto-char goto-point)
      goto-point)))
(defun manued-goto-swap-c-contents-in-current-command ()
  (interactive)
  (let (goto-point)
    (save-excursion
      (when (manued-swap-command-p)
        (manued-goto-l-parenthesis-in-current-command)
        (manued-forward-swap-in-current-command 2)
        (forward-char (length manued-swap-str))
        (setq goto-point (point))))
    (when goto-point
      (goto-char goto-point)
      goto-point)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; e픻
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; in-command-p 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun manued-in-command-p ()
  "R}h̒"
  (not (zerop (manued-get-field-level))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; in-comment-p 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun manued-in-comment-p ()
  "Rg̒"
  (let ((point (point)) from to)
    (save-excursion
      (and (prog1
               (manued-goto-comment-in-current-command)
             (forward-char (length manued-comment-str))
             (setq from (point)))
           (prog1
               (manued-goto-r-parenthesis-in-current-command)
             (setq to (point)))
           (and (<= from point) (< point to))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; escape  
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun manued-escape-p ()
  "OGXP[v
RgΉς݁B"
  (let ((escape-count 0))
    (save-excursion
      (while (looking-back manued-escape-str)
        (incf escape-count)
        (backward-char (length manued-escape-str))))
    (if (zerop escape-count)
        nil
      (if (manued-in-comment-p)
          (looking-for manued-r-parenthesis-str)
        (if (looking-for manued-l-parenthesis-str)
            (cond ((oddp escape-count)     t)
                  ((manued-in-command-p) nil)
                  (t                       t))
          (cond ((evenp escape-count)  nil)
                ((manued-in-command-p)   t)
                (t                     nil)))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; encode / decode
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun manued-encode-string-strict (str in-command-p)
  (if in-command-p
      (manued-encode-string-in-command str)
    (manued-encode-string-out-command str)))

(defun manued-encode-string-out-command (str)
  "command ܂܂Ȃ str  command OpɃGR[hB
ӁFstr  command ̈ꕔ\(l-parenthesis-str\) ܂܂Ă͂ȂȂB
      str  command ͍lȂB"
  (let (pattern replacement)
    (setq pattern (regexp-quote manued-l-parenthesis-str))
    (setq replacement
          (substitute-string (concat manued-escape-str manued-l-parenthesis-str)
                             "\\\\" "\\\\\\\\"))
    (substitute-string str pattern replacement)))

(defun manued-encode-string-in-command (str)
  "command ܂܂Ȃ str  command pɃGR[hB
ӁFstr  command ̈ꕔ\(l-parenthesis-str\) ܂܂Ă͂ȂȂB
      str  command ͍lȂB"
  (let (pattern replacement)
    (dolist (special-str (list manued-escape-str
                               manued-l-parenthesis-str manued-r-parenthesis-str
                               manued-delete-str manued-swap-str manued-comment-str))
      (setq pattern (regexp-quote special-str))
      (setq replacement
            (substitute-string (concat manued-escape-str special-str)
                               "\\\\" "\\\\\\\\"))
      (setq str (substitute-string str pattern replacement))))
  str)

(defun manued-decode-string-out-command (str)
  "command O ́Acommand ܂܂Ȃ str fR[hB"
  (let (pattern replacement)
    (setq pattern (regexp-quote (concat manued-escape-str manued-l-parenthesis-str)))
    (setq replacement (substitute-string manued-l-parenthesis-str "\\\\" "\\\\\\\\"))
    (substitute-string str pattern replacement)))

(defun manued-decode-string-in-command (str)
  "command  ́Acommand ܂܂Ȃ str fR[hB"
  (let (pattern replacement)
    (dolist (special-str (list manued-l-parenthesis-str manued-r-parenthesis-str
                               manued-delete-str manued-swap-str manued-comment-str
                               manued-escape-str))
      (setq pattern (regexp-quote (concat manued-escape-str special-str)))
      (setq replacement (substitute-string special-str "\\\\" "\\\\\\\\"))
      (setq str (substitute-string str pattern replacement))))
  str)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; eval manued command
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun manued-eval-command-strict (command-info in-command-p &optional old-p)
  (with-manued-mode-edit
    (let ((range (manued-command-info-get-wide-range command-info))
          older-contents-str newer-contents-str
          swap-a-contents-str swap-b-contents-str swap-c-contents-str
          str)
      (save-excursion
        (save-restriction
          (narrow-to-region (car range) (cdr range))
          ;; ̎擾
          (cond
           ;; delete
           ((manued-command-info-get-delete-range command-info)
            (if old-p
                (progn
                  (setq range (manued-command-info-get-older-contents-range command-info))
                  (save-restriction
                    (narrow-to-region (car range) (cdr range))
                    (manued-eval-current-level-commands-strict t old-p)
                    (setq older-contents-str (buffer-substring (point-min) (point-max)))))
              (progn
                (setq range (manued-command-info-get-newer-contents-range command-info))
                (save-restriction
                  (narrow-to-region (car range) (cdr range))
                  (manued-eval-current-level-commands-strict t old-p)
                  (setq newer-contents-str (buffer-substring (point-min) (point-max)))))))
           ;; swap
           ((manued-command-info-get-swap-a-range command-info)
            ;; swap-c-contents
            (setq range (manued-command-info-get-swap-c-contents-range command-info))
            (save-restriction
              (narrow-to-region (car range) (cdr range))
              (manued-eval-current-level-commands-strict t old-p)
              (setq swap-c-contents-str (buffer-substring (point-min) (point-max))))
            ;; swap-b-contents
            (setq range (manued-command-info-get-swap-b-contents-range command-info))
            (save-restriction
              (narrow-to-region (car range) (cdr range))
              (manued-eval-current-level-commands-strict t old-p)
              (setq swap-b-contents-str (buffer-substring (point-min) (point-max))))
            ;; swap-a-contents
            (setq range (manued-command-info-get-swap-a-contents-range command-info))
            (save-restriction
              (narrow-to-region (car range) (cdr range))
              (manued-eval-current-level-commands-strict t old-p)
              (setq swap-a-contents-str (buffer-substring (point-min) (point-max))))))
          ;; 폜
          (delete-region (point-min) (point-max))
          ;; VK}
          (if old-p
              ;; old
              (cond
               (older-contents-str
                (apply #'set-text-attribute
                       (append (list (point)
                                     (progn
                                       (insert (manued-encode-string-strict
                                                (manued-decode-string-in-command
                                                 older-contents-str)
                                                in-command-p))
                                       (point))
                                     *manued-eval-command-tag*)
                               *manued-older-contents-attributes*)))
               (swap-a-contents-str
                (apply #'set-text-attribute
                       (append (list (point)
                                     (progn
                                       (insert (manued-encode-string-strict
                                                (manued-decode-string-in-command
                                                 swap-a-contents-str)
                                                in-command-p))
                                       (point))
                                     *manued-eval-command-tag*)
                               *manued-swap-a-contents-attributes*))
                (apply #'set-text-attribute
                       (append (list (point)
                                     (progn
                                       (insert (manued-encode-string-strict
                                                (manued-decode-string-in-command
                                                 swap-b-contents-str)
                                                in-command-p))
                                       (point))
                                     *manued-eval-command-tag*)
                               *manued-swap-b-contents-attributes*))
                (apply #'set-text-attribute
                       (append (list (point)
                                     (progn
                                       (insert (manued-encode-string-strict
                                                (manued-decode-string-in-command
                                                 swap-c-contents-str)
                                                in-command-p))
                                       (point))
                                     *manued-eval-command-tag*)
                               *manued-swap-c-contents-attributes*))))
            ;; new
            (cond
               (newer-contents-str
                (apply #'set-text-attribute
                       (append (list (point)
                                     (progn
                                       (insert (manued-encode-string-strict
                                                (manued-decode-string-in-command
                                                 newer-contents-str)
                                                in-command-p))
                                       (point))
                                     *manued-eval-command-tag*)
                               *manued-newer-contents-attributes*)))
               (swap-a-contents-str
                (apply #'set-text-attribute
                       (append (list (point)
                                     (progn
                                       (insert (manued-encode-string-strict
                                                (manued-decode-string-in-command
                                                 swap-c-contents-str)
                                                in-command-p))
                                       (point))
                                     *manued-eval-command-tag*)
                               *manued-swap-c-contents-attributes*))
                (apply #'set-text-attribute
                       (append (list (point)
                                     (progn
                                       (insert (manued-encode-string-strict
                                                (manued-decode-string-in-command
                                                 swap-b-contents-str)
                                                in-command-p))
                                       (point))
                                     *manued-eval-command-tag*)
                               *manued-swap-b-contents-attributes*))
                (apply #'set-text-attribute
                       (append (list (point)
                                     (progn
                                       (insert (manued-encode-string-strict
                                                (manued-decode-string-in-command
                                                 swap-a-contents-str)
                                                in-command-p))
                                       (point))
                                     *manued-eval-command-tag*)
                               *manued-swap-a-contents-attributes*))))))))))

(defun manued-eval-current-level-commands-strict (in-command-p &optional old-p)
  (save-excursion
    (dolist (command-info (nreverse (manued-parse-commands)))
      (manued-eval-command-strict command-info in-command-p old-p))))

(defun manued-eval-last-command (&optional old-p)
  "ÕR}h]B"
  (interactive "p")
  (save-excursion
    (when (and (manued-backward-r-parenthesis)
               (manued-goto-l-parenthesis-in-current-command))
      (let ((in-command-p (not (zerop (manued-get-field-level)))))
        (manued-eval-command-strict
         (manued-parse-command-from-point) in-command-p old-p)))))

(defun manued-eval-command-region (from to &optional old-p)
  "[WɊ܂܂R}h]B"
  (interactive "r")
  (when (> from to) (rotatef from to))
  (with-manued-mode-edit
    (save-excursion
      (save-restriction
        (narrow-to-region from to)
        (goto-char from)
        (manued-eval-current-level-commands-strict (manued-in-command-p) old-p)))))

(defun manued-eval-command-region-old (from to)
  "[WɊ܂܂R}h]A̕ɖ߂B"
  (interactive "r")
  (manued-eval-command-region from to t))

(defun manued-eval-command-selection (&optional old-p)
  "ZNVɊ܂܂R}h]B"
  (interactive)
  (when (manued-pre-selection-p)
    (selection-start-end (start end)
      (manued-eval-command-region start end old-p))))

(defun manued-eval-command-selection-old ()
  "ZNVɊ܂܂R}h]A̕ɖ߂B"
  (interactive)
  (manued-eval-command-selection t))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; ҏWR}h}
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun manued-undo ()
  "undo Bmanued-mode łȂ΁Aread-only ł undo B"
  (interactive)
  (with-manued-mode-edit
    (undo)))

(defun manued-pre-selection-p ()
  (member (get-selection-type) '(1 2) :test #'eql))

(defun manued-toggle-command-with-comment ()
  "R}h}ɃRgt邩̐ݒgOB"
  (interactive)
  (setq manued-command-with-comment-p
        (not manued-command-with-comment-p)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; delete
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun manued-insert-delete-str (str &optional with-comment-p)
  (if (manued-order-older-first-p)
      (insert (format nil "~A~A~A~A~A"
                      manued-l-parenthesis-str
                      (manued-encode-string-in-command str)
                      manued-delete-str
                      (if with-comment-p manued-comment-str "")
                      manued-r-parenthesis-str))
    (insert (format nil "~A~A~A~A~A"
                    manued-l-parenthesis-str manued-delete-str
                    (manued-encode-string-in-command str)
                    (if with-comment-p manued-comment-str "")
                    manued-r-parenthesis-str))))

(defun manued-insert-delete-command-region (from to &optional (with-comment-p manued-command-with-comment-p))
  "[WV delete R}hɕϊB"
  (interactive "r")
  (with-manued-mode-edit
    (when (> from to) (rotatef from to))
    (manued-insert-delete-str
     (prog1 (buffer-substring from to) (delete-region from to)) with-comment-p)
    (save-excursion
      (goto-char from)
      (manued-parse-command-from-point))))

(defun manued-delete-command-region (from to &optional interactive-p)
  "[W delete R}hɕϊB"
  (interactive "r")
  (when (> from to) (rotatef from to))
  (with-manued-mode-edit
    (let (older-contents-from)
      (save-excursion
        (goto-char to)
        (when (manued-l-parenthesis-p)
          (setq older-contents-from (manued-goto-older-contents-in-current-command))))
      (if older-contents-from
          ;;  delete R}hɒǉ
          (progn
            (goto-char older-contents-from)
            (insert (manued-encode-string-in-command (buffer-substring from to)))
            (delete-region from to))
        ;;  delete R}hȂꍇ͐VKɒǉ
        (progn
          (manued-insert-delete-command-region from to)
          (goto-char from)
          (when (or interactive-p (interactive-p))
            (manued-edit-delete-newer-contents)))))))

(defun manued-delete-command-selection (&optional interactive-p)
  "ZNV delete R}hɕϊB"
  (interactive)
  (when (manued-pre-selection-p)
    (selection-start-end (start end)
      (manued-delete-command-region start end
                                    (or interactive-p (interactive-p))))))

(defun manued-delete-command-line (&optional lines)
  "݈ʒus܂ł delete R}hɕϊB"
  (interactive "p")
  (unless (manued-l-parenthesis-p)
    (manued-delete-command-region
     (point)
     (progn
       (cond ((null lines)
              (if (eolp)
                  (forward-line 1)
                (goto-eol)))
             ((zerop lines)
              (if (bolp)
                  (forward-line -1)
                (goto-bol)))
             (t
              (forward-line lines)))
       (point)))))

(defun manued-delete-command-char (&optional (n 1))
  "݈ʒu delete R}hɕϊB"
  (interactive "p")
  (unless (or (and (plusp n)
                   (manued-l-parenthesis-p))
              (and (minusp n)
                   (save-excursion
                     (backward-char)
                     (manued-in-command-p))))
    (manued-delete-command-region (point)
                                  (progn (forward-char n) (point)))))

(defun manued-delete-command-backward-char (&optional (n 1))
  "Oʒu delete R}hɕϊB"
  (interactive "p")
  (manued-delete-command-char (- n)))

(defun manued-delete-command-char-or-selection (&optional (n 1) interactive-p)
  "ZNV܂݈͌ʒu delete R}hɕϊB"
  (interactive "p")
  (if (manued-pre-selection-p)
      (manued-delete-command-selection (or interactive-p (interactive-p)))
    (manued-delete-command-char n)))

(defun manued-delete-command-backward-char-or-selection (&optional (n 1))
  "ZNV܂͒Oʒu delete R}hɕϊB"
  (interactive "p")
  (manued-delete-command-char-or-selection (- n) (interactive-p)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; swap
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun manued-insert-swap-str (str &optional with-comment-p)
  (insert (format nil "~A~A~A~A~A~A"
                  manued-l-parenthesis-str
                  (manued-encode-string-in-command str)
                  manued-swap-str manued-swap-str
                  (if with-comment-p manued-comment-str "")
                  manued-r-parenthesis-str)))

(defun manued-insert-swap-command-region (from to &optional (with-comment-p manued-command-with-comment-p))
  "[WV swap R}hɕϊB"
  (interactive "r")
  (with-manued-mode-edit
    (when (> from to) (rotatef from to))
    (manued-insert-swap-str
     (prog1 (buffer-substring from to) (delete-region from to)) with-comment-p)
    (save-excursion
      (goto-char from)
      (manued-parse-command-from-point))))

(defun manued-swap-command-region (from to &optional interactive-p)
  "[WV swap R}hɕϊƂƂ swap ʒu̎wsB"
  (interactive "r")
  (when (> from to) (rotatef from to))
  (manued-insert-swap-command-region from to)
  (goto-char from)
  (when (or interactive-p (interactive-p))
    (manued-change-swap-boundary)))

(defun manued-swap-command-selection ()
  "ZNVV swap R}hɕϊƂƂ swap ʒu̎wsB"
  (interactive)
  (when (manued-pre-selection-p)
    (selection-start-end (start end)
      (manued-swap-command-region start end (interactive-p)))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; comment
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun manued-insert-comment-str (str)
  (insert (format nil "~A~A~A~A"
                  manued-l-parenthesis-str manued-comment-str
                  (manued-encode-string-in-command str)
                  manued-r-parenthesis-str)))

(defun manued-insert-comment-region (from to)
  "[WV comment ɕϊB"
  (interactive "r")
  (with-manued-mode-edit
    (when (> from to) (rotatef from to))
    (manued-insert-comment-str
     (prog1 (buffer-substring from to) (delete-region from to)))
    (save-excursion
      (goto-char from)
      (manued-parse-command-from-point))))

(defun manued-comment-region (from to &optional interactive-p)
  "[WV comment ɕϊƂƂ comment ̕ҏWsB"
  (interactive "r")
  (when (> from to) (rotatef from to))
  (manued-insert-comment-region from to)
  (goto-char from)
  (when (or interactive-p (interactive-p))
    (manued-edit-comment-contents)))

(defun manued-comment-selection ()
  "ZNVV comment ɕϊƂƂ comment ̕ҏWsB"
  (interactive)
  (when (manued-pre-selection-p)
    (selection-start-end (start end)
      (manued-comment-region start end (interactive-p)))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; R}hҏW
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defvar *manued-edit-contents-map* nil
  "R}h/RgҏWL[}bv")
(unless *manued-edit-contents-map*
  (setq *manued-edit-contents-map* (copy-keymap *global-keymap*))
  (dotimes (index *full-keymap-length*)
    (let* ((c (*keymap-index-char index))
           (x (lookup-keymap *manued-edit-contents-map* c)))
      (cond
       ;; keymap O
       ((keymapp x)
        (undefine-key *manued-edit-contents-map* c))
       ;; self-insert-command O
       ((eq 'self-insert-command x)
        (undefine-key *manued-edit-contents-map* c))
       ;; widen O
       ((eq 'widen x)
        (undefine-key *manued-edit-contents-map* c))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; delete
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun manued-edit-delete-newer-contents ()
  "݈ʒuJn delete R}h̐VRecҏWB"
  (interactive)
  (with-manued-mode-edit
    (let ((command-info (manued-parse-command-from-point))
          (modified-count (buffer-modified-count))
          pre-modified-count newer-contents-range
          current-char current-command)
      (unless (manued-command-info-get-delete-range command-info)
        (message "delete R}hJnĂ܂B")
        (return-from manued-edit-delete-newer-contents nil))
      (unwind-protect
          (save-excursion
            (save-restriction
              (setq newer-contents-range
                    (manued-command-info-get-newer-contents-range command-info))
              ;; ҏW̌h悭邽߂ɖ dummy attributes ݒ
              (multiple-value-bind (from to tag foreground background bold underline strike-out prefix extend)
                  (find-text-attribute-point (1- (cdr newer-contents-range)))
                (set-text-attribute (cdr newer-contents-range) (1+ (cdr newer-contents-range))
                                    *manued-tag*
                                    :foreground foreground :background background
                                    :bold bold :underline underline :strike-out strike-out
                                    :prefix prefix :extend extend))
              (narrow-to-region (car newer-contents-range) (cdr newer-contents-range))
              (setq pre-modified-count (buffer-modified-count))
              (loop
                (message "Rec̏CF ESC ŏIłB")
                (refresh-screen)
                (setq current-char (read-char *keyboard*))
                (when (eq current-char #\ESC)
                  (return))
                (setq current-command
                      (lookup-keymap *manued-edit-contents-map* current-char t))
                (cond
                 (current-command
                  (call-interactively current-command))
                 (t
                  (insert current-char)))
                (unless (eql pre-modified-count (buffer-modified-count))
                  (setq pre-modified-count (buffer-modified-count))
                  (undo-boundary)))))
        (progn
          (clear-message)
          (manued-parse-command-from-point))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; swap
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun manued-change-swap-boundary ()
  "݈ʒuJn swap R}h swap ʒuw肷B"
  (interactive)
  (with-manued-mode-edit
    (let ((command-info (manued-parse-command-from-point))
          swap-a-range swap-b-range
          backup-str success-p (swap-count 0)
          current-char current-command)
      (unless (manued-command-info-get-swap-a-range command-info)
        (message "swap R}hJnĂ܂B")
        (return-from manued-change-swap-boundary nil))
      (unwind-protect
          (save-excursion
            (save-restriction
              (narrow-to-region
               (cdr (manued-command-info-get-l-parenthesis-range command-info))
               (car (or (manued-command-info-get-comment-range command-info)
                        (manued-command-info-get-r-parenthesis-range command-info))))
              (setq backup-str (buffer-substring (point-min) (point-max)))
              (unwind-protect
                  (progn
                    (setq swap-a-range (manued-command-info-get-swap-a-range command-info))
                    (setq swap-b-range (manued-command-info-get-swap-b-range command-info))
                    (delete-region (car swap-b-range) (cdr swap-b-range))
                    (delete-region (car swap-a-range) (cdr swap-a-range))
                    (goto-char (car swap-a-range))
                    (let ((buffer-read-only t))
                      (declare (special buffer-read-only))
                      (while (not success-p)
                        (message "swap ʒȕCF ~A }ʒu Enter ĂBESC ŃLZłB"
                                 manued-swap-str)
                        (refresh-screen)
                        (setq current-char (read-char *keyboard*))
                        (setq current-command
                              (lookup-keymap *manued-edit-contents-map* current-char t))
                        (cond
                         ((eq current-char #\ESC)
                          (return))
                         ((eq current-char #\RET)
                          (manued-change-swap-boundary-insert-swap-str)
                          (incf swap-count)
                          (when (= swap-count 2)
                            (setq success-p t)))
                         (current-command
                          (call-interactively current-command))))))
                (unless success-p
                  (delete-region (point-min) (point-max))
                  (insert backup-str)))))
        (progn
          (clear-message)
          (manued-parse-command-from-point))))))
(defun manued-change-swap-boundary-insert-swap-str ()
  (interactive)
  (let ((buffer-read-only nil))
    (declare (special buffer-read-only))
    (apply #'set-text-attribute
           (append (list (point)
                         (progn
                           (insert manued-swap-str)
                           (point))
                         *manued-tag*)
                   *manued-swap-attributes*))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; comment
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun manued-edit-comment-contents ()
  "݈ʒuJnR}h comment ҏWB"
  (interactive)
  (with-manued-mode-edit
    (let ((command-info (manued-parse-command-from-point))
          (modified-count (buffer-modified-count))
          pre-modified-count
          comment-contents-range r-parenthesis-range
          current-char current-command)
      (unless command-info
        (message "R}hJnʒuł͂܂B")
        (return-from manued-edit-comment-contents nil))
      (unwind-protect
          (save-excursion
            (save-restriction
              (setq comment-contents-range
                    (manued-command-info-get-comment-contents-range command-info))
              (if comment-contents-range
                  (progn
                    ;; ҏW̌h悭邽߂ɖ dummy attributes ݒ
                    (multiple-value-bind (from to tag foreground background bold underline strike-out prefix extend)
                        (find-text-attribute-point (1- (cdr comment-contents-range)))
                      (set-text-attribute (cdr comment-contents-range) (1+ (cdr comment-contents-range))
                                          *manued-tag*
                                          :foreground foreground :background background
                                          :bold bold :underline underline :strike-out strike-out
                                          :prefix prefix :extend extend))
                    (narrow-to-region (car comment-contents-range) (cdr comment-contents-range)))
                (progn
                  (setq r-parenthesis-range
                        (manued-command-info-get-r-parenthesis-range command-info))
                  (narrow-to-region (car r-parenthesis-range) (car r-parenthesis-range))
                  (insert manued-comment-str)
                  (narrow-to-region (point) (point))))
              (setq pre-modified-count (buffer-modified-count))
              (loop
                (message "Rg̏CF ESC ŏIłB")
                (refresh-screen)
                (setq current-char (read-char *keyboard*))
                (when (eq current-char #\ESC)
                  (return))
                (setq current-command
                      (lookup-keymap *manued-edit-contents-map* current-char t))
                (cond
                 (current-command
                  (call-interactively current-command))
                 (t
                  (insert current-char)))
                (unless (eql pre-modified-count (buffer-modified-count))
                  (setq pre-modified-count (buffer-modified-count))
                  (undo-boundary)))))
        (progn
          (clear-message)
          (manued-parse-command-from-point))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun manued-edit-command ()
  "݈ʒuJnR}hނɉāAR}h/RgҏWB"
  (interactive)
  (with-manued-mode-edit
    (let ((command-info (manued-parse-command-from-point)))
      (unless command-info
        (message "R}hJnʒuł͂܂B")
        (return-from manued-edit-command nil))
      (cond
       ((manued-command-info-get-delete-range command-info)
        (manued-edit-delete-newer-contents))
       ((manued-command-info-get-swap-a-range command-info)
        (manued-change-swap-boundary))
       (t
        (manued-edit-comment-contents))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Normal Document <-> Manued Document
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun manued-convert-normal-to-manued (&optional normal-buffer)
  "Normal Document ̃obt@ Manued Document ɕϊ"
  (save-excursion
    (when normal-buffer
      (set-buffer normal-buffer))
    (let ((l-parenthesis-len (length manued-l-parenthesis-str)))
      (goto-char (manued-point-min))
      (while (scan-buffer manued-l-parenthesis-str :regexp nil)
        (insert manued-escape-str)
        (forward-char l-parenthesis-len)))))

(defun manued-convert-manued-to-normal (&optional manued-buffer)
  "Manued Document ̃obt@ Normal Document ɕϊ"
  (save-excursion
    (when manued-buffer
      (set-buffer manued-buffer))
    (let ((pattern (concat manued-escape-str manued-l-parenthesis-str))
          (escape-len (length manued-escape-str)))
      (goto-char (manued-point-min))
      (while (scan-buffer pattern :regexp nil)
        (delete-char escape-len)))))

(defun manued-create-manued-buffer (&optional normal-buffer)
  "Normal Document ̃obt@ Manued Document ̃obt@𐶐"
  (save-excursion
    (when normal-buffer
      (set-buffer normal-buffer))
    (let ((normal-buffer (selected-buffer))
          (manued-buffer (create-new-buffer
                          (concat (buffer-name (selected-buffer))
                                  " [Manued]"))))
      (with-output-to-buffer (manued-buffer)
        (format t "~A" (buffer-substring (point-min) (point-max))))
      (set-buffer manued-buffer)
      (manued-convert-normal-to-manued)
      (not-modified)
      manued-buffer)))

(defun manued-convert-to-manued-document (&optional normal-buffer)
  "Manued ҏWs߂́AR}hJnGR[hobt@𐶐"
  (interactive)
  (let ((manued-buffer (manued-create-manued-buffer normal-buffer)))
    (when manued-buffer
      (set-buffer manued-buffer))))

(defun manued-extract-normal-document (&optional old-p)
  (long-operation
    (let ((manued-buffer (selected-buffer))
          (normal-buffer (create-new-buffer "*Manued [Normal]*")))
      (save-excursion
        (with-output-to-buffer (normal-buffer)
          (format t "~A" (buffer-substring (point-min) (point-max))))
        (set-buffer normal-buffer)
        (setq manued-l-parenthesis-str (buffer-local-value manued-buffer 'manued-l-parenthesis-str)
              manued-r-parenthesis-str (buffer-local-value manued-buffer 'manued-r-parenthesis-str)
              manued-delete-str (buffer-local-value manued-buffer 'manued-delete-str)
              manued-swap-str (buffer-local-value manued-buffer 'manued-swap-str)
              manued-comment-str (buffer-local-value manued-buffer 'manued-comment-str)
              manued-escape-str (buffer-local-value manued-buffer 'manued-escape-str)
              manued-order-str (buffer-local-value manued-buffer 'manued-order-str)
              manued-version-str (buffer-local-value manued-buffer 'manued-version-str))
        (manued-eval-current-level-commands-strict nil old-p)
        (manued-convert-manued-to-normal)
        (not-modified))
      (pop-to-buffer normal-buffer))))
(defun manued-extract-normal-old-document ()
  "Manued `obt@AҏWOobt@𐶐"
  (interactive)
  (manued-extract-normal-document t))
(defun manued-extract-normal-new-document ()
  "Manued `obt@AҏWobt@𐶐"
  (interactive)
  (manued-extract-normal-document nil))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; \֘A
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun manued-delete-text-attributes (&optional f)
  (when f
    (delete-text-attributes *manued-eval-command-tag*))
  (delete-text-attributes *manued-tag*)
  (delete-text-attributes *manued-tag* :key #'safe-car))

(defun manued-refresh-screen (&optional f)
  (manued-eval-defcommand)
  (manued-delete-text-attributes)
  (manued-parse-commands-from-top-level)
  (refresh-screen f))
  
(defun manued-recenter (&optional arg)
  "R}h߂č\͂nCCg recenter sB"
  (interactive "p")
  (manued-refresh-screen)
  (recenter arg))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; j[
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defvar *manued-menu-name* "&Manued"
  "Manued j[")
(defvar *manued-menu-position* 'ed::help
  "Manued j[ʒu")

(defun manued-create-menu (&optional selection-only-p)
  (let ((menu (create-popup-menu 'manued)))
    (add-menu-item menu 'manued-recenter "&Highlight" 'manued-recenter)
    (add-menu-separator menu)
    (if selection-only-p
        (progn
          (add-menu-item menu 'manued-delete-command-selection
                         "Selection &Delete Command" 'manued-delete-command-selection
                         #'(lambda () (or (manued-pre-selection-p) :disable)))
          (add-menu-item menu 'manued-swap-command-selection
                         "Selection &Swap Command" 'manued-swap-command-selection
                         #'(lambda () (or (manued-pre-selection-p) :disable)))
          (add-menu-item menu 'manued-comment-selection
                         "Selection &Comment" 'manued-comment-selection
                         #'(lambda () (or (manued-pre-selection-p) :disable)))
          (add-menu-item menu 'manued-toggle-command-with-comment
                         "New Command &with Comment (Toggle)" 'manued-toggle-command-with-comment
                         #'(lambda () (and manued-command-with-comment-p :check)))
          (add-menu-separator menu)
          (add-menu-item menu 'manued-eval-command-selection
                         "Selection Extract Ne&w Document (Manued Format)" 'manued-eval-command-selection
                         #'(lambda () (or (manued-pre-selection-p) :disable)))
          (add-menu-item menu 'manued-eval-command-selection-old
                         "Selection Extract O&ld Document (Manued Format)" 'manued-eval-command-selection-old
                         #'(lambda () (or (manued-pre-selection-p) :disable))))
      (progn
        (add-popup-menu menu
                        (define-popup-menu
                          (:item nil "&Delete Command" 'manued-delete-command-selection
                           #'(lambda () (or (manued-pre-selection-p) :disable)))
                          (:item nil "&Swap Command" 'manued-swap-command-selection
                           #'(lambda () (or (manued-pre-selection-p) :disable)))
                          (:item nil "&Comment" 'manued-comment-selection
                           #'(lambda () (or (manued-pre-selection-p) :disable)))
                          :separator
                          (:item nil "Extract &New Document (Manued Format)" 'manued-eval-command-selection
                           #'(lambda () (or (manued-pre-selection-p) :disable)))
                          (:item nil "Extract &Old Document (Manued Format)" 'manued-eval-command-selection-old
                           #'(lambda () (or (manued-pre-selection-p) :disable))))
                        "&Selection")
        (add-popup-menu menu
                        (define-popup-menu
                          (:item nil "&Delete Command" 'manued-delete-command-region)
                          (:item nil "&Swap Command" 'manued-swap-command-region)
                          (:item nil "&Comment" 'manued-comment-region)
                          :separator
                          (:item nil "Extract &New Document (Manued Format)" 'manued-eval-command-region)
                          (:item nil "Extract &Old Document (Manued Format)" 'manued-eval-command-region-old))
                        "&Region")
        (add-menu-item menu 'manued-toggle-command-with-comment
                       "New Command &with Comment (Toggle)" 'manued-toggle-command-with-comment
                       #'(lambda () (and manued-command-with-comment-p :check)))))
    (add-menu-separator menu)
    (add-menu-item menu 'manued-edit-command
                   "Edit Comm&and" 'manued-edit-command
                   #'(lambda () (or (manued-l-parenthesis-p) :disable)))
    (add-menu-item menu 'manued-edit-delete-newer-contents
                   "Edit Dele&te Command" 'manued-edit-delete-newer-contents
                   #'(lambda () (or (manued-l-parenthesis-p) :disable)))
    (add-menu-item menu 'manued-change-swap-boundary
                   "Edit Swa&p Command" 'manued-change-swap-boundary
                   #'(lambda () (or (manued-l-parenthesis-p) :disable)))
    (add-menu-item menu 'manued-edit-comment-contents
                   "Edit Co&mment" 'manued-edit-comment-contents
                   #'(lambda () (or (manued-l-parenthesis-p) :disable)))
    (add-menu-separator menu)
    (add-menu-item menu 'manued-insert-header "&Insert Manued Header" 'manued-insert-header)
    (add-menu-item menu 'manued-eval-last-command "&Eval Last Manued Command"
                   'manued-eval-last-command)
    (add-menu-separator menu)
    (add-menu-item menu 'manued-undo "Manued &Undo" 'manued-undo)
    (add-menu-separator menu)
    (add-menu-item menu 'manued-convert-to-manued-document
                   "Con&vert to Manued Document (Manued Format)" 'manued-convert-to-manued-document)
    (add-menu-item menu 'manued-extract-normal-new-document
                   "Extract &New Document (Normal Format)" 'manued-extract-normal-new-document)
    (add-menu-item menu 'manued-extract-normal-old-document
                   "Extract &Old Document (Normal Format)" 'manued-extract-normal-old-document)
    (add-menu-separator menu)
    (add-menu-item menu 'manued-forward-l-parenthesis "Search &Forward"
                   'manued-forward-l-parenthesis)
    (add-menu-item menu 'manued-backward-l-parenthesis "Search &Backward"
                   'manued-backward-l-parenthesis)
    (add-menu-separator menu)
    (add-menu-item menu 'manued-goto-last-parse-command-error-point "&Goto Last Error"
                   'manued-goto-last-parse-command-error-point
                   #'(lambda () (or manued-last-parse-command-error-point :disable)))
    menu))

(defun manued-delete-menu (&optional (menu (current-menu)))
  (when (menup menu)
    (while (delete-menu menu 'manued))))

(defun manued-insert-menu (&key (menu (current-menu))
                                (position *manued-menu-position*)
                                (menu-name *manued-menu-name*))
  (let ((manued-menu (manued-create-menu)))
    (when (menup menu)
      (setq menu (copy-menu-items menu (create-menu)))
      (manued-delete-menu menu)
      (cond
       ((and (numberp position) (integerp position))
        (insert-popup-menu menu position manued-menu menu-name))
       ((and (symbolp position) (get-menu-position menu position))
        (insert-popup-menu menu (get-menu-position menu position)
                           manued-menu menu-name))
       (t
        (add-popup-menu menu manued-menu menu-name)))
      (use-local-menu menu))))

(defun manued-mouse-menu-popup (&optional apps)
  "ZNVp Manued j[|bvAbv"
  (interactive)
  (track-popup-menu (manued-create-menu t) (or apps :button2)))

(defun manued-apps-popup ()
  "ZNVp Manued j[|C^ʒuɃ|bvAbv"
  (interactive)
  (let ((*last-mouse-window* (selected-window))
        (*last-mouse-line* (current-virtual-line-number))
        (*last-mouse-column* (current-virtual-column)))
    (manued-mouse-menu-popup t)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; W[/}Ci[[h
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun manued-minor-mode (&optional (arg nil sv))
  "Manued t@CҏWp}Ci[[h"
  (interactive "p")
  (toggle-mode 'manued-minor-mode arg sv)
  (update-mode-line t)
  (if manued-minor-mode
      (progn
        (set-minor-mode-map *manued-minor-mode-map*)
        (manued-insert-menu)
        (manued-refresh-screen))
    (progn
      (unset-minor-mode-map *manued-minor-mode-map*)
      (manued-delete-menu)
      (manued-delete-text-attributes)))
  t)
(pushnew '(manued-minor-mode . "Manued") *minor-mode-alist* :key #'car)

(defun manued-mode ()
  "Manued t@CҏWpW[[h"
  (interactive)
  (kill-all-local-variables)
  (setq buffer-read-only t)
  (setq buffer-mode 'manued-mode)
  (setq mode-name "Manued")
  (use-keymap *manued-mode-map*)
  (use-syntax-table *manued-mode-syntax-table*)
  (and *manued-keyword-file*
       (null *manued-keyword-hash-table*)
       (setq *manued-keyword-hash-table*
             (load-keyword-file *manued-keyword-file* t)))
  (when *manued-keyword-hash-table*
    (make-local-variable 'keyword-hash-table)
    (setq keyword-hash-table *manued-keyword-hash-table*))
  (setq *local-abbrev-table* *manued-mode-abbrev-table*)
  (manued-insert-menu)
  (manued-refresh-screen)
  (run-hooks '*manued-mode-hook*))

;;; manued-mode.l ends here
