;;;
;;;  lleee.l : AKpR}h
;;;
;;;  written by sugi <y_sugi@anet.ne.jp> (November 16, 2004)

(provide "lleee")

(in-package "editor")

(export '(lleee *lleee-file-name* *lleee-line-num* *lleee-char-num* *lleee-default-tag*))

; ǂݍރt@C
(defvar *lleee-file-name* "~/lleee.txt")

; \s
(defvar *lleee-line-num* 3)

; 1 s̕
(defvar *lleee-char-num* 10)

; 擪ɂ̕񂪂sǂݍ
(defvar *lleee-default-tag* "LR")

; ̕擪ɂs̓RgƂ݂Ȃ
(defvar *lleee-comment-char* #\#)

; t@Cǂݍ݁A string ƂĕԂ
; filename:  ǂݍރt@C
; read-tag: ̕擪ɂsǂݍ
(defun read-kanji (filename read-tag)
  ; filename I[v(ǂݍ)
  (with-open-file (input_file filename :direction :input)
	; buff: s̃obt@
	; line_list: ܂œǂݍ񂾓e
	; read-regexp: }b`鐳K\
	(let (buff line-list read-regexp)
	  ; K\𐶐(Xy[X܂ł \1, Xy[Xオ \2 ɓ)
	  (setq read-regexp (concat "^\\(.*" read-tag ".*\\) \\(.*\\)"))
	  ; EOF ܂ňsǂݍ
	  (while (setq buff (read-line input_file nil))
		; read-regexp Ƀ}b`ŝݓǂݍ(Rgs͓ǂ܂Ȃ)
		(if (and (string-match read-regexp buff) (not (eq (char buff 0) *lleee-comment-char*))) 
			;(and 
			; ǂݍ񂾃f[^A(head-str ͍폜)
			(setq line-list	(concat line-list (string-replace-match buff "\\2")))))
	  ; 󔒂ƃ^u폜
	  (setq line-list
			(remove-if #'(lambda (char) (find char '(#\SPC #\TAB #\@))) line-list))
	  line-list)))

; XgA_ pickup-num ̊𒊏o
; XgɓĂ pickup-num 菭Ȃ͑So
; kanji-list: ̕񂩂ǂݍ
; pickup-num: ̐o
(defun get-rand-list (kanji-list pickup-num)
  ; XgȂȂ邩AoȂĂ悢 nil Ԃ
  (if (or (eq (length kanji-list) 0) (eq pickup-num 0))
	  nil
	; selected-char: Xg烉_ɑI񂾕
	(let (selected-char)
	  ; Xg烉_ 1 o
	  (setq selected-char (char kanji-list (random (length kanji-list))))
	  ; Xg璊o폜
	  (setq kanji-list (delete selected-char kanji-list))
	  ; oƎcXg烉_ pickup-num - 1 ôȂĕԂ
	  (concat (list selected-char) (get-rand-list  kanji-list (1- pickup-num))))))

; 𐮌`ăobt@ɏ
; rand-list: ޕ
; line-num: ̍s
; char-num: s̕
(defun write-kanji (rand-list line-num char-num)
  ; 1 sobt@ɏ
  (dotimes (i line-num)
	(let (current-line start end)
	  ; 1 s̊JnʒuƏIʒuvZ
	  (setq start (* i char-num))
	  ; Iʒu start  char-num (Xg̏I[͒Ȃ)
	  (setq end (min (+ start char-num)	(length rand-list)))
	  ; 1 s쐬
	  (setq current-line (subseq rand-list start end))
	  ; 1 sobt@ɏ
	  (insert (format nil "~A~%~%" current-line))
	  ; Xg̍Ō܂ŏI
	  (if (eq end (length rand-list))
		  (return)))))

; KpR}h
; head-str: 擪̍̕ŝݓǂݍ
; filename: ǂݍރt@C
; line-num: so͂邩
; char-num: 1 s艽o͂邩
(defun lleee (read-tag &optional (filename *lleee-file-name*) (line-num *lleee-line-num*) (char-num *lleee-char-num*))
  ; R}hƂĒ`
  (interactive "sread-tag:" :default0 *lleee-default-tag*)
  ; kanji-list: gp銿
  (let (kanji-list rand-list)
	; t@Cǂݍ݁AXg擾
	(setq kanji-list (read-kanji filename read-tag))
	;read-tag ɉĂȂ΁ASĂ̍s
	(if (equal (length read-tag) 0)
		(setq read-tag ".*"))
	; ̃V[hݒ
	(setq *random-state* (make-random-state t))
	; _ȊXg擾
	(setq rand-list (get-rand-list kanji-list (* line-num char-num)))
	; Vobt@쐬
	(with-output-to-temp-buffer ("*lleee*")
	  ; obt@ɏ
	  (write-kanji rand-list line-num char-num)))
  ; J[\obt@̐擪
  (goto-char (point-min))
  ; sɃJ[\ړ
  (forward-line))
