; -*- Mode: Lisp; Package: editor -*-

#|
= java-scrapbook - Java ̃R[hЂs

* Author:  miyamuko ((<URL:mailto:miyamuko (at) mtb.biglobe.ne.jp>))
* URL: ((<URL:http://miyamuko.s56.xrea.com/xyzzy/java-scrapbook.html>))
* Version: $Id: java-scrapbook.l,v 1.11 2004/09/13 17:02:06 miyamuko Exp $


== 

Java ̃R[hЂs܂B

ƂR[h̎sʂm肽ꍇɕ֗łB
O킩Ƃ Eclipse ɂ ScrapBook ̂ςłB

== ł邱

* ȒP Java \[X𐶐RpC  słB
* import włB
* classpath włB
  * eclipse  .classpath ǂݍ߂B

== ꂩ邩Ȃ

* \bh`
* NX`
* package ̎w
* obt@炸ɎsʂJ[\ʒuɑ}
  * G[ɂȂ\
*  jdk ȒPɐ؂ւ\ɂ
  * R[h𕡐 jdk ŎsČʂS\
    * sʂ̓o[WƂɃobt@邱Ƃł (diff ₷)

* package-list ǂݍŃChJ[h import w

== CXg[

((<NetInstaller|URL:http://www.mirai.ne.jp/~gyo/xyzzy/ni.html>)) ŃCXg[ꍇ 3 ȍ~A
NetInstaller + (({ni-autoload})) gĂl 4 ȍ~ OK łB

(1) A[JCu_E[h܂B

    ((<URL:http://miyamuko.s56.xrea.com/xyzzy/archives/java-scrapbook.zip>))

(2) A[JCuWJāA$XYZZY/site-lisp zɃt@CRs[܂B

(3) ~/.xyzzy ܂ $XYZZY/site-lisp/siteinit.l Ɉȉ̃R[hǉ܂B

        ;; java-scrapbook
        (require "java-scrapbook")

(4) ݒ𔽉f邽 xyzzy ċNĂB

    siteinit.l ɋLqꍇɂ͍ă_vKvłB

(5) sR[hЂ[WŎw肵 ((% M-x java-scrapbook-region %))A
    ܂ ((% M-x java-scrapbook-oneliner %))A((% M-x java-scrapbook-display %))
    Ń~jobt@s͂Ďs܂B

    : VXevpeB\ (java-scrapbook-oneliner œ)B

        System.getProperties().list(System.out);


== t@X

=== ֐

--- java-scrapbook-current-kill
    kill ring ̕ java R[hЂƂĎs܂B

--- java-scrapbook-clipboard
    Nbv{[h̕ java R[hЂƂĎs܂B

--- java-scrapbook-buffer
    obt@Ŝ Java R[hs܂B

--- java-scrapbook-region
    [W Java R[hs܂B

--- java-scrapbook-oneliner
    ~jobt@ Java ̃R[hs͂Ďs܂B

--- java-scrapbook-display
    ~jobt@ Java ̎s͂Ă̕]ʂ\܂B

    ͂l͂̂܂ System.out.println ̈ɓn܂B
    ē͂̂ Java ̎łKv܂B
    (= Z~R͂Ȃ)

=== ϐ

--- *java-scrapbook-template*
    \[Xt@C̃ev[gw肵܂B

    ev[g͈ȉ̈^ format ܂B

    (1) import 錾̃Xg

        ((<*java-scrapbook-import-list*>)) Ŏw肵XgłB

    (2) R[hВɏĂ import 錾̃Xg

    (3) NX

    (4) s Java R[h

--- *java-scrapbook-import-list*
     import 錾̃XgłB

     ftHg Java 1.4  java. Ŏn܂
     AWT  Applet ȊÕpbP[WłB

     Java 1.2 or 1.3 𗘗pĂl͈ȉ̂悤ɂĂB

         (setf *java-scrapbook-import-list* *java-scrapbook-java1.3-import-list*)

     Vǉꍇ͈ȉ̂悤ɂĂB

        (pushnew "javax.accessibility.*" *java-scrapbook-import-list* :test #'equal)
        (pushnew "javax.crypto.*" *java-scrapbook-import-list* :test #'equal)

--- *java-scrapbook-java1.3-import-list*
--- *java-scrapbook-java1.4-import-list*
    ꂼ Java 1.2/1.3  Java1.4  import 錾̃XgłB

--- *java-scrapbook-substitute-alist*
      Java R[h̒uXgłB

     ftHgł sout  serr ꂼ
     System.out.println  System.err.println ɒu悤
     ȂĂ܂B

     Vǉꍇ͈ȉ̂悤ɂĂB

         (pushnew '("regexp" . "replacement") *java-scrapbook-substitute-alist*)

     :

         (pushnew '("ae" . "assertEquals") *java-scrapbook-substitute-alist*)

--- *java-scrapbook-keep-file-p*
      Java t@CۑE폜肷tOłB

     t@C폜ȂȂȉ̂悤 ((|non-nil|)) w肵ĂB

         (setq *java-scrapbook-keep-file-p* t)

     ͊ϐ ((|%Temp%|)) ziԂj Scrap_`.book
     ƂfBNgłB

     ftHg nil i폜jłB

--- *java-scrapbook-source-buffer-name*
--- *java-scrapbook-javac-buffer-name*
--- *java-scrapbook-java-buffer-name*
     ꂼꐶ\[XR[hARpCʁAsʂ
     ރobt@łB

     ftHgׂ͂ē ((|*Java Scrap*|)) łB

--- *java-scrapbook-java-command*
--- *java-scrapbook-javac-command*

    Java ̎sR}hƃRpCR}hw肵܂B

    ȊOw肷ƓKɕɕϊ܂B
    ֐w肵ꍇ funcall ̂œIɒlύXł܂B

--- *java-scrapbook-before-java-hook*
--- *java-scrapbook-before-javac-hook*

    ȂƂȂpӂtbNłB
    vvZbTɒʂƂ ajc ƂɎg邩B

    ꂼ java R}h̑O javac R}h̑O
    (({run-hook-with-args-while-success})) Ŏs܂B
    tbN ((|nil|)) ԂƂ̎_łׂĂ̎s𒆒f܂B

    tbN͎̈̂ƂłB

      (1) \[Xt@C̐΃pX
      (2) NX

--- *java-scrapbook-search-eclipse-classpath-p*

    Eclipse  .classpath t@Cǂݍނǂw肵܂B
    ((|nil|)) w肵ꍇAǂݍ݂܂B

    .classpath ̌̓JgfBNgʂɒT܂B

--- *java-scrapbook-classpath*

    NXpXw肵܂B
    ftHgl͊ϐ CLASSPATH ̒lłB

    ((< *java-scrapbook-search-eclipse-classpath-p* >))  ((|non-nil|))
    w肵ꍇ Eclipse  .classpath t@CǂݍŃNXpX
    擪ɒǉ܂B

--- *java-scrapbook-erase-output-buffer*

    javac R}h java R}hsOɃobt@̓e폜ꍇ t
    (ftHg ((|nil|)))B


== CZX

java-scrapbook ͏C BSD CZXɊÂėp\łB

  Copyright (C) 2003-2004 MIYAMUKO Katsuyuki. All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are
  met:

  1 Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer as the first lines
    of this file unmodified.

  2 Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
  SUCH DAMAGE.
|#

(provide "java-scrapbook")
(in-package "editor")

(export '(java-scrapbook-current-kill
          java-scrapbook-clipboard
          java-scrapbook-buffer
          java-scrapbook-region
          java-scrapbook-oneliner
          java-scrapbook-display
          *java-scrapbook-template*
          *java-scrapbook-import-list*
          *java-scrapbook-java1.3-import-list*
          *java-scrapbook-java1.4-import-list*
          *java-scrapbook-substitute-alist*
          *java-scrapbook-keep-file-p*
          *java-scrapbook-source-buffer-name*
          *java-scrapbook-javac-buffer-name*
          *java-scrapbook-java-buffer-name*
          *java-scrapbook-java-command*
          *java-scrapbook-javac-command*
          *java-scrapbook-source-dir*
          *java-scrapbook-search-eclipse-classpath-p*
          *java-scrapbook-classpath*
          *java-scrapbook-erase-output-buffer*
          *java-scrapbook-before-java-hook*
          *java-scrapbook-before-javac-hook*
          ))


;; ----------------------------------------------------------------------
;; Hooks

(defvar *java-scrapbook-before-javac-hook* nil
  "java-scrapbook: RpCR}h̑OɌĂ΂B
:
  1.  Java \[X̃t@C
  2. NX
nil ԂꍇŏfB")

(defvar *java-scrapbook-before-java-hook* nil
  "java-scrapbook: sR}h̑OɌĂ΂B
:
  1.  Java \[X̃t@C
  2. NX
nil ԂꍇŏfB")

;; ----------------------------------------------------------------------
;; variables

(defvar *java-scrapbook-template*
"~{import ~A; ~}

~{import ~A; ~}

public class ~A {
    public static void main(String[] args) throws Exception {
~A
    }
}
"
  "java-scrapbook: \[Xt@C̃ev[gB
   arguments: (import list) (local import list) class statements")

(defvar *java-scrapbook-java1.3-import-list*
  '("java.beans.*"
    "java.beans.beancontext.*"
    "java.io.*"
    "java.lang.*"
    "java.lang.ref.*"
    "java.lang.reflect.*"
    "java.math.*"
    "java.net.*"
    "java.rmi.*"
    "java.rmi.activation.*"
    "java.rmi.dgc.*"
    "java.rmi.registry.*"
    "java.rmi.server.*"
    "java.security.*"
    "java.security.acl.*"
    "java.security.cert.*"
    "java.security.interfaces.*"
    "java.security.spec.*"
    "java.sql.*"
    "java.text.*"
    "java.util.*"
    "java.util.jar.*"
    "java.util.zip.*")
  "java-scrapbook: Java2 SDK 1.2, 1.3  import 錾̃Xg")

(defvar *java-scrapbook-java1.4-import-list*
  (append *java-scrapbook-java1.3-import-list*
          '("java.nio.*"
            "java.nio.channels.*"
            "java.nio.channels.spi.*"
            "java.nio.charset.*"
            "java.nio.charset.spi.*"
            "java.util.logging.*"
            "java.util.prefs.*"
            "java.util.regex.*"))
  "java-scrapbook: Java2 SDK 1.4  import 錾̃Xg")

(defvar *java-scrapbook-import-list*
  *java-scrapbook-java1.4-import-list*
  "java-scrapbook: \[X𐶐Ƃ import 錾̃Xg")

(defvar *java-scrapbook-substitute-alist*
  '(("\\<sout\\>" . "System.out.println")
    ("\\<serr\\>" . "System.err.println"))
  "java-scrapbook: uXg")

(defvar *java-scrapbook-keep-file-p* nil
  "java-scrapbook:  java \[Xt@C폜Ȃ t")

(defvar *java-scrapbook-source-buffer-name* "*Java Scrap*"
  "java-scrapbook: \[Xވꎞobt@̖O")

(defvar *java-scrapbook-javac-buffer-name* "*Java Scrap*"
  "java-scrapbook: RpCʂވꎞobt@̖O")

(defvar *java-scrapbook-java-buffer-name* "*Java Scrap*"
  "java-scrapbook: sʂވꎞobt@̖O")

(defvar *java-scrapbook-java-command* "java"
  "java-scrapbook: java R}h")

(defvar *java-scrapbook-javac-command* "javac"
  "java-scrapbook: javac R}h")

(defvar *java-scrapbook-source-dir* nil
  "java-scrapbook: \[X̏o͐fBNgB
   nil w肷Ɗϐ %Temp% 𗘗pB
   ݂ĂfBNgw肷KvB")

(defvar *java-scrapbook-classpath* (si:getenv "CLASSPATH")
  "java-scrapbook: ftHg̃NXpXB
ftHg͊ϐ CLASSPATH ̒l")

(defvar *java-scrapbook-search-eclipse-classpath-p* t
  "java-scrapbook: eclipse  .classpath Ȃ tB
݂ directory ʂɌĂ")

(defvar *java-scrapbook-erase-output-buffer* nil
  "java-scrapbook: o̓obt@ javac, java R}hsO erase-buffer Ȃ t")


(defvar *java-scrapbook-class-name* "Scrap"
  "java-scrapbook: \[X̃NX")

(defvar *java-scrapbook-import-regexp* "^import[ \t]+\\([^;]+\\);?$"
  "java-scrapbook: import ̃p^[")

(defvar *java-scrapbook-temp-buffer-name* "*java scrapbook:temp"
  "java-scrapbook: ꎞobt@̖O")

;; ----------------------------------------------------------------------
;; commands

(defun java-scrapbook-current-kill ()
  "java-scrapbook: kill ring  java R[hsB"
  (interactive)
  (java-scrapbook (car (ed::current-kill 0))))

(defun java-scrapbook-clipboard ()
  "java-scrapbook: Nbv{[h java R[hsB"
  (interactive)
  (java-scrapbook (get-clipboard-data)))

(defun java-scrapbook-region ()
  "java-scrapbook: obt@ŜsB"
  (interactive)
  (java-scrapbook-region (point-min) (point-max)))

(defun java-scrapbook-region (start end)
  "java-scrapbook: [WsB"
  (interactive "r")
  (if (< end start) (rotatef start end))
  (java-scrapbook (buffer-substring start end)))

(defun java-scrapbook-oneliner (statement)
  "java-scrapbook: ~jobt@ Java ̃R[hs͂ĎsB"
  (interactive "sjava statement: ")
  (java-scrapbook statement))

(defun java-scrapbook-display (expression)
  "java-scrapbook: ~jobt@ Java ̎s͂Ă̕]ʂ\B"
  (interactive "sjava expression: ")
  (java-scrapbook (concat "System.out.println(" expression ");")))

;;
;; private
;;
(defun java-scrapbook (scrap)
  (let* ((dir (make-temp-file-name "Scrap_" "book" *java-scrapbook-source-dir* t))
         (file (merge-pathnames (concat *java-scrapbook-class-name* ".java") dir))
         (class *java-scrapbook-class-name*))

    (java-scrapbook-save-page file class scrap)
    (unwind-protect
        (and
         (run-hook-with-args-while-success
          '*java-scrapbook-before-javac-hook* file class)
         (zerop (java-scrapbook-execute-scrap
                 (java-scrapbook-command (java-scrapbook-javac-command)
                                         (java-scrapbook-classpath)
                                         file)
                 *java-scrapbook-javac-buffer-name*
                 dir))
         (run-hook-with-args-while-success
          '*java-scrapbook-before-java-hook* file class)
         (zerop (java-scrapbook-execute-scrap
                 (java-scrapbook-command (java-scrapbook-java-command)
                                         (java-scrapbook-classpath)
                                         class)
                 *java-scrapbook-java-buffer-name*
                 dir)))
      (unless *java-scrapbook-keep-file-p*
        (java-scrapbook-delete-directory-recursive dir)))
    ))

(defun java-scrapbook-command (exe classpath arg)
  (let ((cp (string-trim " \t\r\f\n" (or classpath ""))))
    (if (zerop (length cp))
        (format nil "~A ~A" exe arg)
      (format nil "~A -classpath ~A ~A" exe cp arg))))

(defun java-scrapbook-save-page (file class scrap)
  (with-output-to-temp-buffer (*java-scrapbook-source-buffer-name*)
    (insert (java-scrapbook-generate-src class scrap) #\LFD)
    (java-scrapbook-preprocess)
    (set-buffer (find-buffer *java-scrapbook-source-buffer-name*))
    (write-file file)))

(defun java-scrapbook-generate-src (class scrap)
  (multiple-value-bind (local-import rest)
      (java-scrapbook-parse scrap)
    (format nil *java-scrapbook-template*
            *java-scrapbook-import-list* local-import
            class rest)))

;; "foo;\nimport hoge.*;\nbar;\nimport baz.*"
;; => (values "foo;\n\nbar\n" ("hoge.*" "baz.*"))
(defun java-scrapbook-parse (scrap)
  (let (import-list (rest scrap))
    (setf rest (java-scrapbook-gsub *java-scrapbook-import-regexp*
                                    rest #'(lambda (s)
                                             (push (match-string 1) import-list)
                                             "")))
    (values import-list rest)))

(defun java-scrapbook-preprocess ()
  (save-excursion
    (goto-char (point-min))
    (java-scrapbook-substitute-buffer *java-scrapbook-substitute-alist*)))

(defun java-scrapbook-substitute-buffer (sub-alist)
  (when sub-alist
    (save-excursion
      (replace-buffer (caar sub-alist) (cdar sub-alist) :regexp t))
    (java-scrapbook-substitute-buffer (cdr sub-alist))))

(defun java-scrapbook-execute-scrap (command output dir &optional msg)
  (long-operation
    (progn
      (let ((buffer (get-buffer-create output)))
        (set-buffer buffer)
        (when *java-scrapbook-erase-output-buffer*
          (erase-buffer (selected-buffer)))
        (goto-char (point-max))
        (insert (format nil "> ~A~%" command))
        (message "~A" (or msg command))
        (make-process command :output buffer :exec-directory dir)
        (java-scrapbook-wait-for-exit-process (buffer-process buffer))))))

(defun java-scrapbook-wait-for-exit-process (proc &optional (interval 0.1))
  (while (eq (process-status proc) ':run)
    (sit-for interval))
  (process-exit-code proc))

(defun java-scrapbook-javac-command ()
  (java-scrapbook-as-string *java-scrapbook-javac-command*))

(defun java-scrapbook-java-command ()
  (java-scrapbook-as-string *java-scrapbook-java-command*))

;;
;; eclipse classpath
;;

(defun java-scrapbook-classpath ()
  (let ((classpath (list (java-scrapbook-as-string *java-scrapbook-classpath*))))
    (when *java-scrapbook-search-eclipse-classpath-p*
      (setf classpath (append (java-scrapbook-eclipse-classpath-entry
                               (java-scrapbook-eclipse-classpath-file))
                              classpath)))
    (java-scrapbook-join ";" classpath)))

;; <classpathentry kind="lib" path="D:/opt/java/junit3.8.1/junit.jar" sourcepath="D:/opt/java/junit3.8.1/src.jar"/>
;; <classpathentry kind="lib" path="lib/xsdlib.jar"/>
;; <classpathentry kind="output" path="build/classes"/>
(defun java-scrapbook-eclipse-classpath-entry (dot-classpath)
  (unless dot-classpath
    (return-from java-scrapbook-eclipse-classpath-entry))
  (let (buffer result)
    (unwind-protect
        (progn
          (setf buffer (create-new-buffer *java-scrapbook-temp-buffer-name*))
          (set-buffer buffer)
          (insert-file-contents dot-classpath)
          (goto-char (point-min))
          (while (scan-buffer "kind=\"\\(lib\\|output\\)\" +path=\"\\([^\"]+\\)\""
                              :regexp t :tail t)
            (push (match-string 2) result)))
      (delete-buffer buffer))
    ;; map to fullpath
    (mapcar #'(lambda (lib)
                (if (string-matchp "[a-z]:/" lib)
                    lib
                  (merge-pathnames lib (directory-namestring dot-classpath))))
            result)))

(defun java-scrapbook-eclipse-classpath-file
  (&optional (dir (directory-namestring (or (get-buffer-file-name) ""))))
  (when dir
    (if (file-exist-p (merge-pathnames ".classpath" dir))
        (merge-pathnames ".classpath" dir)
      (java-scrapbook-eclipse-classpath-file (java-scrapbook-parent-directory dir)))))

;;
;; util
;;

(defun java-scrapbook-as-string (something)
  (cond ((null something)
         "")
        ((stringp something)
         something)
        ((listp something)
         (format nil "~A" (mapcar #'java-scrapbook-as-string something)))
        ((functionp something)
         (java-scrapbook-as-string (funcall something)))
        ((characterp something)
         (format nil "~A" something))
        (t
         (format nil "~S" something))))

(defun java-scrapbook-gsub (re str fn)
  (unless (and re str)
    (return-from java-scrapbook-gsub str))
  (let ((result))
    (labels ((java-scrapbook-gsub-internal (re str fn start)
               (if (string-match re str start)
                   (progn
                     (push (substring str start (match-beginning 0)) result)
                     (if fn (push (funcall fn (match-string 0)) result))
                     (java-scrapbook-gsub-internal re str fn (match-end 0)))
                 (push (substring str start) result))))
      (java-scrapbook-gsub-internal re str fn 0))
    (format nil "~{~A~}" (reverse result))))

(defun java-scrapbook-parent-directory (dir)
  (multiple-value-bind (result count)
      (substitute-string (map-backslash-to-slash dir) "[^/]+/?$" "")
    (if (or (zerop count)
            (zerop (length result)))
        nil
      result)))

(defun java-scrapbook-delete-directory-recursive (dir)
  (dolist (file (directory dir))
    (if (file-directory-p file)
        (java-scrapbook-delete-directory-recursive file)
      (delete-file (merge-pathnames file dir))))
  (delete-directory dir))

(defun java-scrapbook-join (sep l)
  (format nil (concat "~A~{" sep "~A~}") (car l) (cdr l)))

;;
;; $Id: java-scrapbook.l,v 1.11 2004/09/13 17:02:06 miyamuko Exp $
;;
