; -*- Mode: Lisp; Package: editor -*-

#|
= is-mode - InstallScript t@CҏW肷

* Author:  miyamuko ((<URL:mailto:miyamuko (at) mtb.biglobe.ne.jp>))
* URL: ((<URL:http://miyamuko.s56.xrea.com/xyzzy/is-mode.html>))
* Version: $Id: is-mode.l,v 1.9 2004/08/09 14:03:06 miyamuko Exp $


== 

InstallScript (InstallShield pXNvg) p̕ҏW[hłB

* KȃCfg
* KȐFÂ
* L[[h̕⊮
* function  #define ̃^OWv


== CXg[

((<NetInstaller|URL:http://www.mirai.ne.jp/~gyo/xyzzy/ni.html>)) ŃCXg[ꍇ 3 ȍ~A
NetInstaller + (({ni-autoload})) gĂl 4 ȍ~ OK łB

(1) A[JCu_E[h܂B

    ((<URL:http://miyamuko.s56.xrea.com/xyzzy/archives/is-mode.zip>))

(2) A[JCuWJāA$XYZZY/site-lisp zɃt@CRs[܂B

(3) gq rul ̃t@CJƂɎI is-mode ɂȂ悤
    ~/.xyzzy ܂ $XYZZY/site-lisp/siteinit.l Ɉȉ̃R[hǉ܂B

        ;; is-mode
        (require "is-mode")
        (pushnew '("\\.rul$" . is-mode) *auto-mode-alist* :test 'equal)

(4) ݒ𔽉f邽 xyzzy ċNĂB

    siteinit.l ɋLqꍇɂ͍ă_vKvłB


== t@X

=== L[蓖

: ((%TAB%))
    CfgB

    Compiler directive (#defineƂ) ̓Cfg܂B

: ((%RET%))
    s{CfgtB

: ((%M-TAB%))
    L[[hƑgݍ݊֐̕⊮B

    s镶΂̕n܂L[[hc[`bvŕ\܂B
    s镶Ȃ΂ׂẴL[[h\܂B

=== ϐ

--- *is-label-level*
--- *is-label-offset*

Cfgxݒ肵܂B

    ;; Cfg̕(} _ ̕, default=4)
    (setq *is-indent-level* 4)

    ;; x̃ItZbg(} - ̕, default=-4)
    ;;; ̂߂̂肦ȂݒB
    (setq *is-label-offset* 4)

    ;; function Foo(nBar)
    ;; ____number nFoo;
    ;; begin
    ;; ____if (nBar != 0) goto Baz;
    ;; ____nFoo = 10
    ;; ____----Label:
    ;; ____// ...
    ;; end;


== ꂩ邩Ȃ

* MSI ̃L[[h܂Ƃ߂B
* t@XB
* Xe[ggpꍇ̃CfgƂB
* łAւȂ傱Ȃ̂ŕu


== m̃oO

ȉ̂悤ȏꍇK؂ɃCfgłȂB

    if (szHoge == "HOGE"
    || szFoo == "FOO") then  // ̍sCfgłȂ
    endif;

    nPos = StrFind(svTarget,
    szFindMe);  // 

{͎̂悤ɂB

    if (szHoge == "HOGE"
        || szFoo == "FOO") then
    endif;

    nPos = StrFind(svTarget,
                   szFindMe);

łCȂB


== ֘A邩Ȃy[W

: InstallShield - Software Installation and Migration for SysAdmins and Developers
    ((<URL:http://www.installshield.com/>))


== CZX

properties-mode ͏C BSD CZXɊÂėp\łB

  Copyright (C) 2003-2004 MIYAMUKO Katsuyuki. All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are
  met:

  1 Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer as the first lines
  of this file unmodified.

  2 Redistributions in binary form must reproduce the above copyright
  notice, this list of conditions and the following disclaimer in the
  documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
  SUCH DAMAGE.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:
|#


(provide "is-mode")
(in-package "editor")
(export '(*is-mode-hook*
          *is-mode-map*
          *is-comment-column*
          *is-indent-level*
          *is-label-offset*
          is-completion
          is-mode))

; tbN
(defvar *is-mode-hook* nil
  "is-mode: tbNϐ")

; configuration
(defvar *is-comment-column* nil)
(defvar *is-indent-level* 4
  "CfgœXy[X̐")
(defvar *is-label-offset* -4
  "x̃ItZbg")

; compiled regexp
(defvar *is-label-regexp*
  (compile-regexp "^[ \t]*[A-Z_][A-Z0-9_]*:[ \t]*$")
  "x̐K\")

(defvar *is-block-beg-regexp*
  (compile-regexp "\\<try\\|for\\|program\\|switch\\|while\\|function\\|repeat\\>")
  "ubNJn鎯ʎq̐K\B
   ̂قɂ if ... then B
   if ... goto label; Ƃʂ if \̂ŒP if ŃubNJnłȂB
  ")

(defvar *is-block-mid-regexp*
  (compile-regexp "\\<begin\\|case\\|default\\|catch\\|else\\|elseif\\>"))

(defvar *is-block-end-regexp*
  (compile-regexp "\\<\\(until\\|end\\(catch\\|for\\|if\\|program\\|switch\\|while\\)?\\)\\>"))


; L[[h
(defvar *is-completion-list* nil
  "is-mode: ⊮Xg̃|bvAbv")

(defvar *is-keyword-hash-table* nil)
(defvar *is-keyword-file* "InstallScript")

;; label color
(defvar *is-label-color* '(:keyword 0 :bold)
  "x̐F")

(defvar *is-regexp-keyword-list* nil
  "is-mode: K\L[[hXg")

(setq *is-regexp-keyword-list*
  (compile-regexp-keyword-list
   `(
     ;; xs
     (,*is-label-regexp* t ((0 . ,*is-label-color*)))
     )))


;; V^bNXe[u
(defvar *is-mode-syntax-table* nil)
(unless *is-mode-syntax-table*
  (setq *is-mode-syntax-table* (make-syntax-table))
  (do ((x #x21 (1+ x))) ((>= x #x7f))
    (let ((c (code-char x)))
      (unless (alphanumericp c)
        (set-syntax-punctuation *is-mode-syntax-table* c))))
  ; ȉmodeɍ킹Đݒ
  (set-syntax-word *is-mode-syntax-table* #\#)
  (set-syntax-string *is-mode-syntax-table* #\")
  (set-syntax-string *is-mode-syntax-table* #\')
  (set-syntax-escape *is-mode-syntax-table* #\\)
  (set-syntax-symbol *is-mode-syntax-table* #\_)
  (set-syntax-match *is-mode-syntax-table* #\( #\)) ; Ή()ɔ
  (set-syntax-match *is-mode-syntax-table* #\{ #\})
  (set-syntax-match *is-mode-syntax-table* #\[ #\])
  (set-syntax-start-multi-comment *is-mode-syntax-table* "/*")
  (set-syntax-end-multi-comment *is-mode-syntax-table* "*/")
  (set-syntax-start-c++-comment *is-mode-syntax-table* #\/)
  (set-syntax-end-c++-comment *is-mode-syntax-table* #\LFD)
  )

;; L[}bv
(defvar *is-mode-map* nil)
(unless *is-mode-map*
  (setq *is-mode-map* (make-sparse-keymap))
  ; ȉL[
  (define-key *is-mode-map* #\# 'is-electric-insert)
  (define-key *is-mode-map* #\: 'is-electric-insert)
  (define-key *is-mode-map* #\C-h 'backward-delete-char-untabify-or-selection)
  (define-key *is-mode-map* #\TAB 'is-indent-line)
  (define-key *is-mode-map* #\C-M-q 'indent-sexp)
  (define-key *is-mode-map* #\RET 'is-newline-and-indent)
  (define-key *is-mode-map* #\M-TAB 'is-completion)       ; ⊮
  )

(defun is-electric-insert (&optional (arg 1))
  (interactive "*p")
  (self-insert-command arg)
  (is-indent-line))

(defun is-newline-and-indent (&optional (arg 1))
  (interactive "*p")
  (is-indent-line)
  (delete-trailing-spaces)
  (insert #\LFD arg)
  (is-indent-line))

; from c-indent-line
(defun is-indent-line ()
  (interactive "*")
  (if (or (not (interactive-p))
          *c-tab-always-indent*
          (save-excursion
            (skip-chars-backward " \t")
            (bolp)))
      (case (save-excursion
              (goto-bol)
              (parse-point-syntax))
        (:string)
        (:comment
         (let ((column (calc-c-comment-indent)))
           (when (integerp column)
             (smart-indentation column))))
        (t
         (let ((column (calc-is-indent)))
           (when (integerp column)
             (smart-indentation column)))))
    (insert "\t"))
  t)

(defun is-previous-line ()
  "O̗Lȍs܂Ŗ߂"
  (let ((in-conditional-compilation nil))
    (save-restriction
      (while (forward-line -1)
        (goto-bol)
        (cond
         ;; #else ̒ɂꍇ #ifdef ̑O܂Ŗ߂
         (in-conditional-compilation
          (if (looking-at "[ \t]*#ifn?def")
              (setq in-conditional-compilation nil)))
         ((equal (parse-point-syntax) :comment)
          ; nop
          )
         ((looking-at "[ \t]*#else")
          (setq in-conditional-compilation t))
         ((not (or (is-space-line) (is-compiler-directive) (is-label)))
          (return-from is-previous-line t))
         ))
      )))

(defun is-space-line ()
  "sǂ"
  (save-excursion
    (goto-bol)
    (looking-at "[ \t]*$")))

(defun is-compiler-directive ()
  "compiler directive ǂ"
  (save-excursion
    (goto-bol)
    (looking-at "[ \t]*#")))

(defun is-label ()
  "xǂ"
  (save-excursion
    (goto-bol)
    (looking-at *is-label-regexp*)))

(defun calc-is-indent ()
  "Cfg鐔𐔂B"
  (let ((column 0))
    ; compiler directive ̓CfgȂ
    (if (is-compiler-directive)
        (return-from calc-is-indent 0))

    (save-excursion
      ;O̍s𒲂ׂ
      (when (is-previous-line)
        (save-restriction
          (narrow-to-region (progn (goto-eol) (point))
                            (progn (goto-bol) (point)))
          (goto-bol)
          (skip-chars-forward " \t")
          ; Cfg
          (setq column (current-column))
;          (msgbox "base indent(line ~D): ~D" (current-line-number) column)

          ; Ĵ΃Cfg𑝂₷
          (cond
           ((or (looking-at *is-block-beg-regexp*)
                (looking-at *is-block-mid-regexp*)
                (and (looking-at "if") (scan-buffer "then[ \t]*$" :regexp t)))
            (incf column *is-indent-level*)
;            (msgbox " open ~D" column)
            ))
          )))
    ; ݂̍s𒲂ׂ
    (save-excursion
      (goto-bol)
      (skip-chars-forward " \t")
      ; ̂΃Cfg炷
      (cond
       ((or (looking-at *is-block-mid-regexp*)
            (looking-at *is-block-end-regexp*))
        (decf column *is-indent-level*)
;        (msgbox "close ~D" column)
        ))
      ; xȂ *is-label-offset* ₷
      (if (is-label)
          (return-from calc-is-indent (+ column *is-label-offset*)))
      )
    column
    ))


; ⊮
;; addrev-table
(defvar *is-mode-abbrev-table* nil)
(unless *is-mode-abbrev-table*
  (define-abbrev-table '*is-mode-abbrev-table*))

;; popup ⊮
(defun is-completion ()
  "is-mode: ⊮"
  (interactive)
  (or *is-completion-list*
      (setq *is-completion-list* (make-list-from-keyword-table *is-keyword-hash-table*))
      (return-from is-completion nil))
  (let ((opoint (point)))
    (skip-syntax-spec-backward "w_")
    (let ((from (point)))
      (goto-char opoint)
      ; :list-ignore-case=⊮ő啶ʂȂ, :list=
      (do-completion from opoint :list-ignore-case *is-completion-list*
                     nil nil *is-completion-list* ; xyzzy 0.2.2.211ȑOgꍇ̓RgAEg
                     ))))

; function ̈ꗗ
(defun is-build-summary-of-functions ()
  (let ((result nil))
    (save-excursion
      (goto-char (point-min))
      (while (scan-buffer (concat "^[ \t]*function[ \t]+"
                                  "\\([a-zA-Z0-9_]+[ \t]+\\)?"
                                  "\\([a-zA-Z0-9_]+\\)[ \t]*(")
                          :regexp t :tail t)
        (push (list (current-line-number) (match-string 2)) result)))
    (nreverse result)
    ))

; tag
(pushnew '(is-maketags "*.rul" "*.h") *maketags-list* :key #'car)

(defun tags-find-is-point (class name functionp point)
  (goto-char (- point *jump-tag-limit*))
  (and (or (scan-buffer "^#[ \t]*define[ \t]+[A-Z_]+"
                        :regexp t :limit (+ point *jump-tag-limit*))
           (scan-buffer (concat "^[ \t]*function[ \t]+"
                                "\\([a-zA-Z]+[ \t]+\\)?"
                                (regexp-quote name) "[ \t]+(")
                        :regexp t :limit (+ point *jump-tag-limit*)))
       (point)))

;; function ^Ot
;;   function [return type] name (parameters)
(defun is-maketags (file count)
  (goto-char (point-min))
  (while (scan-buffer "^[ \t]*\\(#define\\|function\\)[ \t]+" :regexp t :tail t :case-fold t)
    (do-events)
    (when (and (equal (match-string 1) "function")
               (looking-at "[a-zA-Z0-9_]+[ \t]+"))
      (goto-char (match-end 0)))
    (let ((opoint (point)))
      (skip-chars-forward "a-zA-Z0-9_")
      (unless (= opoint (point))
        (format t "~A~A~D" (buffer-substring opoint (point)) file opoint)
        (setq count (1+ count)))))
  count)

; mode̎s
(defun is-mode ()
  "is-mode"
  (interactive)
  (kill-all-local-variables)
  (setq mode-name "InstallScript")
  (setq buffer-mode 'is-mode)
  (use-syntax-table *is-mode-syntax-table*)
  (use-keymap *is-mode-map*)

  ; WJ
  (setq *local-abbrev-table* *is-mode-abbrev-table*)

  (make-local-variable 'paragraph-start)
  (setq paragraph-start "^$\\|\f") ; forward|backward-paragraph ňړiʒu
  (make-local-variable 'paragraph-separate)
  (setq paragraph-separate paragraph-start)

  ; ^O֘A
  (make-local-variable 'tags-find-target)
  (setq tags-find-target #'tags-find-target-simple)
  (make-local-variable 'tags-find-point)
  (setq tags-find-point #'tags-find-is-point)
  (make-local-variable 'build-summary-function)
  (setq build-summary-function 'is-build-summary-of-functions)

  ; indent
  (make-local-variable 'mode-specific-indent-command)
  (setq mode-specific-indent-command 'is-indent-line)
  (make-local-variable 'mode-newline-and-indent-command)
  (setq mode-newline-and-indent-command 'is-newline-and-indent)

  ; comment
  (setq comment-start "// " comment-end "") ; indent-for-commentő}z
  (setq comment-start-skip "/+[ \t]*")
  (setq comment-indent-function 'calc-is-indent)
  (when *is-comment-column*
    (setq comment-column *is-comment-column*))

  ; keyword
  (and *is-keyword-file*
       (null *is-keyword-hash-table*)
       (setq *is-keyword-hash-table*
             (load-keyword-file *is-keyword-file* nil))) ; t=啶ʂȂ, nil=
  (when *is-keyword-hash-table*
    (make-local-variable 'keyword-hash-table)
    (setq keyword-hash-table *is-keyword-hash-table*))
  (make-local-variable 'regexp-keyword-list)
  (setq regexp-keyword-list *is-regexp-keyword-list*)

  ; tbN̎s
  (run-hooks '*is-mode-hook*))
