;;; -*- Mode: Lisp -*-
;;; insert-directory-tree.l --- fBNgc[̏o

;; Copyright (C) 2001-2005 OHKUBO Hiroshi <ohkubo@s53.xrea.com>

;; Author: OHKUBO Hiroshi <ohkubo@s53.xrea.com>
;; Time-stamp: <2005/10/19 01:38:21 +0900>

;;; Commentary:

;; Description:
;;
;;  fBNgc[o͂܂B
;;

;; Installation:
;;
;;      1. WJ insert-directory-tree.l  $XYZZY/site-lisp 
;;         Rs[܂B
;;
;;      2. oCgRpC܂B
;;
;;              M-x byte-compile-file
;;              Byte compile file: $XYZZY/site-lisp/insert-directory-tree.l
;;
;;      3. ~/.xyzzy ܂ $XYZZY/site-lisp/siteinit.l Ɉȉ̃R[h
;;         ǉ܂B
;;
;;              (autoload 'insert-directory-tree "insert-directory-tree" t)
;;
;;      4. L̐ݒ𔽉f邽߂ɁAxyzzy ċN܂B
;;         siteinit.l ɋLqꍇ Ctrl L[ Shift L[Ȃ
;;         xyzzy ċNA_vt@Cč\z܂B
;;

;; Uninstallation:
;;
;;      1. insert-directory-tree.l ɊւLq폜܂B
;;
;;      2. siteinit.l ɋLqĂꍇ Ctrl L[ Shift L[
;;         Ȃ xyzzy ċNA_vt@Cč\z܂B
;;

;; Usage:
;;
;;      M-x insert-directory-tree
;;

;; Setting example:
;;
;;      (require "insert-directory-tree")
;;

;; Customize:
;;
;;      ; t@CTCYo
;;      (setq *insert-directory-tree-leaf-function*
;;            #'(lambda (file)
;;                (unless (file-directory-p file)
;;                  (format nil "\t~D Bytes" (file-length file)))))
;;
;;      ; t@C̍XVo
;;      (setq *insert-directory-tree-leaf-function*
;;            #'(lambda (file)
;;                (unless (file-directory-p file)
;;                  (format-date-string "\t(%y/%m/%d %H:%M:%S)"
;;                                      (cadr (get-file-info file))))))
;;

;; Changes:
;;
;;      Wed, 19 Oct 2005 01:15:32 +0900
;;        ENANRI ̊g荞݁B
;;          *insert-directory-tree-leaf-function* ɁAfile ɂ
;;          蕶Ԃ֐w肷邱Ƃŏto͂B
;;
;;      Sat, 08 Oct 2005 14:37:47 +0900
;;        E[AhXύXB
;;        ECZX(CBSDCZX)LځB
;;
;;      Sat, 08 Jan 2005 06:17:25 +0900
;;        Ebox-fixation-mode.l 쐬ɔAcb(0x8162)
;;          (0x84A0)ɕύXB
;;
;;      Sun, 13 Jun 2004 20:00:56 +0900
;;        Eo̓tH[}bgꕔCB
;;        ENetInstaller ΉB
;;
;;      Tue, 04 Mar 2003 21:44:48 +0900
;;        Ehonami 񂩂璸ĂOt@CXgg𓝍B
;;        ECB
;;
;;      Fri, 19 Oct 2001 13:19:20 +0900
;;        E쐬
;;

;; Licence:
;;
;;    insert-directory-tree ͏CBSDCZXɊÂėp\łB
;;    <http://www.opensource.org/licenses/bsd-license.php>
;;
;;
;;    Copyright (C) 2001-2005, OHKUBO Hiroshi.  All rights reserved.
;;
;;    Redistribution and use in source and binary forms, with or without
;;    modification, are permitted provided that the following conditions
;;    are met:
;;
;;    1. Redistributions of source code must retain the above copyright
;;       notice, this list of conditions and the following disclaimer.
;;
;;    2. Redistributions in binary form must reproduce the above copyright
;;       notice, this list of conditions and the following disclaimer in
;;       the documentation and/or other materials provided with the
;;       distribution.
;;
;;    3. Neither the name of the University nor the names of its
;;       contributors may be used to endorse or promote products derived
;;       from this software without specific prior written permission.
;;
;;    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
;;    ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
;;    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
;;    A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
;;    OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
;;    SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
;;    LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
;;    DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
;;    THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
;;    (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
;;    OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
;;

;;; Code:

(provide "insert-directory-tree")

(defvar *insert-directory-tree-ignore-list* '("^CVS/$" ".*lc$")
  "fBNgc[쐬ɖtH_/t@C (K\) ̃Xg")
(defvar *insert-directory-tree-verbose-p* nil
  "non-nil Ȃ *insert-directory-tree-ignore-list* ̎w𖳎ăc[쐬")

(defvar *insert-directory-tree-leaf-function* nil
  "fileɂƂ蕶Ԃ֐")

(defun insert-directory-tree (directory)
  "fBNgc[쐬"
  (interactive "*Ddirectory: "
    :default0 (if (get-buffer-file-name)
                  (directory-namestring (get-buffer-file-name))
                (si:system-root)))
  (labels ((insert-leaf (base branch &optional file directory directory-p)
             (insert (format nil "~A~A~@[ ~A~]~@[~A~]~@[~A~]~%" base branch
                             file (and directory-p "/")
                             (and file
                                  directory
                                  *insert-directory-tree-leaf-function*
                                  (funcall *insert-directory-tree-leaf-function* (merge-pathnames file directory))))))
           (insert-directory-tree-1 (base-directory &optional (base-str ""))
             (let (file-list directory-list last-file last-directory)
               (dolist (file (directory base-directory))
                 (when (or *insert-directory-tree-verbose-p*
                           (not (member file *insert-directory-tree-ignore-list*
                                        :test #'(lambda (string regexp)
                                                  (string-match regexp string)))))
                   (if (string-match "/$" file)
                       (push (string-right-trim "/" file) directory-list)
                     (push file file-list))))
               (setq file-list (stable-sort file-list #'string-lessp))
               (setq directory-list (stable-sort directory-list #'string-lessp))
               (setq last-file (car (last file-list)))
               (setq last-directory (car (last directory-list)))
               (dolist (file file-list)
                 (if (and (eq file last-file) (not directory-list))
                     (insert-leaf base-str "" file base-directory)
                   (insert-leaf base-str "" file base-directory)))
               (dolist (file directory-list)
                 (insert-leaf base-str "")
                 (if (eq file last-directory)
                     (progn
                       (insert-leaf base-str "" file base-directory t)
                       (insert-directory-tree-1 (merge-pathnames file base-directory)
                                                (concat base-str "   ")))
                   (progn
                     (insert-leaf base-str "" file base-directory t)
                     (insert-directory-tree-1 (merge-pathnames file base-directory)
                                              (concat base-str " "))))))))
    (unless (file-directory-p directory)
      (return-from insert-directory-tree nil))
    (setq directory (append-trail-slash (map-backslash-to-slash directory)))
    (insert (format nil "~A~%" directory))
    (insert-directory-tree-1 directory " ")))

;;; insert-directory-tree.l ends here
