;;; -*- mode: lisp -*-
;;; name:     grouping-symbol-mode
;;; version:  2007.07.13
;;; author:   shiro
;;; category: Editing
;;; src:      http://white.s151.xrea.com/wiki/index.php?plugin=attach&refer=script%2Fgrouping-symbol-mode&openfile=
;;; changes:  
;;; files:    site-lisp/grouping-symbol-mode.l
;;;           site-lisp/grouping-symbol-mode.lc
;;;           site-lisp/ni-autoload/silog/grouping-symbol-mode.l

;; Copyright (C) 2007 shiro
;;
;; Redistribution and use in source and binary forms, with or without
;; modification, are permitted provided that the following conditions
;; are met:
;;
;; 1. Redistributions of source code must retain the above copyright
;;    notice, this list of conditions and the following disclaimer.
;;
;; 2. Redistributions in binary form must reproduce the above copyright
;;    notice, this list of conditions and the following disclaimer in
;;    the documentation and/or other materials provided with the
;;    distribution.
;;
;; 3. The name of the author may not be used to endorse or promote
;;    products derived from this software without specific prior
;;    written permission.
;;
;; THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
;; ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
;; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
;; PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
;; DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
;; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
;; OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
;; HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
;; STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
;; ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
;; POSSIBILITY OF SUCH DAMAGE.

;;; Commentary:

;; Tv:
;; 
;; ʂ̓͂x}Ci[[h
;; 
;; (OunƂ,ǂɕʂ}邩߂)

;; ݒ:
;;
;; NetInstallerœ 1 ͕svł
;;
;;   1 $XYZZY/site-lisp/ ȉɃRs[AoCgRpCĂB
;;   
;;   2 .xyzzy  siteinit.l ɈȉQlɋLqA
;;     siteinit.lɋLq͍ă_vĂB
;;     
;;     (require "grouping-symbol-mode") ; ni-autoloadĂl͕sv
;;   
;;   3 D݂ɉ
;;   
;;     ;; lisp-mode/lisp-interaction-modegrouping-symbol-modeon
;;     (add-hook '*lisp-mode-hook* 'grouping-symbol-mode-on)
;;     (add-hook '*lisp-interaction-mode-hook* 'grouping-symbol-mode-on)
;;     ;; lisp-modeC-8ŕʕtۊ
;;     (define-key ed::*lisp-mode-map* #\C-8 'ed::grouping-symbol-mode-insert-paren)

;; g:
;; 
;; 1. grouping-symbol-modeonɂȂĂ邱ƂmF
;; 
;; 2. L[
;;    ŏɊJʂ}AŌɊJʂ̒܂Ŗ߂Ă܂
;;    ܂A{,<,[ł\ł
;;    
;;    (             | ʏʂ(
;;    M-0 (         | Jʂ̒ɕʂ}
;;    C-u (         | 
;;    M-1 (         | forward-sexp1sʒuɕʂ}
;;    C-u C-u (     | 
;;    M-2 (         | forward-sexp2sʒuɕʂ}
;;    C-u C-u C-u ( | 
;;    .             | 
;;    .             | 
;;    .             | 
;;    
;;    grouping-symbol-mode-insert-{paren,brace,bracket}Ǝ̃L[ɐݒ肵Ăꍇ
;;    digit-argument̎(M-0, M-1, M-3 ,,,)͏LƓlŁA
;;    universal-argument̎(C-u, C-u C-u ,,,)1͉񐔂Ȃčς݂܂

;; ̑:
;; 
;; grouping-symbol-mode-get-position-hookɉ|
;; forward-sexpȊÖʒuɑ}\
;; (run-hook-with-args-until-successŎs)
;; 
;; grouping-symbol-mode-list𑝂₵
;; *grouping-symbol-mode-last-command-string*letňꎞIɕύXĂ
;; Cӂ̑g̕OuɂĎ}AƂł邩B

;; :
;; 
;; 2007.07.13
;; - 


;;; Code:

(provide "grouping-symbol-mode")

(in-package "editor")

(export '(grouping-symbol-mode
		  grouping-symbol-mode-on
		  grouping-symbol-mode-off
		  grouping-symbol-mode-insert
		  grouping-symbol-mode-insert-paren
		  grouping-symbol-insert-bracket
		  grouping-symbol-mode-insert-brace
		  ))

(defvar-local grouping-symbol-mode-get-position-hook nil)

(defvar-local grouping-symbol-mode-list
  '(("(" ")")
	("{" "}")
	("[" "]")
	("<" ">")
	))

(defvar *grouping-symbol-mode-last-command-string* nil)

(defun grouping-symbol-mode-get-close-char ()
  (let ((res (assoc (or *grouping-symbol-mode-last-command-string*
						(string *last-command-char*))
					grouping-symbol-mode-list :test 'equal)))
	(when res
	  (second res))))

;; ------------------------------------------------------------------
;; Command
;; ------------------------------------------------------------------
(defun grouping-symbol-mode-insert ()
  (interactive "*")
  (insert (or *grouping-symbol-mode-last-command-string*
			  *last-command-char*))
  (when *prefix-args*
	(let ((char (grouping-symbol-mode-get-close-char)))
	  (when char
		(cond ((equal 'universal-argument *prefix-args*)
			   (save-excursion
				 (unless (run-hook-with-args-until-success grouping-symbol-mode-get-position-hook)
				   (forward-sexp (- (rationalize (log *prefix-value* 4)) 1)))
				 (insert char)))
			  ((equal 'digit-argument *prefix-args*)
			   (save-excursion
				 (forward-sexp *prefix-value*)
				 (insert char))))))))

(defmacro grouping-symbol-mode-make-insert-command (string)
  `(let ((*prefix-value*
		  (cond ((equal 'universal-argument *prefix-args*)
				 (* 4 *prefix-value*))
				((equal 'digit-argument *prefix-args*)
				 *prefix-value*)
				((not *prefix-args*)
				 4)))
		 (*prefix-args* (or *prefix-args* 'universal-argument))
		 (*grouping-symbol-mode-last-command-string* ,string))
	 (grouping-symbol-mode-insert)))

(defun grouping-symbol-mode-insert-paren ()
  (interactive "*")
  (grouping-symbol-mode-make-insert-command "("))

(defun grouping-symbol-insert-bracket ()
  (interactive "*")
  (grouping-symbol-mode-make-insert-command "["))

(defun grouping-symbol-mode-insert-brace ()
  (interactive "*")
  (grouping-symbol-mode-make-insert-command "{"))

;; ------------------------------------------------------------------
;; Mode
;; ------------------------------------------------------------------

(pushnew '(grouping-symbol-mode-on . "Gr") *minor-mode-alist* :key #'car)
(defvar-local grouping-symbol-mode-on nil)

(defvar *grouping-symbol-mode-map* nil)
(unless *grouping-symbol-mode-map*
  (setf *grouping-symbol-mode-map* (make-sparse-keymap))
  (define-key *grouping-symbol-mode-map* #\( 'grouping-symbol-mode-insert)
  (define-key *grouping-symbol-mode-map* #\{ 'grouping-symbol-mode-insert)
  (define-key *grouping-symbol-mode-map* #\< 'grouping-symbol-mode-insert)
  (define-key *grouping-symbol-mode-map* #\[ 'grouping-symbol-mode-insert))

(defun grouping-symbol-mode (&optional (arg nil sv))
  (interactive "p")
  (toggle-mode 'grouping-symbol-mode-on arg sv)
  (if grouping-symbol-mode-on
	  (set-minor-mode-map *grouping-symbol-mode-map*)
	(unset-minor-mode-map *grouping-symbol-mode-map*))
  (unless *executing-macro*
	(update-mode-line)))

(defun grouping-symbol-mode-on ()
  (interactive)
  (grouping-symbol-mode t))

(defun grouping-symbol-mode-off ()
  (interactive)
  (grouping-symbol-mode nil))

;;; grouping-symbol-mode.l ends here
