;;; -*- mode: lisp -*-
;;; name:     ffap
;;; version:  2007.10.19
;;; author:   shiro
;;; category: Utilities
;;; src:      http://white.s151.xrea.com/wiki/index.php?plugin=attach&refer=script%2Fffap&openfile=
;;; changes:  virtual-filefind-fileꍇ̏fBNg܂Ƃɂ
;;; files:    site-lisp/ffap.l
;;;           site-lisp/ffap.lc
;;;           site-lisp/ni-autoload/silog/ffap.l

;; Copyright (C) 2001-2005 OHKUBO Hiroshi.
;; Copyright (C) 2006-2007 snj14
;;
;; Redistribution and use in source and binary forms, with or without
;; modification, are permitted provided that the following conditions
;; are met:
;;
;; 1. Redistributions of source code must retain the above copyright
;;    notice, this list of conditions and the following disclaimer.
;;
;; 2. Redistributions in binary form must reproduce the above copyright
;;    notice, this list of conditions and the following disclaimer in
;;    the documentation and/or other materials provided with the
;;    distribution.
;;
;; 3. The name of the author may not be used to endorse or promote
;;    products derived from this software without specific prior
;;    written permission.
;;
;; THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
;; ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
;; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
;; PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
;; DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
;; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
;; OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
;; HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
;; STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
;; ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
;; POSSIBILITY OF SUCH DAMAGE.

;;; Commentary:

;; Tv:
;;
;;   emacsɂffap̐(http://www.bookshelf.jp/soft/meadow_23.html#SEC226)
;;   ݂đzŎ̂łB
;;   R[h͎QlɂĂȂ̂ŃoO@\s邩܂B
;;
;;   J[\ʒuӂ̕ăpXURITA
;;   pX̏ꍇAftHg̒lɎw肵Ԃfind-file܂B
;;   URȈꍇAuEUŊJ܂B(ݒ)
;;   J[\ʒuӂTȂꍇ́A
;;   ȑOƕςfind-fileyݒ܂B
;;
;;   v (require "ffap")  <a href="../index.html">
;;   ̏C-x C-fƂɃ~jobt@
;;   Find file: c:/bin/xyzzy/site-lisp/ffap.l
;;   
;;   Find file: c:/data/web/index.html
;;   ƂԂfind-fileJnł悤ɂȂ܂B
;;
;;   J[\ӂ̃t@C̐efBNgANeBuȑA
;;   ܂̓ANeBułȂ̃pXɂ2ʃt@CJ@\܂B

;; ݒ:
;;
;; NetInstallerœ 1 ͕svł
;; (ni-autoload)Ă 2 1sڂ͕svł
;;
;;   1 $XYZZY/site-lisp/ ȉɃRs[A
;;     oCgRpCĂ
;;   2 .xyzzy  siteinit.l ɈȉLqA
;;     siteinit.lɋLq͍ă_vĂB
;;
;;   (require "ffap")
;;   (ffap-bindings)

;; g:
;;
;; find-file-at-point :
;;
;;   ʏʂfind-file(ftHgC-x C-f)Ă
;;   ȑOfind-filelAC-u C-x C-fŃGR[hwo܂
;;   ffappXTA̓ZNVőIC-x C-fĂ
;;   URIꍇ͊֘Atɏ]ĊJƂ܂
;;
;; open-filer-at-point :
;;
;;   ʏʂopen-filer(ftHgC-c C-f)Ă
;;   ANeBuȑ̃pXύXăt@CJ
;;      C-u C-c C-f
;;   ANeBułȂ̃pXύXăt@CJ
;;      C-u C-u C-c C-f

;; :
;; 
;; 2007.10.19
;; - virtual-filefind-fileꍇ̏fBNg܂Ƃɂ
;; 
;; 2007.02.22
;; - Lbgt߂ɋ󔒂Ƃopen-filer-at-pointƃG[ôC
;; 
;; 2007.02.19
;; - urĩqXg悤ɂ
;; 
;; 2007.02.13
;; - find-other-file-at-point, insert-file-at-point, read-file-at-pointǉ
;; - SẴL[蓖Ă֐ ffap-bindings ǉ
;; 
;; 2007.02.08
;; - open-filer-at-pointŃobt@̕pXłȂꍇdefault-directoryg悤ɂ
;; 
;; 2006.10.08
;; - obt@̕lăt@CJ@\ǉ
;;
;; 2006.10.05
;; - 1ʃt@CJɕ̃t@CIׂȂȂĂ̂C
;;
;; 2006.05.10
;; - 

;; ӎ:
;;
;;   쐬ɂAclickable-uriQlɂĂ܂B
;;   ҂OHKUBO HiroshiɊӂ܂B

;;; Code:

(provide "ffap")

(in-package "editor")

(export '(*ffap-uri-open-command-alist*
		  *ffap-uri-chars*
		  *ffap-extension-alist*
		  *ffap-path-alist*
		  *ffap-uri-modify-uri-alist*
		  *ffap-default-extension*
		  find-file-at-point
		  open-filer-at-point
		  find-other-file-at-point
		  insert-file-at-point
		  read-file-at-point
		  ffap-bindings))

;;; URIJݒ
;;; ݒ薳       : ֘Ats
;;;          : R}hCƂ݂ȂĎs
;;;                : URILqׂꏊ~AƋLq
;;; lambda       : lambdaURIƂēnĕ]
;;; ֐̃V{ : ֐          V
;;;
;;; 
;;; (push '("^https?:" . "C:/bin/FireFox/FireFox.exe ~A")
;;;       *ffap-uri-open-command-alist*)
(defvar *ffap-uri-open-command-alist*
  '((#'(lambda (uri) (string-matchp "^file:.+\\.l$" uri)) .
	 #'find-file)
	))

;;; URIK\ (ĂƁ[)
(defvar *ffap-uri-regexp*
  "\\(h?t?tps?\\|ftp\\|telnet\\|gopher\\|www\\|wais\\|file\\|mailto\\):[-a-zA-Z0-9_/~.@?&=;+(),'$!*:#%|]+")

;;; [AhXK\
(defvar *ffap-uri-mail-address-regexp*
  "[-a-zA-Z0-9_.]+@[-a-zA-Z0-9_]+\\(?:\\.[-a-zA-Z0-9_]+\\)+")

;;; URI\
;;; skip-chars-forward,skip-chars-backwardŎgp
(defvar *ffap-uri-chars* "-a-zA-Z0-9_/\\~.@?&=;+(),'$!*:#%| ")

;;; URI␳֐ AzXg
(defvar *ffap-uri-modify-uri-alist*
  '((#'ffap-uri-uri-mail-address-p  . #'(lambda (uri) (concat "mailto:" uri)))
	("^ttp:" . #'(lambda (uri) (concat "h"  uri)))
	("^tp:"  . #'(lambda (uri) (concat "ht" uri)))
	("^file://"  . #'(lambda (uri) (substring uri 7)))
	))

;;; [hƊgq̐ݒ
;;; (require "hoge") Agq̖񂩂t@CTꍇ̊gq𐳋K\Ń[hɎw肵܂B
;;; ʏ *auto-mode-alist* gq擾܂A
;;; *auto-mode-alist*ɐݒ肳ĂȂ[h͂ɒǉĂB
;;; *auto-mode-alist*ɂɂݒ肳ĂȂ[h̏ꍇ͊ϐPATHEXTgq擾܂B
(defvar *ffap-extension-alist*
  '((lisp-interaction-mode . "\\.l$")))

;;; [hƃpX̐ݒ
;;; pX[hɕύXꍇ͂Ŏw肵܂B
;;; ͈ȉ4Ŏw肳ꂽpXSĎgčs܂B
;;;  1 [hɐݒ肳ꂽpX
;;;  2 ftHg̃pX*ffap-default-path*
;;;  3 obt@ƂĂfBNg = (default-directory)̕Ԃl
;;;  4 JĂt@C̐efBNg(obt@t@C̏ꍇ)
;;; ȂA/\\̗L͖₢܂B
;;;
;;; 
;;; ;py-modeł̌pXclnchex,script,extensionǉ
;;; (push '(py-mode "c:/bin/clnchex/" "c:/bin/clnchex/script" "c:/bin/clnchex/extension")
;;;       *ffap-path-alist*)
(defvar *ffap-path-alist*
  (list (append (list 'lisp-mode) *load-path*)
		(append (list 'lisp-interaction-mode) *load-path*)))

;; ftHg̊gq
;; >> "\\.\\(COM\\|EXE\\|BAT\\|CMD\\|VBS\\|VBE\\|JS\\|JSE\\|WSF\\|WSH\\)$"
(defvar *ffap-default-extension*
  (concat "\\.\\("
		  (substitute-string (substitute-string
							  (si:getenv "PATHEXT")
							  "\\." "")
							 ";" "\\\\|")
		  "\\)$"))

;; ftHg̃pX
(defvar *ffap-default-path*
  (append ;xyzzỹCXg[fBNg
   (list (si:system-root))
   ;ϐ PATH
   (mapcar 'map-backslash-to-slash
		   (split-string (si:getenv "PATH") ";"))
   ;Windows (Ă邩MȂ)
   (mapcar 'map-backslash-to-slash
		   (split-string (si:getenv "WINDIR") ";"))
   ;Home
   (mapcar 'map-backslash-to-slash
		   (split-string (si:getenv "HOME") ";"))
   ;XyzzyHome
   (mapcar 'map-backslash-to-slash
		   (split-string (si:getenv "XYZZYHOME") ";"))))

;; history
(defvar *ffap-uri-history* nil)
(setf (get '*ffap-uri-history* 'minibuffer-history-variable)
      '*ffap-uri-history*)
(register-history-variable '(*ffap-uri-history*))

(defun ffap-uri-uri-mail-address-p (uri)
  (and (stringp *ffap-uri-mail-address-regexp*)
	   (string-matchp (concat "^" *ffap-uri-mail-address-regexp* "$") uri)))

(defun ffap-get-extension-from-auto-mode-alist (mode)
  "*auto-mode-alist*ƃ[hgq擾"
  (let ((list (apply 'append
					 (mapcar #'(lambda (x)
								 (when (eq (cdr x) mode)
								   (list (car x))))
							 *auto-mode-alist*))))
	(when list
	  (format nil "\\(~A)" (string-right-trim "|" (format nil "~{~A\\|~}" list))))))

(defun ffap-get-path-and-extension (&optional buffer)
  "buffer̃[h猟pXƊgq𓾂"
  (let ((mode buffer-mode))
	(when buffer
	  (save-excursion
		(set-buffer buffer)
		(setf mode buffer-mode)))
	(values (remove-duplicates
			 (append (cdr (assoc mode *ffap-path-alist*))
					 (list (default-directory)) ;ƃfBNg
					 (let ((cur (get-buffer-file-name))) ;JĂt@C̐efBNg
					   (when cur (list (map-backslash-to-slash
										(directory-namestring cur)))))
					 *ffap-default-path*)
			 :test 'equalp)
			(or (cdr (assoc mode *ffap-extension-alist*))
				(ffap-get-extension-from-auto-mode-alist mode)
				*ffap-default-extension*))))

;; (ffap-locate "grep.l")
;; >> ("C:/bin/xyzzy/lisp/grep.l")
;; (ffap-locate "grep.exe")
;; >> ("c:/cygwin/bin/grep.exe")
(defun ffap-locate (file)
  "t@CtpXT"
  (when (string= file "")
	(return-from ffap-locate))
  (let (path-list extension res)
	(multiple-value-setq (path-list extension)
	  (ffap-get-path-and-extension))
	(setf res
		  (some #'(lambda (path)
					(when (file-exist-p path) path))
				(mapcar #'(lambda (dir)
							(merge-pathnames file dir))
						path-list)))
	(and res (not (file-directory-p res))
		 res)))

;; (ffap-locate-approx "lisp/grep")
;; >> "C:/bin/xyzzy/lisp/grep.l"
(defun ffap-locate-approx (file)
  "t@C(gqȂ)tpXT"
  (when (string= file "")
	(return-from ffap-locate-approx))
  (let (path-list extension res)
	(multiple-value-setq (path-list extension)
	  (ffap-get-path-and-extension))
	(setf res
		  (some #'(lambda (path)
					(when (string-matchp
						   (concat "[\\/]" (regexp-quote file) extension)
						   path)
					  path))
				(apply 'append
					   (mapcar #'(lambda (dir)
								   (directory (directory-namestring
											   (merge-pathnames file dir))
											  :absolute t))
							   path-list))))
	(and res (not (file-directory-p res))
		 res)))

(defun ffap-get-uri (str)
  (and (string-matchp *ffap-uri-regexp* str)
	   (match-string 0)))

(defun ffap-get-mail-address (str)
  (and (string-matchp *ffap-uri-mail-address-regexp* str)
	   (match-string 0)))

(defun ffap-get-region ()
  "[WsȂ當Ԃ"
  (let ((ptline (current-line-number))
		mkline)
	(save-excursion
	  (and (mark t)
		   (goto-char (mark))
		   (setf mkline (current-line-number))))
	(when (eq ptline mkline)
	  (buffer-substring (point) (mark)))))

(defun ffap-get-current-string-regexp ()
  (let ((pt (point)) string
		(region (ffap-get-region)))
	(save-excursion
	  (and (stringp region)
		   (> (mark) pt)
		   (goto-char (mark)))
	  (and (scan-buffer *ffap-uri-regexp* :regexp t :reverse t
						:limit (or (and region (> (mark) pt) pt)
								   (and region (< (mark) pt) (mark))
								   (save-excursion (goto-bol) (point))))
		   (< (match-beginning 0) pt)
		   (<= pt (match-end 0))
		   (setf string (match-string 0);(buffer-substring (match-beginning 0) pt)
				 )
		   (string-match *ffap-uri-regexp* string)
		   string))))

(defun ffap-get-current-string-uri-chars ()
  "*ffap-uri-chars*ĕ擾"
  (save-excursion
	(unless (pre-selection-p)
	  (skip-chars-forward *ffap-uri-chars*)
	  (ed::begin-selection)
	  (skip-chars-backward *ffap-uri-chars*))
	(selection-start-end (start end)
	  (buffer-substring start end))))

(defun ffap-get-current-string-syntax ()
  "V^bNXe[uĕ擾"
  (save-excursion
	(unless (pre-selection-p)
	  (skip-syntax-spec-forward "w_.\\")
	  (ed::begin-selection)
	  (skip-syntax-spec-backward "w_.\\"))
	(selection-start-end (start end)
	  (buffer-substring start end))))

(defun ffap-correct-uri (uri)
  (when uri
	(let ((modify-func
		   (eval (cdr (assoc uri *ffap-uri-modify-uri-alist*
							 :test #'(lambda (uri checker)
									   (setf checker (eval checker))
									   (or (and (or (regexpp checker) (stringp checker))
												(string-matchp checker uri))
										   (and (functionp checker) (funcall checker uri)))))))))
	  (if modify-func
		  (funcall modify-func uri)
		uri))))

(defvar *ffap-find-uri* t)

(defun ffap-get-path ()
  (let ((str (substitute-string
			  (ffap-get-current-string-syntax)
			  "\\\\\\\\" "\\\\")); pX̋؂肪\\̎ɂ̒l"\\\\"ƂȂ΍
		(str1 (substitute-string
			   (ffap-get-current-string-uri-chars)
			   "\\\\\\\\" "\\\\")))
	(ffap-correct-uri
	 (or (and (not (string= str "")) (file-exist-p str) str)
		 (and (not (string= str1 "")) (file-exist-p str1) str1)
		 (ffap-locate str)
		 (ffap-locate-approx str)
		 (when *ffap-find-uri*
		   (ffap-get-uri str))
		 (ffap-get-mail-address str)
		 
		 (ffap-locate str1)
		 (ffap-locate-approx str1)
		 (when *ffap-find-uri*
		   (ffap-get-uri str1))
		 (ffap-get-mail-address str1)))))

(defun ffap-open-uri (uri)
  (when (and uri
			 (string-matchp *ffap-uri-regexp* uri)
			 (setf uri (read-string "URI: " :default (match-string 0)
									:history '*ffap-uri-history*))
			 (not (string= uri "")))
	(let ((cmd (cdr (assoc uri *ffap-uri-open-command-alist*
						   :test #'(lambda (uri checker)
									 (setf checker (eval checker))
									 (or (and (or (regexpp checker) (stringp checker))
											  (string-matchp checker uri))
										 (and (functionp checker) (funcall checker uri))))))))
	  (cond ((consp cmd)
			 (funcall (eval cmd) uri))
			((functionp cmd)
			 (funcall (symbol-function cmd) uri))
			((stringp cmd)
			 (call-process
			  (format nil (map-slash-to-backslash cmd) uri)
			  :wait nil))
			(t (shell-execute uri t))
			))))

(defun ffap-get-truename (path)
  (when path
	(let ((file (string-match "^file://" path)))
	  (setf path (truename path))
	  (and (file-directory-p path)
		   (not (string-match "/$" path))
		   (setf path (concat path "/")))
	  (if file
		  (concat "file://" path)
		path))))


;; virtual file ?
(defun ffap-check-virtual-file ()
  (when (find-package "complete+")
	(eval (intern "*virtual-file-mode*" "complete+"))))
;; virtual-file-archive (C:/archive/hoge.zip:moge -> C:/archive/hoge.zip/moge )
(defun ffap-virtual-file-archive-convert (file)
  (if (= 2 (count #\: file))
	  (substitute #\/ #\: file :from-end t :count 1)
	file))

(defun find-file-at-point ()
  (interactive)
  (let ((path (ffap-get-path)))
	(or (ffap-open-uri path)
		(find-file (read-file-name-list "Find-file: "
										:default (if (ffap-check-virtual-file)
													 (directory-namestring
													  (ffap-virtual-file-archive-convert
													   (get-buffer-alternate-file-name)))
												   (ffap-get-truename path)))
				   (when *prefix-args*
					 (read-char-encoding "Encoding: "))))))

(defun find-other-file-at-point (filename &optional encoding nomsg)
  (interactive "FFind other file: \n0zEncoding: "
	:title0 "Find other file"
	:default0 (or (let ((*ffap-find-uri* nil))
					(ffap-get-path))
				  (cond ((ffap-check-virtual-file)
						 (let ((p (get-buffer-alternate-file-name)))
						   (if *find-other-file-requires-file-name*
							   (ffap-virtual-file-archive-convert p)
							 (directory-namestring p))))
						(*find-other-file-requires-file-name*
						 (get-buffer-file-name)))))
  (find-other-file filename encoding nomsg))

(defun insert-file-at-point (filename &optional encoding)
  (interactive "*fInsert file: \n0zEncoding: "
	:title0 "Insert file"
	:default0 (let ((*ffap-find-uri* nil))
				(ffap-get-path)))
  (insert-file filename encoding))

(defun read-file-at-point (filename &optional encoding nomsg)
  (interactive "fRead file: \n0zEncoding: "
	:title0 "Read file"
	:default0 (let ((*ffap-find-uri* nil))
				(ffap-get-path)))
  (read-file filename encoding nomsg))

(defun open-filer-at-point-current-window (path)
  (let ((*filer-primary-directory* path))
	(open-filer)))

(defun open-filer-at-point-other-window (path)
  (let ((*filer-secondary-directory* path))
	(open-filer)))

(defun open-filer-at-point ()
  (interactive)
  (cond (*prefix-args*
		 (let ((path (ffap-get-path))
			   (dir (default-directory)))
		   (cond ((and path
					   (not (string= path ""))
					   (not (string-match "^ *$" path))
					   (valid-path-p path))
				  (when (and (not (file-directory-p path)))
					(setf path (directory-namestring path)))
				  (cond ((> *prefix-value* 4)
						 (open-filer-at-point-other-window path))
						(t
						 (open-filer-at-point-current-window path))))
				 (t
				  (cond ((> *prefix-value* 4)
						 (open-filer-at-point-other-window dir))
						(t
						 (open-filer-at-point-current-window dir)))))))
		(t
		 (open-filer))))

(defun ffap-bindings ()
  "[C-x C-f], [C-c C-f], [C-x C-v], [C-x i], [C-x C-r]ffapp̊֐蓖Ă܂"
  (global-set-key '(#\C-x #\C-f) 'find-file-at-point)
  (global-set-key '(#\C-c #\C-f) 'open-filer-at-point)
  (global-set-key '(#\C-x #\C-v) 'find-other-file-at-point)
  (global-set-key '(#\C-x #\i)   'insert-file-at-point)
  (global-set-key '(#\C-x #\C-r) 'read-file-at-point))

;;; ffap.l ends here
