;;; -*- Mode: Lisp; Package: EDITOR -*-
#| embedded grep for xyzzy-0.2.2.235

Copyright (c) 2008-2009 knenet <kneneglect_std(^o^)yahoo.co.jp>

Tv
eLXgɖߍ񂾐K\s܂B
͈͂̎w肪łAʂPłΎŔт܂B


(require "embedded-grep")

.xyzzyɏȂǂēǂݍ݂܂B
netinstallerpăCXg[ꍇ͕svłB

(define-key esc-map #\C-l 'eg-run)
(global-set-key '(#\C-c #\C-l) 'eg-goto-run-exp)
(global-set-key '(#\C-c #\l) 'eg-release-run-exp)

ȂǂƍD݂ɉăL[oCh܂B

ACXg[͂̃t@Cembededd-grep.lc폜
Lݒ蓙΂łB

gp@
{
Cӂ̃eLXg
:||:
̂悤ɋLqALbg킹eg-runs܂B
 ͐̕K\ɂȂ܂B

|>>
ƂƁAɓs܂(^[ \t].*$ )B

ʂ1ł΁AYɃJ[\ړ܂B
   V   ΁AYt߂񋓂obt@J܂B
   V   Ȃ΁At@C̖ɈړAev[g}܂B

͒ɏꍇ :||: ƎOɔpXy[XĉB

eg-goto-run-expsƁAOsꏊ֖߂܂B
*eg-marker-ring*ɑSL^Ă̂ŉł߂܂B

߂̂邢ꍇeg-release-run-expsƑSĕ\܂B
*eg-marker-ring*͏܂Buniversal-argumentꍇ͏܂B

ڍ
:||: |>>
ǂłAOɃXy[X܂ɁAL̏ɉċLq
̐ݒ肪s܂B

path|>>word
path̃t@CA̓fBNg猟܂B
ChJ[hpł܂B
pathɔpXy[X܂܂ꍇ""ŊĂB
pathȂȂApathăev[g}܂B
ChJ[hgĂꍇAKɃt@C܂B

path|>>
pathJ܂BfBNgł΃t@C񋓂܂B

<buffer>|>>
obt@Ɉړ܂Bobt@Ȃꍇ͉܂B

|integer|>>word
wordAintegerԖڂ̌ʂ\܂B
pathȂꍇ[|KvłB
|̉Eɏ̂qƌĂт܂B

|integer|>>
integersڂɃJ[\ړ܂B

path|integer|>>
pathintegersڂɃJ[\ړ܂B
pathɕ̃t@C܂܂ꍇAintegerԖڂ̃t@CJ܂B

|>|>>word
ʂ\[gĕ\܂B~(<)Ə(>)wł܂B
t@C񋓂ꍇ path|>|:||:

path|r|>>
path̃TufBNg܂B

path1|path2||>>
path𕡐wł܂BqȂꍇE[|Kv܂B

|>:integer|>>word
q񋓂ꍇ:ŋ؂܂B
̏ꍇ́AwordŌʂŃ\[gAintegerԖڂ\܂B

path1|...|pathN|r:<:num1:num2|>>
q4ō()łB
path1`pathN܂łċAIɓWJ(d͋CɂȂ)A\[gA
num1Ԗڂ̃t@CJAnum2sڂɈړ܂B

ݒ
R[h̎n߂̕ɂdefvarꂽϐ̒lsetqĕύXł܂B
Ⴆ΁Aeg-runC-lł͂ȂAF12Ȃǂɐݒ肵A\LȂƂ
recenterKvȂꍇ́A
(setq *eg-capture-command* nil)
.xyzzyȂǂɏ܂B
ꂼ̕ϐ̈Ӗ͐錾QƂĂB


m̖
炠obt@(*scratch*Ȃ)ɐFÂf܂B

\ɃeXgĂȂ̂ŃoO\܂B
sƂ̓t@CۑĂ̕ł傤B

p & `
pDςȂłH
`D肢@lĂB

pDsɕ path:|word|:Č悤ƂƁA
@@ȂӐ}ƈႤ̂Ă܂
`Dpath̏ŎsƁAO:|word|:D悳܂BdlłB

pDeg-goto-run-expd܂B
`Deg-runƈقȂAt@C͊J܂B
@@Ԃ肪ȂAobt@Ȃ悤ɂ܂傤B

CZX
MITCZXɏ܂B҂𖾂炩ɂΓKɎgėǂłB
̃\tg̎gpɂĐvɂāA҂͈ؐӔC܂B

Copyright (c) 2008-2009 knenet \kneneglect_std(^o^)yahoo.co.jp/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.



001 2009-07-01 23:17 łB
002 2009-07-02 08:59 Ԃ~X̏CB
003 2009-07-02 13:20 s|Cg֖߂悤ɂB邳B
004 2009-07-03 19:19 t@CƂwordȂ΃ev[g}Ȃ悤ɁB
005 2009-07-06 12:15 |>>  :||: ̖ւ
006 2009-07-20 11:20 obt@wŌAYsɔׂȂoOCB

|#

(provide "embedded-grep")
(in-package "editor")

(defvar *eg-keyword-color* '(:color 10 0 :bold)
  "\̐F")
(defvar *eg-keyword-highlight* '(:color 1 3)
  "ʕ\ł̃}b`̐F")
(defvar *eg-capture-command* 'recenter
  "\Ȃꍇ̓")
(defvar *eg-buffer* "*egrep*"
  "embedded-greppobt@̖O")
(defvar *eg-show-line-number* 2
  "ʕ\Ō։s\邩")
(defvar *eg-denominate-new-file* (lambda (num) (format nil "~D.txt" num))
  "VKt@C̖K")
(defvar *eg-template*
  (lambda (word) (insert (format nil "~%~A~%" (string-trim "^$[] \t.*" word))))
  "}ev[g")
(defvar *eg-verbose* t
  "embedded-grep̃Xe[^Xo[ւ̕\؂ւBnil 0 1 2 3 t  tԂ邳B")

(export '(*eg-keyword-color* *eg-keyword-highlight* *eg-capture-command*
		  *eg-buffer* *eg-show-line-number* *eg-denominate-new-file* *eg-template*
		  *eg-verbose*
		  eg-run eg-goto-run-exp eg-release-run-exp))

(defvar *eg-marker-ring* nil)

(defvar eg-heading (compile-regexp "|>> *\\(.*\\)" t))
(defvar eg-inside (compile-regexp ":|\\(.*?\\)|:" t))


(setq eg-regexp-keyword-list
	  (compile-regexp-keyword-list
	   `((,eg-heading t ,*eg-keyword-color* t)
		 (,eg-inside t ,*eg-keyword-color* t))))

(make-local-variable 'regexp-keyword-list)
(setq-default regexp-keyword-list
			  (if (boundp 'regexp-keyword-list)
				  (append regexp-keyword-list eg-regexp-keyword-list)
				eg-regexp-keyword-list))
(global-set-key #\C-l 'eg-run)

(defun eg-run ()
  "embedded-grepsB"
  (interactive)
  (macrolet ((scan (&rest args)
					`(save-excursion (scan-buffer ,@args)))
			 (app (&rest args)
				   `(multiple-value-call 'eg-grep (eg-get-attr ,@args))))
	(cond ((or
			(scan eg-heading :reverse t :limit #1=(save-excursion (goto-bol) (point)))
			(scan eg-heading :limit #2=(save-excursion (goto-eol) (point))))
		   (app (match-beginning 0)
				(if (zerop (- (match-end 1) (match-beginning 1)))
					"" (concat "^" (match-string 1) "[ \t]*$"))))
		  ((or
			(scan eg-inside :reverse t :limit #1#)
			(scan eg-inside :limit #2#))
		   (app (match-beginning 0) (match-string 1)))
		  (t (if *eg-capture-command* (call-interactively *eg-capture-command*))))))


(defun eg-get-attr (limit word)
  "\̎OpathƂattr擾ĕԂ"
  (save-excursion
	(goto-char limit)
	(macrolet ((scan ()
				 `(let (inside)
					(loop
					  (if (scan-buffer "\\([ \t\"]\\|$\\)" :regexp t :reverse t :no-dup t)
						  (if (equal (char-after (point)) #\")
							  (setq inside (not inside))
							(if (not inside) (return (1+ (point)))))
						(return 0))))))
	  (let ((attr (split-string (concat (buffer-substring (scan) limit) "|") #\| t)))
		(values
		 (if (zerop (length word)) nil word)
		 (remove "" (if (cdr attr) (butlast attr) attr) :test 'string=)
		 (if (cdr attr) (split-string (car (last attr)) #\:)))))))

(defun eg-sort-predicate (attr)
  (cond ((string= attr ">") 'string>)
		((string= attr "<") 'string<)
		(t nil)))

(defun eg-grep (word path attr)
  "eg-run̓암"
  (let ((arg (and (car attr) (string= "%" (car attr)))))
	(if arg (setq attr (cdr attr))
	  (push (cons (eg-get-buffer-name) (current-line-number)) *eg-marker-ring*)))
  (if path
	  (let ((r (and (car attr) (string= (car attr) "r"))))
		(eg-grep-path-exist path word (if r (cdr attr) attr) r))
	(eg-grep-here word attr)))

#|
(defun eg-grep (word path attr)
  (msgbox "word:~S~%path:~S~%attr:~S" word path attr))
|#

(defun eg-bufferp (name)
  (equal #\< (char name 0)))

(defun eg-grep-path-exist (path word attr recursive)
  "Lpathw肳Ăꍇ"
  (let ((files
		 (mapcan (lambda (x)
				   (let ((name (string-trim "\"" x)))
					 (cond ((eg-bufferp name) (list name))
						   (t (let ((d (directory-namestring name))
									(f (file-namestring name)))
								(directory d :wild f
										   :file-only t :absolute t :recursive recursive))))))
				 path)))
	(if files
		(if (cdr files)
			(eg-grep-files-exist path word attr files)
		  (if (eg-set-buffer (car files))
			  (eg-grep-here word attr)))
	  (eg-new-file (car path) word))))

(defun eg-grep-files-exist (path word attr files)
  "Lfilebufferw肳Ăꍇ"
  (let ((p (eg-sort-predicate (car attr))))
	(if word
		(eg-scan-files word p (if p (cdr attr) attr) path files)
	  (eg-files-exist-no-word
	   (if p (cdr attr) attr)
	   (if p (stable-sort files p) files)))))

(defun eg-scan-files (word predicate attr path files)
  "t@CXL"
  (let* ((regexp (compile-regexp word t))
		 (res (long-operation
			   (let (l)
				 (handler-case
				  (dolist (a files (apply 'append l))
					(if (eg-read-file a) (push (eg-scan-1 regexp a) l))
					(do-events))
				  (quit (c) (apply 'append l)))))))
	(if res
		(if (cdr res)
			(eg-show-result
			 word
			 (if predicate (stable-sort res predicate :key 'car)
			   (reverse res))
			 attr)
		  (progn (eg-set-buffer (cadar res))
			(goto-line (caddar res))
			(eg-message 3 "肵B")))
	  (eg-new-file (car path) word))))

(defun eg-scan-1 (regexp name &aux l)
  "̖{"
  (save-excursion
	(goto-char (point-min))
	(while (scan-buffer regexp :tail t)
	  (push (list (match-string 0) name (current-line-number) (eg-skim-lines))
			l)))
  l)

(defun eg-skim-lines ()
  (buffer-substring (save-excursion (goto-bol) (point))
					(save-excursion
					  (next-line *eg-show-line-number*) (goto-eol) (point))))

(defun eg-get-buffer-name ()
  "obt@̃t@CO擾"
  (or (get-buffer-file-name)
	  (concat "<" (buffer-name (selected-buffer)) ">")))

(defun eg-scan-here (word predicate attr)
  "݂̃obt@݂̂XL"
  (let ((res (eg-scan-1 (compile-regexp word t)
						(eg-get-buffer-name))))
	(if res
		(if (cdr res)
			(eg-show-result
			 word
			 (if predicate (stable-sort res predicate :key 'car)
			   (reverse res))
			 attr
			 (syntax-table)
			 (if (boundp 'keyword-hash-table)
				 keyword-hash-table))
		  (progn (goto-line (caddar res)) (eg-message 3 "肵B")))
	  (eg-insert-template word))))

(defun eg-set-buffer (name)
  "obt@Ɉړ"
  (let ((buff (if (eg-bufferp name)
				  (find-buffer (string-trim "<>" name))
				(or (get-file-buffer name)
					(ed::find-file-internal name)))))
	(if buff (set-buffer buff)
	  (eg-message 2 "Ȃ恨 ~A" name))))

(defun eg-read-file (name &aux (r t))
  "t@CǂݍށBobt@ΈړB"
  (let ((buff (if (eg-bufferp name)
				  (find-buffer (string-trim "<>" name))
				(or (get-file-buffer name)
					(setq r nil)
					(get-buffer-create (concat " " *eg-buffer*))))))
	(when buff
	  (set-buffer buff)
	  (unless r
		(erase-buffer (selected-buffer))
		(insert-file-contents name))
	  (eg-message 1 "Ă ~A" name))
	buff))

(defun eg-files-exist-no-word (attr files)
  "file݂Awordw肳ĂȂꍇ"
  (let ((arg (if (car attr) (parse-integer (car attr) :junk-allowed t))))
	(if (and arg (elt files arg))
		(if (eg-set-buffer (elt files arg))
			(eg-no-word (cdr attr)))
	  (eg-show-files files))))

(defun eg-new-file (path word)
  "t@C"
  (set-buffer
   (ed::find-file-internal
	(if (string-match "[\\*\\?<>|:\"]" (file-namestring path))
		(let ((num 0))
		  (loop
			(let ((file (merge-pathnames
						 (funcall *eg-denominate-new-file* num)
						 (directory-namestring path))))
			  (if (file-exist-p file) (incf num) (return file)))))
	  path)))
  (when word (eg-insert-template word))
  (set-buffer-modified-p nil))

(defun eg-grep-here (word attr)
  "݂̃obt@ΏۂɌ"
  (if word
	  (let ((p (eg-sort-predicate (car attr))))
		(eg-scan-here word p (if p (cdr attr) attr)))
	(eg-no-word attr)))

(defun eg-no-word (attr)
  "wordȂꍇBԍ΍sړ"
  (let ((arg (if (car attr) (parse-integer (car attr) :junk-allowed t))))
	(and arg (progn (goto-line arg) (recenter))))
  (eg-message t "ړĂ݂B"))

(defun eg-show-result (word res attr &optional syntax keyword)
  "ʂꍇ"
  (let ((arg (if (car attr) (parse-integer (car attr) :junk-allowed t))))
	(if (and arg (elt res arg))
		(if (eg-set-buffer (cadr (elt res arg)))
			(goto-line (caddr (elt res arg))))
	  (let ((buff (get-buffer-create *eg-buffer*)))
		(set-buffer buff)
		(erase-buffer buff)
		(setup-temp-buffer buff)
		(kill-all-local-variables)
		(when syntax (use-syntax-table syntax))
		(when keyword
		  (make-local-variable 'keyword-hash-table)
		  (setf keyword-hash-table keyword))
		(make-local-variable 'regexp-keyword-list)
		(let ((key (compile-regexp-keyword-list
					`((,(compile-regexp word) t ,*eg-keyword-highlight* t)))))
		  (setq regexp-keyword-list
				(if (boundp 'regexp-keyword-list)
					(append regexp-keyword-list key)
				  key)))
		(format (make-buffer-stream buff) "~{~{~*\"~A\"|~A|>>~%~A~%~%~}~}~%~A݂B"
				res (length res)))))
  (eg-message 3 "낢날B"))

(defun eg-show-files (files)
  "t@C̓e"
  (let ((buff (get-buffer-create *eg-buffer*)))
	(set-buffer buff)
	(erase-buffer buff)
	(setup-temp-buffer buff)
	(fundamental-mode)
	(kill-all-local-variables)
	(with-output-to-buffer (buff)
	  (dolist (a files)
		(format t "~A|>>~%" a)
		(if (eg-bufferp a)
			(let ((s (make-buffer-stream ((find-buffer a) (point-min)))))
			  (eg-show-content s))
		  (with-open-file (s a)
			(eg-show-content s)))
		(format t "~%"))))
  (eg-message 3 "ׂĂ݂B"))

(defun eg-show-content (input-stream &aux l)
  (dotimes (N/A *eg-show-line-number*)
	(setq l (read-line input-stream nil nil))
	(if l (format t "~A~%" l) (return))))

(defun eg-insert-template (word)
  (interactive "sږ: ")
  (goto-char (point-max))
  (funcall *eg-template* word)
  (eg-message t "āB" ))

(defun eg-message (threshold &rest args)
  (if (or
	   (null threshold)
	   (and (numberp threshold)
			(numberp *eg-verbose*)
			(>= *eg-verbose* threshold))
	   (eq t *eg-verbose*))
	  (apply 'message args))
  nil)

(defun eg-goto-run-exp (&optional (pop t))
  "embedded-grep̌ʒuɖ߂B"
  (interactive)
  (let ((marker (if pop (pop *eg-marker-ring*) (car *eg-marker-ring*))))
	(and (if marker t
		   (eg-message 2 "Ȃ"))
		 (eg-set-buffer (car marker))
		 (goto-line (cdr marker))
		 (eg-message t "߂B (c~A)" (length *eg-marker-ring*)))))

(defun eg-release-run-exp ()
  (interactive)
  (let ((buff (get-buffer-create *eg-buffer*)))
	(set-buffer buff)
	(erase-buffer buff)
	(setup-temp-buffer buff)
	(fundamental-mode)
	(kill-all-local-variables)
	(with-output-to-buffer (buff)
	  (dolist (a *eg-marker-ring*)
		(if (string/= (car a) (concat "<" *eg-buffer* ">"))
			(format t "~A|%:~A|>>~%~A~%~%"
					(car a) (cdr a) (save-excursion (eg-goto-run-exp nil) (eg-skim-lines))))))
	(let ((buff (find-buffer (concat " " *eg-buffer*))))
	  (if buff (delete-buffer buff)))
	(if *prefix-args*
		(eg-message 2 "\Ă݂B")
		(progn (setq *eg-marker-ring* nil)
		  (eg-message t "ZbgB")))))

;;; end of embedded-grep.l